/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.jndi;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import oracle.javatools.jndi.LocalInitialContextFactory;

public class LocalInitialContextFactoryBuilder
implements InitialContextFactoryBuilder {
    LocalInitialContextFactory ic = new LocalInitialContextFactory();

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> env) throws NamingException {
        String className;
        Object initialContextFactory = env.get("java.naming.factory.initial");
        if (LocalInitialContextFactory.class.getName().equals(initialContextFactory)) {
            return this.ic;
        }
        String string = className = env != null ? (String)env.get("java.naming.factory.initial") : null;
        if (className == null) {
            NoInitialContextException ne = new NoInitialContextException("Need to specify class name in environment or system property, or as an applet parameter, or in an application resource file:  java.naming.factory.initial");
            throw ne;
        }
        try {
            return (InitialContextFactory)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
            ne.setRootCause(e);
            throw ne;
        }
    }
}

