/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.ide.util.HogTracker;

public final class Assert {
    private static final Logger LOGGER = Logger.getLogger(Assert.class.getName());
    private static HashMap<String, Long> _timingMap;
    private static HashMap<String, Stack<HogTracker>> _trackerMap;
    private static final String CHECKING_PROPERTY = "ide.AssertCheckingDisabled";
    private static final boolean checking;
    private static final String TRACING_PROPERTY = "ide.AssertTracingDisabled";
    private static final boolean tracing;
    private static int timingThreshold;

    private Assert() {
    }

    public static void precondition(boolean condition, String description) throws PreconditionException {
        if (checking && !condition) {
            if (description == null) {
                description = "Precondition failed";
            }
            System.err.println(description);
            throw new PreconditionException(description);
        }
    }

    public static void precondition(boolean condition) throws PreconditionException {
        Assert.precondition(condition, null);
    }

    public static void check(boolean condition, String description) throws CheckException {
        if (checking && !condition) {
            System.err.println(description);
            throw new CheckException(description, null);
        }
    }

    public static void check(boolean condition) throws CheckException {
        if (checking && !condition) {
            System.err.println("Check failed");
            throw new CheckException("Check failed", null);
        }
    }

    public static void checkAWTThread() throws CheckException {
        Assert.check(SwingUtilities.isEventDispatchThread(), "Must be invoked from event thread");
    }

    public static void fail(String description) throws CheckException {
        Assert.check(false, description);
    }

    public static void fail() throws CheckException {
        Assert.check(false);
    }

    public static void fail(Exception exception) throws CheckException {
        if (checking) {
            Assert.printStackTrace(exception);
            throw new CheckException("Check failed", exception);
        }
    }

    public static void exit(int code) {
        Assert.println("Assert.exit:");
        System.exit(code);
    }

    public static void printStackTrace() {
        Assert.printStackTrace(new Exception("Assert Stack Trace"));
    }

    public static void printStackTrace(String message) {
        Assert.printStackTrace(new Exception("Assert Stack Trace: " + message));
    }

    public static void printStackTrace(Throwable ex) {
        ex.printStackTrace(System.err);
    }

    public static void printStackTrace(boolean condition, String s) {
        if (condition) {
            Assert.printStackTrace(s);
        }
    }

    public static void print(String s) {
        if (tracing) {
            System.err.print("Assert: " + s);
        }
    }

    public static void print(boolean condition, String s) {
        if (condition) {
            Assert.print(s);
        }
    }

    public static void print(boolean condition, String trueString, String falseString) {
        if (condition) {
            Assert.print(trueString);
        } else {
            Assert.print(falseString);
        }
    }

    public static void println(String s) {
        if (tracing) {
            LOGGER.fine(s);
        }
    }

    public static void println(boolean condition, String s) {
        if (condition) {
            Assert.println(s);
        }
    }

    public static void println(boolean condition, String trueString, String falseString) {
        if (condition) {
            Assert.println(trueString);
        } else {
            Assert.println(falseString);
        }
    }

    public static void println(String pattern, Object param) {
        Assert.println(pattern, new Object[]{param});
    }

    public static void println(String pattern, Object param1, Object param2) {
        Assert.println(pattern, new Object[]{param1, param2});
    }

    public static void println(String pattern, Object param1, Object param2, Object param3) {
        Assert.println(pattern, new Object[]{param1, param2, param3});
    }

    public static void println(String pattern, Object[] params) {
        Assert.println(MessageFormat.format(pattern, params));
    }

    public static void execute(Runnable runnable) {
        runnable.run();
    }

    private static String getTimingKey(String key) {
        return Thread.currentThread().getName() + ":" + key;
    }

    public static void startTiming(String key, String msg, boolean quietStart) {
        Assert.startTiming(key, msg, quietStart, true);
    }

    public static synchronized void startTiming(String key, String msg, boolean quietStart, boolean prefixThread) {
        if (quietStart) {
            return;
        }
        Assert.printHeader(msg);
        String storeKey = prefixThread ? Assert.getTimingKey(key) : key;
        _timingMap.put(storeKey, System.nanoTime());
    }

    public static void endTiming(String key, String msg, String indent, boolean quietStart) {
        Assert.endTiming(key, msg, indent, quietStart, true, 0L);
    }

    public static void endTiming(String key, String msg, String indent, boolean quietStart, long timeThreshold) {
        Assert.endTiming(key, msg, indent, quietStart, true, timeThreshold);
    }

    public static synchronized void endTiming(String key, String msg, String indent, boolean quietStart, boolean prefixThread) {
        Assert.endTiming(key, msg, indent, quietStart, prefixThread, 0L);
    }

    public static synchronized void endTiming(String key, String msg, String indent, boolean quietStart, boolean prefixThread, long timeThreshold) {
        String storeKey;
        if (quietStart) {
            return;
        }
        long endTime = System.nanoTime();
        String string = storeKey = prefixThread ? Assert.getTimingKey(key) : key;
        if (msg != null) {
            if (!_timingMap.containsKey(storeKey)) {
                return;
            }
            long startTime = _timingMap.get(storeKey);
            long msElapsed = (endTime - startTime) / 1000000L;
            Assert.printTiming(msElapsed, msg, indent, timeThreshold);
        }
        _timingMap.remove(storeKey);
    }

    public static void printTiming(long time, String msg, String indent) {
        Assert.printTiming(time, msg, indent, 0L);
    }

    public static void printTiming(long time, String msg, String indent, long threshold) {
        if (time >= threshold && time > (long)Assert.printTimingThreshold()) {
            StringBuffer sb = new StringBuffer(10 + msg.length());
            sb.append("[").append(time).append("ms] ");
            while (sb.length() < 11) {
                sb.insert(0, " ");
            }
            if (indent == null || indent.length() == 0) {
                sb.append(msg);
            } else {
                sb.append(indent).append(msg);
            }
        }
    }

    public static void printHeader(String msg) {
        if (msg != null) {
            // empty if block
        }
    }

    public static int printTimingThreshold() {
        if (timingThreshold == -2) {
            try {
                timingThreshold = Integer.valueOf(System.getProperty("PrintTimingThreshold", "50"));
                if (timingThreshold < 0) {
                    timingThreshold = -1;
                }
            }
            catch (Exception e) {
                timingThreshold = -1;
            }
        }
        return timingThreshold;
    }

    public static synchronized void startTracking(String key) {
        String storeKey = Assert.getTimingKey(key);
        Stack<HogTracker> stack = _trackerMap.get(storeKey);
        if (stack == null) {
            stack = new Stack();
            _trackerMap.put(storeKey, stack);
        }
        stack.push(new HogTracker());
    }

    public static void markTracking(String key) {
        HogTracker tracker = Assert.getTracker(key, false);
        if (tracker != null) {
            tracker.mark();
        }
    }

    public static void checkTracking(String key, Object object) {
        HogTracker tracker = Assert.getTracker(key, false);
        if (tracker != null) {
            tracker.check(object);
        }
    }

    public static void endTracking(String key) {
        Assert.endTracking(key, null);
    }

    public static void endTracking(String key, String msg) {
        HogTracker tracker = Assert.getTracker(key, true);
        if (tracker != null) {
            tracker.report();
            if (msg != null && msg.length() > 0) {
                tracker.reportTotal(msg);
            }
        }
    }

    private static synchronized HogTracker getTracker(String key, boolean remove) {
        String storeKey = Assert.getTimingKey(key);
        if (!_trackerMap.containsKey(storeKey)) {
            return null;
        }
        Stack<HogTracker> stack = _trackerMap.get(storeKey);
        if (remove) {
            HogTracker tracker = stack.pop();
            if (stack.size() == 0) {
                _trackerMap.remove(key);
            }
            return tracker;
        }
        return stack.peek();
    }

    static {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                LOGGER.setUseParentHandlers(false);
                LOGGER.addHandler(new AssertHandler());
                return null;
            }
        };
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(action);
        } else {
            action.run();
        }
        _timingMap = new HashMap();
        _trackerMap = new HashMap();
        checking = !Boolean.getBoolean(CHECKING_PROPERTY);
        tracing = !Boolean.getBoolean(TRACING_PROPERTY);
        timingThreshold = -2;
    }

    private static class AssertFormatter
    extends Formatter {
        private AssertFormatter() {
        }

        @Override
        public String format(LogRecord record) {
            StringBuilder b = new StringBuilder();
            b.append("Trace: ");
            b.append(record.getMessage());
            b.append("\n");
            return b.toString();
        }
    }

    private static class AssertHandler
    extends ConsoleHandler {
        AssertHandler() {
            this.setLevel(Level.FINE);
            if (!Boolean.getBoolean("ide.assert.standardFormatter")) {
                this.setFormatter(new AssertFormatter());
            }
        }
    }

    static class CheckException
    extends IllegalStateException {
        CheckException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static class PreconditionException
    extends IllegalStateException {
        PreconditionException(String message) {
            super(message);
        }
    }
}

