/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.awt.Font;
import java.awt.Image;
import java.lang.reflect.Field;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import oracle.ide.util.GraphicsUtils;

public abstract class ArrayResourceBundle
extends ResourceBundle {
    private static final Logger LOG = Logger.getLogger(ArrayResourceBundle.class.getName());
    private int[] _autoSyncMap;
    private static final String nullString = "(null)";
    private static final HashMap iconCache = new HashMap(500);
    private static final char _MNEMONIC_INDICATOR = '&';

    public final String[] getStringArray(int key) {
        return (String[])this.getObject(key);
    }

    public final Object getObject(int key) {
        return this.getObjectImpl(key);
    }

    public final String getStringImpl(int key) {
        return this.getObjectImpl(key).toString();
    }

    public final char getCharImpl(int key) {
        Character c = (Character)this.getObjectImpl(key);
        return c.charValue();
    }

    public final Font getFontImpl(int key) {
        return (Font)this.getObjectImpl(key);
    }

    public final KeyStroke getAcceleratorImpl(int key) {
        String s = this.getStringImpl(key);
        if (s != null && s.length() > 0) {
            return KeyStroke.getKeyStroke(s);
        }
        return null;
    }

    public final Integer getIntegerImpl(int key) {
        String s = this.getStringImpl(key);
        if (s.length() == 1 && Character.isLetter(s.charAt(0))) {
            return new Integer(s.charAt(0));
        }
        return Integer.valueOf(s);
    }

    public final char getMnemonicImpl(int key) {
        int len;
        String s = this.getStringImpl(key);
        int n = len = s != null ? s.length() : 0;
        if (len == 1) {
            return s.charAt(0);
        }
        return (char)ArrayResourceBundle.getMnemonicKeyCode(s);
    }

    public final Icon getIconImpl(int key) {
        return this.getImageIconImpl(key, true);
    }

    public final Icon getUncachedIconImpl(int key) {
        return this.getImageIconImpl(key, false);
    }

    public final Image getImageImpl(int key) {
        ImageIcon imageIcon = this.getImageIconImpl(key, true);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    public final Image getUncachedImageImpl(int key) {
        ImageIcon imageIcon = this.getImageIconImpl(key, false);
        return imageIcon != null ? imageIcon.getImage() : null;
    }

    public final Object getObjectImpl(int key) {
        return this.getObjectImpl(key, false);
    }

    private final Object getObjectImpl(int key, boolean skipToParent) {
        Object[] contents = this.getContents();
        int mappedKey = this.getMappedIndex(key);
        if (!skipToParent && mappedKey < contents.length && mappedKey >= 0) {
            return contents[mappedKey];
        }
        if (this.parent == null) {
            if (skipToParent) {
                return this.getObjectImpl(key, false);
            }
            throw new MissingResourceException("Can't find resource", this.getClass().getName(), String.valueOf(key));
        }
        if (this.parent instanceof ArrayResourceBundle) {
            return ((ArrayResourceBundle)this.parent).getObjectImpl(key);
        }
        return this.parent.getObject(String.valueOf(key));
    }

    public final String formatImpl(int key, Object[] params) {
        int numParams;
        int n = numParams = params == null ? 0 : params.length;
        if (numParams == 0) {
            return this.getStringImpl(key);
        }
        for (int i = 0; i < numParams; ++i) {
            if (params[i] != null) continue;
            params[i] = nullString;
        }
        String result = this.formatImplNoCheck(key, params);
        for (int i = 0; i < numParams; ++i) {
            if (params[i] != nullString) continue;
            params[i] = null;
        }
        return result;
    }

    public final String formatImpl(int key, Object param1) {
        return this.formatImpl(key, new Object[]{param1});
    }

    public final String formatImpl(int key, Object param1, Object param2) {
        return this.formatImpl(key, new Object[]{param1, param2});
    }

    public final String formatImpl(int key, Object param1, Object param2, Object param3) {
        return this.formatImpl(key, new Object[]{param1, param2, param3});
    }

    private String formatImplNoCheck(int key, Object[] params) {
        String s = this.getStringImpl(key);
        return MessageFormat.format(s, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ImageIcon getImageIconImpl(int key, boolean shouldCacheIcon) {
        String imageName = (String)this.getObjectImpl(key, true);
        if (imageName == null || imageName.length() == 0) {
            return null;
        }
        Class<?> cls = this.getClass();
        String className = cls.getName();
        IconKey iconKey = new IconKey(className, key);
        HashMap hashMap = iconCache;
        synchronized (hashMap) {
            Object cacheObject = iconCache.get(iconKey);
            if (cacheObject != null) {
                return (ImageIcon)cacheObject;
            }
        }
        URL url = cls.getResource(imageName);
        ImageIcon imageIcon = null;
        if (url != null && (imageIcon = GraphicsUtils.createImageIcon(url)) != null && shouldCacheIcon) {
            HashMap hashMap2 = iconCache;
            synchronized (hashMap2) {
                iconCache.put(iconKey, imageIcon);
            }
        }
        return imageIcon;
    }

    protected abstract Object[] getContents();

    public final Enumeration getKeys() {
        Object[] contents = this.getContents();
        List<Object> contentsList = Arrays.asList(contents);
        return Collections.enumeration(contentsList);
    }

    @Override
    protected final Object handleGetObject(String key) {
        return this.getObject(Integer.parseInt(key));
    }

    private int getMappedIndex(int index) {
        if (this.parent == null || !(this.parent instanceof ArrayResourceBundle)) {
            return index;
        }
        if (this._autoSyncMap == null) {
            this.buildAutoSyncMap();
        }
        try {
            int mappedIndex = this._autoSyncMap[index];
            if (mappedIndex == -1) {
                LOG.warning("NLSSYNC: ARB key '" + ArrayResourceBundle.getFieldNameForIndex(this.parent.getClass(), index) + "' exists in " + this.parent.getClass() + " but not in " + this.getClass().getName());
            }
            return mappedIndex;
        }
        catch (ArrayIndexOutOfBoundsException oob) {
            LOG.warning("NLSSYNC: Key " + ArrayResourceBundle.getFieldNameForIndex(this.getClass(), index) + " does not exist in " + this.getClass().getName());
            return -1;
        }
    }

    private void buildAutoSyncMap() {
        Field[] myFields = this.getClass().getDeclaredFields();
        HashMap<String, Integer> fieldValuesByName = new HashMap<String, Integer>();
        for (int i = 0; i < myFields.length; ++i) {
            Field f = myFields[i];
            if (f.getType() != Integer.TYPE) continue;
            try {
                int value = f.getInt(null);
                fieldValuesByName.put(f.getName(), new Integer(value));
                continue;
            }
            catch (IllegalAccessException ille) {
                ille.printStackTrace();
            }
        }
        Field[] parentFields = this.parent.getClass().getDeclaredFields();
        this._autoSyncMap = new int[parentFields.length];
        Arrays.fill(this._autoSyncMap, -1);
        for (int i = 0; i < parentFields.length; ++i) {
            Field f = parentFields[i];
            if (f.getType() != Integer.TYPE) continue;
            try {
                int parentValue = f.getInt(null);
                Integer myValue = (Integer)fieldValuesByName.get(f.getName());
                if (myValue == null) continue;
                this._autoSyncMap[parentValue] = myValue;
                continue;
            }
            catch (IllegalAccessException ille) {
                ille.printStackTrace();
            }
        }
    }

    private static String getFieldNameForIndex(Class clazz, int index) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (field.getType() != Integer.TYPE) continue;
            try {
                int value = field.getInt(null);
                if (value != index) continue;
                return field.getName();
            }
            catch (IllegalAccessException ille) {
                // empty catch block
            }
        }
        return String.valueOf(index);
    }

    private static int getMnemonicKeyCode(String string) {
        int index;
        if (string == null) {
            return 0;
        }
        int lengthMinusOne = string.length() - 1;
        int i = 0;
        while (i < lengthMinusOne && (index = string.indexOf(38, i)) != -1 && index < lengthMinusOne) {
            char ch = string.charAt(index + 1);
            if (ch != '&') {
                return Character.toUpperCase(ch);
            }
            i = index + 2;
        }
        return 0;
    }

    private static final class IconKey {
        private String name;
        private int key;

        IconKey(String name, int key) {
            this.name = name;
            this.key = key;
        }

        public int hashCode() {
            return this.name.hashCode() + this.key;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof IconKey) {
                IconKey otherKey = (IconKey)object;
                if (otherKey.name.equals(this.name) && otherKey.key == this.key) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.name + ":" + this.key;
        }
    }
}

