/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import oracle.ide.model.DefaultSubDirtyable;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLComparator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFilter;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;

public class URLPath
extends DefaultSubDirtyable
implements Copyable,
Iterable<URL> {
    private final List<URL> _entriesList;

    public URLPath() {
        this._entriesList = new ArrayList<URL>();
    }

    public URLPath(int initialCapacity) {
        this._entriesList = new ArrayList<URL>(initialCapacity);
    }

    public URLPath(URL entry) {
        this();
        this.add(entry);
    }

    public URLPath(URL[] entries) {
        this();
        this.add(entries);
    }

    public URLPath(ListStructure entries) {
        this((List)entries);
    }

    public URLPath(List entries) {
        if (entries != null) {
            for (Object entry : entries) {
                if (entry == null) {
                    throw new IllegalArgumentException("The specified List contains null.");
                }
                if (entry instanceof URL) continue;
                throw new IllegalArgumentException("The specified List contains a non-URL object (" + entry.getClass().toString() + ")");
            }
            this._entriesList = entries;
        } else {
            this._entriesList = new ArrayList<URL>();
        }
    }

    public URLPath(URLPath urlPath) {
        this();
        if (urlPath != null) {
            urlPath.copyToImpl(this);
        }
    }

    @Override
    public Object copyTo(Object object) {
        URLPath copy = object != null ? (URLPath)object : new URLPath();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(URLPath copy) {
        copy._entriesList.clear();
        copy._entriesList.addAll(this._entriesList);
    }

    public void add(URL entry) {
        if (entry != null && !this.contains(entry)) {
            this._entriesList.add(entry);
            this.markDirty(true);
        }
    }

    public void add(URL[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            for (int i = 0; i < numEntries; ++i) {
                this.add(entries[i]);
            }
        }
    }

    public void add(Collection<?> entries) {
        if (entries != null) {
            for (Object entry : entries) {
                if (!(entry instanceof URL)) continue;
                this.add((URL)entry);
            }
        }
    }

    public void add(List entries) {
        this.add((Collection<?>)entries);
    }

    public void add(URLPath urlPath) {
        if (urlPath != null) {
            this.add((Collection<?>)urlPath._entriesList);
        }
    }

    public List<URL> asList() {
        return Collections.unmodifiableList(this._entriesList);
    }

    public URL[] getEntries() {
        return this._entriesList.toArray(new URL[this._entriesList.size()]);
    }

    public boolean contains(URL entry) {
        return this.findEntry(entry) >= 0;
    }

    public List<String> getAllDirectories() {
        HashSet<String> dirList = new HashSet<String>();
        for (URL entry : this._entriesList) {
            this._getAllDirectories(entry, entry, dirList, URLFileSystem.findHelper(entry));
        }
        ArrayList<String> list = new ArrayList<String>(dirList);
        Collections.sort(list);
        return list;
    }

    public void expandToIncludeManifestClassPaths() {
        int i = 0;
        HashSet<URL> processedJars = new HashSet<URL>();
        while (i < this._entriesList.size()) {
            URL curEntry = this._entriesList.get(i++);
            i = this.expandToIncludeManifestClassPathImpl(i, curEntry, processedJars);
        }
    }

    public void expandToIncludeManifestClassPathsInterruptibly() throws InterruptedException {
        int i = 0;
        HashSet<URL> processedJars = new HashSet<URL>();
        while (i < this._entriesList.size()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            URL curEntry = this._entriesList.get(i++);
            i = this.expandToIncludeManifestClassPathImpl(i, curEntry, processedJars);
        }
    }

    private int expandToIncludeManifestClassPathImpl(int insertionPoint, URL curEntry, Set<URL> processedJars) {
        if ("".equals(JarUtil.getJarEntry(curEntry)) && !processedJars.contains(curEntry)) {
            processedJars.add(curEntry);
            try {
                String manifestClassPath = JarUtil.getClassPath(curEntry);
                if (manifestClassPath != null) {
                    URL jarFileURL = JarUtil.getJarFileURL(curEntry);
                    URL dirURL = URLFileSystem.getParent(jarFileURL);
                    StringTokenizer st = new StringTokenizer(manifestClassPath);
                    while (st.hasMoreTokens()) {
                        URL manifestCpItemURL;
                        String manifestCpItem = st.nextToken();
                        boolean isJar = false;
                        URL newJarFileURL = null;
                        if (JarUtil.isArchive(manifestCpItem)) {
                            isJar = true;
                            newJarFileURL = URLFactory.newURL(dirURL, manifestCpItem);
                            manifestCpItemURL = URLFactory.newJarURL(newJarFileURL, null);
                        } else {
                            manifestCpItemURL = URLFactory.newURL(dirURL, manifestCpItem);
                        }
                        if (!URLFileSystem.exists(isJar ? newJarFileURL : manifestCpItemURL)) continue;
                        if (!this._entriesList.contains(manifestCpItemURL)) {
                            this._entriesList.add(insertionPoint++, manifestCpItemURL);
                        }
                        if (!isJar) continue;
                        insertionPoint = this.expandToIncludeManifestClassPathImpl(insertionPoint, manifestCpItemURL, processedJars);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return insertionPoint;
    }

    public List getDirectories(String relPath) {
        return this.getDirectories(relPath, null);
    }

    public List<String> getDirectories(String relPath, URLFilter urlFilter) {
        ArrayList<String> list = new ArrayList<String>();
        if (relPath != null) {
            HashSet<String> dirList = new HashSet<String>();
            String prefix = relPath.length() == 0 || relPath.endsWith("/") ? relPath : relPath + "/";
            for (URL url : this._entriesList) {
                URL entry = URLFactory.newDirURL(url, relPath);
                URLFileSystemHelper helper = URLFileSystem.findHelper(entry);
                URLFileSystem.FileInfo[] infos = helper.ls(entry, urlFilter);
                if (infos == null) continue;
                for (URLFileSystem.FileInfo info : infos) {
                    if (!info.isDirectory()) continue;
                    URL newURL = info.getURL();
                    dirList.add(prefix + helper.getFileName(newURL));
                }
            }
            list.addAll(dirList);
            Collections.sort(list);
        }
        return list;
    }

    public List<URL> getFiles(String relPath) {
        return this.getFiles(relPath, null);
    }

    public List<URL> getFiles(String relPath, URLFilter urlFilter) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        if (relPath != null) {
            for (URL url : this._entriesList) {
                URL entry = URLFactory.newDirURL(url, relPath);
                URLFileSystem.FileInfo[] infos = URLFileSystem.ls(entry, urlFilter);
                if (infos == null) continue;
                for (URLFileSystem.FileInfo info : infos) {
                    if (!info.isFile()) continue;
                    URL newURL = info.getURL();
                    fileList.add(newURL);
                }
            }
            Collections.sort(fileList, new URLComparator());
        }
        return fileList;
    }

    public List getFilesAndDirectories(String relPath, boolean dirsBeforeFiles) {
        return this.getFilesAndDirectories(relPath, dirsBeforeFiles, null);
    }

    public List<URL> getFilesAndDirectories(String relPath, boolean dirsBeforeFiles, URLFilter urlFilter) {
        ArrayList<URL> fileList = new ArrayList<URL>();
        if (relPath != null) {
            for (URL url : this._entriesList) {
                URL entry = URLFactory.newDirURL(url, relPath);
                URLFileSystemHelper helper = URLFileSystem.findHelper(entry);
                URLFileSystem.FileInfo[] infos = helper.ls(entry, urlFilter);
                if (infos == null) continue;
                for (URLFileSystem.FileInfo info : infos) {
                    URL newURL = info.getURL();
                    fileList.add(newURL);
                }
            }
            Collections.sort(fileList, new URLComparator(dirsBeforeFiles));
        }
        return fileList;
    }

    public URL getFirstEntry() {
        if (this._entriesList.size() > 0) {
            return this._entriesList.get(0);
        }
        return null;
    }

    public static URLPath getURLPath(HashStructure hash, String urlPathName) {
        URLPath urlPath = new URLPath();
        if (hash != null) {
            try {
                ListStructure list = hash.getListStructure(urlPathName);
                urlPath.add((Collection<?>)list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return urlPath;
    }

    public static boolean setURLPath(HashStructure hash, String urlPathName, URLPath urlPath) {
        if (hash != null) {
            try {
                if (urlPath != null) {
                    ListStructure list = hash.getOrCreateListStructure(urlPathName);
                    return list.mirror(urlPath._entriesList);
                }
                if (hash.containsKey(urlPathName)) {
                    hash.remove(urlPathName);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public Iterator<URL> iterator() {
        return this._entriesList.iterator();
    }

    public static URLPath newURLPathFromString(String entries) {
        URLPath urlPath = new URLPath();
        if (entries != null) {
            StringTokenizer tokenizer = new StringTokenizer(entries, File.pathSeparator);
            while (tokenizer.hasMoreTokens()) {
                String path = tokenizer.nextToken();
                URL url = URLPath.pathToURL(path);
                urlPath.add(url);
            }
        }
        return urlPath;
    }

    public void remove(URL entry) {
        int i;
        if (entry != null && (i = this.findEntry(entry)) >= 0) {
            this._entriesList.remove(i);
            this.markDirty(true);
        }
    }

    public void remove(URL[] entries) {
        if (entries != null) {
            int numEntries = entries.length;
            for (int i = 0; i < numEntries; ++i) {
                this.remove(entries[i]);
            }
        }
    }

    public void remove(URLPath urlPath) {
        if (urlPath != null) {
            for (URL url : urlPath._entriesList) {
                this.remove(url);
            }
        }
    }

    public void setEntries(URL[] entries) {
        this._entriesList.clear();
        if (entries != null) {
            this.add(entries);
        }
        this.markDirty(true);
    }

    public int size() {
        return this._entriesList.size();
    }

    private boolean isArchive(URL url) {
        return ".zip".equalsIgnoreCase(URLFileSystem.getSuffix(url)) || ".jar".equalsIgnoreCase(URLFileSystem.getSuffix(url));
    }

    public URL toQualifiedURL(String relativePath) {
        URL[] urls = this.toQualifiedURL(relativePath, true);
        if (urls == null) {
            return null;
        }
        return urls[0];
    }

    public URL[] toQualifiedURL(String relativePath, boolean firstMatch) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        if (relativePath != null) {
            for (URL url : this._entriesList) {
                URL fullURL = JarUtil.isJarURL(url) ? URLFactory.newJarURL(url, relativePath) : (this.isArchive(url) ? URLFactory.newJarURL(url, relativePath) : URLFactory.newURL(url, relativePath));
                if (!URLFileSystem.exists(fullURL)) continue;
                urlList.add(fullURL);
                if (!firstMatch) continue;
                break;
            }
        }
        if (urlList.size() == 0) {
            return null;
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public URL toBoundURL(String relativePath) {
        if (relativePath != null) {
            for (URL url : this._entriesList) {
                URL fullURL = JarUtil.isJarURL(url) ? URLFactory.newJarURL(url, relativePath) : URLFactory.newURL(url, relativePath);
                if (!URLFileSystem.isBound(fullURL)) continue;
                return fullURL;
            }
        }
        return null;
    }

    public String toRelativePath(URL url) {
        if (url != null) {
            for (URL entry : this._entriesList) {
                String relativePath = URLFileSystem.toRelativeSpec(url, entry, true);
                if (relativePath == null) continue;
                return relativePath;
            }
        }
        return null;
    }

    public String toShortestRelativePath(URL url) {
        URL longestMatch = this.getLongestMatchingEntry(url);
        if (longestMatch != null) {
            return URLFileSystem.toRelativeSpec(url, longestMatch, true);
        }
        return null;
    }

    public URL getLongestMatchingEntry(URL url) {
        if (url != null) {
            String urlString = url.toString();
            String longestMatch = null;
            URL longestURL = null;
            for (URL entry : this._entriesList) {
                String entryString = entry.toString();
                if (!urlString.startsWith(entryString) || longestMatch != null && entryString.length() <= longestMatch.length()) continue;
                longestMatch = entryString;
                longestURL = entry;
            }
            return longestURL;
        }
        return null;
    }

    public String[] toStrings() {
        String[] result = new String[this._entriesList.size()];
        int i = 0;
        for (URL entry : this._entriesList) {
            result[i++] = URLFileSystem.getPlatformPathName(entry);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((URLPath)o);
    }

    protected final boolean equalsImpl(URLPath urlPath) {
        if (this == urlPath) {
            return true;
        }
        if (this._entriesList.size() != urlPath._entriesList.size()) {
            return false;
        }
        Iterator<URL> iter1 = this._entriesList.iterator();
        Iterator<URL> iter2 = urlPath._entriesList.iterator();
        while (iter1.hasNext()) {
            URL url2;
            URL url1 = iter1.next();
            if (URLFileSystem.equals(url1, url2 = iter2.next())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (URL url : this._entriesList) {
            String path = URLFileSystem.getPlatformPathName(url);
            builder.append(path).append(File.pathSeparatorChar);
        }
        int len = builder.length();
        if (len > 0) {
            builder.setLength(len - 1);
        }
        return builder.toString();
    }

    public boolean validateAllEntriesExist() {
        for (URL entry : this._entriesList) {
            if (URLFileSystem.exists(entry)) continue;
            return false;
        }
        return true;
    }

    private int findEntry(URL entry) {
        if (entry != null) {
            Iterator<URL> iter = this.asList().iterator();
            int i = 0;
            while (iter.hasNext()) {
                if (URLFileSystem.equals(entry, iter.next())) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    private static URL pathToURL(String pathname) {
        if (JarUtil.isArchive(pathname) && new File(pathname).isFile()) {
            URL url = URLFactory.newFileURL(pathname);
            return URLFactory.newJarURL(url, "");
        }
        URL dirURL = URLFactory.newDirURL(pathname);
        return URLFileSystem.canonicalize(dirURL);
    }

    private void _getAllDirectories(URL baseURL, URL currentURL, Set<String> dirList, URLFileSystemHelper helper) {
        URLFileSystem.FileInfo[] infos = helper.ls(currentURL);
        if (infos != null) {
            String relPath = helper.toRelativeSpec(currentURL, baseURL);
            if (relPath != null && relPath.length() > 0) {
                dirList.add(relPath);
            }
            for (URLFileSystem.FileInfo info : infos) {
                if (!info.isDirectory()) continue;
                this._getAllDirectories(baseURL, info.getURL(), dirList, helper);
            }
        }
    }
}

