/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.boot;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.concurrent.CopyOnWriteArrayList;

public final class URLStreamHandlerFactoryQueue
implements URLStreamHandlerFactory {
    private static final URLStreamHandlerFactory _factory = new URLStreamHandlerFactoryQueue();
    private static final CopyOnWriteArrayList _otherFactories = new CopyOnWriteArrayList();

    private URLStreamHandlerFactoryQueue() {
    }

    public static URLStreamHandlerFactory getInstance() {
        return _factory;
    }

    public static void addFactory(URLStreamHandlerFactory factory) {
        if (factory != null) {
            _otherFactories.add(factory);
        }
    }

    public static void addHandler(final String handlerProtocol, final URLStreamHandler handler) {
        URLStreamHandlerFactory factory = new URLStreamHandlerFactory(){

            @Override
            public URLStreamHandler createURLStreamHandler(String protocol) {
                if (handlerProtocol.equals(protocol)) {
                    return handler;
                }
                return null;
            }
        };
        _otherFactories.add(factory);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol != null) {
            for (URLStreamHandlerFactory factory : _otherFactories) {
                URLStreamHandler handler = factory.createURLStreamHandler(protocol);
                if (handler == null) continue;
                return handler;
            }
        }
        return null;
    }

    static {
        try {
            URL.setURLStreamHandlerFactory(_factory);
        }
        catch (Error e) {
            System.err.println("Warning: Unable to set URLStreamHandlerFactory");
        }
    }
}

