/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.logging.Logger;
import oracle.dbtools.raptor.migration.applications.engine.WorkPackageDescriptor;

public class EngineDaemonJobHandler
implements Runnable {
    private Logger logger = Logger.getLogger(EngineDaemonJobHandler.class.getName());
    private Socket socket;
    private WorkPackageDescriptor job;

    public EngineDaemonJobHandler(Socket socket) {
        this.socket = socket;
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(this.socket.getInputStream());
            WorkPackageDescriptor workPackageDescriptor = (WorkPackageDescriptor)objectInputStream.readObject();
            System.out.println("WorkPackage Received: " + workPackageDescriptor);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(this.socket.getOutputStream());
            objectOutputStream.writeObject(workPackageDescriptor.getName() + " scheduled");
            objectInputStream.close();
            objectOutputStream.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public WorkPackageDescriptor getJob() {
        return this.job;
    }
}

