/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.raptor.migration.applications.Messages;
import oracle.dbtools.raptor.migration.applications.engine.ApplicationEngineException;
import oracle.dbtools.raptor.migration.applications.engine.ApplicationLogUtil;
import oracle.dbtools.raptor.migration.applications.engine.EngineCog;
import oracle.dbtools.raptor.migration.applications.engine.EngineCogState;
import oracle.dbtools.raptor.migration.applications.engine.EngineEvent;
import oracle.dbtools.raptor.migration.applications.engine.EngineManagementListeners;
import oracle.dbtools.raptor.migration.applications.engine.IApplicationEngineQueue;
import oracle.dbtools.raptor.migration.applications.engine.IDaemon;
import oracle.dbtools.raptor.migration.applications.engine.WorkPackageDescriptor;

public class ApplicationEngine
implements IApplicationEngineQueue,
Cancelable,
IDaemon {
    private ArrayList<WorkPackageDescriptor> queue;
    private ServerSocket server;
    private int port = 7777;
    private static final String ENGINE_ID = "ApplicationEngine";
    private Logger logger = Logger.getLogger(ApplicationLogUtil.APPL_LOG);
    private EngineCog[] m_cogs;
    private boolean m_cancelled = false;
    private EngineManagementListeners m_ems;
    private boolean daemonRunning;

    public ApplicationEngine(int n) throws ApplicationEngineException {
        this.queue = new ArrayList();
        if (n == 0) {
            this.logger.log(Level.FINE, Messages.getString("ApplicationEngine.INVALID_NOS_THREADS"));
            n = 1;
        }
        this.createCogs(n);
        this.startEngineManagement(this.m_ems);
    }

    private void startEngineManagement(EngineManagementListeners engineManagementListeners) {
        if (engineManagementListeners == null) {
            this.m_ems = new EngineManagementListeners();
        }
    }

    protected void createCogs(int n) {
        this.m_cogs = new EngineCog[n];
        for (int i = 0; i < n; ++i) {
            this.m_cogs[i] = new EngineCog(MessageFormat.format(Messages.getString("ApplicationEngine.COG_NAME"), i + 1), this, true);
        }
    }

    private void startEngine() {
        System.out.println("Starting Engine");
        for (EngineCog engineCog : this.m_cogs) {
            Thread thread = new Thread((Runnable)engineCog, engineCog.getId());
            thread.start();
        }
    }

    private void engineRunning() {
        System.out.println("Engine Running");
        boolean bl = false;
        while (!bl) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.m_cancelled) break;
            bl = this.reportState(1);
        }
    }

    private void stopEngine() {
        System.out.println("Engine spooling down.");
    }

    public void doWork() {
        this.startEngine();
        this.engineRunning();
        this.stopEngine();
    }

    public void signalCancel() {
        this.m_cancelled = true;
        if (this.m_cogs != null) {
            for (EngineCog engineCog : this.m_cogs) {
                engineCog.signalCancel();
            }
        }
        EngineEvent engineEvent = new EngineEvent(-1, ENGINE_ID, null);
        this.m_ems.fireListeners(engineEvent);
    }

    private boolean reportState(int n) {
        boolean bl = true;
        if (this.m_cogs != null) {
            EngineCogState[] engineCogStateArray = new EngineCogState[this.m_cogs.length];
            for (int i = 0; i < this.m_cogs.length; ++i) {
                engineCogStateArray[i] = this.m_cogs[i].getState();
                if (engineCogStateArray[i].getProcessState().equals("Finished")) continue;
                bl = false;
            }
            EngineEvent engineEvent = new EngineEvent(n, ENGINE_ID, engineCogStateArray);
            this.m_ems.fireListeners(engineEvent);
        }
        return bl;
    }

    @Override
    public void startDaemon(int n) {
        try {
            this.daemonRunning = true;
            this.server = new ServerSocket(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void stopDaemon() {
        this.daemonRunning = false;
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            this.logger.log(Level.INFO, iOException.getMessage());
            iOException.printStackTrace();
        }
    }

    @Override
    public void handleConnection() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                while (ApplicationEngine.this.daemonRunning) {
                    try {
                        Socket socket = ApplicationEngine.this.server.accept();
                        ApplicationEngine.this.handleMessage(socket);
                        if (!ApplicationEngine.this.isCanceled()) continue;
                        break;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        };
        Thread thread = new Thread(runnable, "ApplicationEngine:HandleConnections");
        thread.start();
    }

    private boolean isCanceled() {
        return this.m_cancelled;
    }

    protected boolean handleMessage(Socket socket) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            WorkPackageDescriptor workPackageDescriptor = (WorkPackageDescriptor)objectInputStream.readObject();
            System.out.println("WorkPackage Received: " + workPackageDescriptor.getName());
            if (workPackageDescriptor.isFinalJob()) {
                this.m_cancelled = true;
                return false;
            }
            this.scheduleJob(workPackageDescriptor);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(workPackageDescriptor.getName() + " scheduled");
            objectInputStream.close();
            objectOutputStream.close();
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        return true;
    }

    private synchronized void scheduleJob(WorkPackageDescriptor workPackageDescriptor) {
        this.queue.add(workPackageDescriptor);
    }

    public static void main(String[] stringArray) {
        try {
            ApplicationEngine applicationEngine = new ApplicationEngine(10);
            applicationEngine.startDaemon(7777);
            applicationEngine.handleConnection();
            applicationEngine.doWork();
        }
        catch (ApplicationEngineException applicationEngineException) {
            applicationEngineException.printStackTrace();
        }
    }

    @Override
    public synchronized WorkPackageDescriptor getWorkPackage() {
        if (this.queue.size() > 0) {
            WorkPackageDescriptor workPackageDescriptor = this.queue.get(0);
            this.queue.remove(0);
            return workPackageDescriptor;
        }
        return null;
    }
}

