/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.migration.applications.cmdline;

import java.util.concurrent.TimeUnit;
import oracle.dbtools.migration.command_line.CMDOut;
import oracle.dbtools.migration.command_line.MigrationDetails;
import oracle.dbtools.raptor.migration.applications.addin.ApplicationAddin;
import oracle.dbtools.raptor.migration.applications.addin.ProcessorException;
import oracle.dbtools.raptor.migration.applications.cmdline.ScannerDetails;
import oracle.dbtools.raptor.migration.applications.cmdline.UsageHelp;
import oracle.dbtools.raptor.migration.applications.report.ReportEngine;
import oracle.dbtools.raptor.migration.applications.report.ReportEngineFactory;
import oracle.dbtools.raptor.migration.applications.report.Summary;
import oracle.dbtools.raptor.migration.applications.scanner.FileProcessor;
import oracle.ide.Ide;
import oracle.ide.IdeArgs;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;

public class ApplicationScanner
extends IdeRunner {
    public void runCommand(IdeStarter ideStarter) {
        IdeArgs ideArgs = Ide.getIdeArgs();
        String[] stringArray = ideArgs.getArgs();
        ScannerDetails scannerDetails = ScannerDetails.getInstance();
        scannerDetails.setOptions(new MigrationDetails(stringArray));
        scannerDetails.setDefaults();
        CMDOut cMDOut = new CMDOut(false, System.out, System.err);
        try {
            if (scannerDetails.isHelpSpecified()) {
                scannerDetails.help();
            } else if (scannerDetails.isValid()) {
                long l = System.currentTimeMillis();
                this.execute(scannerDetails);
                long l2 = System.currentTimeMillis();
                this.reportDuration(l, l2);
            } else {
                scannerDetails.usage(scannerDetails.getError_message());
            }
        }
        catch (ProcessorException processorException) {
            UsageHelp.usage(processorException.getMessage(), cMDOut);
            System.exit(1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private void execute(ScannerDetails scannerDetails) throws ProcessorException {
        ApplicationAddin.registerPackage("oracle.dbtools.raptor.migration.applications.rules.xml");
        FileProcessor fileProcessor = new FileProcessor(scannerDetails);
        ReportEngine reportEngine = ReportEngineFactory.getEngine(scannerDetails);
        fileProcessor.addListener(reportEngine);
        Summary summary = null;
        if (scannerDetails.isAnalysisRequired()) {
            summary = new Summary();
            fileProcessor.addListener(summary);
        }
        fileProcessor.process();
        reportEngine.generateReport(summary);
        fileProcessor.removeListener(reportEngine);
        fileProcessor.removeListener(summary);
    }

    private void reportDuration(long l, long l2) {
        long l3 = l2 - l;
        String string = String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(l3), TimeUnit.MILLISECONDS.toSeconds(l3) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(l3)));
        System.out.println("Scanned in " + string);
    }
}

