/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.quickdiff.QuickDiffAddin;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;

class QuickDiffController
implements Controller {
    QuickDiffController() {
    }

    public boolean handleEvent(IdeAction action, Context context) {
        if (action.getCommandId() == QuickDiffAddin.ENABLE_QUICKDIFF_CMD_ID || action.getCommandId() == QuickDiffAddin.DISABLE_QUICKDIFF_CMD_ID) {
            BasicEditorPane editorPane = QuickDiffController.getEditorPane(context);
            if (editorPane == null) {
                return true;
            }
            boolean enableQuickDiff = action.getCommandId() == QuickDiffAddin.ENABLE_QUICKDIFF_CMD_ID;
            Ide.getDTCache().putBoolean("QuickDiff.Enabled", enableQuickDiff);
            EditorProperties.getProperties().putBooleanProperty("show-quickdiff-margin", enableQuickDiff);
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        if (action.getCommandId() == QuickDiffAddin.ENABLE_QUICKDIFF_CMD_ID || action.getCommandId() == QuickDiffAddin.DISABLE_QUICKDIFF_CMD_ID) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    static final BasicEditorPane getEditorPane(Context context) {
        CodeEditor codeEditor = null;
        if (context.getView() instanceof CodeEditor) {
            codeEditor = (CodeEditor)context.getView();
        }
        if (context.getView().owner() instanceof CodeEditor) {
            codeEditor = (CodeEditor)context.getView().owner();
        }
        return codeEditor != null ? codeEditor.getFocusedEditorPane() : null;
    }
}

