/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.quickdiff;

import java.util.Collections;
import java.util.List;
import java.util.Observable;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorGutter;
import oracle.ide.ceditor.EditorPluginsFactory;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.quickdiff.QuickDiffContextMenuListener;
import oracle.ide.quickdiff.QuickDiffController;
import oracle.ide.quickdiff.QuickDiffMargin;
import oracle.ide.quickdiff.QuickDiffReferenceProvider;
import oracle.ide.quickdiff.QuickDiffReferenceRegistry;
import oracle.ide.quickdiff.res.QuickDiffArb;
import oracle.ideimpl.quickdiff.reference.FileOnDiskReferenceProvider;
import oracle.ideimpl.quickdiff.reference.OldestLocalStateReferenceProvider;
import oracle.javatools.editor.EditorProperties;

class QuickDiffAddin
implements Addin,
EditorPluginsFactory {
    private static final String ENABLE_QUICKDIFF_CMD = "QuickDiff.EnableQuickDiff";
    static final int ENABLE_QUICKDIFF_CMD_ID = Ide.findOrCreateCmdID((String)"QuickDiff.EnableQuickDiff");
    private static final String DISABLE_QUICKDIFF_CMD = "QuickDiff.DisableQuickDiff";
    static final int DISABLE_QUICKDIFF_CMD_ID = Ide.findOrCreateCmdID((String)"QuickDiff.DisableQuickDiff");
    private static final ProviderObservable _providerObservable = new ProviderObservable();
    static final String QUICKDIFF_ENABLED_DTCACHE_KEY = "QuickDiff.Enabled";
    private static final String QUICKDIFF_REFERENCE_DTCACHE_KEY = "QuickDiff.Reference";

    QuickDiffAddin() {
    }

    public final void initialize() {
        CodeEditor.registerFactory((EditorPluginsFactory)this);
        QuickDiffReferenceRegistry.register(new FileOnDiskReferenceProvider());
        QuickDiffReferenceRegistry.register(new OldestLocalStateReferenceProvider());
        IdeAction enableQuickDiffAction = IdeAction.get((int)ENABLE_QUICKDIFF_CMD_ID, (String)ENABLE_QUICKDIFF_CMD, (String)StringUtils.stripMnemonic((String)QuickDiffArb.getString(3)), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)QuickDiffArb.getString(3))), null, null, (boolean)true);
        enableQuickDiffAction.addController((Controller)new QuickDiffController());
        IdeAction disableQuickDiffAction = IdeAction.get((int)DISABLE_QUICKDIFF_CMD_ID, (String)DISABLE_QUICKDIFF_CMD, (String)StringUtils.stripMnemonic((String)QuickDiffArb.getString(4)), (String)IdeMainWindow.ACTION_CATEGORY_TOOLS, (Integer)new Integer(StringUtils.getMnemonicKeyCode((String)QuickDiffArb.getString(4))), null, null, (boolean)true);
        disableQuickDiffAction.addController((Controller)new QuickDiffController());
        CodeEditorGutter.getGutterContextMenu().addContextMenuListener((ContextMenuListener)new QuickDiffContextMenuListener());
        boolean enableQuickDiff = Ide.getDTCache().getBoolean(QUICKDIFF_ENABLED_DTCACHE_KEY, true);
        EditorProperties.getProperties().putBooleanProperty("show-quickdiff-margin", enableQuickDiff);
        String id = Ide.getDTCache().getString(QUICKDIFF_REFERENCE_DTCACHE_KEY);
        if (id == null) {
            Ide.getDTCache().putString(QUICKDIFF_REFERENCE_DTCACHE_KEY, "FileOnDisk");
        }
    }

    public List createPlugins(Context ideContext) {
        return Collections.singletonList(new QuickDiffMargin(ideContext));
    }

    static final ProviderObservable getProviderObservable() {
        return _providerObservable;
    }

    static final class ProviderObservable
    extends Observable {
        ProviderObservable() {
        }

        final QuickDiffReferenceProvider getProvider() {
            String id = Ide.getDTCache().getString(QuickDiffAddin.QUICKDIFF_REFERENCE_DTCACHE_KEY);
            return id != null ? QuickDiffReferenceRegistry.lookup(id) : null;
        }

        final void setProvider(QuickDiffReferenceProvider provider) {
            if (provider == this.getProvider()) {
                return;
            }
            Ide.getDTCache().putString(QuickDiffAddin.QUICKDIFF_REFERENCE_DTCACHE_KEY, provider.getID());
            this.setChanged();
            this.notifyObservers();
        }
    }
}

