/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.preferences.GeneratePreferencesPanel;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPreferences;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.MigrationWizardFinisher;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizard;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryCategory;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryItem;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.SummaryProvider;
import oracle.dbtools.raptor.controls.ConnectionPanelUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.model.Element;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.HyperlinkButton;

public class TargetDBPageMigration
extends DefaultTraversablePanel
implements CommitListener,
SummaryProvider {
    private final MultiLineLabel _lblOverview = new MultiLineLabel(QMWizardArb.getString("TargetDBSelectionOnlineOverview"));
    private final MultiLineLabel _lblOverview2 = new MultiLineLabel(QMWizardArb.getString("TargetDBSelectionOfflineOverview"));
    static final String ONLINEPANEL = "Online Script Genenration";
    static final String OFFLINEPANEL = "Offline Script Genenration";
    private final JRadioButton _rbtnOnlineCapture = new JRadioButton("", true);
    private final JRadioButton _rbtnOfflineCapture = new JRadioButton();
    private final JRadioButton _rbtnUnknown = new JRadioButton();
    private ConnectionPanelUI _connectPanel = null;
    private final JLabel _lblOutputDir = new JLabel(QMWizardArb.getString("ScriptDir"));
    private final JLabel _lblOutputDirValue = new JLabel();
    private final JLabel _lblOutputDir2 = new JLabel(QMWizardArb.getString("ScriptDir"));
    private final JLabel _lblOutputDirValue2 = new JLabel();
    private final HyperlinkButton _prefDlgActivate = new HyperlinkButton(QMWizardArb.getString("AdvanceOptions").trim());
    private final JPanel _topPanel = new JPanel();
    private final CardLayout _cl = new CardLayout();
    private final JCheckBox _chkDropSchema = new JCheckBox();
    private final JCheckBox _chkGoSummary = new JCheckBox();
    private boolean _skip = true;
    private boolean _pageLocked = false;

    TargetDBPageMigration() {
        ResourceUtils.resButton((AbstractButton)this._rbtnOnlineCapture, (String)QMWizardArb.getString("OnlineCapture"));
        ResourceUtils.resButton((AbstractButton)this._rbtnOfflineCapture, (String)QMWizardArb.getString("OfflineCapture"));
        ResourceUtils.resButton((AbstractButton)this._chkDropSchema, (String)QMWizardArb.getString("DropDB"));
        ResourceUtils.resButton((AbstractButton)this._chkGoSummary, (String)QMWizardArb.getString("GoToSummary"));
        this.putClientProperty("pagetitle", QMWizard.TGTDB_PAGE_ID);
        QMWizard.ContextHelper.addSummaryProvider(QMWizard.TGTDB_PAGE_ID, this);
        this.initGUI();
    }

    public void onEntry(TraversableContext traversableContext) {
        this._lblOutputDirValue.setText((String)traversableContext.get("OUTPUT_DIR") + File.separator + QMWizardArb.getString("Generated"));
        this._lblOutputDirValue2.setText((String)traversableContext.get("OUTPUT_DIR") + File.separator + QMWizardArb.getString("Generated"));
        if (this._connectPanel != null) {
            this._connectPanel.resetConnections();
        }
        this.skipIfNeeded(traversableContext);
        if (this._pageLocked) {
            traversableContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        if (traversableContext.getDirection() == 1) {
            this.validateAndAbsorbPage(traversableContext);
        }
        if (!this._pageLocked) {
            if (traversableContext.getDirection() == 2) {
                QMWizard.ContextHelper.removeCommitPage(QMWizardArb.getString("STEP7"));
            } else if (traversableContext.getDirection() == 1) {
                QMWizard.ContextHelper.addCommitPage(QMWizardArb.getString("STEP7"));
            }
        }
    }

    public Object getExitTransition() {
        if (this._chkGoSummary.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }

    @Override
    public SummaryItem getSummary(SummaryCategory summaryCategory) {
        SummaryCategory summaryCategory2 = null;
        SummaryItem summaryItem = null;
        if (summaryCategory != null) {
            summaryCategory2 = summaryCategory;
            if (this._rbtnOnlineCapture.isSelected()) {
                summaryItem = new SummaryItem(QMWizardArb.getString("ScriptGenMode"), StringUtils.stripMnemonic((String)QMWizardArb.getString("OnlineCapture")));
                summaryCategory2.addChild(summaryItem);
                summaryItem = new SummaryItem(QMWizardArb.getString("TargetConnection"), Connections.getDisplayName((String)this._connectPanel.getConnectionName()));
                summaryCategory2.addChild(summaryItem);
                summaryItem = new SummaryItem(QMWizardArb.getString("GenDir"), this._lblOutputDirValue.getText());
                summaryCategory2.addChild(summaryItem);
            }
            if (this._rbtnOfflineCapture.isSelected()) {
                summaryItem = new SummaryItem(QMWizardArb.getString("ScriptGenMode"), StringUtils.stripMnemonic((String)QMWizardArb.getString("OfflineCapture")));
                summaryCategory2.addChild(summaryItem);
                summaryItem = new SummaryItem(QMWizardArb.getString("GenDir"), this._lblOutputDirValue2.getText());
                summaryCategory2.addChild(summaryItem);
            }
            if (this._chkDropSchema.isSelected()) {
                summaryItem = new SummaryItem(StringUtils.stripMnemonic((String)QMWizardArb.getString("DropDB")), QMWizardArb.getString("Yes"));
                summaryCategory2.addChild(summaryItem);
            } else {
                summaryItem = new SummaryItem(StringUtils.stripMnemonic((String)QMWizardArb.getString("DropDB")), QMWizardArb.getString("No"));
                summaryCategory2.addChild(summaryItem);
            }
        }
        return summaryCategory2;
    }

    public void checkCommit(ApplyEvent applyEvent) throws TraversalException {
    }

    public void commit(ApplyEvent applyEvent) throws TraversalException {
        TraversableContext traversableContext = applyEvent.getTraversableContext();
        String string = (String)this.getClientProperty("pagetitle");
        if (QMWizard.ContextHelper.isActiveCommitPage(string)) {
            Element element;
            MdConnection mdConnection;
            Properties properties = new Properties();
            MigrationWizardFinisher migrationWizardFinisher = null;
            if (this._rbtnOnlineCapture.isSelected()) {
                properties.put("GEN_MODE", "Online");
                properties.put("GEN_TGTCONN", this._connectPanel.getConnectionName());
                properties.put("GEN_SCRIPTDIR", this._lblOutputDirValue.getText().trim());
            } else if (this._rbtnOfflineCapture.isSelected()) {
                properties.put("GEN_MODE", "Offline");
                properties.put("GEN_SCRIPTDIR", this._lblOutputDirValue2.getText().trim());
            }
            MdConnection mdConnection2 = QMWizard.ContextHelper.getCapturedConnectionObject();
            if (mdConnection2 != null) {
                properties.put("CONV_CATPCONN", mdConnection2);
            }
            properties.put("GEN_DROP_ENABLED", (Object)this._chkDropSchema.isSelected());
            MdProject mdProject = QMWizard.ContextHelper.getProject();
            if (mdProject != null) {
                properties.put("PARAM_PROJ", mdProject);
            }
            if ((mdConnection = QMWizard.ContextHelper.getConvertedConnectionObject()) != null) {
                properties.put("CONV_CONVCONN", mdConnection);
            }
            if ((element = QMWizard.ContextHelper.getContextElement()) != null) {
                properties.put("CTX_ELEMENT", element);
            }
            migrationWizardFinisher = QMWizard.ContextHelper.getWizardFinisher();
            migrationWizardFinisher.setParamAndFinish(properties, 32);
        }
    }

    public void rollback(ApplyEvent applyEvent) {
    }

    public void cancel(ApplyEvent applyEvent) {
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        ModeActionListener modeActionListener = new ModeActionListener();
        jPanel3.setLayout(new FlowLayout(0));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this._rbtnOnlineCapture);
        buttonGroup.add(this._rbtnOfflineCapture);
        buttonGroup.add(this._rbtnUnknown);
        this._rbtnOnlineCapture.addActionListener(modeActionListener);
        this._rbtnOfflineCapture.addActionListener(modeActionListener);
        jPanel3.add(this._rbtnOnlineCapture);
        jPanel3.add(this._rbtnOfflineCapture);
        jPanel3.setBorder(BorderFactory.createTitledBorder(QMWizardArb.getString("Mode")));
        this._topPanel.setLayout(this._cl);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        this._topPanel.add((Component)jPanel4, ONLINEPANEL);
        this._topPanel.add((Component)jPanel5, OFFLINEPANEL);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)new JLabel(QMWizardArb.getString("NoInfomationAvailable")), "Center");
        this._topPanel.add((Component)jPanel6, "unknown");
        jPanel4.setLayout(new GridBagLayout());
        this._connectPanel = new ConnectionPanelUI(true, false);
        this._connectPanel.setConnectionPrompt(QMWizardArb.getString("TargetDBSelectionOnlineOverview"));
        jPanel4.add((Component)this._connectPanel, new GridBagConstraints(0, 0, 0, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this._lblOutputDir, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel4.add((Component)this._lblOutputDirValue, new GridBagConstraints(1, 2, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel5.setLayout(new GridBagLayout());
        jPanel5.add((Component)this._lblOverview2, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 11, 1, new Insets(10, 0, 10, 0), 0, 0));
        jPanel5.add((Component)this._lblOutputDir2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 10, 0), 0, 0));
        jPanel5.add((Component)this._lblOutputDirValue2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 10, 0), 0, 0));
        jPanel5.add((Component)new JLabel(), new GridBagConstraints(2, 2, 0, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 5, 0), 0, 0));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)this._topPanel, "Center");
        jPanel2.add((Component)this._chkDropSchema, "South");
        this.setLayout(new BorderLayout());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this._chkGoSummary, "West");
        jPanel7.add((Component)this._prefDlgActivate, "East");
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel7, "South");
        this.add(jPanel, "Center");
        this._prefDlgActivate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdeSettings ideSettings = Ide.getSettings();
                String[] stringArray = new String[]{MigrationPreferences.TITLE, GeneratePreferencesPanel.TITLE};
                ideSettings.showDialog((Frame)Ide.getMainWindow(), stringArray);
            }
        });
    }

    private void skipIfNeeded(TraversableContext traversableContext) {
        if (this._skip && QMWizard.ContextHelper.isMigrationAction() && QMWizard.ContextHelper.getActionName() != null && QMWizard.ContextHelper.getActionName().equals(MigrationProjectNavigatorArb.getString("DATAMOVE_PAGE").trim())) {
            this._skip = false;
            this.lockPage(false);
            this.initPageState(traversableContext);
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
    }

    private void initPageState(TraversableContext traversableContext) {
        String string = QMWizard.ContextHelper.getProjectName();
        boolean bl = QMWizard.ContextHelper.isScriptGenModeOnline();
        boolean bl2 = QMWizard.ContextHelper.isScriptGenModeOffline();
        if (bl) {
            String string2 = QMWizard.ContextHelper.getProjectTargetConnection(string);
            this._connectPanel.setSelectedItem(string2);
            this._rbtnOnlineCapture.doClick();
        } else if (bl2) {
            this._rbtnOfflineCapture.doClick();
        } else if (this._pageLocked) {
            this._cl.show(this._topPanel, "unknown");
            this._rbtnUnknown.setSelected(true);
            this._chkDropSchema.setVisible(false);
            this._prefDlgActivate.setVisible(false);
            this._chkGoSummary.setVisible(false);
            this.revalidate();
        }
    }

    private void lockPage(boolean bl) {
        this._pageLocked = true;
        this.disablePageWidgets();
    }

    private void disablePageWidgets() {
        if (this._lblOverview != null) {
            this._lblOverview.setEnabled(false);
        }
        if (this._lblOverview2 != null) {
            this._lblOverview2.setEnabled(false);
        }
        if (this._lblOutputDir != null) {
            this._lblOutputDir.setEnabled(false);
        }
        if (this._lblOutputDirValue != null) {
            this._lblOutputDirValue.setEnabled(false);
        }
        if (this._lblOutputDir2 != null) {
            this._lblOutputDir2.setEnabled(false);
        }
        if (this._lblOutputDirValue2 != null) {
            this._lblOutputDirValue2.setEnabled(false);
        }
        if (this._chkDropSchema != null) {
            this._chkDropSchema.setEnabled(false);
        }
        this._prefDlgActivate.setEnabled(false);
        this._chkGoSummary.setEnabled(false);
        if (this._connectPanel != null) {
            this._connectPanel.setEnabled(false);
        }
        if (this._rbtnOnlineCapture != null) {
            this._rbtnOnlineCapture.setEnabled(false);
        }
        if (this._rbtnOfflineCapture != null) {
            this._rbtnOfflineCapture.setEnabled(false);
        }
    }

    private void validateAndAbsorbPage(TraversableContext traversableContext) throws TraversalException {
        String string = null;
        if (this._rbtnOnlineCapture.isSelected()) {
            string = this._connectPanel.getConnectionName();
            if (string == null || string.trim().length() <= 0) {
                throw new TraversalException(QMWizardArb.getString("InvalidTgtConnection"));
            }
            traversableContext.put("TARGET_CONN", (Object)string.trim());
            traversableContext.put("GEN_MODE_ONLINE", (Object)true);
            traversableContext.put("GEN_MODE_OFFLINE", (Object)false);
        } else if (this._rbtnOfflineCapture.isSelected()) {
            traversableContext.put("GEN_MODE_OFFLINE", (Object)true);
            traversableContext.put("GEN_MODE_ONLINE", (Object)false);
            traversableContext.put("TARGET_CONN", null);
        } else {
            QMWizard.ContextHelper.clearScriptGenMode();
        }
        if (this._chkDropSchema.isSelected()) {
            traversableContext.put("DROP_TARGET_OBJECTS", (Object)true);
        } else {
            traversableContext.put("DROP_TARGET_OBJECTS", (Object)false);
        }
    }

    private class ModeActionListener
    implements ActionListener {
        private ModeActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == TargetDBPageMigration.this._rbtnOnlineCapture) {
                TargetDBPageMigration.this._cl.show(TargetDBPageMigration.this._topPanel, TargetDBPageMigration.ONLINEPANEL);
            } else {
                TargetDBPageMigration.this._cl.show(TargetDBPageMigration.this._topPanel, TargetDBPageMigration.OFFLINEPANEL);
            }
        }
    }
}

