/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui.quickmigrate;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextPane;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.quickmigrate.QMWizardArb;
import oracle.dbtools.raptor.connections.ConnectionComboRenderer;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.db.DatabaseConnectionEditor;

public class SourceSelector
extends DefaultTraversablePanel {
    protected static final Logger LOGGER = Logger.getLogger(SourceSelector.class.getName());
    private static final long serialVersionUID = 329069071724645146L;
    private JComboBox m_cmbSourceConnection = new JComboBox();
    private JTextPane m_txtSourceDescription = new JTextPane();
    private JButton m_btnAddSource = new JButton();
    private boolean m_sourceIsPreSelected = false;
    private String m_sourceConnection;
    private static final String HTMLCONTENT = "text/html";
    private TraversableContext m_dataContext;
    private JCheckBox proceedToSummaryCheckBox = new JCheckBox();

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public SourceSelector() {
        this.populatecConnectionCombos(true);
        this.m_cmbSourceConnection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Connections connections = Connections.getInstance();
                Connection connection = null;
                try {
                    connection = connections.getConnection((String)SourceSelector.this.m_cmbSourceConnection.getSelectedItem());
                }
                catch (DBException dBException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                }
                if (connection != null) {
                    SourceSelector.this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(true), Boolean.valueOf(false));
                    SourceSelector.this.m_sourceConnection = (String)SourceSelector.this.m_cmbSourceConnection.getItemAt(0);
                } else {
                    SourceSelector.this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
                }
            }
        });
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this.m_btnAddSource, (String)MigrationAddinArb.getString("QUICKMIGRATE_BUTTON_ADD_SOURCE"));
        this.m_btnAddSource.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SourceSelector.this.newSourceOrTarget();
            }
        });
        this.m_cmbSourceConnection.setRenderer(new ConnectionComboRenderer());
        this.add(this.m_cmbSourceConnection, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        Dimension dimension = new Dimension(72, 22);
        this.m_btnAddSource.setMinimumSize(dimension);
        this.m_btnAddSource.setMaximumSize(dimension);
        this.m_btnAddSource.setPreferredSize(dimension);
        this.add(this.m_btnAddSource, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        Font font = this.m_btnAddSource.getFont();
        String string = MigrationUtils.fontToCSSString(font);
        this.m_txtSourceDescription.setContentType(HTMLCONTENT);
        this.m_txtSourceDescription.setText(MigrationAddinArb.format("QUICKMIGRATE_SOURCE_DESC", string));
        this.m_txtSourceDescription.setEditable(false);
        this.m_txtSourceDescription.setOpaque(false);
        this.m_txtSourceDescription.setRequestFocusEnabled(false);
        this.m_txtSourceDescription.setFocusable(false);
        this.add(this.m_txtSourceDescription, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.proceedToSummaryCheckBox.setText(QMWizardArb.get("ProceedToSummaryLabel"));
        this.add(this.proceedToSummaryCheckBox, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 14, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void newSourceOrTarget() {
        DatabaseConnectionEditor.editConnection((String)"IdeConnections", null);
        this.populatecConnectionCombos(true);
    }

    private void populatecConnectionCombos(boolean bl) {
        String[] stringArray;
        String string = null;
        if (bl && !this.m_sourceIsPreSelected) {
            string = (String)this.m_cmbSourceConnection.getSelectedItem();
        }
        this.m_cmbSourceConnection.removeAllItems();
        Connections connections = Connections.getInstance();
        for (String string2 : stringArray = connections.getConnNames()) {
            if (connections.isOracle(string2) || connections.isTimesTen(string2)) continue;
            this.m_cmbSourceConnection.addItem(string2);
        }
        if (bl && string != null && !this.m_sourceIsPreSelected) {
            this.m_cmbSourceConnection.setSelectedItem(string);
        }
    }

    public void setSourceConnection(String string) {
        int n = this.m_cmbSourceConnection.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!((String)this.m_cmbSourceConnection.getItemAt(i)).equals(string)) continue;
            this.m_cmbSourceConnection.setSelectedIndex(i);
            break;
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        this.m_dataContext = traversableContext;
        this.m_dataContext.getWizardCallbacks().wizardEnableButtons(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false));
        this.m_sourceConnection = (String)traversableContext.get("SOURCE_CONNECTION");
        if (this.m_sourceConnection != null) {
            this.m_cmbSourceConnection.setSelectedItem(this.m_sourceConnection);
        } else if (this.m_cmbSourceConnection.getSelectedObjects().length > 0) {
            this.m_cmbSourceConnection.setSelectedIndex(0);
            this.m_sourceConnection = (String)this.m_cmbSourceConnection.getItemAt(0);
        }
        this.proceedToSummaryCheckBox.setSelected(false);
        this.m_dataContext.put("DO_CONVERT", (Object)true);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string = (String)this.m_cmbSourceConnection.getSelectedItem();
        traversableContext.put("SOURCE_CONNECTION", (Object)string);
        Connections connections = Connections.getInstance();
        Connection connection = null;
        try {
            connection = connections.getConnection(string);
        }
        catch (DBException dBException) {
            SourceSelector.log(dBException);
        }
        traversableContext.put("SOURCE_CONNECTION_OBJ", (Object)connection);
        traversableContext.put("PLUGIN", (Object)MigrationAddin.getPluginForConnection(connection));
        if (null == traversableContext.get("PLUGIN")) {
            String string2 = Connections.getDisplayName((String)string);
            throw new TraversalException(QMWizardArb.format("SourceSelector_NoPluginFound", string2));
        }
        if (this.proceedToSummaryCheckBox.isSelected()) {
            traversableContext.put("DO_CONVERT", (Object)false);
        }
    }

    public Object getExitTransition() {
        if (this.proceedToSummaryCheckBox.isSelected()) {
            return "TRANSITION_TO_SUMMARY";
        }
        return null;
    }
}

