/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import javax.swing.JPanel;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.MigrationLogPanel;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogWindow;

public final class MigrationLogPage
extends AbstractLogPage
implements CaptureEventListener,
Cancelable {
    private static MigrationLogPage s_instance = null;
    public static final String MESSAGE_PAGE_ID = "MigrationLog";
    private Controller m_controller = new MigrationLogController();
    private JPanel _ui;

    public static MigrationLogPage getMigrationLog() {
        if (s_instance == null) {
            MigrationLogPage.addMigrationLogPage(Messages.getString("MigrationLogPage.1"), true);
            return MigrationLogPage.getMigrationLog();
        }
        return s_instance;
    }

    public static void addMigrationLogPage(String string, boolean bl) {
        MigrationLogPage migrationLogPage = new MigrationLogPage();
        MigrationLogPage.setMigrationLogInstance(migrationLogPage);
        migrationLogPage.log(string);
        if (bl) {
            LogWindow logWindow = LogManager.getIdeLogWindow();
            DockStation.getDockStation().activateDockable((Dockable)logWindow);
        }
    }

    protected MigrationLogPage getMigrationLogInstance() {
        return s_instance;
    }

    protected static void setMigrationLogInstance(MigrationLogPage migrationLogPage) {
        s_instance = migrationLogPage;
    }

    private MigrationLogPage() {
        super(new ViewId(MESSAGE_PAGE_ID, Messages.getString("MigrationLogPage.2")), null, true);
        ContextMenu contextMenu = LogManager.getLogManager().getContextMenu();
        contextMenu.addContextMenuListener(new ContextMenuListener(){

            public void poppingUp(ContextMenu contextMenu) {
            }

            public void poppingDown(ContextMenu contextMenu) {
            }

            public boolean handleDefaultAction(Context context) {
                return false;
            }

            public void menuWillShow(ContextMenu contextMenu) {
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }
        });
    }

    @Override
    public void signalCancel() {
    }

    protected void log(String string) {
    }

    @Override
    public void raiseEvent(CaptureEvent captureEvent) {
        String string = "";
        switch (captureEvent.getEventId()) {
            case 1: {
                string = MigrationAddinArb.getString("CAPTURING") + " " + captureEvent.getEventSource();
                this.log(string);
                break;
            }
            case 2: {
                string = captureEvent.getEventSource() + " " + MigrationAddinArb.getString("CAPTURED");
                this.log(string);
                break;
            }
            case 3: {
                string = MigrationAddinArb.getString("STORING") + " " + captureEvent.getEventSource();
                this.log(string);
                break;
            }
            case 4: {
                string = MigrationAddinArb.getString("STORED") + " " + captureEvent.getEventSource();
                this.log(string);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                string = MigrationAddinArb.getString("START_CAPTURE");
                this.log(string);
                break;
            }
            case 7: {
                string = MigrationAddinArb.getString("START_CAPTURE");
                this.log(string);
                break;
            }
        }
    }

    public Component getGUI() {
        if (this._ui == null) {
            this._ui = new MigrationLogPanel();
        }
        return this._ui;
    }

    private class MigrationLogController
    implements Controller {
        private MigrationLogController() {
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != 18) {
                return false;
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(Messages.getString("MigrationLogPage.8")), null);
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            if (n != 18) {
                return false;
            }
            ideAction.setEnabled(true);
            return true;
        }
    }
}

