/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.createRepository.RepositoryRegistry;
import oracle.dbtools.metadata.createRepository.RunRepositoryScripts;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.CaptureWorker;
import oracle.dbtools.migration.capture.OnlineCaptureWorker;
import oracle.dbtools.migration.convert.ConvertEventListener;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.convert.DataTypeConversionMap;
import oracle.dbtools.migration.convert.SupportedDataTypesMap;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.online.DataMoveGui;
import oracle.dbtools.migration.datamove.online.DataMoveWorker;
import oracle.dbtools.migration.generate.GenerateWorker;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.SimpleGenerationOutputStream;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationFilterUtil;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.dbtools.migration.workbench.core.ui.CaptureEventListenerPanel;
import oracle.dbtools.migration.workbench.core.ui.ConvertEventListenerPanel;
import oracle.dbtools.migration.workbench.core.ui.FullMigrationTopPanel;
import oracle.dbtools.migration.workbench.core.ui.GenerateEventListenerPanel;
import oracle.dbtools.migration.workbench.core.ui.Messages;
import oracle.dbtools.migration.workbench.core.ui.RunRepoScriptPanel;
import oracle.dbtools.raptor.dialogs.user.ResultPanel;
import oracle.dbtools.raptor.newscriptrunner.OutputRedirector;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicEditorPane;
import oracle.jdeveloper.db.ConnectionException;

public class FullMigrateProgressRunnable
extends AbstractMigrationProgressRunnable {
    private static final String CURRENTSTEP_CREATE = "CREATEREPO";
    private static final String CURRENTSTEP_REMOVE = "REMOVEREPO";
    private FullMigrationTopPanel m_topPanel;
    private CaptureWorker m_captureWorker;
    private MigrationPlugin m_plugin;
    private URL m_url;
    private String m_generationConnectionName;
    private String m_sourceConnectionName;
    private static Logger s_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private File m_generateSQLFile;
    private boolean m_leastPrivilege = false;
    private boolean m_needToCreateARepo = false;
    private boolean m_needToDropARepo = false;
    private String m_currentStep = null;
    private RunRepoScriptPanel m_currentRepoPanel;
    private ThirdPartyDbProvider m_provider;
    private String m_migrationType;
    private Context m_context;

    public FullMigrateProgressRunnable(MigrationPlugin migrationPlugin, Connection connection, String string, String string2, boolean bl, String string3) throws MigrationPluginException {
        this.m_plugin = migrationPlugin;
        this.m_sourceConnectionName = string;
        this.m_generationConnectionName = string2;
        if (MigrationAddin.getPersistenceManager() == null || !RepositoryManager.doesRepositoryExist(MigrationAddin.getPersistenceManager().getConn())) {
            this.m_needToCreateARepo = true;
            this.m_needToDropARepo = bl;
        }
        this.m_provider = this.m_plugin.getProvider(connection);
        this.m_migrationType = string3;
        this.setTitle(MigrationAddinArb.getString("QUICKMIGRATE_DIALOG_TITLE"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object doWork() throws Exception {
        PersistenceManager persistenceManager = null;
        if (this.m_needToCreateARepo ? (persistenceManager = this.doCreateRepo()) == null : (persistenceManager = MigrationAddin.getPersistenceManager()) == null) {
            return Boolean.FALSE;
        }
        MdConnection mdConnection = this.doCapture(persistenceManager);
        if (mdConnection == null) {
            return Boolean.FALSE;
        }
        MdConnection mdConnection2 = this.doConvert(persistenceManager, mdConnection);
        if (mdConnection2 == null) {
            return Boolean.FALSE;
        }
        if (!this.doGenerate(mdConnection2)) {
            return Boolean.FALSE;
        }
        try {
            if (!this.runGenerateScript()) {
                Boolean bl;
                boolean bl2 = MessageDialog.confirm((Component)this.getTopPanel(), (Object)MigrationAddinArb.getString("QUICKMIGRATE_BUILD_CHOICE"), (String)MigrationAddinArb.getString("QUICKMIGRATE_BUILD_FAIL_TITLE"), (String)"help_drop_out_of_quick");
                if (bl2) {
                    bl = null;
                    bl = (SqlNode)NodeFactory.findOrCreate(SqlNode.class, (URL)this.m_url);
                    Boolean bl3 = bl;
                    if (bl3 != null) {
                        SwingUtilities.invokeLater(new Runnable((SqlNode)bl3){
                            final /* synthetic */ SqlNode val$sn;
                            {
                                this.val$sn = sqlNode;
                            }

                            @Override
                            public void run() {
                                IdeUtil.invokeAfterRepaint((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        EditorUtil.openDefaultEditorInFrame((Node)val$sn);
                                    }
                                });
                            }
                        });
                    }
                }
                bl = Boolean.FALSE;
                return bl;
            }
            if (!this.m_migrationType.equals(MigrationAddinArb.getString("FULLMIGRATION_MTYPE_TABLE")) && !this.doDataMove(persistenceManager, mdConnection2.getKey())) {
                Boolean bl = Boolean.FALSE;
                return bl;
            }
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
        if (this.m_needToDropARepo) {
            if (this.m_migrationType.equals(MigrationAddinArb.getString("FULLMIGRATION_MTYPE_TABLE"))) {
                this.m_topPanel.nextStep();
            }
            if (!this.dropTheRepo()) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private boolean runRepositoryScripts(String string, int n, String string2, String string3) {
        Connection connection;
        this.m_currentRepoPanel = new RunRepoScriptPanel();
        this.m_topPanel.addTab(null, string2, this.m_currentRepoPanel.getPanel());
        this.m_topPanel.nextStep();
        try {
            connection = Connections.getInstance().getConnection(this.m_generationConnectionName);
        }
        catch (DBException dBException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, MigrationAddinArb.format("QM_SCRIPTRUN_FAIL", string, dBException.getLocalizedMessage()));
            return false;
        }
        RunRepositoryScripts runRepositoryScripts = new RunRepositoryScripts(connection);
        runRepositoryScripts.setProgressBar(this);
        runRepositoryScripts.setMode(n);
        runRepositoryScripts.setScript(string);
        this.setUseBuzyBar(false);
        this.m_currentStep = string3;
        JProgressBar jProgressBar = this.getProgBar().getProgressBar();
        jProgressBar.setIndeterminate(false);
        jProgressBar.setMinimum(0);
        jProgressBar.setMaximum(100);
        jProgressBar.setStringPainted(true);
        runRepositoryScripts.run();
        jProgressBar.setStringPainted(false);
        jProgressBar.setIndeterminate(true);
        this.m_currentStep = null;
        this.setUseBuzyBar(true);
        return runRepositoryScripts.getSuccess() != false;
    }

    private PersistenceManager doCreateRepo() {
        if (this.runRepositoryScripts("CREATE_REPOSITORY.sql", 1, MigrationAddinArb.getString("FULLMIGRATION_TAB_CREATEREPO_ABBREV"), CURRENTSTEP_CREATE)) {
            MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
            migrationConfig.addRepository(this.m_generationConnectionName);
            migrationConfig.setDefaultRepository(this.m_generationConnectionName);
            return MigrationAddin.getPersistenceManager();
        }
        return null;
    }

    private boolean dropTheRepo() {
        this.m_currentRepoPanel = new RunRepoScriptPanel();
        this.m_topPanel.addTab(null, MigrationAddinArb.getString("FULLMIGRATION_TAB_DROPREP_ABBREV"), this.m_currentRepoPanel.getPanel());
        this.m_currentStep = CURRENTSTEP_REMOVE;
        this.m_topPanel.nextStep();
        Connection connection = null;
        try {
            connection = Connections.getInstance().getConnection(this.m_generationConnectionName);
        }
        catch (DBException dBException) {
            MigrationLogUtil.logThrowable(MigrationAddinArb.getString("REPO_CONN_RETRIEVE_ERROR"), CURRENTSTEP_REMOVE, (Throwable)dBException);
            return false;
        }
        boolean bl = RepositoryRegistry.dropRepository(connection, this);
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        migrationConfig.removeRepository(this.m_generationConnectionName);
        this.m_currentStep = null;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MdConnection doCapture(PersistenceManager persistenceManager) {
        BasicMigrationStorer basicMigrationStorer = new BasicMigrationStorer(persistenceManager);
        MigrationObjectFilterList migrationObjectFilterList = null;
        migrationObjectFilterList = this.m_migrationType.equals(MigrationAddinArb.getString("FULLMIGRATION_MTYPE_EVERYTHING")) ? (this.m_context != null ? MigrationFilterUtil.generateFilters(this.m_context) : MigrationFilterUtil.getFullFilter()) : MigrationFilterUtil.getProgramLessFilter();
        this.m_captureWorker = new OnlineCaptureWorker(this.m_provider.getCapturer(basicMigrationStorer), this.m_plugin.getPlatformName(), this.m_plugin.getClass().getName(), migrationObjectFilterList);
        CaptureEventListenerPanel captureEventListenerPanel = new CaptureEventListenerPanel(this);
        this.m_captureWorker.addActionListener(captureEventListenerPanel);
        this.m_topPanel.addTab(null, captureEventListenerPanel.getPanelName(), captureEventListenerPanel.getPanel());
        this.m_topPanel.nextStep();
        try {
            if (!this.m_captureWorker.runCapture()) {
                MdConnection mdConnection = null;
                return mdConnection;
            }
        }
        catch (PersistenceException persistenceException) {
            s_logger.log(Level.WARNING, "Capture.EXCEPTION", persistenceException.getLocalizedMessage());
            MdConnection mdConnection = null;
            return mdConnection;
        }
        catch (CaptureException captureException) {
            s_logger.log(Level.WARNING, "Capture.EXCEPTION", captureException.getLocalizedMessage());
            MdConnection mdConnection = null;
            return mdConnection;
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
        MdConnection mdConnection = this.m_captureWorker.getCapturedConnection();
        MigrationAddin.getMigrationConfig().updateUACode(this.m_plugin.getPlatformMask());
        CapturedDatabases.getInstance().addMdConnection(mdConnection);
        return mdConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MdConnection doConvert(PersistenceManager persistenceManager, MdConnection mdConnection) {
        ConverterWorker converterWorker;
        Object object;
        try {
            DBObjectId dBObjectId = this.storeDefaultMap(persistenceManager, this.m_plugin, mdConnection.getProjectId());
            object = null;
            object = this.m_migrationType.equals(MigrationAddinArb.getString("FULLMIGRATION_MTYPE_EVERYTHING")) ? MigrationFilterUtil.getFullFilter() : MigrationFilterUtil.getProgramLessFilter();
            converterWorker = new ConverterWorker(persistenceManager, mdConnection.getKey(), this.m_plugin.getConverter(), dBObjectId, (MigrationObjectFilterList)object);
        }
        catch (PersistenceException persistenceException) {
            s_logger.log(Level.WARNING, "Convert.EXCEPTION", persistenceException.getLocalizedMessage());
            return null;
        }
        catch (MigrationPluginException migrationPluginException) {
            s_logger.log(Level.WARNING, "Convert.EXCEPTION", migrationPluginException.getLocalizedMessage());
            return null;
        }
        object = new ConvertEventListenerPanel();
        converterWorker.addEventListener((ConvertEventListener)object);
        this.m_topPanel.addTab(null, ((ConvertEventListenerPanel)object).getPanelName(), ((ConvertEventListenerPanel)object).getPanel());
        this.m_topPanel.nextStep();
        try {
            if (!converterWorker.runConvert()) {
                MdConnection mdConnection2 = null;
                return mdConnection2;
            }
            MdConnection mdConnection3 = converterWorker.getConvertedConnection();
            ConvertedDatabases.getInstance().addMdConnection(mdConnection3);
            MdConnection mdConnection4 = mdConnection3;
            return mdConnection4;
        }
        catch (Exception exception) {
            s_logger.log(Level.WARNING, "Convert.EXCEPTION", exception.getLocalizedMessage());
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
        return null;
    }

    private DBObjectId storeDefaultMap(PersistenceManager persistenceManager, MigrationPlugin migrationPlugin, DBObjectId dBObjectId) throws PersistenceException, MigrationPluginException {
        SupportedDataTypesMap supportedDataTypesMap = migrationPlugin.getSupportedDataTypesMap();
        DataTypeConversionMap dataTypeConversionMap = ConvertUtils.getDefaultMapFromSupportedMap(supportedDataTypesMap);
        DBObjectId dBObjectId2 = ConvertUtils.persistMap(persistenceManager, dBObjectId, "quickmigr", dataTypeConversionMap);
        return dBObjectId2;
    }

    protected boolean doGenerate(MdConnection mdConnection) {
        try {
            GenerationOutputStream generationOutputStream = this.createPrintStream();
            MigrationObjectFilterList migrationObjectFilterList = null;
            migrationObjectFilterList = this.m_context != null ? MigrationFilterUtil.generateFilters(this.m_context) : MigrationFilterUtil.getFullFilter();
            GenerateWorker generateWorker = new GenerateWorker(MigrationAddin.getPersistenceManager(), mdConnection.getKey(), generationOutputStream, migrationObjectFilterList);
            GenerateEventListenerPanel generateEventListenerPanel = new GenerateEventListenerPanel();
            generateWorker.addEventListener(generateEventListenerPanel);
            this.m_topPanel.addTab(null, generateEventListenerPanel.getPanelName(), generateEventListenerPanel.getPanel());
            this.m_topPanel.nextStep();
            this.m_leastPrivilege = generateWorker.findSchemaCount() == 1;
            return generateWorker.runGenerate(this.m_leastPrivilege);
        }
        catch (IOException iOException) {
            s_logger.log(Level.WARNING, "Generate.EXCEPTION", iOException.getLocalizedMessage());
        }
        catch (Exception exception) {
            s_logger.log(Level.WARNING, "Generate.EXCEPTION", exception.getLocalizedMessage());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected boolean runGenerateScript() {
        Connection connection = null;
        try {
            connection = Connections.getInstance().isConnectionOpen(this.m_generationConnectionName) ? Connections.getInstance().cloneConnection(Connections.getInstance().getConnection(this.m_generationConnectionName)) : Connections.getInstance().getConnection(this.m_generationConnectionName);
        }
        catch (DBException dBException) {
            s_logger.log(Level.WARNING, "RunScript.EXCEPTION", dBException.getLocalizedMessage());
            return false;
        }
        catch (ConnectionException connectionException) {
            s_logger.log(Level.WARNING, "RunScript.EXCEPTION", connectionException.getLocalizedMessage());
        }
        try {
            BufferedOutputStream bufferedOutputStream;
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.setTopLevel(true);
            scriptRunnerContext.setLastUrl(this.m_url);
            scriptRunnerContext.setSqlError(5);
            scriptRunnerContext.setOsError(5);
            PipedInputStream pipedInputStream = new PipedInputStream();
            String string = Ide.getEnvironOptions().getEncoding();
            ScriptExecutor scriptExecutor = null;
            try {
                scriptExecutor = string == null ? new ScriptExecutor(this.m_url, connection) : new ScriptExecutor((Reader)new BufferedReader(new InputStreamReader(this.m_url.openStream(), string)), connection);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                s_logger.log(Level.WARNING, "RunScript.EXCEPTION", unsupportedEncodingException.getLocalizedMessage());
                boolean bl = false;
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return bl;
            }
            catch (IOException iOException) {
                s_logger.log(Level.WARNING, "RunScript.EXCEPTION", iOException.getLocalizedMessage());
                boolean bl = false;
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return bl;
            }
            scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
            scriptExecutor.setName(MigrationAddinArb.getString("FULLMIGRATION_SCRIPTRUNNER_NAME"));
            ResultPanel resultPanel = new ResultPanel();
            BasicEditorPane basicEditorPane = resultPanel.getSqlPane();
            JScrollPane jScrollPane = new JScrollPane((Component)basicEditorPane, 22, 32);
            jScrollPane.setPreferredSize(basicEditorPane.getPreferredSize());
            jScrollPane.setSize(jScrollPane.getPreferredSize());
            this.m_topPanel.addTab(null, MigrationAddinArb.getString("FULLMIGRATION_TAB_BUILD"), jScrollPane);
            this.m_topPanel.nextStep();
            OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, resultPanel.getSqlPane().getDocument(), resultPanel.getSqlPane());
            outputRedirector.setName(MigrationAddinArb.getString("FULLMIGRATION_OUTPUTREADER_NAME"));
            outputRedirector.start();
            try {
                bufferedOutputStream = new BufferedOutputStream(new PipedOutputStream(pipedInputStream));
            }
            catch (IOException iOException) {
                s_logger.log(Level.WARNING, "RunScript.EXCEPTION", iOException.getLocalizedMessage());
                boolean bl = false;
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                return bl;
            }
            scriptExecutor.setOut(bufferedOutputStream);
            scriptExecutor.run();
            if (scriptRunnerContext.getReturnExited()) {
                boolean bl = false;
                return bl;
            }
            this.m_generateSQLFile.deleteOnExit();
            boolean bl = true;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private GenerationOutputStream createPrintStream() throws IOException, UnsupportedEncodingException {
        this.m_generateSQLFile = File.createTempFile(Messages.getString("FullMigrateProgressRunnable.16"), ".sql");
        this.m_url = this.m_generateSQLFile.toURL();
        SimpleGenerationOutputStream simpleGenerationOutputStream = null;
        String string = Ide.getEnvironOptions().getEncoding();
        simpleGenerationOutputStream = string == null ? new SimpleGenerationOutputStream(new PrintStream(this.m_generateSQLFile)) : new SimpleGenerationOutputStream(new PrintStream(this.m_generateSQLFile, string));
        return simpleGenerationOutputStream;
    }

    private boolean doDataMove(PersistenceManager persistenceManager, DBObjectId dBObjectId) {
        DataMoveGui dataMoveGui = new DataMoveGui();
        try {
            DataMoveWorker dataMoveWorker = new DataMoveWorker(persistenceManager, this.m_sourceConnectionName, this.m_generationConnectionName, dBObjectId, MigrationAddin.getMigrationConfig().getNumDataMoveThreads(), MigrationAddin.getMigrationConfig().getDataMoveCommitInterval(), !this.m_leastPrivilege, false);
            dataMoveWorker.addListener(dataMoveGui);
            JPanel jPanel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(10);
            jPanel.setLayout(borderLayout);
            jPanel.add((Component)dataMoveGui.getCurrentActivityPanel(), "North");
            jPanel.add((Component)dataMoveGui.getCompletedActivityPanel(), "Center");
            this.m_topPanel.addTab(null, MigrationAddinArb.getString("FULLMIGRATION_TAB_DATAMOVE"), jPanel);
            this.m_topPanel.nextStep();
            dataMoveWorker.doWork();
        }
        catch (DataMoveException dataMoveException) {
            s_logger.log(Level.WARNING, "DataMove.EXCEPTION", dataMoveException.getLocalizedMessage());
            return false;
        }
        catch (PersistenceException persistenceException) {
            s_logger.log(Level.WARNING, "DataMove.EXCEPTION", persistenceException.getLocalizedMessage());
            return false;
        }
        return true;
    }

    @Override
    public JPanel getDownPanel() {
        return null;
    }

    @Override
    public JPanel getTopPanel() {
        if (this.m_topPanel == null) {
            this.m_topPanel = new FullMigrationTopPanel();
        }
        return this.m_topPanel;
    }

    @Override
    public void updateAbovePanel(Object object) {
    }

    @Override
    public void updateBelowPanel(Object object) {
    }

    @Override
    public void updateProgress(int n, Object object, Object object2) {
        if (this.m_currentStep != null) {
            if (this.m_currentStep.equals(CURRENTSTEP_CREATE) || this.m_currentStep.equals(CURRENTSTEP_REMOVE)) {
                this.getProgBar().getProgressBar().setValue(n);
                this.getProgBar().getProgressBar().setString("(" + n + "%)");
                this.m_currentRepoPanel.update(n, (String)object2);
                if (n == 100) {
                    this.m_currentRepoPanel.complete();
                }
            } else {
                super.updateProgress(n, object, object2);
            }
        }
    }

    public void setContext(Context context) {
        this.m_context = context;
    }
}

