/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.ui;

import java.awt.Component;
import javax.swing.SwingUtilities;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.migration.convert.ConverterWorker;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.ui.MigrationSchedulingRule;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.ISchedulingRule;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.internal.ConnectionMutexFactory;
import oracle.dbtools.raptor.backgroundTask.internal.ObjectMutexRule;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.Element;

public class ConvertObjectRunnerTask
extends RaptorTask<Object> {
    private int m_uaMask;
    private ConverterWorker m_worker;
    private String m_sourceConnName;
    private PersistableObject _object = null;

    public ConvertObjectRunnerTask(ConverterWorker converterWorker, int n, String string, PersistableObject persistableObject) {
        super(MigrationAddinArb.getString("CONVERTRUNNER_TITLE"), true, IRaptorTaskRunMode.NO_GUI);
        this.m_worker = converterWorker;
        this.m_uaMask = n;
        this.m_sourceConnName = string;
        this._object = persistableObject;
        this.setMessage(MigrationAddinArb.getString("CONVERTRUNNER_INITIAL_MESSAGE"));
        this.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            }

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getThrowable(), (String)MigrationAddinArb.getString("FAILED_TO_CONVERT"), null);
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                Boolean bl = Boolean.FALSE;
                try {
                    bl = (Boolean)ConvertObjectRunnerTask.this.getResult();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl != null && bl.booleanValue()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("END_CONVERT"), (String)MigrationAddinArb.getString("END_CONVERT"), null);
                            ((MigrationProjectNavigatorManager)MigrationProjectNavigatorManager.getInstance()).refreshElement((Element)MigrationProjectsFolderNode.getInstance());
                        }
                    });
                } else {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)raptorTaskEvent.getThrowable(), (String)MigrationAddinArb.getString("FAILED_TO_CONVERT"), null);
                }
            }
        });
    }

    protected Object doWork() throws TaskException {
        try {
            this.m_worker.translate(this._object);
            IconOverlayCache iconOverlayCache = IconOverlayCache.getInstance();
            iconOverlayCache.clearOverlays("MigrationNodeInfoType");
            iconOverlayCache.fireOverlaysChanged();
            Boolean bl = Boolean.TRUE;
            return bl;
        }
        catch (Exception exception) {
            throw new TaskException((Throwable)exception);
        }
        finally {
            MigrationLogUtil.endMigrationLogSession();
        }
    }

    public ISchedulingRule getSchedulingRule() {
        ISchedulingRule iSchedulingRule = ConnectionMutexFactory.getRule((String)this.m_sourceConnName);
        ISchedulingRule iSchedulingRule2 = ConnectionMutexFactory.getRule((String)MigrationAddin.getRepositoryConnectionName());
        ObjectMutexRule objectMutexRule = new ObjectMutexRule((Object)"MigrationSession");
        return new MigrationSchedulingRule(iSchedulingRule, iSchedulingRule2, objectMutexRule);
    }

    public boolean cancel() {
        this.m_worker.signalCancel();
        return true;
    }
}

