/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.sql.Connection;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.repository.Messages;
import oracle.dbtools.migration.workbench.core.repository.RepositoryManager;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBException;
import oracle.javatools.dialogs.MessageDialog;

public final class RepositoryDialog {
    private JEWTDialog m_dlg = null;
    private String m_dbName = null;
    private DBObject m_dbObject;
    private static final long serialVersionUID = -1190029218127406490L;

    public RepositoryDialog(DBObject dBObject) {
        this.setDbName(dBObject.getObjectName());
        this.m_dbObject = dBObject;
        this.initialize();
    }

    private void initialize() {
        String string = "";
        String string2 = "";
        JButton jButton = null;
        boolean bl = true;
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        bl = migrationConfig.isRepository(this.getDbName());
        if (bl) {
            string = MigrationAddinArb.getString("EXISTING_REPO_TITLE");
            string2 = MigrationAddinArb.getString("EXISTING_REPO_MESSAGE");
            jButton = new JButton(MigrationAddinArb.getString("REPO_REMOVE_LABEL"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RepositoryManager.removeRepository(RepositoryDialog.this.getDbName());
                    RepositoryDialog.this.m_dlg.closeDialog(true);
                }
            });
        } else {
            string = MigrationAddinArb.getString("NEW_REPO_TITLE");
            string2 = MigrationAddinArb.getString("NEW_REPO_MESSAGE");
            jButton = new JButton(MigrationAddinArb.getString("REPO_INSTALL_LABEL"));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    RepositoryDialog.this.m_dlg.closeDialog(true);
                    URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)RepositoryDialog.this.getDbName());
                    DBObject dBObject = new DBObject(uRL);
                    if (!RepositoryManager.gotUserPermission(dBObject)) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("REPO_PERM_INFO"), null, null);
                        return;
                    }
                    RepositoryManager.findOrCreateRepositoryTables(dBObject.getConnectionName());
                }
            });
        }
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(string2);
        jPanel.add(jLabel);
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel, null, (String)string, (int)6);
        Dimension dimension = jPanel.getPreferredSize();
        int n = (int)dimension.getHeight() + 100;
        int n2 = (int)dimension.getWidth() + 100;
        this.m_dlg.setSize(n2, n);
        this.m_dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
        this.m_dlg.addCustomButton((Component)jButton);
        JButton jButton2 = new JButton(Messages.getString("RepositoryDialog.2"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    URL uRL = DBURLFormatHelper.getURL((String)"sqldev.nav", (String)RepositoryDialog.this.getDbName());
                    DBObject dBObject = new DBObject(uRL);
                    Connection connection = Connections.getInstance().getConnection(RepositoryDialog.this.getDbName());
                    int n = RepositoryManager.getCurentRepoVersion(connection);
                    if (!RepositoryManager.gotUserPermission(dBObject)) {
                        MessageDialog.information((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("REPO_PERM_UPGRADE_INFO"), null, null);
                        return;
                    }
                    RepositoryManager.upgradeRepository(dBObject.getConnectionName(), n);
                }
                catch (DBException dBException) {
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)Messages.getString("RepositoryDialog.3"), null, null);
                }
            }
        });
        this.m_dlg.addCustomButton((Component)jButton2);
    }

    protected JEWTDialog getDialog() {
        return this.m_dlg;
    }

    private String getDbName() {
        return this.m_dbName;
    }

    private void setDbName(String string) {
        this.m_dbName = string;
    }

    public void setVisible(boolean bl) {
        this.getDialog().setVisible(bl);
    }
}

