/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.CapturedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedDatabases;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.impl.ObjectNode;
import oracle.dbtools.raptor.navigator.impl.SchemaFolder;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Ide;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public class RenameNodeAction
extends AbstractMenuAction {
    private static final String RENAME_TITLE = MigrationAddinArb.getString("RENAME_NODE_TITLE");
    private MigrationRepositoryDatabases m_instance;

    public void launch() {
        DBObject dBObject = this.getDBObject();
        try {
            if ("MD_VIEW".equals(dBObject.getObjectType())) {
                this.handleViewRename(dBObject);
            } else if ("USER".equals(dBObject.getObjectType())) {
                this.handleSchemaRename(dBObject);
            } else if ("MD_TABLE".equals(dBObject.getObjectType())) {
                this.handleTableRename(dBObject);
            } else if ("MD_PROCEDURE".equals(dBObject.getObjectType())) {
                this.handleProcedureRename(dBObject);
            } else if ("MD_FUNCTION".equals(dBObject.getObjectType())) {
                this.handleFunctionRename(dBObject);
            } else if ("MD_COLUMNS".equals(dBObject.getObjectType())) {
                this.handleColumnRename(dBObject);
            } else if ("MD_SEQUENCE".equals(dBObject.getObjectType())) {
                this.handleSequenceRename(dBObject);
            } else if ("MD_TRIGGER".equals(dBObject.getObjectType())) {
                this.handleTriggerRename(dBObject);
            } else if ("MD_INDEX".equals(dBObject.getObjectType())) {
                this.handleIndexRename(dBObject);
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, persistenceException.getMessage(), persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, noSuchObjectException.getMessage(), noSuchObjectException);
        }
    }

    private void handleIndexRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            String string = objectNode.getShortLabel();
            String[] stringArray = string.split("\\(");
            simpleInputDialog.setInputValue(stringArray[0].trim());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenameindex")) {
                MdIndexe mdIndexe = MdIndexe.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string2 = simpleInputDialog.getInputValue();
                mdIndexe.rename(string2);
                mdIndexe.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    private void handleTriggerRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof DBObjectNode) {
            DBObjectNode dBObjectNode = (DBObjectNode)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(dBObjectNode.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenametrigger")) {
                MdTrigger mdTrigger = MdTrigger.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string = simpleInputDialog.getInputValue();
                mdTrigger.rename(string);
                mdTrigger.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    private void handleSequenceRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(objectNode.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenamesequence")) {
                MdSequence mdSequence = MdSequence.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string = simpleInputDialog.getInputValue();
                mdSequence.rename(string);
                mdSequence.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    private void handleColumnRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof ChildObjectElement) {
            ChildObjectElement childObjectElement = (ChildObjectElement)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getColumnId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(childObjectElement.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "f1_helprenamecolumn_html")) {
                MdColumn mdColumn = MdColumn.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string = simpleInputDialog.getInputValue();
                mdColumn.rename(string);
                mdColumn.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    private void handleFunctionRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof DBObjectNode) {
            DBObjectNode dBObjectNode = (DBObjectNode)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(dBObjectNode.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenamefunction")) {
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string = simpleInputDialog.getInputValue();
                mdStoredProgram.setName(string);
                mdStoredProgram.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    private void handleProcedureRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof CapturedNode || dBObject.getElement() instanceof ObjectNode) {
            Node node = (Node)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(node.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenameprocedure")) {
                MdStoredProgram mdStoredProgram = MdStoredProgram.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string = simpleInputDialog.getInputValue();
                mdStoredProgram.rename(string);
                mdStoredProgram.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    private void handleTableRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(objectNode.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenametable")) {
                MdTable mdTable = MdTable.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string = simpleInputDialog.getInputValue();
                mdTable.rename(string);
                mdTable.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    private void handleSchemaRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof SchemaFolder) {
            SchemaFolder schemaFolder = (SchemaFolder)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getSchemaId(dBObject.getURL());
            MdSchema mdSchema = MdSchema.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(schemaFolder.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenameschema")) {
                String string = simpleInputDialog.getInputValue();
                mdSchema.setName(string);
                mdSchema.save(MigrationAddin.getPersistenceManager());
                UpdateMessage.fireStructureChanged((Subject)this.m_instance, Collections.singletonList(mdSchema));
            }
        }
    }

    private void handleViewRename(DBObject dBObject) throws PersistenceException, NoSuchObjectException {
        if (dBObject.getElement() instanceof DBObjectNode) {
            DBObjectNode dBObjectNode = (DBObjectNode)dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
            SimpleInputDialog simpleInputDialog = new SimpleInputDialog((Component)Ide.getMainWindow());
            simpleInputDialog.setInputValue(dBObjectNode.getShortLabel());
            if (simpleInputDialog.show(RENAME_TITLE, MigrationAddinArb.getString("RENAME_CONNECTION_PROMPT"), "helprenameview")) {
                MdView mdView = MdView.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                String string = simpleInputDialog.getInputValue();
                mdView.setViewName(string);
                mdView.save(MigrationAddin.getPersistenceManager());
            }
        }
    }

    public void setArgs(String string) {
        this.m_instance = "CAPTURED".equals(string) ? CapturedDatabases.getInstance() : ConvertedDatabases.getInstance();
    }
}

