/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.repository;

import java.awt.Component;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.utils.DatabaseQueryTask;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.MessageDialog;

public class MultiSelectDeleteNodes
extends AbstractMenuAction {
    private static Logger LOGGER = Logger.getLogger(MultiSelectDeleteNodes.class.getName());
    private static final String DELETE_MD_OBJECTS_ID = "DeletingMigrRepObjects";
    private static final String DELETE_MD_OBJECTS_HELP = "DeletingMigrRepObjectsHelp";

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public void launch() {
        Context context = this.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray == null) {
            return;
        }
        String string = MigrationAddinArb.getString("DELETE_OBJECT_CONFIRM_MSG");
        String string2 = MigrationAddinArb.getString("DELETE_OBJECT_CONFIRM_TITLE");
        this.setBlockOACRefresh(true);
        int n = MessageDialog.optionalConfirmOrCancel((String)DELETE_MD_OBJECTS_ID, (Component)Ide.getMainWindow(), (String)string, (String)string2, (String)DELETE_MD_OBJECTS_HELP);
        if (n == 1) {
            DatabaseQueryTask<Void> databaseQueryTask = this.getMultiSelectDeleteTask();
            this.attachPostProcessCallback((RaptorTask)databaseQueryTask, this.getDBObject(), true);
            RaptorTaskManager.getInstance().addTask(databaseQueryTask);
        }
    }

    private DatabaseQueryTask<Void> getMultiSelectDeleteTask() {
        return new DatabaseQueryTask<Void>(MigrationAddinArb.getString("DELETE_TASK"), IRaptorTaskRunMode.IDE_STATUSBAR, false, true, true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doWork() {
                Element[] elementArray;
                for (Element element : elementArray = MultiSelectDeleteNodes.this.getContext().getSelection()) {
                    Object object;
                    String string = null;
                    DBObject dBObject = new DBObject(element);
                    DBObjectId dBObjectId = MigrationURLFormatHelper.getObjectId(dBObject.getURL());
                    if (dBObject.getObjectType().equals("CATALOG")) {
                        try {
                            if (dBObjectId == null) {
                                object = new MigrationURLFormatHelper();
                                dBObjectId = ((MigrationURLFormatHelper)((Object)object)).getCatalogId(dBObject.getURL());
                            }
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_CATALOGS");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    } else if (dBObject.getObjectType().equals("USER")) {
                        try {
                            if (dBObjectId == null) {
                                dBObjectId = MigrationURLFormatHelper.getSchemaId(dBObject.getURL());
                            }
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_SCHEMAS");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    } else if (dBObject.getObjectType().equals("MD_TABLE")) {
                        try {
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_TABLES");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    } else if (dBObject.getObjectType().equals("MD_VIEW")) {
                        try {
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_VIEWS");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    } else if (dBObject.getObjectType().equals("MD_INDEX")) {
                        try {
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_INDEXES");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    } else if (dBObject.getObjectType().equals("MD_SEQUENCE")) {
                        try {
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_SEQUENCES");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    } else if (dBObject.getObjectType().equals("MD_PROCEDURE") || dBObject.getObjectType().equals("MD_FUNCTION")) {
                        try {
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_STORED_PROGRAMS");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    } else if (dBObject.getObjectType().equals("MD_TRIGGER")) {
                        try {
                            string = MultiSelectDeleteNodes.this.buildDeleteStmt(dBObjectId.getId(), "MD_TRIGGERS");
                        }
                        catch (Exception exception) {
                            MultiSelectDeleteNodes.log(exception);
                        }
                    }
                    object = null;
                    try {
                        if (string == null || string.equals("")) continue;
                        Connection connection = Connections.getInstance().getConnection(dBObject.getConnectionName());
                        object = connection.createStatement();
                        object.executeQuery(string);
                    }
                    catch (Exception exception) {
                        MultiSelectDeleteNodes.log(exception);
                    }
                    finally {
                        if (object != null) {
                            try {
                                object.close();
                            }
                            catch (SQLException sQLException) {
                                MultiSelectDeleteNodes.log(sQLException);
                            }
                        }
                    }
                }
                return null;
            }

            public String getConnectionName() {
                return MigrationAddin.getRepositoryConnectionName();
            }

            public String getQuery() {
                return null;
            }
        };
    }

    String buildDeleteStmt(long l, String string) {
        String string2 = "BEGIN DELETE FROM " + string + " WHERE ID = " + l + "; COMMIT; END;";
        return string2;
    }

    public void setArgs(String string) {
    }
}

