/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.Serializable;
import java.text.ParseException;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.MaskFormatter;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.preferences.Messages;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.ide.help.HelpSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;

public class IdentitiferPreferencesPanel
extends DefaultTraversablePanel {
    public static final String TITLE = MigrationAddinArb.getString("IDENTIFIER_PREFERENCES_TITLE");
    private static final long serialVersionUID = 4843227636357117486L;
    private JFormattedTextField m_prefixText;
    private JLabel m_prefixTextLabel;
    private JCheckBox m_isQuotedIdentifierOnSQLServer;
    private JCheckBox m_isQuotedIdentifierOnSybase;

    public IdentitiferPreferencesPanel() {
        this.initComponents();
        HelpSystem.getHelpSystem().registerTopic((JComponent)((Object)this), "f1_identprefgeneration_html");
    }

    private void initComponents() {
        Serializable serializable;
        this.setLayout(new BorderLayout());
        try {
            serializable = new MaskFormatter("****");
            this.m_prefixText = new JFormattedTextField((JFormattedTextField.AbstractFormatter)serializable);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.m_prefixText.setColumns(4);
        this.m_prefixText.setSize(4, 2);
        this.m_prefixText.setAlignmentY(2.0f);
        this.m_prefixText.setHorizontalAlignment(2);
        this.m_prefixText.setColumns(4);
        this.m_prefixText.setText("");
        this.m_prefixTextLabel = new JLabel();
        this.m_prefixTextLabel.setToolTipText(MigrationAddinArb.getString("GEN_TIP_PREPEND_IDENTIFIER"));
        this.m_prefixTextLabel.setLabelFor(this.m_prefixText);
        ResourceUtils.resLabel((JLabel)this.m_prefixTextLabel, (Component)this.m_prefixText, (String)MigrationAddinArb.getString("GEN_PREPEND_IDENTIFIER"));
        this.m_isQuotedIdentifierOnSQLServer = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_isQuotedIdentifierOnSQLServer, (String)Messages.getString("IdentitiferPreferencesPanel.SQLServer"));
        this.m_isQuotedIdentifierOnSQLServer.setAlignmentY(2.0f);
        this.m_isQuotedIdentifierOnSQLServer.setHorizontalAlignment(2);
        this.m_isQuotedIdentifierOnSybase = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.m_isQuotedIdentifierOnSybase, (String)Messages.getString("IdentitiferPreferencesPanel.Sybase"));
        serializable = new Box(1);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        FlowLayout flowLayout = new FlowLayout(0);
        jPanel.setLayout(flowLayout);
        jPanel2.setLayout(new FlowLayout(0));
        jPanel3.setLayout(new FlowLayout(0));
        jPanel.add(this.m_prefixTextLabel);
        jPanel.add(this.m_prefixText);
        jPanel2.add(this.m_isQuotedIdentifierOnSQLServer);
        jPanel3.add(this.m_isQuotedIdentifierOnSybase);
        ((Container)serializable).add(jPanel);
        ((Container)serializable).add(jPanel2);
        ((Container)serializable).add(jPanel3);
        this.add((Component)serializable, "North");
    }

    public void onEntry(TraversableContext traversableContext) {
        MigrationConfig migrationConfig = MigrationConfig.getInstance(traversableContext.getPropertyStorage());
        super.onEntry(traversableContext);
        this.load(migrationConfig);
    }

    private void load(MigrationConfig migrationConfig) {
        this.m_prefixText.setText(migrationConfig.getNamePrefix());
        this.m_isQuotedIdentifierOnSQLServer.setSelected(migrationConfig.isQuotedIdentifierOnSQLServer());
        this.m_isQuotedIdentifierOnSybase.setSelected(migrationConfig.isQuotedIdentifierOnSybase());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        MigrationConfig migrationConfig = MigrationConfig.getInstance(traversableContext.getPropertyStorage());
        super.onExit(traversableContext);
        String string = this.m_prefixText.getText().trim();
        if (string.length() > 4) {
            string = string.substring(0, 4);
        }
        migrationConfig.setNamePrefix(string);
        migrationConfig.setisQuotedIdentifierOnSQLServer(this.m_isQuotedIdentifierOnSQLServer.isSelected());
        migrationConfig.setisQuotedIdentifierOnSybase(this.m_isQuotedIdentifierOnSybase.isSelected());
    }
}

