/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.objectviewer.application;

import java.net.URL;
import java.util.BitSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationFileNode;
import oracle.dbtools.raptor.oviewer.base.ViewerNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.util.Assert;
import oracle.javatools.compare.CompareContributor;
import oracle.javatools.compare.CompareModel;
import oracle.jdeveloper.compare.CompareContext;
import oracle.jdeveloper.compare.URLContributor;
import oracle.jdevimpl.compare.CompareEditor;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.compare.CompareInvocation;
import oracle.jdevimpl.compare.CompareNode;
import oracle.jdevimpl.compare.CompareURLHelper;
import oracle.jdevimpl.compare.CompareUtil;

public class ApplicationFileCompareEditor
extends CompareEditor {
    protected static final Logger LOGGER = Logger.getLogger(ApplicationFileCompareEditor.class.getName());

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected static void ignore(Throwable throwable) {
        assert (throwable != null || null == throwable);
    }

    public void setContext(Context context) {
        if (context != null) {
            DBObject dBObject;
            Object object;
            Context context2 = new Context(context);
            Node node = context.getNode();
            if (node instanceof ViewerNode) {
                object = (ViewerNode)node;
                node = ((ViewerNode)node).getBaseNode();
                dBObject = object.getDBObject();
                dBObject.getDictionary().put("NEW_OBJECTVIEWER_FLAG", "true");
            }
            context2.setElement((Element)node);
            if (node instanceof Node) {
                context2.setNode(node);
            }
            if (node instanceof ApplicationFileNode) {
                object = (ApplicationFileNode)node;
                try {
                    URL uRL;
                    Editor editor2;
                    dBObject = new URLContributor(((ApplicationFileNode)object).getOriginalFileURL());
                    URLContributor uRLContributor = new URLContributor(((ApplicationFileNode)object).getFileURL());
                    CompareInvocation compareInvocation = CompareUtil.createInvocationContext((CompareContributor)dBObject, (CompareContributor)uRLContributor);
                    CompareModel compareModel = CompareUtil.createCompareModel((CompareContributor)dBObject, (CompareContributor)uRLContributor, (CompareInvocation)compareInvocation);
                    Context context3 = Context.newIdeContext();
                    BitSet bitSet = new BitSet();
                    bitSet.set(0);
                    for (Editor editor2 : EditorManager.getEditorManager().getAllEditors()) {
                        if (!(editor2 instanceof CompareEditor) || !(uRL = editor2.getContext().getNode().getURL()).getProtocol().startsWith("ide.compare")) continue;
                        bitSet.set(CompareURLHelper.getSequence((URL)uRL));
                    }
                    URL uRL2 = CompareURLHelper.newCompareURL((CompareContributor)dBObject, (CompareContributor)uRLContributor, (int)bitSet.nextClearBit(0));
                    editor2 = NodeFactory.find((URL)uRL2);
                    if (editor2 != null && !(editor2 instanceof CompareNode)) {
                        Assert.println((String)"CompareIdeViewer: Warning: incompatible node cached against compare URL");
                        NodeFactory.uncache((URL)uRL2);
                    }
                    uRL = (CompareNode)NodeFactory.findOrCreate(CompareNode.class, (URL)uRL2);
                    uRL.setSource((CompareContributor)dBObject);
                    uRL.setTarget((CompareContributor)uRLContributor);
                    uRL.setModel(compareModel);
                    if (compareModel == null) {
                        uRL.setMessage(CompareIdeViewer.getCompareNotAvailableMessage((CompareInvocation)compareInvocation, (Exception)compareInvocation.getFailure()));
                    }
                    context3.setNode((Node)uRL);
                    context3.setElement((Element)uRL);
                    CompareContext.setContributors((Context)context3, (CompareContributor[])new CompareContributor[]{dBObject, uRLContributor});
                    super.setContext(context3);
                }
                catch (Exception exception) {
                    ApplicationFileCompareEditor.log(exception);
                }
            }
        }
    }
}

