/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationRepositoryDatabases;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.DefaultContainerCustomNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.navigator.CustomNode;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.explorer.IconOverlayCache;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;

public class MigrationProjectsFolderNode
extends MigrationRepositoryDatabases
implements CustomNode,
ViewableElement {
    protected static final Logger LOGGER = Logger.getLogger(MigrationProjectsFolderNode.class.getName());
    private static MigrationProjectsFolderNode s_instance;
    private String _reposName;
    private HashMap<String, Object> _dict;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public MigrationProjectsFolderNode() {
        this.attach(new Observer(){

            public void update(Object object, UpdateMessage updateMessage) {
                if (UpdateMessage.CHILD_REMOVED == updateMessage.getMessageID()) {
                    for (Object e : updateMessage.getRemoveObjects()) {
                        MigrationProjectsFolderNode.this._children.remove(e);
                    }
                }
            }
        });
    }

    public static synchronized MigrationProjectsFolderNode getInstance() {
        if (s_instance == null) {
            s_instance = new MigrationProjectsFolderNode();
        }
        return s_instance;
    }

    @Override
    protected void openImpl() throws IOException {
        if (!MigrationAddin.isRepositoryOpen()) {
            return;
        }
        this.m_utility = PersistenceUtility.getInstance(this.getPersistenceManager());
        this._children.add(DummyElement.INSTANCE);
        UpdateMessage.fireChildAdded((Subject)this, (Element)DummyElement.INSTANCE);
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)this){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<Element> doWork() {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                CloseableIterator closeableIterator = null;
                try {
                    closeableIterator = MigrationProjectsFolderNode.this.getMdProjectsIterator();
                    while (closeableIterator.hasNext()) {
                        MdProject mdProject = (MdProject)closeableIterator.next();
                        MigrationProjectNode migrationProjectNode = MigrationProjectsFolderNode.this.addChild(mdProject);
                        if (migrationProjectNode == null) continue;
                        arrayList.add((Element)migrationProjectNode);
                    }
                }
                catch (PersistenceException persistenceException) {
                    this.log(persistenceException);
                }
                finally {
                    if (closeableIterator != null) {
                        closeableIterator.close();
                    }
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    private MigrationProjectNode addChild(MdProject mdProject) {
        Object object2;
        for (Object object2 : this._children) {
            MigrationProjectNode migrationProjectNode;
            if (!(object2 instanceof MigrationProjectNode) || (migrationProjectNode = (MigrationProjectNode)object2).getMdProject().getKey().getId() != mdProject.getKey().getId()) continue;
            this.reload();
            return null;
        }
        String string = this.findUniqueName(mdProject.getProjectName());
        object2 = this.createMdProjectNode(string, mdProject);
        ((DefaultContainerCustomNode)object2).setParentElement((Element)this);
        this._children.add(object2);
        return object2;
    }

    private MigrationProjectNode createMdProjectNode(String string, MdProject mdProject) {
        return new MigrationProjectNode(string, mdProject);
    }

    private void reload() {
        IconOverlayCache iconOverlayCache = IconOverlayCache.getInstance();
        iconOverlayCache.clearOverlays("MigrationNodeInfoType");
        iconOverlayCache.fireOverlaysChanged();
        UpdateMessage.fireObjectReloaded((Subject)this);
        this.repositoryClosed();
        try {
            this.open();
        }
        catch (IOException iOException) {
            MigrationProjectsFolderNode.log(iOException);
        }
    }

    private CloseableIterator getMdProjectsIterator() throws PersistenceException {
        return this.getUtility().getAllProjects();
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return MigrationAddin.getPersistenceManager();
    }

    @Override
    public void repositoryOpened(String string) {
        this._reposName = Connections.getDisplayName((String)string);
        super.repositoryOpened(string);
    }

    @Override
    public void repositoryClosed() {
        super.repositoryClosed();
        this._reposName = null;
    }

    @Override
    public String getShortLabel() {
        String string = this._reposName;
        if (null == string) {
            string = MigrationProjectNavigatorArb.get("MIG_PRJ_SELECT_REPO_MSG");
        }
        return MigrationProjectNavigatorArb.format("MIG_PRJ_NAV_ROOT_LABEL", string);
    }

    @Override
    public String getToolTipText() {
        if (null == this._reposName) {
            return MigrationProjectNavigatorArb.get("MIG_PRJ_SELECT_REPO_TIP");
        }
        return super.getToolTipText();
    }

    @Override
    protected MigrationConnectionNode createMdConnectionNode(String string, String string2, MdConnection mdConnection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CloseableIterator getMdConnectionsIterator() throws PersistenceException {
        throw new UnsupportedOperationException();
    }

    public Icon getIcon() {
        return MigrationProjectsFolderNode.getProjectIcon();
    }

    public static Icon getProjectIcon() {
        return MigrationAddinArb.getIcon("MIGRATION_PROJECTS_ICON");
    }

    public String getObjectName() {
        return "MD_PROJECTS";
    }

    public String getSchemaName() {
        String string = "";
        try {
            Connection connection = this.getConn();
            if (connection != null) {
                Database database = Connections.getInstance().getDatabase(connection);
                string = database != null ? database.getUserName() : "";
            }
        }
        catch (DBException dBException) {
            MigrationProjectsFolderNode.log(dBException);
        }
        return string;
    }

    public String getObjectId() {
        return null;
    }

    public String getObjectType() {
        return "MIGRATION_PROJECTS_FOLDER";
    }

    public String getChildName() {
        return null;
    }

    public Object getObject() {
        return null;
    }

    public Connection getConn() {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        return persistenceManager != null ? persistenceManager.getConn() : null;
    }

    public String getConnectionName() {
        return MigrationAddin.getRepositoryConnectionName();
    }

    public HashMap<String, Object> getDict() {
        if (null == this._dict) {
            this._dict = (HashMap)DefaultContainerCustomNode.getBinds(null);
        }
        return this._dict;
    }

    public String getConnType() {
        return "MIGPROJ";
    }

    public String getCatalog() {
        return null;
    }
}

