/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator.nodes;

import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.navigator.AbstractMigrationNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.nodes.AbstractLoadChildrenTask;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ApplicationsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedObjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CatalogFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.ConvertedModelsFolderNode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.navigator.ConnectionFilter;
import oracle.dbtools.raptor.navigator.DatabaseNavigatorResources;
import oracle.dbtools.raptor.navigator.DummyElement;
import oracle.dbtools.raptor.navigator.ObjectFactory;
import oracle.dbtools.raptor.navigator.WrappedException;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.impl.OtherSchemasFolder;
import oracle.dbtools.raptor.navigator.model.AbortException;
import oracle.dbtools.raptor.navigator.model.DBCatalogInstance;
import oracle.dbtools.raptor.navigator.model.DBCatalogsInstance;
import oracle.dbtools.raptor.navigator.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.model.DBItemInstance;
import oracle.dbtools.raptor.navigator.model.DatabaseFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.ExceptionHandler;
import oracle.ide.explorer.TNode;
import oracle.ide.model.DefaultElement;
import oracle.ide.model.Element;

public class MigrationProjectNodeChildFilter
extends ConnectionFilter {
    protected static final Logger LOGGER = Logger.getLogger(MigrationProjectNodeChildFilter.class.getName());
    private Comparator<Object> m_comp;
    private String m_tooltip;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    protected ObjectFactory getFactory() throws IOException {
        MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this.getOwner().getData();
        return AbstractMigrationNavigatorManager.getRegistry().getFactory(migrationConnectionNode.getShortLabel(), migrationConnectionNode.getConnection());
    }

    public Comparator<Object> getComparator() {
        if (this.m_comp == null) {
            this.m_comp = new C();
        }
        return this.m_comp;
    }

    public String getToolTipText() {
        if (this.m_tooltip == null) {
            MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this.getOwner().getData();
            this.m_tooltip = migrationConnectionNode != null ? migrationConnectionNode.getShortLabel() : null;
        }
        return this.m_tooltip;
    }

    protected void fillInInitialProperties(DBItemInstance dBItemInstance) {
        MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this.getOwner().getData();
        HashMap<String, Object> hashMap = migrationConnectionNode.getDict();
        if (hashMap != null) {
            for (String string : hashMap.keySet()) {
                dBItemInstance.setProperty(string, hashMap.get(string));
            }
        }
    }

    protected void fillInInitialPropertiesConverted(DBItemInstance dBItemInstance, MigrationConnectionNode migrationConnectionNode) {
        HashMap<String, Object> hashMap = migrationConnectionNode.getDict();
        if (hashMap != null) {
            for (String string : hashMap.keySet()) {
                dBItemInstance.setProperty(string, hashMap.get(string));
            }
        }
    }

    protected List<Element> loadChildrenImpl() throws IOException {
        if (this.getOwner() == null) {
            return Collections.emptyList();
        }
        MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)this.getOwner().getData();
        final String string = migrationConnectionNode != null ? migrationConnectionNode.getQualifiedConnectionName() : null;
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)migrationConnectionNode){

            protected List<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList = new ArrayList<Element>();
                try {
                    Object object = null;
                    if (MigrationProjectNodeChildFilter.this.getOwner() != null) {
                        object = (MigrationConnectionNode)MigrationProjectNodeChildFilter.this.getOwner().getData();
                    }
                    if (object != null) {
                        MigrationProjectNodeChildFilter.this.m_tooltip = ((MigrationConnectionNode)object).getShortLabel() + DatabaseNavigatorResources.getString((String)"CONNECTION_FILTER_CONNECTED_MSG");
                        Object object2 = ((MigrationConnectionNode)object).getMdConnection().getKey();
                        this.checkStatus("getCapturedObjectsFolderNode");
                        CapturedObjectsFolderNode capturedObjectsFolderNode = MigrationProjectNodeChildFilter.this.getCapturedObjectsFolderNode((DBObjectId)object2);
                        capturedObjectsFolderNode.setParentElement((Element)object);
                        arrayList.add((Element)capturedObjectsFolderNode);
                        this.checkStatus("getConvertedModelsFolderNode");
                        ConvertedModelsFolderNode convertedModelsFolderNode = MigrationProjectNodeChildFilter.this.getConvertedModelsFolderNode((DBObjectId)object2);
                        convertedModelsFolderNode.setParentElement((Element)object);
                        if (convertedModelsFolderNode.hasChildren()) {
                            arrayList.add((Element)convertedModelsFolderNode);
                        }
                        this.checkStatus("getApplicationsFolderNode");
                        ApplicationsFolderNode applicationsFolderNode = MigrationProjectNodeChildFilter.this.getApplicationsFolderNode((DBObjectId)object2);
                        applicationsFolderNode.setParentElement((Element)object);
                        if (applicationsFolderNode.hasChildren()) {
                            arrayList.add((Element)applicationsFolderNode);
                        }
                    }
                }
                catch (Exception exception) {
                    Throwable throwable = exception;
                    if (exception instanceof WrappedException) {
                        throwable = exception.getCause();
                    }
                    throw new TaskException(throwable);
                }
                MigrationProjectNodeChildFilter.this.removeChild(DummyElement.INSTANCE);
                for (Object object2 : arrayList) {
                    MigrationProjectNodeChildFilter.this.addChild(object2);
                }
                return arrayList;
            }

            @Override
            public String getConnectionName() {
                return string;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
        return Collections.singletonList(DummyElement.INSTANCE);
    }

    private CapturedObjectsFolderNode getCapturedObjectsFolderNode(DBObjectId dBObjectId) {
        return new CapturedObjectsFolderNode(dBObjectId, this);
    }

    void loadConvertedObjectsFolderNode(final ConvertedModelsFolderNode convertedModelsFolderNode) {
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)convertedModelsFolderNode){

            protected List<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList;
                block6: {
                    arrayList = new ArrayList<Element>();
                    ConvertedConnectionNode convertedConnectionNode = null;
                    MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)MigrationProjectNodeChildFilter.this.getOwner().getData();
                    MdConnection mdConnection = migrationConnectionNode.getMdConnection();
                    convertedConnectionNode = new ConvertedConnectionNode(MigrationProjectNavigatorArb.get("CONVERTED_DATABASE_OBJECT_FOLDER_LABEL"), convertedModelsFolderNode.getConnectionName(), convertedModelsFolderNode.getConvertedConnection());
                    if (convertedConnectionNode != null) {
                        try {
                            String string;
                            ObjectFactory objectFactory = AbstractMigrationNavigatorManager.getConvertedConnectionRegistry().getFactory(convertedModelsFolderNode.getConvertedConnection().getName(), convertedConnectionNode.getConn());
                            if (objectFactory == null || (string = MigrationProjectNodeChildFilter.this.getURLProtocol()) == null || !objectFactory.isSupportsCatalog()) break block6;
                            DBCatalogsInstance dBCatalogsInstance = objectFactory.getCatalogsInstance();
                            try {
                                MigrationProjectNodeChildFilter.this.fillInInitialPropertiesConverted((DBItemInstance)dBCatalogsInstance, convertedConnectionNode);
                                for (DBChildInstance dBChildInstance : dBCatalogsInstance.listChildren()) {
                                    this.checkStatus("create catalogs");
                                    DBCatalogInstance dBCatalogInstance = (DBCatalogInstance)dBChildInstance;
                                    dBCatalogInstance.setProperty("CAPT_CONNECTION_OBJID", (Object)mdConnection.getKey());
                                    URL uRL = DBURLFormatHelper.getURL((String)string, (String)convertedConnectionNode.getQualifiedConnectionName(), (String)((String)dBCatalogInstance.getProperty("CATALOG")), null, null);
                                    CatalogFolderNode catalogFolderNode = new CatalogFolderNode(uRL, dBCatalogInstance, convertedConnectionNode.getMdConnection(), ((MigrationConnectionNode)convertedConnectionNode).getConnType());
                                    arrayList.add((Element)catalogFolderNode);
                                }
                            }
                            catch (SQLException sQLException) {
                                ExceptionHandler.handleException((Throwable)sQLException);
                            }
                        }
                        catch (AbortException abortException) {
                            throw new TaskException((Throwable)abortException);
                        }
                    }
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    void loadCapturedObjectsFolderNode(CapturedObjectsFolderNode capturedObjectsFolderNode) {
        AbstractLoadChildrenTask abstractLoadChildrenTask = new AbstractLoadChildrenTask((Element)capturedObjectsFolderNode){

            protected List<Element> doWork() throws TaskException {
                ArrayList<Element> arrayList;
                block9: {
                    arrayList = new ArrayList<Element>();
                    MigrationConnectionNode migrationConnectionNode = null;
                    if (MigrationProjectNodeChildFilter.this.getOwner() != null) {
                        migrationConnectionNode = (MigrationConnectionNode)MigrationProjectNodeChildFilter.this.getOwner().getData();
                    }
                    if (migrationConnectionNode != null) {
                        try {
                            String string;
                            ObjectFactory objectFactory = MigrationProjectNodeChildFilter.this.getFactory();
                            if (objectFactory == null || (string = MigrationProjectNodeChildFilter.this.getURLProtocol()) == null || !objectFactory.isSupportsCatalog()) break block9;
                            DBCatalogsInstance dBCatalogsInstance = objectFactory.getCatalogsInstance();
                            try {
                                MigrationProjectNodeChildFilter.this.fillInInitialProperties((DBItemInstance)dBCatalogsInstance);
                                for (DBChildInstance dBChildInstance : dBCatalogsInstance.listChildren()) {
                                    this.checkStatus("create catalogs");
                                    DBCatalogInstance dBCatalogInstance = (DBCatalogInstance)dBChildInstance;
                                    URL uRL = DBURLFormatHelper.getURL((String)string, (String)migrationConnectionNode.getQualifiedConnectionName(), (String)((String)dBCatalogInstance.getProperty("CATALOG")), null, null);
                                    CatalogFolderNode catalogFolderNode = new CatalogFolderNode(uRL, dBCatalogInstance, migrationConnectionNode.getMdConnection(), migrationConnectionNode.getConnType());
                                    arrayList.add((Element)catalogFolderNode);
                                }
                            }
                            catch (SQLException sQLException) {
                                ExceptionHandler.handleException((Throwable)sQLException);
                            }
                        }
                        catch (IOException iOException) {
                            Throwable throwable = iOException;
                            if (iOException instanceof WrappedException) {
                                throwable = iOException.getCause();
                            }
                            throw new TaskException(throwable);
                        }
                        catch (AbortException abortException) {
                            throw new TaskException((Throwable)abortException);
                        }
                    }
                }
                return arrayList;
            }
        };
        RaptorTaskManager.getInstance().addTask((RaptorTask)abstractLoadChildrenTask);
    }

    private ConvertedModelsFolderNode getConvertedModelsFolderNode(DBObjectId dBObjectId) {
        return new ConvertedModelsFolderNode(dBObjectId, this);
    }

    private ApplicationsFolderNode getApplicationsFolderNode(DBObjectId dBObjectId) {
        return new ApplicationsFolderNode(dBObjectId);
    }

    private static class C
    implements Comparator<Object> {
        private C() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == object2) {
                return 0;
            }
            return this.compareTNodes((TNode)object, (TNode)object2);
        }

        private int compareTNodes(TNode tNode, TNode tNode2) {
            Element element = tNode.getData();
            Element element2 = tNode2.getData();
            if (element instanceof ApplicationsFolderNode) {
                return 1;
            }
            if (element2 instanceof ApplicationsFolderNode) {
                return -1;
            }
            if (element instanceof ConvertedModelsFolderNode) {
                return 1;
            }
            if (element2 instanceof ConvertedModelsFolderNode) {
                return -1;
            }
            if (element instanceof CapturedObjectsFolderNode) {
                return 1;
            }
            if (element2 instanceof CapturedObjectsFolderNode) {
                return -1;
            }
            if (element instanceof OtherSchemasFolder) {
                return 1;
            }
            if (element2 instanceof OtherSchemasFolder) {
                return -1;
            }
            if (element instanceof ObjectFolder && element2 instanceof ObjectFolder) {
                return this.compareObjectFolders((ObjectFolder)element, (ObjectFolder)element2);
            }
            return element.toString().compareTo(element2.toString());
        }

        private int compareObjectFolders(ObjectFolder objectFolder, ObjectFolder objectFolder2) {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            DBFolderInstance dBFolderInstance2 = objectFolder2.getFolderInstance();
            DatabaseFolder databaseFolder = (DatabaseFolder)dBFolderInstance.getDescriptor();
            DatabaseFolder databaseFolder2 = (DatabaseFolder)dBFolderInstance2.getDescriptor();
            double d = databaseFolder.getWeight() - databaseFolder2.getWeight();
            if (d < 0.0) {
                return -1;
            }
            if (d > 0.0) {
                return 1;
            }
            return dBFolderInstance.getType().compareTo(dBFolderInstance2.getType());
        }
    }

    public class DummyConvertedModelsFolderNode
    extends DefaultElement {
        public String getShortLabel() {
            return "Converted Models";
        }

        public Icon getIcon() {
            return MigrationAddinArb.getIcon("MIGRATION_CONVERT_ICON");
        }
    }
}

