/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.controls.display.IModifyToolbar;
import oracle.ide.config.Preferences;
import oracle.ide.controls.Toolbar;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBException;

public class TargetChooserToolbar
implements IModifyToolbar {
    static String _defaultConn = null;

    public void modifyToolbar(Toolbar toolbar) {
        this.addConnectionCombo(toolbar, true);
    }

    protected void addConnectionCombo(Toolbar toolbar, boolean bl) {
        JPanel jPanel;
        toolbar.addSeparator();
        if (bl) {
            toolbar.add(Box.createHorizontalGlue());
            jPanel = new JPanel(new BorderLayout());
            jPanel.setOpaque(false);
            toolbar.add((Component)jPanel);
            jPanel.setVisible(false);
        }
        toolbar.add((Component)new JLabel("Target:"));
        toolbar.add(Box.createHorizontalStrut(10));
        jPanel = new DBConnectionComboBox();
        String string = TargetChooserToolbar.getDefaultConn();
        if (string != null) {
            try {
                this.validateConnection(string);
                jPanel.setCurrentConnection(string);
            }
            catch (DBException dBException) {
                _defaultConn = null;
                Preferences preferences = Preferences.getPreferences();
                MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
                migrationConfig.setTargetConn(null);
            }
        }
        JComboBox jComboBox = jPanel.getJComboBox();
        jComboBox.addItemListener(new ConnComboListener((DBConnectionComboBox)jPanel));
        jComboBox.setToolTipText("Choose Target Connection");
        toolbar.add((Component)jComboBox);
    }

    protected void validateConnection(String string) throws DBException {
    }

    public static String getDefaultConn() {
        if (_defaultConn == null) {
            Preferences preferences = Preferences.getPreferences();
            MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
            _defaultConn = migrationConfig.getTargetConn();
        }
        return _defaultConn;
    }

    public void modifyToolbar(Toolbar toolbar, Map<String, Object> map) {
        this.modifyToolbar(toolbar);
    }

    private class ConnComboListener
    implements ItemListener {
        private DBConnectionComboBox _combo;

        public ConnComboListener(DBConnectionComboBox dBConnectionComboBox) {
            this._combo = dBConnectionComboBox;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                _defaultConn = (String)itemEvent.getItem();
                Preferences preferences = Preferences.getPreferences();
                MigrationConfig migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
                migrationConfig.setTargetConn(_defaultConn);
            }
        }
    }
}

