/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorController;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.NavWindow;
import oracle.dbtools.raptor.navigator.impl.ViewableElement;
import oracle.ide.Context;
import oracle.ide.controller.Controller;
import oracle.ide.explorer.TNode;
import oracle.ideimpl.explorer.CustomTree;
import oracle.ideimpl.explorer.ExplorerNode;

public class MigrationProjectNavigatorWindow
extends NavWindow {
    private MouseAdapter _mouseTrap = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (DBConfig.getInstance().getBoolean("OPEN_ON_SINGLE_CLICK").booleanValue() || mouseEvent.getClickCount() == 2) {
                Object object = mouseEvent.getSource();
                ViewableElement viewableElement = null;
                if (object instanceof CustomTree) {
                    MigrationProjectsFolderNode migrationProjectsFolderNode;
                    CustomTree customTree = (CustomTree)object;
                    TreePath treePath = customTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    if (treePath != null) {
                        viewableElement = MigrationProjectNavigatorWindow.this.getLastObject(customTree);
                    }
                    if ((migrationProjectsFolderNode = MigrationProjectsFolderNode.getInstance()).equals(viewableElement) && !MigrationAddin.isRepositoryOpen()) {
                        mouseEvent.consume();
                    }
                }
            }
        }
    };

    public MigrationProjectNavigatorWindow(Context context, String string, String string2) {
        super(context, string, string2);
    }

    protected Controller createController(Controller controller) {
        return new MigrationProjectNavigatorController(controller);
    }

    protected void specifyTreeWillExpandListener(final JTree jTree) {
        jTree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillCollapse(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
                TreeModel treeModel = jTree.getModel();
                TNode tNode = (TNode)treeModel.getRoot();
                TNode tNode2 = tNode;
                if (tNode2 == treeExpansionEvent.getPath().getLastPathComponent()) {
                    throw new ExpandVetoException(treeExpansionEvent);
                }
            }

            @Override
            public void treeWillExpand(TreeExpansionEvent treeExpansionEvent) throws ExpandVetoException {
            }
        });
    }

    public Component getGUI() {
        Component component = super.getGUI();
        JTree jTree = this.getTree();
        boolean bl = true;
        for (MouseListener mouseListener : jTree.getMouseListeners()) {
            if (mouseListener != this._mouseTrap) continue;
            bl = false;
            break;
        }
        if (bl) {
            jTree.addMouseListener(this._mouseTrap);
        }
        return component;
    }

    private ViewableElement getLastObject(CustomTree customTree) {
        Object object;
        ViewableElement viewableElement = null;
        if (customTree.getSelectionCount() > 0 && (object = ((ExplorerNode)customTree.getLastSelectedPathComponent()).getUserObject()) instanceof ViewableElement) {
            viewableElement = (ViewableElement)object;
        }
        return viewableElement;
    }
}

