/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.navigator;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.navigator.AbstractMigrationNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.CapturedConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectConnectionRecognizer;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorArb;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorContextMenu;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorWindow;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedObjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.IChildNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectNodeChildFilter;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.SchemaFolderNode;
import oracle.dbtools.raptor.controls.sqldialog.IObjectActionListener;
import oracle.dbtools.raptor.controls.sqldialog.ObjectActionController;
import oracle.dbtools.raptor.navigator.ConnectionRecognizer;
import oracle.dbtools.raptor.navigator.NavActionListener;
import oracle.dbtools.raptor.navigator.SchemaFilter;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.IdeAction;
import oracle.ide.explorer.ExplorerContext;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ideri.navigator.DefaultNavigatorWindow;
import oracle.javatools.icons.OracleIcons;

public class MigrationProjectNavigatorManager
extends AbstractMigrationNavigatorManager {
    public static final Logger LOGGER = Logger.getLogger(MigrationProjectNavigatorManager.class.getName());
    private static final String MIG_PRJ_NAV_CMD = "MigrationProjectNavigator.SHOW_NAVIGATOR";
    private static final int MIG_PRJ_NAV_CMD_ID = Ide.findOrCreateCmdID((String)"MigrationProjectNavigator.SHOW_NAVIGATOR");
    private static final String MIG_PRJ_NAV_LABEL = MigrationProjectNavigatorArb.getString("MIG_PRJ_NAV_LABEL");
    private static final String MIG_PRJ_NAV_WINDOW_ID = "MigrationProjectNavigatorWindow";
    private static NavigatorManager s_instance;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public static synchronized NavigatorManager getInstance() {
        if (s_instance == null) {
            s_instance = new MigrationProjectNavigatorManager();
        }
        return s_instance;
    }

    public void initialize() {
        super.initialize();
        ObjectActionController.addListener((IObjectActionListener)new NavActionListener((NavigatorManager)this));
        MigrationProjectNavigatorManager.getRegistry().registerRecognizer((ConnectionRecognizer)new MigrationProjectConnectionRecognizer());
        MigrationProjectNavigatorManager.getConvertedConnectionRegistry().registerRecognizer((ConnectionRecognizer)new MigrationProjectConnectionRecognizer());
        this.registerFilter(CapturedConnectionNode.class, MigrationProjectNodeChildFilter.class, null);
        this.registerFilter(SchemaFolderNode.class, SchemaFilter.class, null);
        this.addContextMenuListener(new MigrationProjectNavigatorContextMenu(), null);
    }

    @Override
    protected NavigatorWindow createNavigatorWindow() {
        return this.createNavigatorWindow((Folder)MigrationProjectsFolderNode.getInstance(), true, 4);
    }

    protected DefaultNavigatorWindow createNavigatorWindow(Context context, ViewId viewId) {
        return new MigrationProjectNavigatorWindow(context, viewId.getId(), this.getTabTitle());
    }

    @Override
    protected IdeAction createShowNavigatorAction() {
        return IdeAction.get((int)MIG_PRJ_NAV_CMD_ID, null, (String)StringUtils.stripMnemonic((String)MIG_PRJ_NAV_LABEL), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)MIG_PRJ_NAV_LABEL), (Icon)OracleIcons.getIcon((String)"project.png"), null, (boolean)true);
    }

    @Override
    protected String getDefaultName() {
        return StringUtils.stripMnemonic((String)MIG_PRJ_NAV_LABEL);
    }

    @Override
    protected String getViewCategory() {
        return MIG_PRJ_NAV_WINDOW_ID;
    }

    protected String getTabTitle() {
        return this.getDefaultName();
    }

    public void refreshElement(Element element) {
        Element element2 = element;
        final TreeExplorer treeExplorer = this.getNavigatorWindow().getTreeExplorer();
        TNode tNode = treeExplorer.searchTNode(element2, treeExplorer.getRoot());
        if (null == tNode) {
            tNode = treeExplorer.getRoot();
            element2 = tNode.getData();
        }
        final List list = ExplorerContext.storeSelectionState((TreeExplorer)treeExplorer);
        if (element2 instanceof CapturedObjectsFolderNode) {
            element2 = ((IChildNode)element2).getParentElement();
        }
        final TNode tNode2 = treeExplorer.searchTNode(element2, treeExplorer.getRoot());
        final List list2 = ExplorerContext.storeExpansionState((TNode)tNode2, (TreeExplorer)treeExplorer);
        if (element2 instanceof Node) {
            Node node = (Node)element2;
            try {
                node.close();
                node.open();
            }
            catch (IOException iOException) {
                MigrationProjectNavigatorManager.log(iOException);
            }
            UpdateMessage.fireStructureChanged((Subject)node);
        }
        treeExplorer.refresh(tNode2);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ExplorerContext.restoreExpansionState((TNode)tNode2, (TreeExplorer)treeExplorer, (List)list2);
                ExplorerContext.restoreSelectionState((TreeExplorer)treeExplorer, (List)list);
            }
        });
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_migration_projects_html");
    }
}

