/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core.logging;

import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdUser;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllConnectionsRec;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.ILogListener;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.CaptureRepositoryDatabaseManager;
import oracle.dbtools.migration.workbench.core.navigator.ConvertedRepositoryDatabaseManager;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.oviewer.base.NavSelectionListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.explorer.TNode;
import oracle.ide.explorer.TreeExplorer;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.net.URLFactory;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.explorer.ExplorerNode;

public final class MigrationLogListener
implements ILogListener {
    private static final String TYPE_CONVERTED = "CONVERTED";
    private static final String MD_VIEW = "MD_VIEW";
    private static final String MD_TABLE = "MD_TABLE";
    private static final String MD_PROCEDURE = "MD_PROCEDURE";
    private static final String MD_INDEX = "MD_INDEX";
    private static final String MD_TRIGGER = "MD_TRIGGER";
    private static final String MD_FUNCTION = "MD_FUNCTION";
    private static final String MD_SEQUENCE = "MD_SEQUENCE";
    private static final String MD_CONSTRAINT = "MD_CONSTRAINT";
    private static final String MD_USER = "MD_USER";

    @Override
    public void run(LogRecord logRecord) {
        List<ClickableLogInfo> list = MigrationLogUtil.searchParameterByType(logRecord.getParameters(), ClickableLogInfo.class);
        if (list.size() > 0) {
            this.handleSpecificNodeType(list.get(0));
        }
    }

    private ExplorerNode searchNode(ExplorerNode explorerNode, TreeExplorer treeExplorer, List<URL> list) {
        if (list.isEmpty()) {
            return explorerNode;
        }
        try {
            treeExplorer.open((TNode)explorerNode);
            Enumeration enumeration = explorerNode.children();
            URL uRL = list.remove(0);
            while (enumeration.hasMoreElements()) {
                String string;
                ExplorerNode explorerNode2 = (ExplorerNode)enumeration.nextElement();
                Object object = explorerNode2.getUserObject();
                if (!(object instanceof Locatable) || !(string = ((Locatable)object).getURL().toString()).equals(uRL.toString())) continue;
                if (list.isEmpty()) {
                    return explorerNode2;
                }
                return this.searchNode(explorerNode2, treeExplorer, list);
            }
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable("MigrationLogListener.NODE_LOAD_ERROR", "Navigator", (Throwable)exception);
        }
        return explorerNode;
    }

    private boolean checkDBConnection() {
        Connection connection;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        return persistenceManager != null && (connection = persistenceManager.getConn()) != null;
    }

    private void handleSpecificNodeType(LogInfo logInfo) {
        if (!this.checkDBConnection()) {
            return;
        }
        if (logInfo.getSourceObject() instanceof MdView) {
            this.handleMDViewObject((MdView)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdTable) {
            this.handleMDTableObject((MdTable)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdStoredProgram) {
            this.handleMdStoredProgramObject((MdStoredProgram)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdIndexe) {
            this.handleMdIndexObject((MdIndexe)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdTrigger) {
            this.handleMdTriggerObject((MdTrigger)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdConstraint) {
            this.handleMdConstraintObject((MdConstraint)logInfo.getSourceObject());
        } else if (logInfo.getSourceObject() instanceof MdUser) {
            this.handleMdUserObject((MdUser)logInfo.getSourceObject());
        }
    }

    private void handleMdQuery(PersistableObject persistableObject, String string, String string2) {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        try {
            PreparedStatement preparedStatement = persistenceManager.getPreparedStatement(string);
            ResultSet resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                DBObjectId dBObjectId = new DBObjectId(resultSet.getLong("connection_id"));
                DBObjectId dBObjectId2 = new DBObjectId(resultSet.getLong("schema_id"));
                String string3 = resultSet.getString("schema_name");
                List<URL> list = this.getURLSearchList(persistableObject, dBObjectId2, string3, dBObjectId, string2);
                this.doTreeSelection(dBObjectId, persistenceManager, list);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    private void handleMdConstraintObject(MdConstraint mdConstraint) {
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        try {
            MdTable mdTable = MdTable.retrieveExistingInstance(persistenceManager, mdConstraint.getTableId());
            this.handleMDTableObject(mdTable);
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, noSuchObjectException.getStackTrace()[0].toString(), noSuchObjectException);
        }
    }

    private void handleMdUserObject(MdUser mdUser) {
        DBObjectId dBObjectId = mdUser.getKey();
        StringBuffer stringBuffer = new StringBuffer("SELECT  unique(md_connections.id) connection_id , ").append(" md_schemas.id schema_id , md_schemas.name schema_name ").append(" FROM md_connections, md_catalogs, md_schemas, md_users, md_tables ").append(" WHERE md_users.id = " + dBObjectId.getId()).append(" AND md_users.schema_id_fk = md_schemas.id ").append(" AND md_schemas.catalog_id_fk = md_catalogs.id ").append(" AND md_catalogs.connection_id_fk = md_connections.id ");
        this.handleMdQuery(mdUser, stringBuffer.toString(), MD_USER);
    }

    private void handleMdTriggerObject(MdTrigger mdTrigger) {
        DBObjectId dBObjectId = mdTrigger.getKey();
        StringBuffer stringBuffer = new StringBuffer("SELECT  mgv_all_table_triggers.connection_id, ").append(" mgv_all_table_triggers.schema_id,        ").append("  mgv_all_table_triggers.schema_name ").append(" FROM  ").append(" mgv_all_table_triggers ").append(" WHERE   mgv_all_table_triggers.trigger_id = " + dBObjectId.getId()).append(" UNION ").append(" SELECT  mgv_all_view_triggers.connection_id, ").append(" mgv_all_view_triggers.schema_id,        ").append(" mgv_all_view_triggers.schema_name ").append(" FROM  ").append(" mgv_all_view_triggers ").append(" WHERE   mgv_all_view_triggers.trigger_id = " + dBObjectId.getId());
        this.handleMdQuery(mdTrigger, stringBuffer.toString(), MD_TRIGGER);
    }

    private void handleMdIndexObject(MdIndexe mdIndexe) {
        DBObjectId dBObjectId = mdIndexe.getKey();
        StringBuffer stringBuffer = new StringBuffer("SELECT  md_connections.id connection_id , md_schemas.id schema_id , ").append(" md_schemas.name schema_name ").append(" FROM md_connections, md_catalogs, md_schemas, md_indexes, md_tables ").append(" WHERE md_indexes.id = " + dBObjectId.getId()).append(" AND md_indexes.table_id_fk = md_tables.id ").append(" AND md_tables.schema_id_fk = md_schemas.id ").append(" AND md_schemas.catalog_id_fk = md_catalogs.id ").append(" AND md_catalogs.connection_id_fk = md_connections.id");
        this.handleMdQuery(mdIndexe, stringBuffer.toString(), MD_INDEX);
    }

    private void handleMdStoredProgramObject(MdStoredProgram mdStoredProgram) {
        Object object;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        String string = null;
        DBObjectId dBObjectId2 = null;
        try {
            object = PersistenceUtility.getInstance(persistenceManager).getStoredProgramForProgramId(mdStoredProgram.getKey());
            if (object == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.STORED_PROG_FETCH_ERROR", mdStoredProgram.getName());
                return;
            }
            dBObjectId = ((MgvAllSchemasRec)object).getSchemaId();
            string = ((MgvAllSchemasRec)object).getSchemaName();
            dBObjectId2 = ((MgvAllConnectionsRec)object).getConnectionId();
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", persistenceException);
            return;
        }
        object = this.getURLSearchList(mdStoredProgram, dBObjectId, string, dBObjectId2, MD_PROCEDURE);
        this.doTreeSelection(dBObjectId2, persistenceManager, (List<URL>)object);
    }

    private void handleMDTableObject(MdTable mdTable) {
        Object object;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        String string = null;
        DBObjectId dBObjectId2 = null;
        try {
            object = PersistenceUtility.getInstance(persistenceManager).getTablesForTableId(mdTable.getKey());
            if (object == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.TABLE_FETCH_ERROR", mdTable.getTableName());
                return;
            }
            dBObjectId = ((MgvAllSchemasRec)object).getSchemaId();
            string = ((MgvAllSchemasRec)object).getSchemaName();
            dBObjectId2 = ((MgvAllConnectionsRec)object).getConnectionId();
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", persistenceException);
            return;
        }
        object = this.getURLSearchList(mdTable, dBObjectId, string, dBObjectId2, MD_TABLE);
        this.doTreeSelection(dBObjectId2, persistenceManager, (List<URL>)object);
    }

    private void handleMDViewObject(MdView mdView) {
        Object object;
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        DBObjectId dBObjectId = null;
        String string = null;
        DBObjectId dBObjectId2 = null;
        try {
            object = PersistenceUtility.getInstance(persistenceManager).getViewRecordForViewId(mdView.getKey());
            if (object == null) {
                Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.TABLE_FETCH_ERROR", mdView.getViewName());
                return;
            }
            dBObjectId = ((MgvAllSchemasRec)object).getSchemaId();
            string = ((MgvAllSchemasRec)object).getSchemaName();
            dBObjectId2 = ((MgvAllConnectionsRec)object).getConnectionId();
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", persistenceException);
            return;
        }
        object = this.getURLSearchList(mdView, dBObjectId, string, dBObjectId2, MD_VIEW);
        this.doTreeSelection(dBObjectId2, persistenceManager, (List<URL>)object);
    }

    private List<URL> getURLSearchList(PersistableObject persistableObject, DBObjectId dBObjectId, String string, DBObjectId dBObjectId2, String string2) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string3 = MigrationAddin.getRepositoryConnectionName() + "/" + dBObjectId2.getId();
        arrayList.add(URLFactory.newURL((String)"sqldev.migration", (String)string3));
        Connections.ConnectionKey connectionKey = Connections.ConnectionKey.createConnectionKey((String)"", (String)MigrationAddin.getRepositoryConnectionName());
        string3 = connectionKey.getQualifiedName() + "//" + dBObjectId + "_" + DBURLFormatHelper.encode((String)string);
        arrayList.add(URLFactory.newURL((String)"sqldev.migration", (String)string3));
        string3 = string3 + "/" + string2;
        arrayList.add(URLFactory.newURL((String)"sqldev.migration", (String)string3));
        string3 = string3 + "/" + persistableObject.getKey().getId() + "_" + DBURLFormatHelper.encode((String)persistableObject.getObjectName());
        arrayList.add(URLFactory.newURL((String)"sqldev.migration", (String)string3));
        return arrayList;
    }

    private TreeExplorer getNavigatorInstance(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        TreeExplorer treeExplorer = CaptureRepositoryDatabaseManager.getInstance().getNavigatorWindow().getTreeExplorer();
        try {
            MdConnection mdConnection = MdConnection.retrieveExistingInstance(persistenceManager, dBObjectId);
            if (TYPE_CONVERTED.equals(mdConnection.getType())) {
                treeExplorer = ConvertedRepositoryDatabaseManager.getInstance().getNavigatorWindow().getTreeExplorer();
            }
        }
        catch (PersistenceException persistenceException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.PERSISTENCE_EXCEPTION", persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "MigrationLogListener.NOSUCHOBJECT_EXCEPTION", noSuchObjectException);
        }
        return treeExplorer;
    }

    private void doTreeSelection(DBObjectId dBObjectId, PersistenceManager persistenceManager, List<URL> list) {
        TreeExplorer treeExplorer = this.getNavigatorInstance(dBObjectId, persistenceManager);
        ExplorerNode explorerNode = (ExplorerNode)treeExplorer.getRoot();
        if (treeExplorer != null) {
            String string = list.get(list.size() - 1).toString();
            ExplorerNode explorerNode2 = this.searchNode(explorerNode, treeExplorer, list);
            if (explorerNode2 != null) {
                boolean bl;
                Object object;
                if (explorerNode2.getData() instanceof ObjectFolder && MD_INDEX.equals(((ObjectFolder)explorerNode2.getData()).getObjectType())) {
                    for (int i = 0; i < explorerNode2.getChildCount(); ++i) {
                        ExplorerNode explorerNode3 = (ExplorerNode)explorerNode2.getChildAt(i);
                        object = explorerNode3.getUserObject();
                        if (!(object instanceof Locatable) || !((Locatable)object).getURL().toString().startsWith(string)) continue;
                        explorerNode2 = explorerNode3;
                        string = ((Locatable)object).getURL().toString();
                    }
                }
                treeExplorer.setSelected((TNode)explorerNode2);
                URL uRL = ((Locatable)explorerNode2.getUserObject()).getURL();
                if (uRL != null && (bl = uRL.toString().equals(string)) && explorerNode2.getData() instanceof Node) {
                    object = (Node)explorerNode2.getData();
                    IdeUtil.invokeAfterRepaint((Runnable)new Runnable((Node)object){
                        final /* synthetic */ Node val$dbnode;
                        {
                            this.val$dbnode = node;
                        }

                        @Override
                        public void run() {
                            NavSelectionListener.getInstance().open(this.val$dbnode);
                        }
                    });
                }
            }
            treeExplorer.show();
            treeExplorer.activate();
        }
    }
}

