/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.filechooser.FileFilter;
import oracle.dbtools.migration.capture.OfflineCaptureWorker;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.OfflineCaptureOptionsDialog;
import oracle.dbtools.migration.workbench.core.QMLauncher;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.ui.CaptureDialogTaskUI;
import oracle.dbtools.migration.workbench.core.ui.CaptureRunnerTask;
import oracle.dbtools.migration.workbench.core.ui.ClearRepositoryDialog;
import oracle.dbtools.migration.workbench.core.ui.CreateRepositoryDialog;
import oracle.dbtools.migration.workbench.core.ui.DataMoveDialog;
import oracle.dbtools.migration.workbench.core.ui.DeleteRepositoryDialog;
import oracle.dbtools.migration.workbench.core.ui.OfflineDatamoveDialog;
import oracle.dbtools.migration.workbench.core.ui.OfflineOracleGenerationDialog;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.oviewer.OBResourcesArb;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.javatools.dialogs.MessageDialog;

public class WorkbenchController
implements Controller {
    private static final int BLOCKSIZE = 2048;
    private static final String GETTING_STARTED_HELPID = "migr_quick_steps.htm-CHDIJEBC";
    private static OfflineCaptureOptionsDialog s_offlineCaptureOptionsDialog = null;
    private static URL s_selectedURL;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("MigrationDataMove")) {
            DataMoveDialog dataMoveDialog = new DataMoveDialog();
            dataMoveDialog.setVisible(true);
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("DisconnectMigrationRepository")) {
            String string = MigrationAddin.getRepositoryConnectionName();
            if (string == null) {
                return true;
            }
            String string2 = MigrationAddinArb.getString("MIGRATION_DISONNECTED_REPO_MESSAGE");
            String string3 = MessageFormat.format(string2, Connections.getDisplayName((String)string));
            MigrationAddin.disconnectRepository();
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string3, (String)MigrationAddinArb.getString("MIGRATION_DISONNECTED_DIALOG_TITLE_MESSAGE"), null);
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("MigrationOfflineDataMove")) {
            OfflineDatamoveDialog offlineDatamoveDialog = new OfflineDatamoveDialog();
            offlineDatamoveDialog.launchunknownMenu();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("GenerateOracleScripts")) {
            OfflineOracleGenerationDialog offlineOracleGenerationDialog = new OfflineOracleGenerationDialog();
            offlineOracleGenerationDialog.launch();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("CreateRepository")) {
            CreateRepositoryDialog createRepositoryDialog = new CreateRepositoryDialog();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("DropRepository")) {
            DeleteRepositoryDialog deleteRepositoryDialog = new DeleteRepositoryDialog();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("TruncateRepository")) {
            ClearRepositoryDialog clearRepositoryDialog = new ClearRepositoryDialog();
            return true;
        }
        if (Ide.findCmdName((int)ideAction.getCommandId()).equals("CreateOfflineScripts")) {
            this.launchOfflineCapture();
        } else if (Ide.findCmdName((int)ideAction.getCommandId()).equals("ReadOfflineOutput")) {
            this.processOfflineOutput();
        } else if (Ide.findCmdName((int)ideAction.getCommandId()).equals("MigrationQuickMigrate")) {
            QMLauncher qMLauncher = new QMLauncher();
            qMLauncher.setContext(context);
            qMLauncher.launch();
        }
        return true;
    }

    private File chooseDataDump() {
        int n;
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setSelectionScope(0);
        uRLFileChooser.setSelectionMode(0);
        uRLFileChooser.setURLFilter((URLFilter)new DefaultURLFilter(Messages.getString("WorkbenchController.6"), new String[]{"ocp"}));
        if (s_selectedURL != null && s_selectedURL.getFile().length() > 0) {
            uRLFileChooser.setSelectedURL(s_selectedURL);
        }
        if ((n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow(), OBResourcesArb.getString((String)"DBDOC_SELECT_DIR"))) == 0) {
            File file = new File(uRLFileChooser.getSelectedURL().getFile());
            return file;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processOfflineOutput() {
        Object object;
        FileInputStream fileInputStream;
        File file = this.chooseDataDump();
        if (file == null) return;
        if (!file.canRead()) return;
        try {
            s_selectedURL = file.getParentFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            s_selectedURL = null;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string = MigrationAddinArb.format("ERR_FILE_MISSING", file.getName());
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)MigrationAddinArb.getString("TITLE_FILE_MISSING"), (String)"help_file_missing");
            return;
        }
        Properties properties = new Properties();
        try {
            properties.load(fileInputStream);
            String string = properties.getProperty("OfflinePluginIdentifier");
            if (string == null || string.trim().length() == 0) {
                String string2 = MigrationAddinArb.format("ERR_FILE_INVALID_FORMAT", file.getName());
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)MigrationAddinArb.getString("TITLE_INVALID_FILE"), (String)"help_invalid_ocp_format");
                return;
            }
            object = MigrationAddin.findPlugin(string);
            if (object == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MSG_PLUGIN_NO_LONGER_AVAILABLE"), (String)MigrationAddinArb.getString("TITLE_MISSING_OR_INVALID_PLUGIN"), (String)"help_migr_plugin_unavailable");
                return;
            }
            OfflineCapturer offlineCapturer = object.getOfflineCapturer();
            if (offlineCapturer == null) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("ERR_OFFLINE_NOT_SUPPORTED"), (String)MigrationAddinArb.getString("TITLE_OFFLINE_NOT_SUPPORTED"), (String)"help_offline_unsupported");
                return;
            }
            this.doOfflineCapture(file.getParent(), offlineCapturer, properties, string, object.getPlatformMask());
            return;
        }
        catch (IOException iOException) {
            object = MigrationAddinArb.format("READ_OFFLINE_OUTPUT_FAILED", file.getName(), iOException.getMessage());
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)object, (String)MigrationAddinArb.getString("TITLE_READ_OFFLINE_OUTPUT_FAILED"), (String)"file_read_offline_output_failed");
            return;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void doOfflineCapture(String string, OfflineCapturer offlineCapturer, Properties properties, String string2, int n) {
        Logger logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        try {
            BasicMigrationStorer basicMigrationStorer = new BasicMigrationStorer(MigrationAddin.getPersistenceManager());
            String string3 = offlineCapturer.captureInitialize(string, properties, basicMigrationStorer);
            if (string3 == null) {
                throw new OfflineCaptureException(new NullPointerException());
            }
            OfflineCaptureWorker offlineCaptureWorker = new OfflineCaptureWorker(offlineCapturer, string3, string2);
            CaptureRunnerTask captureRunnerTask = new CaptureRunnerTask(offlineCaptureWorker, n);
            final CaptureDialogTaskUI captureDialogTaskUI = new CaptureDialogTaskUI(captureRunnerTask.getDescriptor());
            offlineCaptureWorker.addActionListener(captureDialogTaskUI);
            RaptorTaskManager.getInstance().addTask((RaptorTask)captureRunnerTask, Collections.singletonList(new ITaskViewer(){

                public void addTaskUI(ITaskUI iTaskUI) {
                }

                public ITaskUI getTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return captureDialogTaskUI;
                }

                public ITaskUI createTaskUI(RaptorTaskDescriptor raptorTaskDescriptor) {
                    return this.getTaskUI(raptorTaskDescriptor);
                }

                public void taskCancelRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }

                public void taskPauseRequested(RaptorTaskDescriptor raptorTaskDescriptor) {
                }
            }));
        }
        catch (Exception exception) {
            MigrationLogUtil.logThrowable(exception.getMessage(), Messages.getString("CaptureInitiator.2"), (Throwable)exception);
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public boolean update(IdeAction ideAction, Context context) {
        return true;
    }

    private void launchOfflineCapture() {
        String[] stringArray = null;
        OfflineCaptureOptionsDialog offlineCaptureOptionsDialog = WorkbenchController.getOfflineCaptureDialog();
        offlineCaptureOptionsDialog.show();
        if (offlineCaptureOptionsDialog.isCancelled()) {
            return;
        }
        MigrationPlugin migrationPlugin = offlineCaptureOptionsDialog.getPluginChoice();
        OfflineCapturer offlineCapturer = migrationPlugin.getOfflineCapturer();
        try {
            String[] stringArray2 = offlineCapturer.getScriptFiles(offlineCaptureOptionsDialog.getOutputScriptChoice());
            stringArray = stringArray2 != null && stringArray2.length > 0 ? this.extractScripts(stringArray2, offlineCapturer.getClass(), offlineCaptureOptionsDialog.getOutputDir()) : offlineCapturer.generateScripts(offlineCaptureOptionsDialog.getOutputDir(), offlineCaptureOptionsDialog.getOutputScriptChoice());
            if (stringArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(MigrationAddinArb.getString("OFFLINE_SCRIPT_GENERATION_INFO"));
                for (String string : stringArray) {
                    stringBuffer.append('\n');
                    stringBuffer.append(string);
                }
                stringBuffer.append('\n');
                stringBuffer.append(MigrationAddinArb.format("OFFLINE_SCRIPT_GENERATION_CONTROLLER", stringArray[0]));
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)stringBuffer.toString(), (String)MigrationAddinArb.getString("OFFLINE_SCRIPT_GENERATION_TITLE"), (String)"help_scripts_generated");
            }
        }
        catch (OfflineCaptureException offlineCaptureException) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.SEVERE, offlineCaptureException.getLocalizedMessage());
        }
    }

    private String[] extractScripts(String[] stringArray, Class clazz, String string) throws OfflineCaptureException {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException(Messages.getString("WorkbenchController.7"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        byte[] byArray = new byte[2048];
        FileOutputStream fileOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        for (String string2 : stringArray) {
            if (string2 == null) {
                throw new OfflineCaptureException(new NullPointerException());
            }
            InputStream inputStream = clazz.getResourceAsStream(string2);
            bufferedInputStream = new BufferedInputStream(inputStream);
            if (inputStream == null) {
                throw new OfflineCaptureException(new FileNotFoundException(string2));
            }
            String[] stringArray2 = string2.split("/");
            if (stringArray2 == null) {
                throw new OfflineCaptureException(new IllegalArgumentException(string2));
            }
            String string3 = string + File.separator + stringArray2[stringArray2.length - 1];
            try {
                fileOutputStream = new FileOutputStream(string3);
                int n = bufferedInputStream.read(byArray);
                while (n != -1) {
                    fileOutputStream.write(byArray, 0, n);
                    n = bufferedInputStream.read(byArray);
                }
                fileOutputStream.close();
                bufferedInputStream.close();
                arrayList.add(stringArray2[stringArray2.length - 1]);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new OfflineCaptureException(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new OfflineCaptureException(iOException);
            }
            finally {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static OfflineCaptureOptionsDialog getOfflineCaptureDialog() {
        if (s_offlineCaptureOptionsDialog == null) {
            s_offlineCaptureOptionsDialog = new OfflineCaptureOptionsDialog((Frame)Ide.getMainWindow());
            Collection<MigrationPlugin> collection = MigrationAddin.getPlugins();
            MigrationPlugin[] migrationPluginArray = collection.toArray(new MigrationPlugin[collection.size()]);
            Arrays.sort(migrationPluginArray, new PluginComparator());
            for (MigrationPlugin migrationPlugin : migrationPluginArray) {
                if (migrationPlugin.getPlatformName().equals("MSAccess") || migrationPlugin.getOfflineCapturer() == null) continue;
                s_offlineCaptureOptionsDialog.addPlugin(migrationPlugin);
            }
        }
        return s_offlineCaptureOptionsDialog;
    }

    private static class PropertiesFileFilter
    extends FileFilter {
        private PropertiesFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".ocp");
        }

        @Override
        public String getDescription() {
            return MigrationAddinArb.getString("OFFLINE_FILECHOOSER_FILTER_DESC");
        }
    }

    private static class PluginComparator
    implements Comparator<MigrationPlugin> {
        private PluginComparator() {
        }

        @Override
        public int compare(MigrationPlugin migrationPlugin, MigrationPlugin migrationPlugin2) {
            int[] nArray;
            int n = migrationPlugin.getPlatformName().compareTo(migrationPlugin2.getPlatformName());
            if (n != 0) {
                return n;
            }
            int[] nArray2 = this.threeNumbers(migrationPlugin.getVersionNumber());
            n = nArray2[0] - (nArray = this.threeNumbers(migrationPlugin2.getVersionNumber()))[0];
            if (n != 0) {
                return n;
            }
            n = nArray2[1] - nArray[1];
            if (n != 0) {
                return n;
            }
            return nArray2[2] - nArray[2];
        }

        private int[] threeNumbers(String string) {
            int[] nArray = new int[3];
            try {
                String[] stringArray = string.split("\\.");
                nArray[0] = Integer.parseInt(stringArray[0]);
                if (stringArray.length > 1) {
                    nArray[1] = Integer.parseInt(stringArray[1]);
                    nArray[2] = stringArray.length > 2 ? Integer.parseInt(stringArray[2]) : 0;
                } else {
                    nArray[1] = 0;
                    nArray[2] = 0;
                }
            }
            catch (NumberFormatException numberFormatException) {
                nArray[0] = 1;
                nArray[1] = 0;
                nArray[2] = 0;
            }
            return nArray;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof PluginComparator;
        }
    }
}

