/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.controls.sqldialog.ObjectAction;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.navigator.DatabaseConnection;
import oracle.dbtools.raptor.navigator.Databases;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.newscriptrunner.OutputRedirector;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutorTask;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.WrapListenBufferOutputStream;
import oracle.dbtools.raptor.scriptrunner.utils.ScriptUtils;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;

public class QuickMigrateInitiator
extends AbstractMenuAction
implements LayoutControl {
    public boolean useSchema() {
        return true;
    }

    public String quoteMe(String string) {
        return "[" + string + "]";
    }

    public void launch() {
        Object object;
        Object object2;
        Context context = this.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length == 0) {
            elementArray = new Element[]{context.getNode()};
        }
        if (elementArray == null) {
            return;
        }
        Element[] elementArray2 = elementArray;
        String[] stringArray = Connections.getInstance().getConnNames();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Connections.getInstance().isOracle(stringArray[i])) continue;
            arrayList.add(Connections.getConnectionName((String)stringArray[i]));
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        Object object3 = null;
        if (objectArray != null && objectArray.length > 0) {
            object2 = new AbstractAction[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                object2[i] = new AbstractAction((String)object){
                    final /* synthetic */ String val$nls_txt;
                    {
                        this.val$nls_txt = string;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                    }

                    public String toString() {
                        return this.val$nls_txt;
                    }
                };
                object2[i].putValue("org_val", objectArray[i]);
            }
            object3 = object2;
        }
        if (object3 != null) {
            object2 = new JComboBox((E[])object3);
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setSelected(true);
            object = new JLabel();
            ResourceUtils.resLabel((JLabel)object, (Component)jCheckBox, (String)MigrationAddinArb.getString("QUICK_MIGRATE_INCLUDE_DATA"));
            ((JLabel)object).setHorizontalAlignment(4);
            JLabel jLabel = new JLabel();
            ResourceUtils.resLabel((JLabel)jLabel, (Component)object2, (String)MigrationAddinArb.getString("QUICK_MIGRATE_DESTINATION_DATABASE"));
            jLabel.setHorizontalAlignment(4);
            JLabel jLabel2 = new JLabel(MigrationAddinArb.getString("QUICK_MIGRATE_IF_TABLE_EXISTS"));
            jLabel2.setHorizontalAlignment(4);
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton();
            jRadioButton.setSelected(true);
            ResourceUtils.resButton((AbstractButton)jRadioButton, (String)MigrationAddinArb.getString("QUICK_MIGRATE_INDICATE_ERROR"));
            buttonGroup.add(jRadioButton);
            JRadioButton jRadioButton2 = new JRadioButton();
            jRadioButton2.setSelected(false);
            ResourceUtils.resButton((AbstractButton)jRadioButton2, (String)MigrationAddinArb.getString("QUICK_MIGRATE_APPEND"));
            buttonGroup.add(jRadioButton2);
            JRadioButton jRadioButton3 = new JRadioButton();
            jRadioButton3.setSelected(false);
            ResourceUtils.resButton((AbstractButton)jRadioButton3, (String)MigrationAddinArb.getString("QUICK_MIGRATE_REPLACE"));
            buttonGroup.add(jRadioButton3);
            JPanel jPanel = LayoutControl.GBC.createPanel();
            jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP));
            jPanel.add((Component)object2, LayoutControl.GBC.gbc((int)1, (int)0, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
            jPanel.add((Component)object, LayoutControl.GBC.gbc((int)0, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel.add((Component)jCheckBox, LayoutControl.GBC.gbc((int)1, (int)1, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
            jPanel.add((Component)jLabel2, LayoutControl.GBC.gbc((int)0, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP));
            jPanel.add((Component)jRadioButton, LayoutControl.GBC.gbc((int)1, (int)2, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
            jPanel.add((Component)jRadioButton2, LayoutControl.GBC.gbc((int)1, (int)3, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
            jPanel.add((Component)jRadioButton3, LayoutControl.GBC.gbc((int)1, (int)4, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP));
            LayoutControl.GBC.addSpring((JPanel)jPanel, (int)5, (int)2);
            JPanel jPanel2 = jPanel;
            HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_simplequickmigrate_html");
            JEWTDialog jEWTDialog = OnePageWizardDialogFactory.createJEWTDialog((Component)jPanel2, null, (String)MigrationAddinArb.getString("QUICK_MIGRATE_CHOOSE_DATABASE"), (int)14);
            jEWTDialog.addActionListener(new ActionListener((JComboBox)object2, jCheckBox, jRadioButton2, jRadioButton3, elementArray2, jEWTDialog){
                final /* synthetic */ JComboBox val$promptValue;
                final /* synthetic */ JCheckBox val$includeData;
                final /* synthetic */ JRadioButton val$append;
                final /* synthetic */ JRadioButton val$replace;
                final /* synthetic */ Element[] val$els;
                final /* synthetic */ JEWTDialog val$dlg;
                {
                    this.val$promptValue = jComboBox;
                    this.val$includeData = jCheckBox;
                    this.val$append = jRadioButton;
                    this.val$replace = jRadioButton2;
                    this.val$els = elementArray;
                    this.val$dlg = jEWTDialog;
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getActionCommand() == "apply") {
                        QuickMigrateInitiator.this.doQuickMigrate(this.val$promptValue.getSelectedItem().toString(), this.val$includeData.isSelected(), this.val$append.isSelected(), this.val$replace.isSelected(), this.val$els);
                    }
                    this.val$dlg.dispose();
                }
            });
            Dimension dimension = jPanel2.getPreferredSize();
            int n = (int)dimension.getHeight() + 80;
            int n2 = (int)dimension.getWidth() + 120;
            jEWTDialog.setSize(n2, n);
            jEWTDialog.setPreferredSize(n2, n);
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)jEWTDialog);
            jEWTDialog.setVisible(true);
        } else {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("COPY_TO_ORACLE_NO_TARGET_MSG"), (String)MigrationAddinArb.getString("COPY_TO_ORACLE_NO_TARGET_TITLE"), null);
        }
    }

    public ArrayList<String> getArrayListOfBridges(String string, boolean bl, boolean bl2, boolean bl3, Element[] elementArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        DBObject dBObject = null;
        for (Element element : elementArray) {
            String string2 = null;
            dBObject = new DBObject(element);
            String string3 = dBObject.getSchemaName();
            String string4 = dBObject.getObjectName();
            String string5 = DBURLFormatHelper.getCatalog((URL)dBObject.getURL());
            String string6 = string4;
            if (string3 != null) {
                string3 = string3.trim();
            }
            if (string3 != null) {
                string3 = this.quoteMe(string3);
            }
            if (string4 != null) {
                string4 = this.quoteMe(string4);
            }
            if (string5 != null) {
                string5 = this.quoteMe(string5);
            }
            string2 = this.useSchema() ? (string3 != null ? (string5 != null && (this.getDBObject().getConnectionType().equalsIgnoreCase("SYBASE") || this.getDBObject().getConnectionType().equalsIgnoreCase("Microsoft SQL Server")) ? string5 + "." + string3 + "." + string4 : string3 + "." + string4) : string4) : string4;
            String string7 = "where 1=1";
            if (!bl) {
                string7 = "where 1=2";
            }
            String string8 = string6.replace(" ", "_");
            String string9 = "";
            if (bl2) {
                string9 = "append";
            } else if (bl3) {
                string9 = "replace";
            }
            arrayList.add("BRIDGE " + string + "(" + string8 + ") AS (SELECT * FROM " + string2 + " " + string7 + ")" + string9 + ";\n");
        }
        return arrayList;
    }

    private void doQuickMigrate(String string, boolean bl, boolean bl2, boolean bl3, Element[] elementArray) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList<String> arrayList = this.getArrayListOfBridges(string, bl, bl2, bl3, elementArray);
        Collections.sort(arrayList);
        for (String object2 : arrayList) {
            stringBuffer.append(object2);
        }
        if (stringBuffer.toString().equals("")) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, MigrationAddinArb.getString("QUICK_MIGRATE_NO_TABLES_FOUND"));
            object = new Runnable(){

                @Override
                public void run() {
                    try {
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("QUICK_MIGRATE_NO_TABLES_FOUND"), (String)MigrationAddinArb.getString("QUICK_MIGRATE_TASK_SHORT_NAME"), null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                object.run();
            } else {
                SwingUtilities.invokeLater((Runnable)object);
            }
            return;
        }
        try {
            object = new BasicEditorPane();
            object.setDocument((Document)new BasicDocument());
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(pipedOutputStream);
            ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
            scriptRunnerContext.setScanOn(false);
            WrapListenBufferOutputStream wrapListenBufferOutputStream = new WrapListenBufferOutputStream((OutputStream)bufferedOutputStream, null);
            wrapListenBufferOutputStream.setRemoveForcePrint(true);
            scriptRunnerContext.setOutputStreamWrapper((BufferedOutputStream)wrapListenBufferOutputStream);
            scriptRunnerContext.consumerRuning(true);
            scriptRunnerContext.setEscape(false);
            scriptRunnerContext.setSqlError(0);
            scriptRunnerContext.consumerRuning(true);
            final OutputRedirector outputRedirector = new OutputRedirector(pipedInputStream, object.getDocument(), (BasicEditorPane)object);
            outputRedirector.start();
            ScriptExecutorTask scriptExecutorTask = new ScriptExecutorTask(MigrationAddinArb.getString("QUICK_MIGRATE_TASK"), IRaptorTaskRunMode.MODAL_OPTIONAL, true, true){

                protected void cleanup() throws ExecutionException {
                    super.cleanup();
                    try {
                        this.flushOut(true);
                        outputRedirector.join();
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, interruptedException.getStackTrace()[0].toString(), interruptedException);
                    }
                }

                protected void afterRunStatementProcessing() throws ExecutionException {
                    if (this.wasErrorEncountered()) {
                        this.getScriptRunnerContext().setExited(true);
                    }
                }
            };
            scriptExecutorTask.setOut((BufferedOutputStream)wrapListenBufferOutputStream);
            scriptExecutorTask.setScriptRunnerContext(scriptRunnerContext);
            scriptExecutorTask.setConnection(new DBObject(elementArray[0]).getConnection());
            scriptExecutorTask.setStmt(stringBuffer.toString());
            String string2 = Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)string).getQualifiedName();
            DatabaseConnection databaseConnection = Databases.getConnectionNode((String)string2, (boolean)false);
            DBObject dBObject = new DBObject((Element)databaseConnection);
            this.attachPostProcessCallback((RaptorTask)scriptExecutorTask, dBObject);
            ObjectAction objectAction = this.getObjectAction();
            objectAction.setReload(true);
            objectAction.setReloadParent(false);
            objectAction.setRemoveFromParent(false);
            this.runTask(scriptExecutorTask, MigrationAddinArb.getString("QUICK_MIGRATE_TASK"), (BasicEditorPane)object);
        }
        catch (IOException iOException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    private void runTask(ScriptExecutorTask scriptExecutorTask, String string, BasicEditorPane basicEditorPane) {
        scriptExecutorTask.setCancellable(true);
        scriptExecutorTask.setPausable(true);
        scriptExecutorTask.getDescriptor().addListener((IRaptorTaskListener)new SchemaTaskListener(string, basicEditorPane, scriptExecutorTask));
        RaptorTaskManager.getInstance().addTask((RaptorTask)scriptExecutorTask);
    }

    public void setArgs(String string) {
    }

    static class SchemaTaskListener
    extends RaptorTaskAdapter {
        private String _taskFullName;
        private BasicEditorPane _bep;
        private final ScriptExecutorTask _task;

        SchemaTaskListener(String string, BasicEditorPane basicEditorPane, ScriptExecutorTask scriptExecutorTask) {
            this._taskFullName = string;
            this._bep = basicEditorPane;
            this._task = scriptExecutorTask;
        }

        public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = SchemaTaskListener.this._taskFullName + ". " + MigrationAddinArb.getString("QUICK_MIGRATE_TASK_FAILED");
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, string);
                        MessageDialog.error((Component)Ide.getMainWindow(), (Object)string, (String)MigrationAddinArb.getString("QUICK_MIGRATE_TASK_SHORT_NAME"), null);
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            });
        }

        public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
            String string = this._taskFullName + ". " + MigrationAddinArb.getString("QUICK_MIGRATE_TASK_CANCELLED");
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, string);
        }

        public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        String string = "";
                        boolean bl = true;
                        try {
                            String string2 = (String)SchemaTaskListener.this._task.getScriptRunnerContext().getProperty("sqldev.last.err.message");
                            if (string2 == null || string2.equals("")) {
                                string = MigrationAddinArb.getString("QUICK_MIGRATE_TASK_SUCCEEDED");
                            } else {
                                bl = false;
                                ScriptUtils.showError((BasicEditorPane)SchemaTaskListener.this._bep);
                            }
                        }
                        catch (Exception exception) {
                            string = SchemaTaskListener.this._taskFullName + ". " + MigrationAddinArb.getString("QUICK_MIGRATE_TASK_FAILED");
                        }
                        if (bl) {
                            MessageDialog.information((Component)Ide.getMainWindow(), (Object)string, (String)MigrationAddinArb.getString("QUICK_MIGRATE_TASK_SHORT_NAME"), null);
                        }
                    }
                    catch (Exception exception) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                    }
                }
            });
        }
    }
}

