/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;
import oracle.ide.net.URLTextField;
import oracle.ide.util.IdeUtil;

public class OfflineCaptureOptionsDialog {
    private JEWTDialog m_dlg;
    private boolean m_cancelled = false;
    private JLabel m_lblOutputDir = new JLabel();
    private URLTextField m_outputDirVal = new URLTextField();
    private JButton m_btnBrowse = new JButton();
    private JLabel m_lblGenerateFor = new JLabel();
    private JRadioButton m_rdoWindows = new JRadioButton();
    private JRadioButton m_rdoLinux = new JRadioButton();
    private JLabel m_lblPlatform = new JLabel();
    private JComboBox m_comboPlatform = new JComboBox();
    private ButtonGroup m_radioGroup = new ButtonGroup();
    private final String SYBASE12 = "Sybase 12";
    private final String SQLSERVER = "SQL Server";
    private boolean m_sybase12Included = false;
    private static URL s_lastSelection;

    public OfflineCaptureOptionsDialog(Frame frame) {
        try {
            this.jbInit(frame);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    public void show() {
        Dimension dimension = this.m_dlg.getContentPane().getPreferredSize();
        int n = (int)dimension.getHeight() + 20;
        int n2 = (int)dimension.getWidth() + 20;
        this.m_dlg.setSize(n2, n);
        this.m_dlg.setPreferredSize(n2, n);
        IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this.m_dlg);
        KeyListener keyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                OfflineCaptureOptionsDialog.this.setOKButtonState(OfflineCaptureOptionsDialog.this.m_outputDirVal.getURL());
                s_lastSelection = OfflineCaptureOptionsDialog.this.m_outputDirVal.getURL();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        };
        this.m_outputDirVal.addKeyListener(keyListener);
        this.setOKButtonState(this.m_outputDirVal.getURL());
        this.m_dlg.setVisible(true);
    }

    private void jbInit(Frame frame) throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(400, 120);
        jPanel.setSize(dimension);
        jPanel.setPreferredSize(dimension);
        this.m_comboPlatform.setRenderer(new PluginRenderer());
        this.m_comboPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OfflineCaptureOptionsDialog.this.switchOffLinux();
            }
        });
        this.switchOffLinux();
        this.m_lblOutputDir.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_LBL_OUTPUT_DIR"));
        this.m_lblOutputDir.setBounds(new Rectangle(0, 5, 95, 25));
        this.m_outputDirVal.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_LBL_OUTPUT_DIR_INITIAL"));
        this.m_outputDirVal.setBounds(new Rectangle(100, 5, 150, 25));
        this.m_btnBrowse.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_BTN_BROWSE"));
        this.m_btnBrowse.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_OFFLINE_CAPOPT_BTN_BROWSE"));
        this.m_btnBrowse.setBounds(new Rectangle(270, 5, 105, 25));
        this.m_btnBrowse.setPreferredSize(new Dimension(76, 25));
        this.m_btnBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OfflineCaptureOptionsDialog.this.chooseOutputDirectory();
            }
        });
        this.m_lblGenerateFor.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_LBL_GENERATE_FOR"));
        this.m_rdoWindows.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_RDO_WINDOWS"));
        this.m_rdoWindows.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_OFFLINE_CAPOPT_RDO_WINDOWS"));
        this.m_rdoWindows.setSelected(true);
        this.m_rdoLinux.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_RDO_LINUX"));
        this.m_rdoLinux.setMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_OFFLINE_CAPOPT_RDO_LINUX"));
        this.m_radioGroup.add(this.m_rdoLinux);
        this.m_radioGroup.add(this.m_rdoWindows);
        this.m_lblPlatform.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_LBL_PLATFORM"));
        this.m_lblPlatform.setLabelFor(this.m_comboPlatform);
        this.m_lblPlatform.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_OFFLINE_CAPOPT_LBL_PLATFORM"));
        jPanel.add((Component)this.m_btnBrowse, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_outputDirVal, new GridBagConstraints(1, 0, 1, 1, 50.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_lblOutputDir, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_lblGenerateFor, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_rdoWindows, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        jPanel.add((Component)this.m_rdoLinux, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_lblPlatform, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        jPanel.add((Component)this.m_comboPlatform, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_offline_capture_initiator_html");
        this.m_dlg = OnePageWizardDialogFactory.createJEWTDialog((Component)frame, (Component)jPanel, null, (String)MigrationAddinArb.getString("OFFLINE_CAPOPT_TITLE"), (int)7);
        this.m_dlg.setOKButtonMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_OFFLINE_CAPOPT_BTN_OK"));
        this.m_dlg.setCancelButtonMnemonic(StringUtils.getMnemonicKeyCode((String)"MNEM_OFFLINE_CAPOPT_BTN_CANCEL"));
    }

    protected void switchOffLinux() {
        MigrationPlugin migrationPlugin = this.getPluginChoice();
        if (migrationPlugin == null) {
            return;
        }
        if (migrationPlugin.getPlatformName().toLowerCase().indexOf("microsoft") != -1) {
            this.m_rdoWindows.setSelected(true);
            this.m_rdoLinux.setEnabled(false);
        } else {
            this.m_rdoLinux.setEnabled(true);
        }
    }

    protected void chooseOutputDirectory() {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        uRLFileChooser.clearChooseableURLFilters();
        uRLFileChooser.setSelectionScope(1);
        uRLFileChooser.setSelectionMode(0);
        if (s_lastSelection != null) {
            uRLFileChooser.setSelectedURL(s_lastSelection);
        } else {
            uRLFileChooser.setSelectedURL(this.m_outputDirVal.getURL());
            s_lastSelection = this.m_outputDirVal.getURL();
        }
        int n = uRLFileChooser.showOpenDialog((Component)Ide.getMainWindow());
        if (n == 0) {
            s_lastSelection = uRLFileChooser.getSelectedURL();
            File file = new File(s_lastSelection.getFile());
            if (file.isDirectory()) {
                this.m_outputDirVal.setText(file.getAbsolutePath());
                this.m_outputDirVal.setToolTipText(s_lastSelection.getFile());
                this.setOKButtonState(this.m_outputDirVal.getURL());
            } else {
                this.m_outputDirVal.setText(MigrationAddinArb.getString("OFFLINE_CAPOPT_LBL_OUTPUT_DIR_ERROR"));
                this.m_dlg.setOKButtonEnabled(false);
            }
        }
    }

    private void setOKButtonState(URL uRL) {
        File file = null;
        if (uRL != null) {
            file = new File(uRL.getPath());
        }
        if (file != null && file.exists()) {
            this.m_dlg.setOKButtonEnabled(true);
        } else {
            this.m_dlg.setOKButtonEnabled(false);
        }
    }

    public boolean isCancelled() {
        return this.m_dlg.isCancelled();
    }

    public String getOutputDir() {
        if (s_lastSelection != null) {
            return s_lastSelection.getFile();
        }
        return null;
    }

    public int getOutputScriptChoice() {
        if (this.m_rdoLinux.isSelected()) {
            return 2;
        }
        return 1;
    }

    public MigrationPlugin getPluginChoice() {
        if (this.m_cancelled) {
            return null;
        }
        if (this.m_comboPlatform.getSelectedItem() == "Sybase 12") {
            MigrationPlugin[] migrationPluginArray;
            Collection<MigrationPlugin> collection = MigrationAddin.getPlugins();
            for (MigrationPlugin migrationPlugin : migrationPluginArray = collection.toArray(new MigrationPlugin[collection.size()])) {
                if (migrationPlugin.getOfflineCapturer() == null || !migrationPlugin.getPluginName().equalsIgnoreCase("Sybase 12.0")) continue;
                return migrationPlugin;
            }
        }
        return (MigrationPlugin)this.m_comboPlatform.getSelectedItem();
    }

    public void addPlugin(MigrationPlugin migrationPlugin) {
        if (migrationPlugin.getPlatformName().equalsIgnoreCase("SQL Server")) {
            if (!this.m_sybase12Included) {
                this.m_comboPlatform.addItem("Sybase 12");
                this.m_sybase12Included = true;
            }
        } else {
            this.m_comboPlatform.addItem(migrationPlugin);
        }
    }

    private static class PluginRenderer
    extends DefaultListCellRenderer {
        private PluginRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null || !(object instanceof MigrationPlugin)) {
                return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            }
            MigrationPlugin migrationPlugin = (MigrationPlugin)object;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(migrationPlugin.getPlatformName());
            stringBuffer.append(" (");
            stringBuffer.append(migrationPlugin.getPublishedVersion());
            stringBuffer.append(")");
            return super.getListCellRendererComponent((JList<?>)jList, stringBuffer.toString(), n, bl, bl2);
        }
    }
}

