/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.capture.CaptureCmd;
import oracle.dbtools.migration.capture.ListCapturedModelsCmd;
import oracle.dbtools.migration.command_line.DelCapturedCmd;
import oracle.dbtools.migration.command_line.DelConnCmd;
import oracle.dbtools.migration.command_line.DelConvertedCmd;
import oracle.dbtools.migration.command_line.DriverCmd;
import oracle.dbtools.migration.command_line.InfoCmd;
import oracle.dbtools.migration.command_line.InitCmd;
import oracle.dbtools.migration.command_line.ListConnCmd;
import oracle.dbtools.migration.command_line.MigrationCmdRegistry;
import oracle.dbtools.migration.command_line.MkConnCmd;
import oracle.dbtools.migration.command_line.QMCmd;
import oracle.dbtools.migration.command_line.RunSQLCmd;
import oracle.dbtools.migration.command_line.TranslateCmd;
import oracle.dbtools.migration.convert.ConvertCmd;
import oracle.dbtools.migration.convert.ListConvertedModelsCmd;
import oracle.dbtools.migration.copy.BridgeCmd;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.offline.OfflineDataMoveCmd;
import oracle.dbtools.migration.generate.GenerateCmd;
import oracle.dbtools.migration.identifierMapping.IdentifierMappingCmd;
import oracle.dbtools.migration.workbench.core.CapturedNodeMenuFilter;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationMenuManager;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryManager;
import oracle.dbtools.migration.workbench.core.MigrationRepositoryStateListener;
import oracle.dbtools.migration.workbench.core.WorkbenchController;
import oracle.dbtools.migration.workbench.core.logging.LogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogPersistenceHandler;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.navigator.ConnectionsAdapter;
import oracle.dbtools.migration.workbench.core.navigator.MigrationProjectNavigatorManager;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFileSystemHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.migration.workbench.core.navigator.nodes.MigrationProjectsFolderNode;
import oracle.dbtools.migration.workbench.core.preferences.DataMovePreferencesPane;
import oracle.dbtools.migration.workbench.core.preferences.GeneratePreferencesPanel;
import oracle.dbtools.migration.workbench.core.preferences.IdentitiferPreferencesPanel;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPreferences;
import oracle.dbtools.migration.workbench.core.preferences.PluginPreferencesPanel;
import oracle.dbtools.migration.workbench.core.preferences.TranslationPanelData;
import oracle.dbtools.raptor.config.NonUserConfigOptions;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.newscriptrunner.CommandRegistry;
import oracle.dbtools.raptor.newscriptrunner.SQLCommand;
import oracle.dbtools.raptor.oviewer.base.ViewerAddin;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.Preferences;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuFilter;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorListener;
import oracle.ide.editor.EditorManager;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.Navigable;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;

public class MigrationAddin
implements Addin {
    public static Object s_lock = new Object();
    public static final String DATE_DELIMITER = "@";
    private static HashSet<String> s_registeredCapturedMenus = new HashSet();
    private static final String MIGRATION_CORE_ID = "oracle.dbtools.migration";
    public static final String MIGRATION_MENU_ID = "MigrationMenu";
    public static final String ACTION_OFFLINE_DATA_MOVE = "MigrationOfflineDataMove";
    public static final String ACTION_DATA_MOVE = "MigrationDataMove";
    public static final String ACTION_QUICK_MIGRATE = "MigrationQuickMigrate";
    public static final String ACTION_DISCONNECT_REPO = "DisconnectMigrationRepository";
    public static final String ACTION_GENERATE_ORACLE_SCRIPTS = "GenerateOracleScripts";
    public static final String ACTION_CREATE_REPOSITORY = "CreateRepository";
    public static final String ACTION_DELETE_REPOSITORY = "DropRepository";
    public static final String ACTION_TRUNCATE_REPO = "TruncateRepository";
    public static final String ACTION_CREATE_OFFLINE_SCRIPTS = "CreateOfflineScripts";
    public static final String ACTION_READ_OFFLINE_OUTPUT = "ReadOfflineOutput";
    private static Map<String, MigrationPlugin> s_loadedPlugins = new HashMap<String, MigrationPlugin>();
    private static MigrationMenuManager s_migrationMenuManager;
    private static MigrationRepositoryManager s_repositoryManager;
    private static Navigable s_pluginsPrefNavigable;
    private static Navigable s_migrationCoreSettingsPane;
    private static MigrationConfig s_migrationConfig;
    private static List<MigrationRepositoryStateListener> s_repositoryListeners;
    private Logger m_logger = null;

    public static String removeSpaces(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreElements()) {
            stringBuilder.append(stringTokenizer.nextToken());
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static void registerPlugin(MigrationPlugin migrationPlugin) {
        String string = migrationPlugin.getClass().getName();
        if (!s_loadedPlugins.containsKey(string)) {
            s_loadedPlugins.put(string, migrationPlugin);
        }
    }

    public void initialize() {
        this.createPreferences();
        this.registerObjectViewers();
        this.registerTreeActions();
        this.registerCmdLineActions();
        this.registerWSCommandListeners();
        this.setupMigrationURLHelper();
        this.createConnectionsAdapter();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MigrationAddin.this.updateUserAgentString();
            }
        });
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent ideEvent) {
            }

            public void mainWindowClosing(IdeEvent ideEvent) {
            }

            public void mainWindowOpened(IdeEvent ideEvent) {
                MigrationAddin.this.addToMenuStructure();
                MigrationAddin.this.registerLogHandlers();
                MigrationAddin.this.createMigrationProjectsNavigator();
            }
        });
    }

    private void registerWSCommandListeners() {
        CommandRegistry.addListener(BridgeCmd.class, (SQLCommand.StmtSubType)SQLCommand.StmtSubType.G_S_BRIDGE);
    }

    private void registerCmdLineActions() {
        MigrationCmdRegistry.registerMigrationCmd("capture", CaptureCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("qm", QMCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("convert", ConvertCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("idmap", IdentifierMappingCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("lscaptured", ListCapturedModelsCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("lsconverted", ListConvertedModelsCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("lsconn", ListConnCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("mkconn", MkConnCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("delconn", DelConnCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("delconverted", DelConvertedCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("delcaptured", DelCapturedCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("generate", GenerateCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("runsql", RunSQLCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("datamove", OfflineDataMoveCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("driver", DriverCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("init", InitCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("info", InfoCmd.class);
        MigrationCmdRegistry.registerMigrationCmd("translate", TranslateCmd.class);
    }

    private void createConnectionsAdapter() {
        Connections.getInstance().addConnectionListener((ConnectionListener)new ConnectionsAdapter());
    }

    private void setupMigrationURLHelper() {
        URLFileSystem.registerHelper((String)"sqldev.migration", (URLFileSystemHelper)new MigrationURLFileSystemHelper());
    }

    private void registerTreeActions() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions.OracleNavMenus");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions.CapNavMenus");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions.ConnNavMenus");
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.core.actions");
    }

    private void registerObjectViewers() {
        ViewerAddin.registerPackage((String)"oracle.dbtools.migration.workbench.core.objectviewer");
    }

    private void createMigrationProjectsNavigator() {
        NavigatorManager navigatorManager = MigrationProjectNavigatorManager.getInstance();
        navigatorManager.initialize();
        navigatorManager.addContextMenuListener(new ContextMenuListener(){

            public boolean handleDefaultAction(Context context) {
                return false;
            }

            public void menuWillHide(ContextMenu contextMenu) {
            }

            public void menuWillShow(ContextMenu contextMenu) {
                contextMenu.addMenuFilter((MenuFilter)new CapturedNodeMenuFilter(contextMenu));
            }
        }, CapturedNode.class);
        EditorManager.getEditorManager().addEditorListener(new EditorListener(){

            public void editorActivated(Editor editor) {
            }

            public void editorClosed(Editor editor) {
            }

            public void editorDeactivated(Editor editor) {
            }

            public void editorOpened(Editor editor) {
                if (editor instanceof CodeEditor && editor.getContext().getNode() instanceof CapturedNode) {
                    while (editor.getToolbar().getComponentCount() > 2) {
                        editor.getToolbar().remove(2);
                    }
                    ContextMenu contextMenu = editor.getContextMenu();
                    contextMenu.addMenuFilter((MenuFilter)new CapturedNodeMenuFilter(contextMenu));
                }
            }
        });
    }

    private void createPreferences() {
        s_migrationCoreSettingsPane = new Navigable(MigrationPreferences.TITLE, MigrationPreferences.class);
        s_migrationCoreSettingsPane.setChildComparator(null);
        Navigable navigable = new Navigable(GeneratePreferencesPanel.TITLE, GeneratePreferencesPanel.class);
        s_migrationCoreSettingsPane.addChildNavigable(navigable);
        Navigable navigable2 = new Navigable(DataMovePreferencesPane.TITLE, DataMovePreferencesPane.class);
        s_migrationCoreSettingsPane.addChildNavigable(navigable2);
        Navigable navigable3 = new Navigable(IdentitiferPreferencesPanel.TITLE, IdentitiferPreferencesPanel.class);
        s_migrationCoreSettingsPane.addChildNavigable(navigable3);
        Navigable navigable4 = new Navigable(TranslationPanelData.TITLE, TranslationPanelData.class);
        s_migrationCoreSettingsPane.addChildNavigable(navigable4);
        IdeSettings.registerUI((Navigable)s_migrationCoreSettingsPane);
    }

    private void registerLogHandlers() {
        this.m_logger = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle", "oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
        Formatter formatter = new Formatter(){

            @Override
            public synchronized String format(LogRecord logRecord) {
                String string = this.formatMessage(logRecord);
                Object[] objectArray = logRecord.getParameters();
                List<LogInfo> list = MigrationLogUtil.searchParameterByType(objectArray, LogInfo.class);
                if (list.size() == 0) {
                    list = new ArrayList<LogInfo>(1);
                    list.add(new LogInfo(""));
                    if (objectArray == null) {
                        logRecord.setParameters(list.toArray());
                    } else {
                        Object[] objectArray2 = new Object[objectArray.length + 1];
                        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                        objectArray2[objectArray2.length - 1] = list.get(0);
                        logRecord.setParameters(objectArray2);
                    }
                }
                if (list.size() > 0 && MigrationLogUtil.getCurrentSession() != null) {
                    list.get(0).addSupplementaryInfo(new Object[]{"MigrationConnectionId", MigrationLogUtil.getCurrentSession()});
                }
                return string;
            }
        };
        this.m_logger.setUseParentHandlers(false);
        this.m_logger.setLevel(Level.INFO);
        MigrationLogPersistenceHandler migrationLogPersistenceHandler = MigrationLogPersistenceHandler.getInstance();
        migrationLogPersistenceHandler.setFormatter(formatter);
        this.m_logger.addHandler(migrationLogPersistenceHandler);
    }

    private void addToMenuStructure() {
        JMenu jMenu;
        Menubar menubar = Ide.getMenubar();
        try {
            jMenu = MenuManager.getJMenu((String)"Tools");
            if (jMenu == null) {
                throw new IllegalStateException("Menu is unavailable - cannot initialise");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Ide is unavailable - cannot initialise");
        }
        JMenu jMenu2 = this.createMigrationMenu();
        MenuManager.setMenuId((JMenu)jMenu2, (String)MIGRATION_MENU_ID);
        menubar.add((Component)jMenu2, jMenu, MenuConstants.decrement((float)MenuConstants.SECTION_TOOLS_ADDINS));
        MigrationAddin.storeMigrationMenu(jMenu2);
        WorkbenchController workbenchController = new WorkbenchController();
        JMenuItem jMenuItem = this.createMigrationMenuItem(jMenu, workbenchController, ACTION_QUICK_MIGRATE, MigrationAddinArb.getString("MENU_QUICKMIGRATION"));
        s_migrationMenuManager.addMenuItem(jMenuItem, false, 0);
        this.addRepositoryMenus(jMenu, workbenchController);
        this.addOfflineMenus(jMenu, workbenchController);
    }

    private JMenu createMigrationMenu() {
        JMenu jMenu = new JMenu(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MENU_MIGRATION")));
        jMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)MigrationAddinArb.getString("MENU_MIGRATION")));
        jMenu.setIcon(this.getIcon(MigrationAddinArb.getString("MIGRATION_ICON")));
        return jMenu;
    }

    private void addRepositoryMenus(JMenu jMenu, WorkbenchController workbenchController) {
        JMenu jMenu2 = new JMenu(StringUtils.stripMnemonic((String)MigrationAddinArb.getString("MIGRATION_REPOSITORY_MENU")));
        jMenu2.setMnemonic(StringUtils.getMnemonicKeyCode((String)MigrationAddinArb.getString("MIGRATION_REPOSITORY_MENU")));
        JMenuItem jMenuItem = this.createMigrationMenuItem(jMenu, workbenchController, ACTION_CREATE_REPOSITORY, MigrationAddinArb.getString("MIGRATION_CREATE_REPOSITORY_MENU"));
        jMenuItem.setIcon(this.getIcon(MigrationAddinArb.getString("MIGRATION_REPO_CREATE_ICON")));
        JMenuItem jMenuItem2 = this.createMigrationMenuItem(jMenu, workbenchController, ACTION_DELETE_REPOSITORY, MigrationAddinArb.getString("MIGRATION_DELETE_REPOSITORY_MENU"));
        jMenuItem2.setIcon(this.getIcon(MigrationAddinArb.getString("MIGRATION_REPO_DELETE_ICON")));
        JMenuItem jMenuItem3 = this.createMigrationMenuItem(jMenu, workbenchController, ACTION_DISCONNECT_REPO, MigrationAddinArb.getString("MENU_DISCONNECTREPO"));
        jMenuItem3.setIcon(this.getIcon(MigrationAddinArb.getString("MIGRATION_REPO_DISCONNECT_ICON")));
        JMenuItem jMenuItem4 = this.createMigrationMenuItem(jMenu, workbenchController, ACTION_TRUNCATE_REPO, MigrationAddinArb.getString("MIGRATION_TRUNCATE_REPOSITORY_MENU"));
        jMenuItem4.setIcon(this.getIcon(MigrationAddinArb.getString("MIGRATION_REPO_CLEAR_ICON")));
        jMenu2.add(jMenuItem);
        jMenu2.add(jMenuItem2);
        jMenu2.add(jMenuItem4);
        jMenu2.add(jMenuItem3);
        s_migrationMenuManager.addMenuItem(jMenu2, false, 1);
    }

    private void addOfflineMenus(JMenu jMenu, WorkbenchController workbenchController) {
        JMenuItem jMenuItem = this.createMigrationMenuItem(jMenu, workbenchController, ACTION_CREATE_OFFLINE_SCRIPTS, MigrationAddinArb.getString("OFFLINE_CREATE_SCRIPTS"), MigrationAddinArb.getIcon("MIGRATION_CAPTURE_SCRIPT_GEN_ICON"));
        s_migrationMenuManager.addMenuItem(jMenuItem, false, 3);
    }

    private JMenuItem createMigrationMenuItem(JMenu jMenu, Controller controller, String string, String string2, Icon icon) {
        int n = Ide.findOrCreateCmdID((String)string);
        IdeAction ideAction = IdeAction.get((int)n, null, (String)StringUtils.stripMnemonic((String)string2), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)string2), (Icon)icon, null, (boolean)true);
        ideAction.addController(controller);
        JMenuItem jMenuItem = new JMenuItem((Action)ideAction);
        return jMenuItem;
    }

    private JMenuItem createMigrationMenuItem(JMenu jMenu, Controller controller, String string, String string2) {
        return this.createMigrationMenuItem(jMenu, controller, string, string2, null);
    }

    public static Collection<MigrationPlugin> getPlugins() {
        return s_loadedPlugins.values();
    }

    public static MigrationPlugin findPlugin(String string) {
        return s_loadedPlugins.get(string);
    }

    private static void storeMigrationMenu(JMenu jMenu) {
        if (s_migrationMenuManager == null) {
            s_migrationMenuManager = new MigrationMenuManager(jMenu);
            MigrationAddin.addMigrationRepositoryStateListener(s_migrationMenuManager);
        }
    }

    public static MigrationMenuManager getMigrationMenuManager() {
        return s_migrationMenuManager;
    }

    private static MigrationRepositoryManager getRepositoryManager() {
        if (s_repositoryManager == null) {
            s_repositoryManager = new MigrationRepositoryManager();
        }
        return s_repositoryManager;
    }

    public static boolean isRepositoryOpen() {
        return MigrationAddin.getRepositoryManager().isConnected();
    }

    public static String getRepositoryConnectionName() {
        if (MigrationAddin.getRepositoryManager().isConnected()) {
            return MigrationAddin.getRepositoryManager().getName();
        }
        return null;
    }

    public static PersistenceManager getPersistenceManager() {
        MigrationRepositoryManager migrationRepositoryManager = MigrationAddin.getRepositoryManager();
        if (!migrationRepositoryManager.isConnected()) {
            return null;
        }
        return migrationRepositoryManager.getPersistenceManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disconnectRepository() {
        MigrationAddin.getRepositoryManager().closeConnections();
        s_repositoryManager = null;
        Object object = s_lock;
        synchronized (object) {
            if (s_repositoryListeners != null) {
                for (MigrationRepositoryStateListener migrationRepositoryStateListener : s_repositoryListeners) {
                    migrationRepositoryStateListener.repositoryClosed();
                }
            }
        }
    }

    public static boolean openRepository(final String string) {
        boolean bl = MigrationAddin.getRepositoryManager().openConnections(string);
        if (bl) {
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = s_lock;
                            synchronized (object) {
                                MigrationProjectsFolderNode.getInstance();
                                if (s_repositoryListeners != null) {
                                    for (MigrationRepositoryStateListener migrationRepositoryStateListener : s_repositoryListeners) {
                                        migrationRepositoryStateListener.repositoryOpened(string);
                                    }
                                }
                            }
                        }
                    });
                    return null;
                }
            };
            if (Ide.getMainWindow() != null) {
                swingWorker.start();
            }
        }
        return bl;
    }

    public static PersistenceManager getLogPersistenceConnection() {
        return MigrationAddin.getRepositoryManager().getLoggerPersistenceManager();
    }

    public static PersistenceManager getPersitenceManager() {
        return MigrationAddin.getRepositoryManager().getPersistenceManager();
    }

    public static MigrationPlugin getPluginForConnection(Connection connection) {
        try {
            if (connection == null) {
                return null;
            }
            MigrationPlugin migrationPlugin = null;
            int n = -1;
            int n2 = -1;
            String string = null;
            String string2 = null;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            try {
                string2 = databaseMetaData.getDatabaseProductName();
                if (string2.equals("sql server") || string2.equals("ASE")) {
                    string2 = "Sybase";
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n = databaseMetaData.getDatabaseMajorVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                n2 = databaseMetaData.getDatabaseMinorVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string = databaseMetaData.getDatabaseProductVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
            MigrationPlugin migrationPlugin2 = null;
            for (MigrationPlugin migrationPlugin3 : MigrationAddin.getPlugins()) {
                MigrationPlugin.PluginSupportLevel pluginSupportLevel;
                if ("JDBC".equals(migrationPlugin3.getPlatformName())) {
                    migrationPlugin2 = migrationPlugin3;
                }
                if ((pluginSupportLevel = migrationPlugin3.getPlatformSupportLevel(string2, n, n2, string)) == MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION) {
                    return migrationPlugin3;
                }
                if (pluginSupportLevel != MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES) continue;
                migrationPlugin = migrationPlugin3;
            }
            if (migrationPlugin == null) {
                migrationPlugin = migrationPlugin2;
            }
            return migrationPlugin;
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static synchronized void registerPluginPreferences(PluginPreferencesPanel pluginPreferencesPanel) {
        Navigable navigable;
        if (s_pluginsPrefNavigable == null) {
            s_pluginsPrefNavigable = navigable = new Navigable(PluginPreferencesPanel.TITLE, PluginPreferencesPanel.class);
            s_migrationCoreSettingsPane.addChildNavigable(navigable);
        }
        navigable = new Navigable(pluginPreferencesPanel.getTitle(), ((Object)((Object)pluginPreferencesPanel)).getClass());
        s_pluginsPrefNavigable.addChildNavigable(navigable);
    }

    public static void registerGenericPreferences(DefaultTraversablePanel defaultTraversablePanel) {
        Navigable navigable = new Navigable(defaultTraversablePanel.getDefaultTitle(), defaultTraversablePanel.getClass());
        s_migrationCoreSettingsPane.addChildNavigable(navigable);
    }

    public static MigrationConfig getMigrationConfig() {
        if (s_migrationConfig == null) {
            Preferences preferences = Preferences.getPreferences();
            s_migrationConfig = MigrationConfig.getInstance((PropertyStorage)preferences);
            s_migrationConfig.addStructureChangeListener(new MyChangeListener());
        }
        return s_migrationConfig;
    }

    private void updateUserAgentString() {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        String string = NonUserConfigOptions.get((String)"raptor.user.agent.extras");
        if (string != null) {
            Pattern pattern = Pattern.compile("MWB_[0-9]+");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                String string2 = matcher.group();
                NonUserConfigOptions.removeUserAgent((String)string2);
                string = NonUserConfigOptions.get((String)"raptor.user.agent.extras");
                if (string == null) break;
                matcher = pattern.matcher(string);
            }
        }
        NonUserConfigOptions.addUserAgent((String)("MWB_" + migrationConfig.getUACode()));
    }

    public static String getDefaultMigrationRepository() {
        return MigrationAddin.getMigrationConfig().getDefaultRepository();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addMigrationRepositoryStateListener(MigrationRepositoryStateListener migrationRepositoryStateListener) {
        Object object = s_lock;
        synchronized (object) {
            if (s_repositoryListeners == null) {
                s_repositoryListeners = Collections.synchronizedList(new ArrayList());
            }
            s_repositoryListeners.add(migrationRepositoryStateListener);
        }
    }

    private Icon getIcon(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = this.getClass().getResource(string);
        if (uRL == null) {
            return null;
        }
        try {
            ImageIcon imageIcon = new ImageIcon(uRL);
            return imageIcon;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        s_migrationConfig = null;
    }

    private static class MyChangeListener
    extends StructureChangeListener {
        private MyChangeListener() {
        }

        public void structureValuesChanged(StructureChangeEvent structureChangeEvent) {
            ChangeInfo[] changeInfoArray;
            for (ChangeInfo changeInfo : changeInfoArray = structureChangeEvent.getChangeDetails()) {
                if (changeInfo.getChangeType() != 0 || !changeInfo.getPropertyName().equals("DefaultRepository")) continue;
                if (MigrationAddin.isRepositoryOpen()) {
                    MigrationAddin.disconnectRepository();
                }
                String string = changeInfo.getNewValueAsString();
                if (!Connections.getInstance().isConnectionOpen(string)) continue;
                MigrationAddin.openRepository(string);
                MigrationUtils.resetDateFormatter();
            }
        }
    }
}

