/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.core;

import java.awt.Component;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.migration.workbench.core.Messages;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CapturedNode;
import oracle.dbtools.raptor.navigator.BaseNavigatorController;
import oracle.dbtools.raptor.plsql.PLSQLController;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuFilter;
import oracle.ide.model.Element;
import oracle.jdeveloper.compiler.JCompiler;

public final class CapturedNodeMenuFilter
implements MenuFilter {
    private static final String MENU_EDIT_AND_RECONVERT = Messages.getString("CapturedNodeMenuFilter.0");
    private static final String MENU_EDIT = Messages.getString("CapturedNodeMenuFilter.1");
    private final ContextMenu menu;

    public CapturedNodeMenuFilter(ContextMenu contextMenu) {
        this.menu = contextMenu;
    }

    public boolean accept(Component component) {
        Context context = this.menu.getContext();
        Element[] elementArray = context.getSelection();
        if (elementArray.length >= 1 && elementArray[0] instanceof CapturedNode) {
            if (component instanceof JMenuItem && ((JMenuItem)component).getAction() != null && ((JMenuItem)component).getAction() instanceof IdeAction) {
                int n = ((IdeAction)((JMenuItem)component).getAction()).getCommandId();
                if (n == PLSQLController.COMPILE_DEBUG_COMMAND || n == BaseNavigatorController.EDIT_OBJECT_CMD_ID || n == JCompiler.MAKE_SELECTED_CMD_ID) {
                    return false;
                }
                String string = ((JMenuItem)component).getText().trim();
                if (elementArray.length > 1 && (MENU_EDIT.equals(string) || MENU_EDIT_AND_RECONVERT.equals(string))) {
                    return false;
                }
            } else if (component instanceof JPopupMenu.Separator && ((JPopupMenu.Separator)component).getComponentCount() == 0) {
                return false;
            }
        }
        return true;
    }
}

