/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.identifierMapping;

import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.migration.identifierMapping.IdentifierMappingCmd;
import oracle.dbtools.migration.identifierMapping.Messages;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoadMappingXML {
    private IdentifierMappingCmd.IdentifierMappingDetails m_details = null;
    private Connection m_reposConn = null;

    public LoadMappingXML(Connection connection, IdentifierMappingCmd.IdentifierMappingDetails identifierMappingDetails) {
        this.m_details = identifierMappingDetails;
        this.m_reposConn = connection;
    }

    public void loadXML() throws Exception {
        Document document;
        Statement statement = this.m_reposConn.createStatement();
        String string = this.m_details.getCapturedModel();
        if (string == null || string.trim().equals("")) {
            throw new Exception(Messages.getString("LoadMappingXML.1"));
        }
        String string2 = "select distinct CONNNAME, CONNID from MGV_ALL_DETAILS WHERE CAPTUREDORCONVERTED = 'CAPTURED'";
        ResultSet resultSet = statement.executeQuery(string2);
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        while (resultSet.next()) {
            string3 = resultSet.getString(1);
            string4 = resultSet.getString(2);
            if (!string3.equals(string) && !string4.equals(string)) continue;
            bl = true;
            this.m_details.setCapturedModel(string4);
            break;
        }
        statement.close();
        if (bl && string4 != null && !string4.equals("")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            String string5 = this.m_details.getFilePath();
            if (string5 == null || string5.equals("")) {
                throw new Exception(Messages.getString("LoadMappingXML.5"));
            }
            document = documentBuilder.parse(new File(string5));
            document.getDocumentElement().normalize();
            if (!this.isValidCaptureId(document, string4)) {
                String string6 = MessageFormat.format(Messages.getString("LoadMappingXML.30"), string5, string);
                throw new Exception(string6);
            }
        } else {
            String string7 = Messages.getString("LoadMappingXML.15") + "\"" + string + "\"" + Messages.getString("LoadMappingXML.18");
            throw new Exception(string7);
        }
        this.parseXML(document, "schemas");
    }

    private boolean isValidCaptureId(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName("IdentifierMapping");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (element.getNodeType() != 1) continue;
            String string2 = element.getAttribute("captureId");
            return string.equals(string2);
        }
        return false;
    }

    private void parseXML(Node node, String string) throws Exception {
        Object object;
        Node node2;
        int n;
        NodeList nodeList;
        if (node instanceof Document) {
            nodeList = ((Document)node).getElementsByTagName(string);
            for (n = 0; n < nodeList.getLength(); ++n) {
                node2 = nodeList.item(n);
                if (node2.getNodeType() != 1) continue;
                object = (Element)node2;
                this.parseXML((Node)object, "schema");
            }
            System.out.println(Messages.getString("LoadMappingXML.22") + "\"" + this.m_details.getFilePath() + "\"" + Messages.getString("LoadMappingXML.25"));
        }
        if (node instanceof Element && !string.equals("schemas")) {
            nodeList = ((Element)node).getElementsByTagName(string);
            for (n = 0; n < nodeList.getLength(); ++n) {
                node2 = (Element)nodeList.item(n);
                if (node2.getNodeType() != 1) continue;
                object = node2.getAttribute("qualifiedSourceName");
                if (object != null && !((String)object).equals("")) {
                    String string2 = node2.getAttribute("internalObjID");
                    Long l = new Long(string2);
                    String string3 = node2.getAttribute("sourceName");
                    String string4 = node2.getAttribute("targetName");
                    String string5 = node2.getAttribute("transformed");
                    Statement statement = this.m_reposConn.createStatement();
                    String string6 = "UPDATE MD_DERIVATIVES SET TRANSFORMED = '" + string5 + "'," + " NEW_IDENTIFIER = '" + string4 + "'" + " WHERE SRC_ID = " + l + " AND DERIVATIVE_REASON = 'SCRATCH'";
                    statement.executeQuery(string6);
                    statement.close();
                }
                if (string.equals("schema")) {
                    this.parseXML(node2, "tables");
                    this.parseXML(node2, "constraints");
                    this.parseXML(node2, "procedures");
                    this.parseXML(node2, "functions");
                    this.parseXML(node2, "triggers");
                    this.parseXML(node2, "views");
                    this.parseXML(node2, "indexes");
                }
                if (string.equals("tables")) {
                    this.parseXML(node2, "table");
                }
                if (string.equals("table")) {
                    this.parseXML(node2, "columns");
                }
                if (string.equals("columns")) {
                    this.parseXML(node2, "column");
                }
                if (string.equals("constraints")) {
                    this.parseXML(node2, "constraint");
                }
                if (string.equals("procedures")) {
                    this.parseXML(node2, "procedure");
                }
                if (string.equals("functions")) {
                    this.parseXML(node2, "function");
                }
                if (string.equals("triggers")) {
                    this.parseXML(node2, "trigger");
                }
                if (string.equals("views")) {
                    this.parseXML(node2, "view");
                }
                if (!string.equals("indexes")) continue;
                this.parseXML(node2, "index");
            }
        }
    }
}

