/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.generate;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdGroup;
import oracle.dbtools.metadata.persistence.MdIndexDetail;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.metadata.persistence.MdPackage;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdSequence;
import oracle.dbtools.metadata.persistence.MdStoredProgram;
import oracle.dbtools.metadata.persistence.MdSynonym;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdTrigger;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.TranslationContext;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.MigrationEvent;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.generate.FileDumpGenerationOutputStream;
import oracle.dbtools.migration.generate.GenerateAudience;
import oracle.dbtools.migration.generate.GenerateEvent;
import oracle.dbtools.migration.generate.GenerateEventListener;
import oracle.dbtools.migration.generate.GenerateException;
import oracle.dbtools.migration.generate.GenerationOutputStream;
import oracle.dbtools.migration.generate.GroupsFromGroupIterator;
import oracle.dbtools.migration.generate.Messages;
import oracle.dbtools.migration.generate.MigrGenerationOrderIterator;
import oracle.dbtools.migration.generate.SchemasFromGroupIterator;
import oracle.dbtools.migration.generate.UntranslatedStoredProgramsIterator;
import oracle.dbtools.migration.generate.UntranslatedTriggersIterator;
import oracle.dbtools.migration.generate.UntranslatedViewsIterator;
import oracle.dbtools.migration.parser.ParserFactory;
import oracle.dbtools.migration.parser.internalapi.ITranslationAll;
import oracle.dbtools.migration.persistence.MigrGenerationOrder;
import oracle.dbtools.migration.translation.api.exceptions.TranslationException;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.ClickableLogInfo;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class GenerateWorker
implements Cancelable {
    private PersistenceManager m_persistenceManager;
    private DBObjectId m_connectionId;
    private GenerationOutputStream m_outputStream;
    private String m_outputDir;
    private GenerationOutputStream m_masterDumpStream = null;
    private File m_masterFile = null;
    private boolean _genDropStmts;
    private StringTemplateGroup m_templateGroup;
    private PersistenceUtility m_persistenceUtility;
    private GenerateAudience m_audience;
    private boolean m_shouldCancel = false;
    private String m_templateName;
    private static final String DEFAULT_TEMPLATE_NAME = "10g";
    private MigrationObjectFilterList m_filters;
    private static final SimpleDateFormat S_DATEFORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private ArrayList<String> m_viewsListForRecompile;
    private static Logger s_log = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    private boolean m_tablesOnly = false;
    private Hashtable<DBObjectId, MdSchema> m_schemaCache = new Hashtable();
    private int m_numSchema;
    private String m_dataMoveUser;
    private boolean m_attemptLeastPrivilege;
    private String m_currentSchemaDumpDir;
    private Hashtable<String, String> m_SchemaDumpHashTable = null;
    private HashMap<Long, String> m_dependencies = null;
    private int m_counterForEmulationPkg = 0;
    private MdConstraint m_IOTTableConstraint = null;
    private MdConstraint m_IOTPrimaryKey = null;
    private IOTMode cacheIOTMode = null;
    private MdIndexe m_IOTIndex = null;

    public GenerateWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, GenerationOutputStream generationOutputStream, String string, MigrationObjectFilterList migrationObjectFilterList, boolean bl) {
        this.setPersistenceManager(persistenceManager);
        this.setPersistenceUtility(PersistenceUtility.getInstance(persistenceManager));
        this.setConnectionId(dBObjectId);
        this.setOutputStream(generationOutputStream);
        this.loadTemplates();
        this.m_audience = new GenerateAudience();
        this.setTemplateName(string);
        this.setFilters(migrationObjectFilterList);
        this.loadDependencies(persistenceManager);
        this._genDropStmts = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDependencies(PersistenceManager persistenceManager) {
        block7: {
            String string = "select distinct  a1.objid, a1.objname,a2.schemaName grantee  from md_migr_dependency d,md_derivatives d1, md_derivatives d2,mgv_All_details a1, mgv_all_details a2  where d1.src_id = d.child_id and d2.src_id = d.parent_id and d1.derivative_reason IS NULL and d1.original_identifier IS NOT NULL and d2.derivative_reason IS NULL and d2.original_identifier IS NOT NULL and a1.objid = d1.derived_id and a2.objid = d2.derived_id and d.child_object_type IN ('MD_TABLES','MD_VIEWS','MD_STORED_PROGRAMS') and d.parent_object_type IN ('MD_VIEWS','MD_STORED_PROGRAMS') and a1.schemaid <> a2.schemaid";
            this.m_dependencies = new HashMap();
            ResultSet resultSet = null;
            Statement statement = null;
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (statement == null) break block7;
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public GenerateWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, GenerationOutputStream generationOutputStream, MigrationObjectFilterList migrationObjectFilterList, boolean bl) {
        this(persistenceManager, dBObjectId, generationOutputStream, DEFAULT_TEMPLATE_NAME, migrationObjectFilterList, bl);
    }

    public GenerateWorker(PersistenceManager persistenceManager, DBObjectId dBObjectId, GenerationOutputStream generationOutputStream, MigrationObjectFilterList migrationObjectFilterList) {
        this(persistenceManager, dBObjectId, generationOutputStream, DEFAULT_TEMPLATE_NAME, migrationObjectFilterList, false);
    }

    private void loadTemplates() {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader("oracle/dbtools/migration/generate/templates", null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runGenerate(boolean bl) throws GenerateException {
        GenerateEvent generateEvent;
        try {
            MigrationLogUtil.startMigrationLogSession(this.getConnectionId());
            generateEvent = new GenerateEvent(4, "", MigrationAddinArb.getString("BEGIN_GENERATE"));
            this.fireEventListeners(generateEvent);
            this.m_attemptLeastPrivilege = bl;
            this.m_numSchema = this.findSchemaCount();
            this.getOutputStream().println("SET DEFINE OFF;");
            this.generateCreateUsers();
            this.generateSchema();
            if (this.getDumpFlag()) {
                this.m_masterDumpStream.println("DISCONNECT;");
            } else {
                this.getOutputStream().println("DISCONNECT;");
            }
            if (this.shouldCancel()) {
                boolean bl2 = false;
                return bl2;
            }
            generateEvent.setEventId(5);
            this.fireEventListeners(generateEvent);
        }
        catch (PersistenceException persistenceException) {
            generateEvent = new GenerateEvent(6, "", persistenceException.getLocalizedMessage());
            s_log.log(Level.SEVERE, Messages.getString("GenerateWorker.5"), new Object[]{persistenceException.getLocalizedMessage(), generateEvent.getEventSource(), new ClickableLogInfo(generateEvent.getEventSource(), Messages.getString("GenerateWorker.6"))});
            this.fireEventListeners(generateEvent);
            boolean bl3 = false;
            return bl3;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            generateEvent = new GenerateEvent(6, "", noSuchObjectException.getLocalizedMessage());
            s_log.log(Level.SEVERE, Messages.getString("GenerateWorker.8"), new Object[]{noSuchObjectException.getLocalizedMessage(), generateEvent.getEventSource(), new ClickableLogInfo(generateEvent.getEventSource(), Messages.getString("GenerateWorker.9"))});
            this.fireEventListeners(generateEvent);
            boolean bl4 = false;
            return bl4;
        }
        finally {
            this.getPersistenceManager().releaseCache();
            if (this.getDumpFlag()) {
                this.m_masterDumpStream.close();
            }
            this.getOutputStream().close();
        }
        return true;
    }

    public int findSchemaCount() throws PersistenceException {
        return this.getPersistenceUtility().getSchemaCountForConnectionId(this.getConnectionId(), this.m_filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateCreateUsers() throws PersistenceException, NoSuchObjectException, GenerateException {
        CloseableIterator<MgvAllCatalogsRec> closeableIterator = this.m_persistenceUtility.getCatalogsForConnectionId(this.getConnectionId(), this.m_filters);
        boolean bl = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        boolean bl2 = false;
        while (closeableIterator.hasNext()) {
            String string;
            String string2;
            StringTemplate stringTemplate;
            MgvAllCatalogsRec mgvAllCatalogsRec = (MgvAllCatalogsRec)closeableIterator.next();
            CloseableIterator closeableIterator2 = this.m_persistenceUtility.getSchemasforCatalogId(mgvAllCatalogsRec.getCatalogId(), this.m_filters);
            if (bl && !bl2 && TranslationContext.getGenerateEntireEmulationPkg()) {
                stringTemplate = MigrationAddin.getMigrationConfig().getMigrate12c() ? this.getTemplateGroup().getInstanceOf("CreateUser12c") : this.getTemplateGroup().getInstanceOf("CreateUser");
                stringTemplate.setAttribute("mdschema", new Object(){

                    public String getName() {
                        return "Emulation";
                    }
                });
                string2 = stringTemplate.toString();
                string2 = string2.replaceAll("CREATE SYNONYM", " CREATE SYNONYM,CREATE PUBLIC SYNONYM ");
                if (this.getDumpFlag()) {
                    string = "create_user_emulation.sql";
                    try {
                        this.setOutputStream(this.getOutputDir(), string);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new GenerateException(fileNotFoundException);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new GenerateException(unsupportedEncodingException);
                    }
                    this.m_masterDumpStream.println("@@" + string);
                }
                this.getOutputStream().println(string2);
                bl2 = true;
            }
            string = null;
            while (closeableIterator2.hasNext()) {
                GenerateEvent generateEvent;
                if (this.shouldCancel()) {
                    closeableIterator2.close();
                    generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    return;
                }
                MdSchema mdSchema = (MdSchema)closeableIterator2.next();
                if (this.m_dataMoveUser == null) {
                    this.m_dataMoveUser = mdSchema.getName() + "_DMU";
                    while (this.m_dataMoveUser.length() > 30) {
                        this.m_dataMoveUser = this.m_dataMoveUser.substring(2);
                    }
                }
                this.m_schemaCache.put(mdSchema.getKey(), mdSchema);
                generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_USER"), mdSchema.getName());
                try {
                    this.fireEventListeners(generateEvent);
                    string = "create_user_" + mdSchema.getName() + ".sql";
                    if (!bl) continue;
                    stringTemplate = MigrationAddin.getMigrationConfig().getMigrate12c() ? this.getTemplateGroup().getInstanceOf("CreateUser12c") : this.getTemplateGroup().getInstanceOf("CreateUser");
                    stringTemplate.setAttribute("mdschema", (Object)mdSchema);
                    stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                    string2 = stringTemplate.toString();
                    try {
                        if (this.getDumpFlag()) {
                            this.setOutputStream(this.getOutputDir(), string);
                            this.m_masterDumpStream.println("@@" + string);
                        }
                        this.getOutputStream().startPreamble(Messages.getString("GenerateWorker.10") + S_DATEFORMAT.format(Calendar.getInstance().getTime()));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new GenerateException(fileNotFoundException);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        throw new GenerateException(unsupportedEncodingException);
                    }
                    this.getOutputStream().println("SET SCAN OFF;");
                    this.getOutputStream().println(string2);
                    stringTemplate.reset();
                    CloseableIterator<MdGroup> closeableIterator3 = null;
                    try {
                        closeableIterator3 = this.m_persistenceUtility.getGroupsForSchemaId(mdSchema.getKey(), this.m_filters);
                        if (!closeableIterator3.hasNext()) continue;
                        stringTemplate = this.getTemplateGroup().getInstanceOf("GrantCreateRole");
                        stringTemplate.setAttribute("mdschema", (Object)mdSchema);
                        stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                        string2 = stringTemplate.toString();
                        this.getOutputStream().println(string2);
                        stringTemplate.reset();
                    }
                    finally {
                        if (closeableIterator3 == null) continue;
                        closeableIterator3.close();
                    }
                }
                finally {
                    generateEvent.setEventId(2);
                    this.fireEventListeners(generateEvent);
                }
            }
            if (this.m_numSchema > 1 && MigrationAddin.getMigrationConfig().getGenerateDataMoveUserFlag()) {
                stringTemplate = this.getTemplateGroup().getInstanceOf("CreateDataMoveUser");
                stringTemplate.setAttribute("username", (Object)this.m_dataMoveUser);
                string2 = stringTemplate.toString();
                this.getOutputStream().println(string2);
            }
            this.getOutputStream().endPreamble();
            closeableIterator2.close();
        }
        closeableIterator.close();
    }

    private void setOutputStream(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        if (this.getDumpFlag() && this.m_masterDumpStream == null) {
            this.setMasterOutPutStream();
        }
        this.getOutputStream().close();
        File file = new File(string, string2);
        FileDumpGenerationOutputStream fileDumpGenerationOutputStream = null;
        String string3 = Ide.getEnvironOptions().getEncoding();
        fileDumpGenerationOutputStream = string3 == null ? new FileDumpGenerationOutputStream(new PrintStream(file)) : new FileDumpGenerationOutputStream(new PrintStream(file, string3));
        this.setOutputStream(fileDumpGenerationOutputStream);
    }

    private void setMasterOutPutStream() throws FileNotFoundException, UnsupportedEncodingException {
        this.m_masterFile = new File(this.getOutputDir(), "MASTER_SCRIPT.sql");
        FileDumpGenerationOutputStream fileDumpGenerationOutputStream = null;
        String string = Ide.getEnvironOptions().getEncoding();
        fileDumpGenerationOutputStream = string == null ? new FileDumpGenerationOutputStream(new PrintStream(this.m_masterFile)) : new FileDumpGenerationOutputStream(new PrintStream(this.m_masterFile, string));
        this.m_masterDumpStream = fileDumpGenerationOutputStream;
    }

    public File getMasterFile() {
        return this.m_masterFile;
    }

    protected void generateSchema() throws PersistenceException, NoSuchObjectException, GenerateException {
        CloseableIterator<MgvAllCatalogsRec> closeableIterator = this.m_persistenceUtility.getCatalogsForConnectionId(this.getConnectionId(), this.m_filters);
        boolean bl = false;
        while (closeableIterator.hasNext()) {
            MgvAllCatalogsRec mgvAllCatalogsRec = (MgvAllCatalogsRec)closeableIterator.next();
            CloseableIterator object = this.m_persistenceUtility.getSchemasforCatalogId(mgvAllCatalogsRec.getCatalogId(), this.m_filters);
            while (object.hasNext()) {
                if (this.shouldCancel()) {
                    object.close();
                    GenerateEvent generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    return;
                }
                MdSchema unsupportedEncodingException = (MdSchema)object.next();
                MdPackage mdPackage = this.getPersistenceUtility().getEmulationPackageForSchema(unsupportedEncodingException.getKey());
                if (TranslationContext.getGenerateEntireEmulationPkg()) {
                    if (!bl && mdPackage != null) {
                        this.generateEmulationSchema(unsupportedEncodingException);
                        bl = true;
                    }
                } else {
                    this.generateEmulationSchema(unsupportedEncodingException);
                    bl = true;
                }
                if (this.m_numSchema != 1 || !this.m_attemptLeastPrivilege) {
                    this.getOutputStream().startSchema(unsupportedEncodingException.getName());
                }
                this.generateIndividualSchema(unsupportedEncodingException);
                this.getOutputStream().endSchema();
            }
            object.close();
        }
        this.generateTranslatedObjects();
        for (MdSchema mdSchema : this.m_schemaCache.values()) {
            this.generateConnect(mdSchema);
            if (this.m_numSchema != 1 || !this.m_attemptLeastPrivilege) {
                this.getOutputStream().startSchema(mdSchema.getName());
                this.generateRoleMembers(mdSchema);
            }
            this.generateForeignKeyConstraints(mdSchema);
            try {
                if (this.getDumpFlag()) {
                    this.setOutputStream("UntranslatedTriggers.sql");
                }
                this.generateTriggers(mdSchema);
                if (this.getDumpFlag()) {
                    this.setOutputStream("UntranslatedViews.sql");
                }
                this.generateViews(mdSchema);
                if (this.getDumpFlag()) {
                    this.setOutputStream("UntranslatedProcsAndFuncs.sql");
                }
                this.generateUntranslatedStoredProcedures(mdSchema);
                if (this.getDumpFlag()) {
                    this.setOutputStream("RecompileViews.sql");
                }
                this.generateRecompileViews(mdSchema);
                this.generateObjectPrivileges();
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new GenerateException(fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new GenerateException(unsupportedEncodingException);
            }
            this.getOutputStream().endSchema();
        }
        this.getOutputStream().finished();
        closeableIterator.close();
    }

    private void generateObjectPrivileges() {
    }

    private void generateEmulationSchema(MdSchema mdSchema) throws GenerateException, PersistenceException {
        if (this.getDumpFlag()) {
            try {
                this.createDirectory("Emulation");
                this.setOutputStream(this.getOutputDir(), "Emulation" + File.separator + "Emulation" + ".sql");
                this.m_masterDumpStream.println("@@Emulation" + File.separator + "Emulation.sql");
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new GenerateException(fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new GenerateException(unsupportedEncodingException);
            }
        }
        String string = mdSchema.getName();
        if (TranslationContext.getGenerateEntireEmulationPkg()) {
            string = "Emulation";
        }
        final String string2 = string;
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SCHEMAS"), string2);
        this.getOutputStream().startDatabase("Emulation");
        this.getAudience().fireListeners(generateEvent);
        this.getOutputStream().startObject("Emulation", "MD_SCHEMAS");
        if (!this.m_attemptLeastPrivilege) {
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("ConnectUser");
            stringTemplate.setAttribute("mdschema", new Object(){

                public String getName() {
                    return string2;
                }
            });
            String string3 = stringTemplate.toString();
            this.getOutputStream().println(string3);
        }
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
        this.getOutputStream().endObject();
        this.generateEmulationPackage(mdSchema);
        this.generateUDTTable();
        this.getOutputStream().endDatabase();
    }

    private void generateUDTTable() {
        Object object;
        DBObjectId dBObjectId = this.getConnectionId();
        DBUtil dBUtil = DBUtil.getInstance((Connection)this.getPersistenceManager().getConn());
        String string = "select src_id from  md_derivatives  where derived_id = " + dBObjectId.getId();
        if (DBUtil.getConnectionResolver() == null) {
            DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
        }
        String string2 = dBUtil.executeOracleReturnOneCol(string, null);
        String string3 = "select min(schemaid) from mgv_all_schema_details where connid=" + string2;
        String string4 = dBUtil.executeOracleReturnOneCol(string3, null);
        String string5 = "select data_type_name ||' ' ||   CASE definition  WHEN 'char' THEN 'char(1)'  WHEN 'varchar' THEN 'varchar(1)'  ELSE definition END UDT  FROM md_user_defined_data_Types where schema_id_fk = " + string4;
        List list = dBUtil.executeReturnList(string5, null);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE TABLE UDT (");
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (Map map : list) {
            object = map.get("UDT");
            String string6 = object.toString() + " ";
            if (!hashSet.add(string6.substring(0, string6.indexOf(" ")))) continue;
            bl = true;
            stringBuffer.append(object.toString() + ",");
        }
        if (bl) {
            Map map;
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            stringBuffer.append(")");
            String string7 = stringBuffer.toString();
            map = (ITranslationAll)ParserFactory.getParser((String)"oracle.dbtools.migration.parser.tsql.TSQLParserMain");
            object = null;
            try {
                object = map.translate(string7);
            }
            catch (TranslationException translationException) {
                // empty catch block
            }
            object = ((String)object).replaceAll(" BLOB", " RAW(8)");
            this.getOutputStream().println("--UDT DEFINITION\n" + (String)object);
            if (TranslationContext.getGenerateEntireEmulationPkg()) {
                this.getOutputStream().println("CREATE OR REPLACE PUBLIC SYNONYM UDT FOR " + (this.m_numSchema != 1 && this.getDumpFlag() ? "emulation." : "") + "UDT;\n/ \n ");
                this.getOutputStream().println("GRANT SELECT, REFERENCES ON UDT TO PUBLIC;\n/ \n");
            }
        }
    }

    protected void generateForeignKeyConstraints(MdSchema mdSchema) throws GenerateException {
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = this.getPersistenceUtility().getForeignKeyConstraintsForSchemaId(mdSchema.getKey());
        }
        catch (PersistenceException persistenceException) {
            s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{persistenceException.getLocalizedMessage(), mdSchema.getName()});
            return;
        }
        while (closeableIterator.hasNext()) {
            MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
            try {
                MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
                if (this.getDumpFlag()) {
                    this.setOutputStream(mdConstraint.getName() + ".sql");
                }
                this.generateIndividualForeignKeyConstraint(mdTable, mdConstraint);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{noSuchObjectException.getLocalizedMessage(), mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.23"))});
            }
            catch (PersistenceException persistenceException) {
                s_log.log(Level.SEVERE, "Generate.FOREIGNKEYCONSTRAINT", new Object[]{persistenceException.getLocalizedMessage(), mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.25"))});
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new GenerateException(fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new GenerateException(unsupportedEncodingException);
            }
        }
    }

    protected void generateIndividualSchema(MdSchema mdSchema) throws PersistenceException, NoSuchObjectException, GenerateException {
        boolean bl = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("ConnectUser");
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SCHEMAS"), mdSchema.getName());
        if (this.getDumpFlag()) {
            try {
                this.createDirectory(mdSchema.getName());
                this.setOutputStream(this.getOutputDir(), mdSchema.getName() + ".sql");
                this.m_masterDumpStream.println("@@" + mdSchema.getName() + ".sql");
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new GenerateException(fileNotFoundException);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new GenerateException(unsupportedEncodingException);
            }
        }
        this.getOutputStream().startDatabase(mdSchema.getName());
        this.getAudience().fireListeners(generateEvent);
        this.getOutputStream().startObject(mdSchema.getName(), "MD_SCHEMAS");
        if (bl) {
            stringTemplate.setAttribute("mdschema", (Object)mdSchema);
            String string = stringTemplate.toString();
            this.getOutputStream().println(string);
            mdSchema.setNativeSql(string);
        }
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
        this.getOutputStream().endObject();
        if (bl) {
            mdSchema.save(this.getPersistenceManager());
        }
        if (!this.m_tablesOnly) {
            this.generateSequences(mdSchema);
        }
        this.generateClobToBlob(mdSchema);
        this.generateAllTables(mdSchema);
        this.generateSynonyms(mdSchema);
        if (!this.m_tablesOnly && bl) {
            this.generateRoles(mdSchema);
        }
        this.getOutputStream().endDatabase();
    }

    private void createDirectory(String string) {
        File file = new File(this.getOutputDir(), string);
        file.mkdir();
        if (this.m_SchemaDumpHashTable == null) {
            this.m_SchemaDumpHashTable = new Hashtable();
        }
        this.m_SchemaDumpHashTable.put(string, file.toString());
        this.setCurrentSchemaDumpDirectory(string);
    }

    private void setCurrentSchemaDumpDirectory(String string) {
        this.m_currentSchemaDumpDir = string;
    }

    private String getCurrentSchemaDumpDirectory() {
        return this.m_currentSchemaDumpDir;
    }

    protected void generateSynonyms(MdSchema mdSchema) throws GenerateException {
        String string = "select name, synonym_for_id, native_key from md_synonyms where schema_id_fk = (select src_id from md_derivatives where derived_id = ? and src_type = 'MD_SCHEMAS')";
        String string2 = "select new_identifier from md_derivatives where src_id = ?";
        Connection connection = this.getPersistenceManager().getConn();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (this.getDumpFlag()) {
                this.setCurrentSchemaDumpDirectory(mdSchema.getName());
                this.setOutputStream("Synonyms.sql");
            }
            preparedStatement = connection.prepareStatement(string);
            preparedStatement.setLong(1, mdSchema.getKey().getId());
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string3 = resultSet.getString(1);
                String string4 = null;
                String string5 = null;
                long l = resultSet.getLong(2);
                long l2 = new Long(resultSet.getString(3));
                PreparedStatement preparedStatement2 = connection.prepareStatement(string2);
                preparedStatement2.setLong(1, l);
                ResultSet resultSet2 = preparedStatement2.executeQuery();
                if (resultSet2.next()) {
                    string4 = resultSet2.getString(1);
                }
                PreparedStatement preparedStatement3 = connection.prepareStatement(string2);
                preparedStatement3.setLong(1, l2);
                ResultSet resultSet3 = preparedStatement3.executeQuery();
                if (resultSet3.next()) {
                    string5 = resultSet3.getString(1);
                }
                if (string4 == null) continue;
                StringTemplate stringTemplate = null;
                String string6 = null;
                if (string5 != null) {
                    stringTemplate = this.getTemplateGroup().getInstanceOf("createSynonym");
                    stringTemplate.setAttribute("name", (Object)string3);
                    stringTemplate.setAttribute("refObj", (Object)(string5 + "." + string4));
                    string6 = stringTemplate.toString();
                    this.getOutputStream().println(string6);
                    this.getOutputStream().println("\n");
                    continue;
                }
                stringTemplate = this.getTemplateGroup().getInstanceOf("createSynonym");
                stringTemplate.setAttribute("name", (Object)string3);
                stringTemplate.setAttribute("refObj", (Object)string4);
                string6 = stringTemplate.toString();
                this.getOutputStream().println(string6);
                this.getOutputStream().println("\n");
            }
        }
        catch (SQLException sQLException) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenerateException(fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GenerateException(unsupportedEncodingException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTranslatedObjects() throws PersistenceException {
        CloseableIterator closeableIterator = null;
        PersistableObject persistableObject = null;
        try {
            closeableIterator = new MigrGenerationOrderIterator(this.getPersistenceManager(), this.m_connectionId);
            while (closeableIterator.hasNext()) {
                MigrGenerationOrder migrGenerationOrder = (MigrGenerationOrder)closeableIterator.next();
                try {
                    boolean bl;
                    MdSchema mdSchema;
                    PersistableObject persistableObject2 = this.getPersistenceUtility().loadPersistableObject(migrGenerationOrder.getObjectId(), migrGenerationOrder.getObjectType());
                    if (persistableObject2.getObjectType().equals("MD_CONSTRAINTS") || (mdSchema = this.findParentSchema(persistableObject2)) == null) continue;
                    boolean bl2 = bl = persistableObject == null || !mdSchema.getKey().equals(persistableObject.getKey());
                    if (bl) {
                        this.generateConnect(mdSchema);
                        persistableObject = mdSchema;
                    }
                    try {
                        if (this.m_numSchema != 1 || !this.m_attemptLeastPrivilege) {
                            this.getOutputStream().startSchema(mdSchema.getName());
                        }
                        if (this.getDumpFlag()) {
                            this.setCurrentSchemaDumpDirectory(((MdSchema)persistableObject).getName());
                        }
                        this.generateIndividualPersistableObject(persistableObject2, (MdSchema)persistableObject);
                        this.getOutputStream().endSchema();
                    }
                    catch (IOException iOException) {
                        s_log.log(Level.FINE, "Generate.EXCEPTION", new Object[]{iOException.getLocalizedMessage(), persistableObject2.getObjectName(), new ClickableLogInfo(persistableObject2, Messages.getString("GenerateWorker.29"))});
                    }
                    catch (GenerateException generateException) {
                        s_log.log(Level.FINE, "Generation.EXCEPTION", new Object[]{generateException.getLocalizedMessage(), persistableObject2.getObjectName(), new ClickableLogInfo(persistableObject2, Messages.getString("GenerateWorker.31"))});
                    }
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    s_log.log(Level.FINE, "Generate.FAILEDTORETRIEVEOBJECT", new Object[]{noSuchObjectException.getLocalizedMessage(), migrGenerationOrder.getObjectName(), new ClickableLogInfo(migrGenerationOrder, Messages.getString("GenerateWorker.33"))});
                }
            }
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    private void generateConnect(MdSchema mdSchema) {
        boolean bl;
        if (this.getDumpFlag()) {
            this.setCurrentSchemaDumpDirectory(mdSchema.getName());
        }
        boolean bl2 = bl = this.m_numSchema != 1 || !this.m_attemptLeastPrivilege;
        if (bl) {
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("ConnectUser");
            stringTemplate.setAttribute("mdschema", (Object)mdSchema);
            String string = stringTemplate.toString();
            if (this.getDumpFlag()) {
                this.m_masterDumpStream.startObject("connect-" + mdSchema.getName(), "sql");
                this.m_masterDumpStream.println(string);
                this.m_masterDumpStream.endObject();
            } else {
                this.getOutputStream().startObject("connect-" + mdSchema.getName(), "sql");
                this.getOutputStream().println(string);
                this.getOutputStream().endObject();
            }
        }
    }

    protected void generateIndividualPersistableObject(PersistableObject persistableObject, MdSchema mdSchema) throws IOException, PersistenceException, NoSuchObjectException, GenerateException {
        String string = persistableObject.getObjectType();
        if (string.equals("MD_STORED_PROGRAMS")) {
            if (this.getDumpFlag()) {
                this.setOutputStream("PROC_FUNC_" + persistableObject.getObjectName() + ".sql");
            }
            this.generateIndividualStoredProcedure((MdStoredProgram)persistableObject);
        } else if (string.equals("MD_TRIGGERS")) {
            if (this.getDumpFlag()) {
                this.setOutputStream("TRIGGER_" + persistableObject.getObjectName() + ".sql");
            }
            this.generateIndividualTrigger((MdTrigger)persistableObject);
        } else if (string.equals("MD_CONSTRAINTS")) {
            if (this.getDumpFlag()) {
                this.setOutputStream(persistableObject.getObjectName() + ".sql");
            }
            this.generateIndividualConstraint((MdConstraint)persistableObject);
        } else if (string.equals("MD_VIEWS")) {
            if (this.getDumpFlag()) {
                this.setOutputStream("VIEW_" + persistableObject.getObjectName() + ".sql");
            }
            this.generateIndividualView((MdView)persistableObject, mdSchema);
        } else if (string.equals("MD_PACKAGES")) {
            // empty if block
        }
        if (this.m_dependencies.containsKey(persistableObject.getKey().getId())) {
            this.generateObjectGrants(persistableObject);
        }
    }

    private MdSchema findParentSchema(PersistableObject persistableObject) {
        PersistableObject persistableObject2;
        DBObjectId dBObjectId = null;
        MdSchema mdSchema = null;
        String string = persistableObject.getObjectType();
        if (string.equals("MD_STORED_PROGRAMS")) {
            persistableObject2 = (MdStoredProgram)persistableObject;
            dBObjectId = ((MdStoredProgram)persistableObject2).getSchemaId();
        } else if (string.equals("MD_TRIGGERS")) {
            persistableObject2 = (MdTrigger)persistableObject;
            dBObjectId = this.findParentSchemaId((MdTrigger)persistableObject2);
        } else if (string.equals("MD_CONSTRAINTS")) {
            persistableObject2 = (MdConstraint)persistableObject;
            dBObjectId = this.findParentSchemaId((MdConstraint)persistableObject2);
        } else if (string.equals("MD_VIEWS")) {
            persistableObject2 = (MdView)persistableObject;
            dBObjectId = ((MdView)persistableObject2).getSchemaId();
        } else if (string.equals("MD_PACKAGES")) {
            persistableObject2 = (MdPackage)persistableObject;
            dBObjectId = ((MdPackage)persistableObject2).getSchemaId();
        } else if (string.equals("MD_TABLES")) {
            persistableObject2 = (MdTable)persistableObject;
            dBObjectId = ((MdTable)persistableObject2).getSchemaId();
        }
        if (dBObjectId != null && (mdSchema = this.m_schemaCache.get(dBObjectId)) == null) {
            try {
                mdSchema = MdSchema.retrieveExistingInstance(this.getPersistenceManager(), dBObjectId);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.38"), (Throwable)noSuchObjectException);
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.39"), (Throwable)persistenceException);
            }
        }
        return mdSchema;
    }

    private DBObjectId findParentSchemaId(MdTrigger mdTrigger) {
        try {
            if (mdTrigger.getTriggerOnFlag().equals("T")) {
                MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdTrigger.getTableOrViewId());
                return mdTable.getSchemaId();
            }
            MdView mdView = MdView.retrieveExistingInstance(this.getPersistenceManager(), mdTrigger.getTableOrViewId());
            return mdView.getSchemaId();
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.40"), (Throwable)persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.41"), (Throwable)noSuchObjectException);
        }
        return null;
    }

    private DBObjectId findParentSchemaId(MdConstraint mdConstraint) {
        try {
            MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
            return mdTable.getSchemaId();
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.42"), (Throwable)persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.43"), (Throwable)noSuchObjectException);
        }
        return null;
    }

    protected void generateRecompileViews(MdSchema mdSchema) {
        List<String> list = this.getListForRecompile();
        for (String string : list) {
            if (!string.startsWith(mdSchema.getName() + ".")) continue;
            string = string.substring(string.indexOf(46) + 1);
            String string2 = "ALTER VIEW " + string + " COMPILE;\n";
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
            stringTemplate.reset();
            stringTemplate.setAttribute("text", (Object)string2);
            this.getOutputStream().startObject("recompile-" + string, "sql");
            this.getOutputStream().println(stringTemplate.toString());
            this.getOutputStream().endObject();
        }
    }

    protected void generateClobToBlob(MdSchema mdSchema) throws PersistenceException, GenerateException {
        MigrationPlugin migrationPlugin = null;
        try {
            migrationPlugin = MigrationUtils.getPluginForConnection(MdConnection.retrieveExistingInstance(this.getPersistenceManager(), this.m_connectionId));
        }
        catch (MigrationPluginException migrationPluginException) {
            migrationPlugin = null;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            migrationPlugin = null;
        }
        if (migrationPlugin != null && migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() && this.m_persistenceUtility.getHaveIaBlob(mdSchema)) {
            int n = 500;
            if (MigrationAddin.getMigrationConfig().getMigrate12c()) {
                n = 4000;
            }
            String string = "CREATE OR REPLACE PROCEDURE CLOBTOBLOB_sqldeveloper \n  ( \n    tableNameL      VARCHAR2 , \n    clobColumnNameL VARCHAR2, \n    blobColumnNameL VARCHAR2 ) \nAS \n  tableName      VARCHAR2 ( 500 ) := '';--to_UPPER(tableNameL); \n  clobColumnName VARCHAR2 ( 500 ) := '';--to_UPPER(clobColumNameL); \n  blobColumnName VARCHAR2 ( 500 ) := '';--to_UPPER(blobColumNameL); \n  tmpString      VARCHAR2 ( 500 ) := ''; \n  errorOut       BOOLEAN          := false; \n  inputLength    NUMBER; -- size of input CLOB \n  offSet         NUMBER := 1; \n  pieceMaxSize   NUMBER := " + n + ";          -- the max size of each peice large for 12c" + "\n  piece          VARCHAR2 ( " + n + " CHAR ) ; -- these pieces will make up the entire CLOB " + "\n  currentPlace   NUMBER := 1;            -- this is where were up to in the CLOB " + "\n  blobLoc BLOB;                          -- blob locator in the table " + "\n  clobLoc CLOB;                          -- clob locator pointsthis is the value from the dat file " + "\n  myquery VARCHAR2 ( 2000 ) ; " + "\n  -- THIS HAS TO BE CHANGED FOR SPECIFIC CUSTOMER TABLE " + "\n  -- AND COLUMN NAMES " + "\n  --CURSOR cur; " + "\nTYPE cur_typ " + "\nIS " + "\n  REF " + "\n  CURSOR; " + "\n    cur cur_typ; " + "\n    --cur_rec cur%ROWTYPE; " + "\n  BEGIN " + "\n    tableName      := UPPER ( tableNameL ) ; " + "\n    clobColumnName := UPPER ( clobColumnNameL ) ; " + "\n    blobColumnName := UPPER ( blobColumnNameL ) ; " + "\n    BEGIN " + "\n      EXECUTE immediate 'select table_name from user_tables where table_name = :1 ' INTO tmpString USING tableName; " + "\n      IF ( tmpString != tableName ) THEN " + "\n        errorOut     := true; " + "\n      ELSE " + "\n        BEGIN " + "\n          EXECUTE immediate 'select COLUMN_NAME from user_tab_columns where table_name = :1 and COLUMN_NAME = :2 ' INTO tmpString USING tableName, clobColumnName; " + "\n          IF ( tmpString != clobColumnName ) THEN " + "\n            errorOut     := true; " + "\n          ELSE " + "\n            EXECUTE immediate 'select COLUMN_NAME from user_tab_columns where table_name = :1 and COLUMN_NAME = :2 ' INTO tmpString USING tableName, blobColumnName; " + "\n            IF ( tmpString != blobColumnName ) THEN " + "\n              errorOut     := true; " + "\n            END IF; " + "\n          END IF; " + "\n        END; " + "\n      END IF; " + "\n    EXCEPTION " + "\n    WHEN OTHERS THEN " + "\n      errorOut := true; " + "\n    END; " + "\n    IF ( errorOut = true ) THEN " + "\n      raise_application_error ( -20001, 'Invalid parameters' ) ; " + "\n    END IF; " + "\n    EXECUTE immediate 'update ' || tableName || ' set ' || blobColumnName || '= empty_blob() ' ; " + "\n    myquery := 'SELECT '||clobColumnName||' clob_column , '||blobColumnName||' blob_column FROM ' || tableName || ' FOR UPDATE'; " + "\n    OPEN cur FOR myquery;-- using clobColumName, blobColumnName ; " + "\n    FETCH cur " + "\n       INTO clobLoc, " + "\n      blobLoc ; " + "\n   " + "\n  WHILE cur%FOUND " + "\n  LOOP " + "\n    --RETRIVE THE clobLoc and blobLoc " + "\n    --clobLoc := cur_rec.clob_column; " + "\n    --blobLoc := cur_rec.blob_column; " + "\n    currentPlace := 1; -- reset evertime " + "\n    -- find the lenght of the clob " + "\n    inputLength := DBMS_LOB.getLength ( clobLoc ) ; " + "\n    -- loop through each peice " + "\n    LOOP " + "\n      IF (inputLength > 0) " + "\n      THEN " + "\n      -- get the next piece and add it to the clob " + "\n      piece := DBMS_LOB.subStr ( clobLoc,pieceMaxSize,currentPlace ) ; " + "\n      -- append this piece to the BLOB " + "\n      DBMS_LOB.WRITEAPPEND ( blobLoc, LENGTH ( piece ) /2, HEXTORAW ( piece ) ) ; " + "\n      currentPlace := currentPlace                     + pieceMaxSize ; " + "\n      END IF; " + "\n      EXIT " + "\n    WHEN inputLength < currentplace; " + "\n    END LOOP; " + "\n    FETCH cur " + "\n       INTO clobLoc, " + "\n      blobLoc ; " + "\n  END LOOP; " + "\n  EXECUTE immediate 'alter table ' || tableName || ' drop column ' || clobColumnName; " + "\n  --unnecessary after ddl " + "\n  COMMIT; " + "\nEND CLOBtoBLOB_sqldeveloper;";
            GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_STORED_PROGRAMS"), "");
            this.getOutputStream().startObject("CLOBTOBLOB_sqldeveloper", "MD_STORED_PROGRAMS");
            this.getAudience().fireListeners(generateEvent);
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
            stringTemplate.setAttribute("text", (Object)string);
            this.getOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
            stringTemplate.setAttribute("text", (Object)"/\n");
            this.getOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
            this.getOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
            this.m_outputStream.endObject();
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
        }
    }

    protected void generateEmulationPackage(MdSchema mdSchema) throws PersistenceException, GenerateException {
        try {
            MdPackage mdPackage = this.getPersistenceUtility().getEmulationPackageForSchema(mdSchema.getKey());
            if (!(mdPackage == null || this.m_counterForEmulationPkg != 0 && TranslationContext.getGenerateEntireEmulationPkg())) {
                ++this.m_counterForEmulationPkg;
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_PACKAGE"), "");
                this.getOutputStream().startObject("Emulation", "MD_PACKAGES");
                this.getAudience().fireListeners(generateEvent);
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
                stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdPackage.getPackageHeader()));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                stringTemplate.setAttribute("text", (Object)"/\n");
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdPackage.getNativeSql()));
                this.getOutputStream().println(stringTemplate.toString());
                stringTemplate.reset();
                stringTemplate.setAttribute("text", (Object)"/\n");
                this.getOutputStream().println(stringTemplate.toString());
                this.m_outputStream.endObject();
                generateEvent.setEventId(2);
                this.getAudience().fireListeners(generateEvent);
                if (TranslationContext.getGenerateEntireEmulationPkg()) {
                    StringTemplate stringTemplate2 = this.getTemplateGroup().getInstanceOf("blindDump");
                    stringTemplate2.setAttribute("text", (Object)("create or replace  public  synonym " + mdPackage.getComments() + " for  emulation." + mdPackage.getComments().trim() + ";\n/"));
                    this.getOutputStream().println(stringTemplate2.toString());
                    stringTemplate2.reset();
                    this.getOutputStream().println("grant execute on " + mdPackage.getComments() + " to public;\n/ \n");
                }
            } else {
                MdSynonym mdSynonym = this.getPersistenceUtility().getEmulationSynonymForSchema(mdSchema.getKey());
                if (mdSynonym != null) {
                    GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SYNONYM"), mdSynonym.getName());
                    StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
                    stringTemplate.setAttribute("text", (Object)mdSynonym.getProperty("MIGRATIONEMULATION"));
                    this.getOutputStream().println(stringTemplate.toString());
                    stringTemplate.reset();
                }
            }
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.162"), (Throwable)persistenceException);
            throw new GenerateException(persistenceException);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            MigrationLogUtil.logThrowable(noSuchObjectException.getLocalizedMessage(), Messages.getString("GenerateWorker.163"), (Throwable)noSuchObjectException);
            throw new GenerateException(noSuchObjectException);
        }
        catch (IOException iOException) {
            MigrationLogUtil.logThrowable(iOException.getLocalizedMessage(), Messages.getString("GenerateWorker.164"), (Throwable)iOException);
            throw new GenerateException(iOException);
        }
    }

    protected void generateSequences(MdSchema mdSchema) throws GenerateException {
        CloseableIterator<MdSequence> closeableIterator = null;
        try {
            closeableIterator = this.m_persistenceUtility.getSequencesForSchemaId(mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdSequence mdSequence = (MdSequence)closeableIterator.next();
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_SEQUENCE"), mdSequence.getName());
                this.getOutputStream().startObject(mdSequence.getName(), "MD_SEQUENCES");
                this.getAudience().fireListeners(generateEvent);
                StringTemplate stringTemplate = null;
                String string = null;
                stringTemplate = this.getTemplateGroup().getInstanceOf("DropSequence");
                stringTemplate.setAttribute("mdsequence", (Object)mdSequence);
                string = stringTemplate.toString();
                if (this._genDropStmts) {
                    string = string.replaceFirst("-- ", "");
                }
                this.getOutputStream().println(string);
                this.getOutputStream().println("\n");
                stringTemplate = this.getTemplateGroup().getInstanceOf("CreateSequence");
                stringTemplate.setAttribute("mdsequence", (Object)mdSequence);
                stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                this.getOutputStream().println(stringTemplate.toString());
                this.getOutputStream().endObject();
                generateEvent.setEventId(2);
                this.getAudience().fireListeners(generateEvent);
                stringTemplate.reset();
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    protected void generateRoles(MdSchema mdSchema) throws GenerateException {
        CloseableIterator<MdGroup> closeableIterator = null;
        try {
            if (this.getDumpFlag()) {
                this.setCurrentSchemaDumpDirectory(mdSchema.getName());
                this.setOutputStream("Roles.sql");
            }
            closeableIterator = this.m_persistenceUtility.getGroupsForSchemaId(mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdGroup mdGroup = (MdGroup)closeableIterator.next();
                if (mdGroup.getGroupFlag() == null || !mdGroup.getGroupFlag().equals("R")) continue;
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_GROUP"), mdGroup.getGroupName());
                this.getOutputStream().startObject(mdGroup.getGroupName(), "MD_GROUPS");
                this.getAudience().fireListeners(generateEvent);
                StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("CreateGroup");
                stringTemplate.setAttribute("mdgroup", (Object)mdGroup);
                stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                this.getOutputStream().println(stringTemplate.toString());
                this.getOutputStream().endObject();
                generateEvent.setEventId(2);
                this.getAudience().fireListeners(generateEvent);
                stringTemplate.reset();
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenerateException(fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GenerateException(unsupportedEncodingException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    protected void generateRoleMembers(MdSchema mdSchema) throws GenerateException {
        CloseableIterator<MdGroup> closeableIterator = null;
        CloseableIterator closeableIterator2 = null;
        CloseableIterator closeableIterator3 = null;
        try {
            closeableIterator = this.m_persistenceUtility.getGroupsForSchemaId(mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                StringTemplate stringTemplate;
                GenerateEvent generateEvent;
                PersistableObject persistableObject;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdGroup mdGroup = (MdGroup)closeableIterator.next();
                if (mdGroup.getGroupFlag() == null || !mdGroup.getGroupFlag().equals("R")) continue;
                closeableIterator3 = new SchemasFromGroupIterator(this.getPersistenceManager(), mdGroup.getKey(), this.m_filters);
                while (closeableIterator3.hasNext()) {
                    persistableObject = (MdSchema)closeableIterator3.next();
                    generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_GROUP_MEMBERS"), ((MdSchema)persistableObject).getName());
                    this.getOutputStream().startObject(mdGroup.getGroupName(), "MD_GROUP_MEMBERS");
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate = this.getTemplateGroup().getInstanceOf("GrantRole");
                    stringTemplate.setAttribute("mdgroup", (Object)mdGroup);
                    stringTemplate.setAttribute("mdschema", (Object)persistableObject);
                    this.getOutputStream().println(stringTemplate.toString());
                    this.getOutputStream().endObject();
                    generateEvent.setEventId(2);
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate.reset();
                }
                if (closeableIterator3 != null) {
                    closeableIterator3.close();
                }
                closeableIterator2 = new GroupsFromGroupIterator(this.getPersistenceManager(), mdGroup.getKey(), this.m_filters);
                while (closeableIterator2.hasNext()) {
                    persistableObject = (MdGroup)closeableIterator2.next();
                    generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_GROUP_MEMBERS"), ((MdGroup)persistableObject).getGroupName());
                    this.getOutputStream().startObject(mdGroup.getGroupName(), "MD_GROUP_MEMBERS");
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate = this.getTemplateGroup().getInstanceOf("GrantRoleToRole");
                    stringTemplate.setAttribute("mdgroup", (Object)mdGroup);
                    stringTemplate.setAttribute("mdgroupto", (Object)persistableObject);
                    this.getOutputStream().println(stringTemplate.toString());
                    this.getOutputStream().endObject();
                    generateEvent.setEventId(2);
                    this.getAudience().fireListeners(generateEvent);
                    stringTemplate.reset();
                }
                if (closeableIterator2 == null) continue;
                closeableIterator2.close();
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
            if (closeableIterator3 != null) {
                closeableIterator3.close();
            }
            if (closeableIterator2 != null) {
                closeableIterator2.close();
            }
        }
    }

    protected void generateTriggers(MdSchema mdSchema) throws GenerateException {
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = new UntranslatedTriggersIterator(this.getPersistenceManager(), mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdTrigger mdTrigger = (MdTrigger)closeableIterator.next();
                this.generateIndividualTrigger(mdTrigger);
            }
        }
        catch (PersistenceException persistenceException) {
            throw new GenerateException(persistenceException);
        }
        catch (IOException iOException) {
            throw new GenerateException(iOException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    protected void generateIndividualTrigger(MdTrigger mdTrigger) throws IOException {
        if (!mdTrigger.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.TRIGGERNOTCONVERTED", new Object[]{mdTrigger.getTriggerName(), mdTrigger.getLanguage(), new ClickableLogInfo(mdTrigger, "Generate")});
        } else {
            GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_TRIGGERS"), mdTrigger.getTriggerName());
            this.getAudience().fireListeners(generateEvent);
            this.getOutputStream().startObject(mdTrigger.getTriggerName(), "MD_TRIGGERS");
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
            stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdTrigger.getNativeSql()));
            this.getOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
            stringTemplate.setAttribute("text", (Object)"/\n");
            this.getOutputStream().println(stringTemplate.toString());
            stringTemplate.reset();
            this.getOutputStream().endObject();
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateViews(MdSchema mdSchema) throws PersistenceException, GenerateException {
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = new UntranslatedViewsIterator(this.getPersistenceManager(), mdSchema.getKey(), null);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdView mdView = (MdView)closeableIterator.next();
                try {
                    this.generateIndividualView(mdView, mdSchema);
                }
                catch (IOException iOException) {
                    throw new GenerateException(iOException);
                }
                catch (NoSuchObjectException noSuchObjectException) {
                    throw new GenerateException(noSuchObjectException);
                    return;
                }
            }
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    protected void generateIndividualView(MdView mdView, MdSchema mdSchema) throws IOException, PersistenceException, NoSuchObjectException {
        Object object;
        if (!mdView.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.VIEWNOTCONVERTED", new Object[]{mdView.getViewName(), mdView.getLanguage(), new ClickableLogInfo(mdView, Messages.getString("GenerateWorker.184"))});
            return;
        }
        int n = MigrationAddin.getMigrationConfig().getFileOutputOption();
        String string = this.getOutputDir();
        String string2 = ConvertUtils.getClobAsString(mdView.getNativeSql());
        if (string2 != null && string2.indexOf("MATERIALIZED VIEW") == -1) {
            object = this.getListForRecompile();
            object.add((String)(mdSchema.getName() + "." + mdView.getViewName()));
        }
        object = new GenerateEvent(1, MigrationAddinArb.getString("MD_VIEWS"), mdView.getViewName());
        this.getAudience().fireListeners((GenerateEvent)object);
        this.getOutputStream().startObject(mdView.getViewName(), "MD_VIEWS");
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
        stringTemplate.setAttribute("text", (Object)string2);
        String string3 = stringTemplate.toString();
        if (string3 != null && !(string3 = string3.trim()).endsWith(";")) {
            string3 = string3 + ";";
        }
        this.getOutputStream().println(string3);
        stringTemplate.reset();
        stringTemplate.setAttribute("text", (Object)"\n");
        this.getOutputStream().println(stringTemplate.toString());
        this.getOutputStream().endObject();
        ((MigrationEvent)object).setEventId(2);
        this.getAudience().fireListeners((GenerateEvent)object);
    }

    private List<String> getListForRecompile() {
        if (this.m_viewsListForRecompile == null) {
            this.m_viewsListForRecompile = new ArrayList();
        }
        return this.m_viewsListForRecompile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void generateUntranslatedStoredProcedures(MdSchema mdSchema) throws PersistenceException, GenerateException {
        CloseableIterator closeableIterator = null;
        try {
            closeableIterator = new UntranslatedStoredProgramsIterator(this.getPersistenceManager(), mdSchema.getKey(), this.m_filters);
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                try {
                    MdStoredProgram mdStoredProgram = (MdStoredProgram)closeableIterator.next();
                    this.generateIndividualStoredProcedure(mdStoredProgram);
                }
                catch (IOException iOException) {
                    throw new GenerateException(iOException);
                    return;
                }
            }
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    protected void generateIndividualStoredProcedure(MdStoredProgram mdStoredProgram) throws IOException {
        if (!mdStoredProgram.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.WARNING, "Generate.PROCNOTCONVERTED", new Object[]{mdStoredProgram.getName(), mdStoredProgram.getLanguage(), new ClickableLogInfo(mdStoredProgram, Messages.getString("GenerateWorker.190"))});
            return;
        }
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_STORED_PROGRAMS"), mdStoredProgram.getName());
        this.getAudience().fireListeners(generateEvent);
        this.getOutputStream().startObject(mdStoredProgram.getName(), "MD_STORED_PROGRAMS");
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("blindDump");
        stringTemplate.setAttribute("text", (Object)ConvertUtils.getClobAsString(mdStoredProgram.getNativeSql()));
        this.getOutputStream().println(stringTemplate.toString());
        stringTemplate.reset();
        stringTemplate.setAttribute("text", (Object)"/");
        this.getOutputStream().println(stringTemplate.toString());
        this.getOutputStream().endObject();
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
    }

    protected void generateAllTables(MdSchema mdSchema) throws PersistenceException, GenerateException {
        CloseableIterator closeableIterator = this.m_persistenceUtility.getTablesForSchemaId(mdSchema.getKey(), this.m_filters);
        try {
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdTable mdTable = (MdTable)closeableIterator.next();
                GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_TABLES"), mdTable.getTableName());
                this.fireEventListeners(generateEvent);
                this.getOutputStream().startObject(mdTable.getTableName(), "MD_TABLES");
                if (this.getDumpFlag()) {
                    this.setCurrentSchemaDumpDirectory(mdSchema.getName());
                }
                this.generateIndividualTable(mdTable);
                this.getOutputStream().endObject();
                generateEvent.setEventId(2);
                this.fireEventListeners(generateEvent);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GenerateException(fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new GenerateException(unsupportedEncodingException);
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
    }

    private boolean getDumpFlag() {
        return MigrationAddin.getMigrationConfig().getFileOutputOption() == 2;
    }

    private void setIOTTableConstraint(MdConstraint mdConstraint) {
        this.m_IOTTableConstraint = mdConstraint;
        if (mdConstraint != null) {
            this.setIOTIndex(null);
            this.setIOTPrimaryKey(null);
        }
    }

    private synchronized IOTMode getIOTMode() {
        if (this.cacheIOTMode == null) {
            int n = MigrationConfig.getInstance((PropertyStorage)Preferences.getPreferences()).getIOTOption();
            if (n == 0) {
                this.cacheIOTMode = IOTMode.NONE;
            } else if (n == 1) {
                this.cacheIOTMode = IOTMode.CLUSTERED_NO_PRIMARY;
            } else if (n == 2) {
                this.cacheIOTMode = IOTMode.PRIMARY;
            }
            MigrationPlugin migrationPlugin = null;
            try {
                migrationPlugin = MigrationUtils.getPluginForConnection(MdConnection.retrieveExistingInstance(this.getPersistenceManager(), this.m_connectionId));
            }
            catch (MigrationPluginException migrationPluginException) {
                migrationPlugin = null;
            }
            catch (NoSuchObjectException noSuchObjectException) {
                migrationPlugin = null;
            }
            catch (PersistenceException persistenceException) {
                MigrationLogUtil.logThrowable(persistenceException.getLocalizedMessage(), Messages.getString("GenerateWorker.39"), (Throwable)persistenceException);
                migrationPlugin = null;
            }
            if (migrationPlugin == null || !migrationPlugin.usesClobToBlob()) {
                this.cacheIOTMode = IOTMode.NONE;
            }
        }
        return this.cacheIOTMode;
    }

    private MdConstraint getIOTTableConstraint() {
        return this.m_IOTTableConstraint;
    }

    private MdConstraint getIOTPrimaryKey() {
        return this.m_IOTPrimaryKey;
    }

    private void setIOTPrimaryKey(MdConstraint mdConstraint) {
        this.m_IOTPrimaryKey = mdConstraint;
        if (mdConstraint != null) {
            this.setIOTTableConstraint(null);
            this.setIOTIndex(null);
        }
    }

    private void setIOTIndex(MdIndexe mdIndexe) {
        this.m_IOTIndex = mdIndexe;
        if (mdIndexe != null) {
            this.setIOTTableConstraint(null);
            this.setIOTPrimaryKey(null);
        }
    }

    private MdIndexe getIOTIndex() {
        return this.m_IOTIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean primaryKeyExists(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);
        try {
            while (closeableIterator.hasNext()) {
                MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
                if (mdConstraint.getConstraintType() == null || !mdConstraint.getConstraintType().equals("PK")) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            closeableIterator.close();
        }
        return false;
    }

    private boolean indexOrganizedTableColumnCheck(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = MigrationAddin.getMigrationConfig().getMigrate12c();
        this.setIOTTableConstraint(null);
        this.setIOTIndex(null);
        String string = mdTable.getProperty("IS_INDEX_ORGANIZED_TABLE");
        if (string != null && string.equals("Y")) {
            bl = true;
        } else {
            bl2 = true;
        }
        if (bl) {
            int n = 0;
            for (MdColumn mdColumn : arrayList) {
                if (mdColumn.getColumnType().toLowerCase().startsWith("varchar2") || mdColumn.getColumnType().toLowerCase().startsWith("char") || mdColumn.getColumnType().toLowerCase().startsWith("nvarchar") || mdColumn.getColumnType().toLowerCase().startsWith("nchar")) {
                    if (mdColumn.getPrecision() != null) {
                        n += mdColumn.getPrecision() / 100;
                    }
                    if (bl3 && (mdColumn.getPrecision() > 4000 || mdColumn.getColumnType().toLowerCase().startsWith("nchar") && mdColumn.getPrecision() > 1000 || mdColumn.getColumnType().toLowerCase().startsWith("nvarchar") && mdColumn.getPrecision() > 2000 || mdColumn.getColumnType().toLowerCase().startsWith("char") && mdColumn.getPrecision() > 2000)) {
                        bl2 = true;
                        break;
                    }
                }
                if (mdColumn.getColumnType().toLowerCase().equals("blob") || mdColumn.getColumnType().toLowerCase().equals("clob")) {
                    n += 40;
                }
                n += 10;
                if (bl3 && mdColumn.getColumnType().toLowerCase().startsWith("raw") && mdColumn.getPrecision() > 2000) {
                    bl2 = true;
                    break;
                }
                if (!mdColumn.getColumnType().toLowerCase().startsWith("long")) continue;
                bl2 = true;
                break;
            }
            if (n > 400) {
                bl2 = true;
            }
        }
        return !bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> indexOrganizedTableGetUniqueConstraintClustered(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<MdColumn> arrayList3 = new ArrayList<MdColumn>();
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);
        try {
            while (closeableIterator.hasNext()) {
                MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
                if (mdConstraint.getConstraintType() == null || !mdConstraint.getConstraintType().equals("UNIQUE")) continue;
                MdConstraint mdConstraint2 = mdConstraint;
                boolean bl = false;
                String string = mdConstraint.getProperty("IS_CLUSTERED_INDEX");
                if (string != null && string.equals("Y")) {
                    bl = true;
                }
                if (!bl) continue;
                CloseableIterator closeableIterator2 = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());
                try {
                    while (closeableIterator2.hasNext()) {
                        if (this.shouldCancel()) {
                            closeableIterator2.close();
                            break;
                        }
                        MdConstraintDetail mdConstraintDetail = (MdConstraintDetail)closeableIterator2.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(mdConstraintDetail.getColumnId())) continue;
                            arrayList3.add(mdColumn);
                            arrayList2.add(mdColumn.getColumnName());
                            break;
                        }
                        if (!this.validateColumnsForIOT(arrayList3, false)) {
                            arrayList3 = new ArrayList();
                            arrayList2 = new ArrayList();
                        }
                        if (arrayList3.size() == 0) continue;
                        this.setIOTTableConstraint(mdConstraint2);
                    }
                }
                finally {
                    closeableIterator2.close();
                }
                if (arrayList3.size() == 0) continue;
                break;
            }
        }
        finally {
            closeableIterator.close();
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> indexOrganizedTableGetPrimaryKeyClustered(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<MdColumn> arrayList3 = new ArrayList<MdColumn>();
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);
        try {
            boolean bl = false;
            while (closeableIterator.hasNext()) {
                Object object;
                Object object2;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    object2 = arrayList2;
                    return object2;
                }
                object2 = (MdConstraint)closeableIterator.next();
                boolean bl2 = false;
                if (((MdConstraint)object2).getConstraintType().equals("PK")) {
                    object = ((PersistableObject)object2).getProperty("IS_CLUSTERED_INDEX");
                    if (object == null || !((String)object).equals("Y")) break;
                    bl2 = true;
                }
                if (bl) {
                    break;
                }
                if (!((MdConstraint)object2).getConstraintType().equals("PK")) continue;
                object = this.m_persistenceUtility.getConstraintDetails(((PersistableObject)object2).getKey());
                try {
                    boolean bl3 = false;
                    block8: while (object.hasNext()) {
                        if (this.shouldCancel()) {
                            object.close();
                            break;
                        }
                        MdConstraintDetail mdConstraintDetail = (MdConstraintDetail)object.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(mdConstraintDetail.getColumnId())) continue;
                            arrayList2.add(mdColumn.getColumnName());
                            arrayList3.add(mdColumn);
                            continue block8;
                        }
                    }
                    if (!bl3) {
                        boolean bl4 = bl3 = !this.validateColumnsForIOT(arrayList3, true);
                    }
                    if (bl3) {
                        arrayList3 = new ArrayList();
                        arrayList2 = new ArrayList();
                        continue;
                    }
                    this.setIOTPrimaryKey((MdConstraint)object2);
                    bl = true;
                }
                finally {
                    object.close();
                }
            }
        }
        finally {
            closeableIterator.close();
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ArrayList<String> indexOrganizedTableGetUniqeIndexClustered(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<MdColumn> arrayList3 = new ArrayList<MdColumn>();
        boolean bl = false;
        CloseableIterator closeableIterator = this.m_persistenceUtility.getIndexesForTableId(mdTable.getKey(), this.m_filters);
        try {
            boolean bl2 = false;
            while (closeableIterator.hasNext()) {
                Object object;
                Object object2;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    object2 = arrayList2;
                    return object2;
                }
                object2 = (MdIndexe)closeableIterator.next();
                boolean bl3 = false;
                if (((MdIndexe)object2).getIndexType().equals("UNIQUE")) {
                    object = ((PersistableObject)object2).getProperty("IS_CLUSTERED_INDEX");
                    if (object == null || !((String)object).equals("Y")) continue;
                    bl3 = true;
                }
                if (bl2) {
                    break;
                }
                if (!((MdIndexe)object2).getIndexType().equals("UNIQUE")) continue;
                object = this.m_persistenceUtility.getIndexDetails(((PersistableObject)object2).getKey());
                try {
                    boolean bl4 = false;
                    block8: while (object.hasNext()) {
                        if (this.shouldCancel()) {
                            object.close();
                            break;
                        }
                        MdIndexDetail mdIndexDetail = (MdIndexDetail)object.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(mdIndexDetail.getColumnId())) continue;
                            arrayList2.add(mdColumn.getColumnName());
                            arrayList3.add(mdColumn);
                            continue block8;
                        }
                    }
                    if (!bl4) {
                        boolean bl5 = bl4 = !this.validateColumnsForIOT(arrayList3, false);
                    }
                    if (bl4) {
                        arrayList3 = new ArrayList();
                        arrayList2 = new ArrayList();
                        continue;
                    }
                    this.setIOTIndex((MdIndexe)object2);
                    bl2 = true;
                }
                finally {
                    object.close();
                }
            }
        }
        finally {
            closeableIterator.close();
        }
        return arrayList2;
    }

    boolean validateColumnsForIOT(ArrayList<MdColumn> arrayList, boolean bl) {
        boolean bl2 = true;
        for (MdColumn mdColumn : arrayList) {
            String string = mdColumn.getColumnType().toLowerCase();
            if ((bl || mdColumn.getNullable() == null || bl || !mdColumn.getNullable().equals("Y")) && !string.equals("clob") && !string.equals("blob") && !string.equals("nclob")) continue;
            bl2 = false;
        }
        if (arrayList.size() > 10) {
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualTable(MdTable mdTable) throws PersistenceException, FileNotFoundException, UnsupportedEncodingException {
        MdColumn mdColumn;
        boolean bl = true;
        String string = null;
        CloseableIterator closeableIterator = this.m_persistenceUtility.getColumnsForTableId(mdTable.getKey());
        ArrayList<MdColumn> arrayList = new ArrayList<MdColumn>();
        try {
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                mdColumn = (MdColumn)closeableIterator.next();
                arrayList.add(mdColumn);
            }
        }
        finally {
            closeableIterator.close();
        }
        mdColumn = null;
        mdColumn = this.getTemplateGroup().getInstanceOf("DropTable");
        String string2 = null;
        mdColumn = this.getTemplateGroup().getInstanceOf("DropTable");
        mdColumn.setAttribute("mdtable", mdTable);
        string2 = mdColumn.toString();
        if (this._genDropStmts) {
            string2 = string2.replaceFirst("-- ", "");
        }
        if (this.getDumpFlag()) {
            this.setOutputStream("TABLE_" + mdTable.getTableName() + ".sql");
        }
        this.getOutputStream().println(string2);
        this.getOutputStream().println("\n");
        this.setIOTTableConstraint(null);
        this.setIOTIndex(null);
        this.setIOTPrimaryKey(null);
        bl = this.getIOTMode() != IOTMode.NONE ? this.indexOrganizedTableColumnCheck(mdTable, arrayList) : false;
        ArrayList<Object> arrayList2 = new ArrayList();
        if (bl && this.getIOTMode() != IOTMode.NONE) {
            if (this.getIOTMode() == IOTMode.PRIMARY) {
                arrayList2 = this.indexOrganizedTableGetPrimaryKeyClustered(mdTable, arrayList);
            }
            if (this.getIOTMode() != IOTMode.PRIMARY && arrayList2.size() == 0 && !this.primaryKeyExists(mdTable, arrayList)) {
                if (arrayList2.size() == 0) {
                    arrayList2 = this.indexOrganizedTableGetUniqueConstraintClustered(mdTable, arrayList);
                }
                if (arrayList2.size() == 0) {
                    arrayList2 = this.indexOrganizedTableGetUniqeIndexClustered(mdTable, arrayList);
                }
            }
        }
        if (arrayList2.size() == 0) {
            mdColumn = this.getTemplateGroup().getInstanceOf("CreateTable");
            mdColumn.setAttribute("mdtable", mdTable);
            mdColumn.setAttribute("colList", arrayList);
            mdColumn.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
            this.setIOTTableConstraint(null);
            this.setIOTIndex(null);
            this.setIOTPrimaryKey(null);
        } else {
            string = this.getIOTPrimaryKey() != null ? this.getIOTPrimaryKey().getName() : (this.getIOTTableConstraint() != null ? this.getIOTTableConstraint().getName() : this.getIOTIndex().getIndexName());
            mdColumn = this.getTemplateGroup().getInstanceOf("CreateTableIndexOrganizedTable");
            mdColumn.setAttribute("mdtable", mdTable);
            mdColumn.setAttribute("colList", arrayList);
            mdColumn.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
            mdColumn.setAttribute("constraint_name", string);
            mdColumn.setAttribute("collist_pk", arrayList2);
        }
        string2 = mdColumn.toString();
        this.getOutputStream().println(string2);
        this.wasClustered(string, null, true);
        this.getOutputStream().println("");
        if (mdTable.getComments() != null && mdTable.getComments().length() > 0) {
            mdColumn = this.getTemplateGroup().getInstanceOf("TableComment");
            mdColumn.setAttribute("tableName", mdTable.getTableName());
            mdColumn.setAttribute("comment", this.removeSingleQuotes(mdTable.getComments()));
            string2 = mdColumn.toString();
            this.getOutputStream().println(string2);
            this.getOutputStream().println("");
        }
        mdTable.setNativeSql(string2);
        mdTable.save(this.getPersistenceManager());
        if (!this.m_tablesOnly) {
            this.generateColumnComments(mdTable, arrayList);
            this.generateTableConstraints(mdTable, arrayList);
            this.generateIndexes(mdTable, arrayList);
            mdColumn.reset();
            if (this.m_dependencies.containsKey(mdTable.getKey().getId())) {
                this.generateObjectGrants(mdTable);
            }
            this.getOutputStream().println("");
            if (MigrationAddin.getMigrationConfig().getGenerateDataMoveUserFlag() && this.m_numSchema > 1 && this.m_dataMoveUser != null) {
                mdColumn = this.getTemplateGroup().getInstanceOf("GrantDataMoveUser");
                mdColumn.setAttribute("objtogrant", mdTable.getTableName());
                mdColumn.setAttribute("usertograntto", this.m_dataMoveUser);
                string2 = mdColumn.toString();
                this.getOutputStream().println(string2);
                this.getOutputStream().println("");
            }
        }
    }

    private void generateObjectGrants(PersistableObject persistableObject) {
        DBObjectId dBObjectId = persistableObject.getKey();
        String string = this.m_dependencies.get(dBObjectId.getId());
        this.getOutputStream().println(string + "\n");
    }

    private void setOutputStream(String string) throws FileNotFoundException, UnsupportedEncodingException {
        this.setOutputStream(this.m_SchemaDumpHashTable.get(this.m_currentSchemaDumpDir), string);
        if (this.getDumpFlag()) {
            this.m_masterDumpStream.println("@@" + this.m_currentSchemaDumpDir + "/" + string);
        }
    }

    private void generateColumnComments(MdTable mdTable, ArrayList<MdColumn> arrayList) {
        for (MdColumn mdColumn : arrayList) {
            String string = mdColumn.getComments();
            if (string == null || string.length() <= 0) continue;
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("ColumnComment");
            stringTemplate.setAttribute("tableName", (Object)mdTable.getTableName());
            stringTemplate.setAttribute("columnName", (Object)mdColumn.getObjectName());
            stringTemplate.setAttribute("comment", (Object)this.removeSingleQuotes(string));
            String string2 = stringTemplate.toString();
            this.getOutputStream().println(string2);
            this.getOutputStream().println("");
        }
    }

    private String removeSingleQuotes(String string) {
        if (string.indexOf("'") == -1) {
            return string;
        }
        return string.replace("'", "''");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateTableConstraints(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintsForTableId(mdTable.getKey(), this.m_filters);
        try {
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdConstraint mdConstraint = (MdConstraint)closeableIterator.next();
                if (mdConstraint.getConstraintType() != null) {
                    if (mdConstraint.getConstraintType().equals("PK")) {
                        this.generateIndividualPrimaryKeyConstraint(mdTable, mdConstraint, arrayList);
                        continue;
                    }
                    if (!mdConstraint.getConstraintType().equals("CHECK") && !mdConstraint.getConstraintType().equals("UNIQUE")) continue;
                    this.generateIndividualConstraint(mdConstraint, mdTable, false);
                    continue;
                }
                s_log.log(Level.WARNING, "Generate.NOCONSTRAINTTYPE", new Object[]{Messages.getString("GenerateWorker.221"), mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.222"))});
            }
        }
        finally {
            closeableIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualPrimaryKeyConstraint(MdTable mdTable, MdConstraint mdConstraint, ArrayList<MdColumn> arrayList) throws PersistenceException {
        StringTemplate stringTemplate;
        if (this.getIOTPrimaryKey() != null && this.getIOTPrimaryKey().getKey().equals(mdConstraint.getKey())) {
            String string = mdConstraint.getProperty("DO_NOT_ENABLE_DISABLE");
            if (string == null) {
                mdConstraint.addProperty("DO_NOT_ENABLE_DISABLE", "Y", this.getConnectionId());
                mdConstraint.save(this.getPersistenceManager());
            }
            return;
        }
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());
        ArrayList<MdColumn> arrayList2 = new ArrayList<MdColumn>();
        try {
            stringTemplate = this.getTemplateGroup().getInstanceOf("CreatePrimaryKey");
            stringTemplate.setAttribute("mdtable", (Object)mdTable);
            stringTemplate.setAttribute("mdconstraint", (Object)mdConstraint);
            block3: while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    break;
                }
                MdConstraintDetail mdConstraintDetail = (MdConstraintDetail)closeableIterator.next();
                for (MdColumn mdColumn : arrayList) {
                    if (!mdColumn.getKey().equals(mdConstraintDetail.getColumnId())) continue;
                    arrayList2.add(mdColumn);
                    continue block3;
                }
            }
        }
        finally {
            closeableIterator.close();
        }
        stringTemplate.setAttribute("collist", arrayList2);
        String string = stringTemplate.toString();
        this.getOutputStream().println(string);
        this.wasClustered(mdConstraint.getName(), mdConstraint.getProperty("IS_CLUSTERED_INDEX"), false);
        mdConstraint.setConstraintText(string);
        mdConstraint.save(this.getPersistenceManager());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndexes(MdTable mdTable, ArrayList<MdColumn> arrayList) throws PersistenceException {
        CloseableIterator closeableIterator = this.m_persistenceUtility.getIndexesForTableId(mdTable.getKey(), this.m_filters);
        try {
            while (closeableIterator.hasNext()) {
                StringTemplate stringTemplate;
                Object object;
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    return;
                }
                MdIndexe mdIndexe = (MdIndexe)closeableIterator.next();
                if (this.getIOTIndex() != null && this.getIOTIndex().getKey().equals(mdIndexe.getKey())) {
                    object = mdIndexe.getProperty("DO_NOT_ENABLE_DISABLE");
                    if (object != null) continue;
                    mdIndexe.addProperty("DO_NOT_ENABLE_DISABLE", "Y", this.getConnectionId());
                    mdIndexe.save(this.getPersistenceManager());
                    continue;
                }
                object = this.m_persistenceUtility.getIndexDetails(mdIndexe.getKey());
                ArrayList<String> arrayList2 = new ArrayList<String>();
                try {
                    stringTemplate = mdIndexe.getIndexType().equals("UNIQUE") ? this.getTemplateGroup().getInstanceOf("CreateUniqueIndex") : this.getTemplateGroup().getInstanceOf("CreateIndex");
                    stringTemplate.setAttribute("mdtable", (Object)mdTable);
                    stringTemplate.setAttribute("mdindex", (Object)mdIndexe);
                    stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
                    stringTemplate.setAttribute("extindextype", (Object)mdIndexe.getProperty("EXTENDEDINDEXTYPE"));
                    block8: while (object.hasNext()) {
                        if (this.shouldCancel()) {
                            object.close();
                            break;
                        }
                        MdIndexDetail mdIndexDetail = (MdIndexDetail)object.next();
                        for (MdColumn mdColumn : arrayList) {
                            if (!mdColumn.getKey().equals(mdIndexDetail.getColumnId())) continue;
                            String string = mdIndexDetail.getProperty("IS_INDEXDETAIL_DESCENDING");
                            if (string != null && string.equals("Y")) {
                                arrayList2.add(mdColumn.getColumnName() + " DESC");
                                continue block8;
                            }
                            arrayList2.add(mdColumn.getColumnName());
                            continue block8;
                        }
                    }
                }
                finally {
                    object.close();
                }
                stringTemplate.setAttribute("collist", arrayList2);
                String string = stringTemplate.toString();
                this.getOutputStream().println(string);
                this.wasClustered(mdIndexe.getIndexName(), mdIndexe.getProperty("IS_CLUSTERED_INDEX"), false);
                mdIndexe.setNativeSql(string);
                mdIndexe.save(this.getPersistenceManager());
            }
        }
        finally {
            closeableIterator.close();
        }
    }

    protected void generateIndividualConstraint(MdConstraint mdConstraint, MdTable mdTable, boolean bl) {
        String string = null;
        try {
            if (mdConstraint.getConstraintType().equals("FOREIGN KEY")) {
                this.generateIndividualForeignKeyConstraint(mdTable, mdConstraint);
            } else if (mdConstraint.getConstraintType().equals("CHECK")) {
                this.generateCheckConstraint(mdTable, mdConstraint, bl);
            } else if (mdConstraint.getConstraintType().equals("UNIQUE")) {
                this.generateUniqueConstraint(mdTable, mdConstraint);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            string = noSuchObjectException.getLocalizedMessage();
        }
        catch (PersistenceException persistenceException) {
            string = persistenceException.getLocalizedMessage();
        }
        if (string != null) {
            s_log.log(Level.SEVERE, "Generate.GENERATECONSTRAINTFAILED", new Object[]{string, mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.235"))});
        }
    }

    protected void generateIndividualConstraint(MdConstraint mdConstraint) throws PersistenceException, NoSuchObjectException, GenerateException {
        MdTable mdTable = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getTableId());
        this.generateIndividualConstraint(mdConstraint, mdTable, false);
    }

    protected void generateCheckConstraint(MdTable mdTable, MdConstraint mdConstraint, boolean bl) throws PersistenceException {
        if (!mdConstraint.getLanguage().equals("OracleSQL") && !MigrationAddin.getMigrationConfig().getGenerateFailedObjects()) {
            s_log.log(Level.WARNING, "Generate.CONSTRAINTNOTCONVERTED", new Object[]{mdConstraint.getName(), mdConstraint.getLanguage(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.237"))});
            return;
        }
        String string = MigrationUtils.findCheckConstraintCondition(mdConstraint, this.getPersistenceManager());
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("CreateCheckConstraint");
        stringTemplate.setAttribute("mdconstraint", (Object)mdConstraint);
        stringTemplate.setAttribute("mdtable", (Object)mdTable);
        stringTemplate.setAttribute("condition", (Object)string);
        GenerateEvent generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_CONSTRAINTS"), mdConstraint.getName());
        this.getAudience().fireListeners(generateEvent);
        if (bl) {
            this.getOutputStream().startObject(mdConstraint.getName(), "MD_CONSTRAINTS");
        }
        String string2 = stringTemplate.toString();
        string2 = string2.replaceAll("\n", "\r\n");
        this.getOutputStream().println(string2);
        if (bl) {
            this.getOutputStream().endObject();
        }
        generateEvent.setEventId(2);
        this.getAudience().fireListeners(generateEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateIndividualForeignKeyConstraint(MdTable mdTable, MdConstraint mdConstraint) throws PersistenceException, NoSuchObjectException {
        ArrayList<MdColumn> arrayList = new ArrayList<MdColumn>();
        ArrayList<MdColumn> arrayList2 = new ArrayList<MdColumn>();
        MdTable mdTable2 = MdTable.retrieveExistingInstance(this.getPersistenceManager(), mdConstraint.getReftableId());
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());
        try {
            Object object;
            MdConstraintDetail mdConstraintDetail;
            GenerateEvent generateEvent;
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    break;
                }
                mdConstraintDetail = (MdConstraintDetail)closeableIterator.next();
                object = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), mdConstraintDetail.getColumnId());
                if (mdConstraintDetail.getRefFlag().equals("N")) {
                    arrayList.add((MdColumn)object);
                    continue;
                }
                arrayList2.add((MdColumn)object);
            }
            mdConstraintDetail = null;
            if (mdConstraint.getDeleteClause() != null) {
                mdConstraintDetail = this.getTemplateGroup().getInstanceOf("CreateForeignKeyWithDeleteClause");
                mdConstraintDetail.setAttribute("delClause", mdConstraint.getDeleteClause());
            } else {
                mdConstraintDetail = this.getTemplateGroup().getInstanceOf("CreateForeignKey");
            }
            mdConstraintDetail.setAttribute("mdconstraint", mdConstraint);
            mdConstraintDetail.setAttribute("mdtable", mdTable);
            if (mdTable.getSchemaId().equals(mdTable2.getSchemaId())) {
                mdConstraintDetail.setAttribute("reftablename", mdTable2.getTableName());
            } else {
                object = this.findParentSchema(mdTable2);
                if (object != null) {
                    String string = ((MdSchema)object).getName() + "." + mdTable2.getTableName();
                    mdConstraintDetail.setAttribute("reftablename", string);
                } else {
                    s_log.log(Level.FINE, "Generate.CANTLOCATEREFSCHEMA", new Object[]{"CAN NOT FIND SCHEMA", mdConstraint.getName(), new ClickableLogInfo(mdConstraint, Messages.getString("GenerateWorker.252"))});
                    return;
                }
            }
            mdConstraintDetail.setAttribute("collist", arrayList);
            mdConstraintDetail.setAttribute("refcols", arrayList2);
            generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_CONSTRAINTS"), mdConstraint.getName());
            this.getAudience().fireListeners(generateEvent);
            this.getOutputStream().startObject(mdConstraint.getName(), "MD_CONSTRAINTS");
            object = mdConstraintDetail.toString();
            this.getOutputStream().println((String)object);
            this.getOutputStream().endObject();
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
            mdConstraint.setConstraintText((String)object);
            mdConstraint.save(this.getPersistenceManager());
        }
        finally {
            closeableIterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateUniqueConstraint(MdTable mdTable, MdConstraint mdConstraint) throws PersistenceException, NoSuchObjectException {
        ArrayList<MdColumn> arrayList = new ArrayList<MdColumn>();
        if (this.getIOTTableConstraint() != null && this.getIOTTableConstraint().getKey().equals(mdConstraint.getKey())) {
            String string = mdConstraint.getProperty("DO_NOT_ENABLE_DISABLE");
            if (string == null) {
                mdConstraint.addProperty("DO_NOT_ENABLE_DISABLE", "Y", this.getConnectionId());
                mdConstraint.save(this.getPersistenceManager());
            }
            return;
        }
        CloseableIterator closeableIterator = this.m_persistenceUtility.getConstraintDetails(mdConstraint.getKey());
        try {
            Object object;
            Object object2;
            GenerateEvent generateEvent;
            while (closeableIterator.hasNext()) {
                if (this.shouldCancel()) {
                    closeableIterator.close();
                    generateEvent = new GenerateEvent(3, null, null);
                    this.fireEventListeners(generateEvent);
                    break;
                }
                object2 = (MdConstraintDetail)closeableIterator.next();
                object = MdColumn.retrieveExistingInstance(this.getPersistenceManager(), ((MdConstraintDetail)object2).getColumnId());
                arrayList.add((MdColumn)object);
            }
            object2 = this.getTemplateGroup().getInstanceOf("CreateUniqueConstraint");
            object2.setAttribute("mdconstraint", (Object)mdConstraint);
            object2.setAttribute("mdtable", (Object)mdTable);
            object2.setAttribute("collist", arrayList);
            generateEvent = new GenerateEvent(1, MigrationAddinArb.getString("MD_CONSTRAINTS"), mdConstraint.getName());
            this.getAudience().fireListeners(generateEvent);
            this.getOutputStream().startObject(mdConstraint.getName(), "MD_CONSTRAINTS");
            object = object2.toString();
            this.getOutputStream().println((String)object);
            this.wasClustered(mdConstraint.getName(), mdConstraint.getProperty("IS_CLUSTERED_INDEX"), false);
            this.getOutputStream().endObject();
            generateEvent.setEventId(2);
            this.getAudience().fireListeners(generateEvent);
            mdConstraint.setConstraintText((String)object);
            mdConstraint.save(this.getPersistenceManager());
        }
        finally {
            closeableIterator.close();
        }
    }

    private String wasClustered(String string, String string2, boolean bl) {
        if (string == null || string.equals("")) {
            return "";
        }
        String string3 = "";
        if (bl || string2 != null) {
            StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("Comment");
            stringTemplate.setAttribute("txt", (Object)(string + " was clustered"));
            stringTemplate.setAttribute("genoptions", (Object)MigrationAddin.getMigrationConfig());
            string3 = stringTemplate.toString();
            this.getOutputStream().println(string3);
            stringTemplate.reset();
        }
        return string3;
    }

    protected DBObjectId getConnectionId() {
        return this.m_connectionId;
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        this.m_connectionId = dBObjectId;
    }

    protected PersistenceManager getPersistenceManager() {
        return this.m_persistenceManager;
    }

    protected void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    protected GenerationOutputStream getOutputStream() {
        return this.m_outputStream;
    }

    protected void setOutputStream(GenerationOutputStream generationOutputStream) {
        this.m_outputStream = generationOutputStream;
    }

    protected StringTemplateGroup getTemplateGroup() {
        return this.m_templateGroup;
    }

    protected void setTemplateGroup(StringTemplateGroup stringTemplateGroup) {
        this.m_templateGroup = stringTemplateGroup;
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    protected GenerateAudience getAudience() {
        return this.m_audience;
    }

    protected void setAudience(GenerateAudience generateAudience) {
        this.m_audience = generateAudience;
    }

    public void addEventListener(GenerateEventListener generateEventListener) {
        this.getAudience().addListener(generateEventListener);
    }

    @Override
    public void signalCancel() {
        this.m_shouldCancel = true;
    }

    protected boolean shouldCancel() {
        return this.m_shouldCancel;
    }

    private void fireEventListeners(GenerateEvent generateEvent) {
        this.getAudience().fireListeners(generateEvent);
    }

    public String getTemplateName() {
        return this.m_templateName;
    }

    public void setTemplateName(String string) {
        this.m_templateName = string;
        this.setTemplateGroup(StringTemplateGroup.loadGroup((String)string));
    }

    protected void setFilters(MigrationObjectFilterList migrationObjectFilterList) {
        this.m_filters = migrationObjectFilterList;
    }

    public void setOutputDir(String string) {
        this.m_outputDir = string;
    }

    public String getOutputDir() {
        return this.m_outputDir;
    }

    private static enum IOTMode {
        NONE,
        CLUSTERED_NO_PRIMARY,
        PRIMARY;

    }
}

