/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.estimation;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.migration.estimation.EstimationPlanResultFormatter;
import oracle.dbtools.migration.estimation.MigrationEstimationAction;
import oracle.dbtools.raptor.format.ResultsFormatterWrapper;
import oracle.dbtools.raptor.format.SQLFormatterWrapper;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.util.Resource;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.net.URLFileSystem;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;

public class RSTableMigrationEstimateXLS {
    private static RSTableMigrationEstimateXLS m_instance = null;

    private RSTableMigrationEstimateXLS() {
    }

    public static RSTableMigrationEstimateXLS getInstance() {
        if (m_instance == null) {
            m_instance = new RSTableMigrationEstimateXLS();
        }
        return m_instance;
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createEstimationPlan(Component component, String string, File file, Map<String, Object> map) {
        if (file == null) {
            file = this.chooseXLSFile(component);
        }
        if (file != null) {
            InputStream inputStream = null;
            try {
                Map<String, Object> map2 = this.getBinds(map);
                inputStream = this.getTemplateInputStream(string, map2);
                HSSFWorkbook hSSFWorkbook = new HSSFWorkbook(inputStream);
                this.exportToXLS("TableBreakdown", string, map2, file, hSSFWorkbook, "SQLDevTables");
                this.exportToXLS("ObjectsConverted", string, map2, file, hSSFWorkbook, "SQLDevConvStatus");
                this.exportToXLS("ProcedureBreakdown", string, map2, file, hSSFWorkbook, "SQLDevProcedures");
                this.exportToXLS("ViewsBreakdown", string, map2, file, hSSFWorkbook, "SQLDevViews");
                this.exportToXLS("TriggersBreakdown", string, map2, file, hSSFWorkbook, "SQLDevTriggers");
                this.exportToXLS("ApplicationBreakdown", string, map2, file, hSSFWorkbook, "SQLDevApplication");
                this.exportToXLS("ApplicationPatternBreakdown", string, map2, file, hSSFWorkbook, "SQLDevPatternApplication");
                FileInputStream fileInputStream = new FileInputStream(file);
                HSSFWorkbook hSSFWorkbook2 = new HSSFWorkbook((InputStream)fileInputStream);
                FormulaEvaluator formulaEvaluator = hSSFWorkbook2.getCreationHelper().createFormulaEvaluator();
                for (int i = 0; i < hSSFWorkbook2.getNumberOfSheets(); ++i) {
                    HSSFSheet hSSFSheet = hSSFWorkbook2.getSheetAt(i);
                    for (Row row : hSSFSheet) {
                        for (Cell cell : row) {
                            if (cell.getCellType() != 2) continue;
                            formulaEvaluator.evaluateFormulaCell(cell);
                        }
                    }
                }
                this.writeWorkbook(file, hSSFWorkbook2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return file;
    }

    private Map<String, Object> getBinds(Map<String, Object> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("IDPROJECT", null);
        hashMap.put("IDCAPCONNECTION", null);
        hashMap.put("IDCAPCATALOG", null);
        hashMap.put("IDCAPSCHEMA", null);
        hashMap.put("IDCONCONNECTION", null);
        hashMap.put("IDCONCATALOG", null);
        hashMap.put("IDCONSCHEMA", null);
        hashMap.put("CAPPROJECTID", null);
        hashMap.put("CAPCONNID", null);
        hashMap.put("CAPCATALOGID", null);
        hashMap.put("CAPSCHEMAID", null);
        hashMap.put("CONPROJECTID", null);
        hashMap.put("CONCONNID", null);
        hashMap.put("CONCATALOGID", null);
        hashMap.put("CONSCHEMAID", null);
        hashMap.put("SQLDEVPREF_TARGETCONN", "super_oracle");
        for (String string : map.keySet()) {
            hashMap.put(string, map.get(string));
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportToXLS(String string, String string2, Map<String, Object> map, File file, HSSFWorkbook hSSFWorkbook, String string3) {
        SQLFormatterWrapper sQLFormatterWrapper = null;
        try {
            String string4 = MigrationEstimationAction.getChildQuery(MigrationEstimationAction.getXMLDoc(), string);
            sQLFormatterWrapper = new SQLFormatterWrapper(string2, string4, map);
            this.exportTable(file, sQLFormatterWrapper, string3, hSSFWorkbook, string2);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            sQLFormatterWrapper.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasResult(String string, String string2, Map<String, Object> map) {
        String string3 = MigrationEstimationAction.getChildQuery(MigrationEstimationAction.getXMLDoc(), string);
        ResultSetWrapper resultSetWrapper = null;
        ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
        if (connectionResolver.lock(string2)) {
            try {
                resultSetWrapper = map == null ? DBUtil.getInstance((String)string2).executeQuery(string3, (List)null) : DBUtil.getInstance((String)string2).executeQuery(string3, map);
                if (resultSetWrapper.getResultSet().next()) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (Exception exception) {
            }
            finally {
                resultSetWrapper.close();
                resultSetWrapper = null;
                connectionResolver.unlock(string2);
            }
        }
        return false;
    }

    private InputStream getTemplateInputStream(String string, Map<String, Object> map) {
        URL[] uRLArray = Resource.getPath((String)"oracle/dbtools/migration/estimation");
        URL uRL = uRLArray[0];
        String string2 = null;
        string2 = this.hasResult("ApplicationBreakdown", string, map) ? "jar:" + uRL.getPath() + "DBMigrationAssessmentAll.xls" : "jar:" + uRL.getPath() + "DBMigrationAssessmentDB.xls";
        URL uRL2 = null;
        InputStream inputStream = null;
        try {
            uRL2 = new URL(string2);
            inputStream = URLFileSystem.openInputStream((URL)uRL2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    public void exportTable(File file, SQLFormatterWrapper sQLFormatterWrapper, String string, HSSFWorkbook hSSFWorkbook, String string2) throws FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(bufferedOutputStream);
        EstimationPlanResultFormatter estimationPlanResultFormatter = new EstimationPlanResultFormatter(string, hSSFWorkbook);
        estimationPlanResultFormatter.setDataProvider((ResultsFormatterWrapper)sQLFormatterWrapper);
        estimationPlanResultFormatter.setOutputStream(bufferedOutputStream);
        estimationPlanResultFormatter.setOutWriter(outputStreamWriter);
        try {
            estimationPlanResultFormatter.print();
            bufferedOutputStream.close();
            outputStreamWriter.close();
            fileOutputStream.close();
            fileOutputStream = null;
            bufferedOutputStream = null;
            outputStreamWriter = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void writeWorkbook(File file, HSSFWorkbook hSSFWorkbook) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            hSSFWorkbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
            fileOutputStream = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private File chooseXLSFile(Component component) {
        URLFileChooser uRLFileChooser = new URLFileChooser();
        File file = new File(Ide.getTrueUserHomeDirectory());
        File file2 = new File(file.getAbsolutePath() + File.separator + "MigrationAnalysis.xls");
        uRLFileChooser.setSelectedFile(file2);
        int n = uRLFileChooser.showSaveDialog(component);
        if (n == 1) {
            return null;
        }
        File file3 = uRLFileChooser.getSelectedFile();
        return file3;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return false;
    }
}

