/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.migration.datamove.offline.OfflineDatamoveOutputStream;
import oracle.dbtools.migration.datamove.online.Messages;
import oracle.dbtools.migration.datamove.online.TriggerHandler;

public class OfflineTriggerHandler
extends TriggerHandler {
    private static final String GET_TRIGGERS_QUERY = "SELECT TRIGGER_NAME, SCHEMA_NAME FROM MGV_ALL_TABLE_TRIGGERS WHERE CONNECTION_ID = ? AND CATALOG_NAME = ? AND SCHEMA_NAME = ?";

    public OfflineTriggerHandler(DBObjectId dBObjectId, PersistenceManager persistenceManager) {
        super(dBObjectId, persistenceManager);
    }

    public void disableTriggers(OfflineDatamoveOutputStream offlineDatamoveOutputStream, String string, String string2, boolean bl) {
        this.disableTriggers(offlineDatamoveOutputStream, null, string, string2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableTriggers(OfflineDatamoveOutputStream offlineDatamoveOutputStream, Connection connection, String string, String string2, boolean bl) {
        if (offlineDatamoveOutputStream == null && connection == null) {
            throw new IllegalArgumentException(Messages.getString("TriggerHandler.1"));
        }
        if (offlineDatamoveOutputStream != null && connection != null) {
            throw new IllegalArgumentException(Messages.getString("TriggerHandler.2"));
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = this.m_persistenceManager.getPreparedStatement(GET_TRIGGERS_QUERY);
            preparedStatement.setLong(1, this.m_connectionId.getId());
            preparedStatement.setString(2, string);
            preparedStatement.setString(3, string2);
            resultSet = preparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            s_log.warning(sQLException.getLocalizedMessage());
            CloseableResultSet.close(null, resultSet);
            return;
        }
        try {
            try {
                if (resultSet != null) {
                    while (resultSet.next()) {
                        boolean bl2;
                        TriggerHandler.TriggerInformation triggerInformation = new TriggerHandler.TriggerInformation(resultSet);
                        if (connection != null) {
                            bl2 = this.issueTriggerStmt(connection, triggerInformation.getDisableStatment(bl));
                        } else {
                            offlineDatamoveOutputStream.println(triggerInformation.getDisableStatment(bl) + ";");
                            bl2 = true;
                        }
                        if (!bl2) continue;
                        this.m_disabledTriggers.add(triggerInformation);
                    }
                }
                resultSet.close();
            }
            catch (SQLException sQLException) {
                s_log.warning(sQLException.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            CloseableResultSet.close(null, resultSet);
            throw throwable;
        }
        CloseableResultSet.close(null, resultSet);
    }
}

