/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.File;
import java.util.ArrayList;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderPrintStream;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.preferences.MaskUtil;
import org.antlr.stringtemplate.CommonGroupLoader;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.StringTemplateGroupLoader;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class OfflineSQLLoaderGenerator {
    private StringTemplateGroup templateGroup;

    public boolean generateCtl(String string, String string2, MdColumn[] mdColumnArray, MdColumn[] mdColumnArray2, String string3, OfflineSQLLoaderPrintStream offlineSQLLoaderPrintStream, MigrationPlugin migrationPlugin) {
        String[] stringArray;
        StringTemplate stringTemplate = migrationPlugin.getLoadCtlStatementTemplate();
        if (stringTemplate == null) {
            stringArray = this.getTemplateGroup();
            stringTemplate = stringArray.getInstanceOf("LoadCtlStatement");
        }
        try {
            stringTemplate.setAttribute("infile", (Object)string3);
            stringTemplate.setAttribute("rowDelimiter", (Object)migrationPlugin.getDataMoveRowDelimiter());
            stringTemplate.setAttribute("table", (Object)string2);
            stringTemplate.setAttribute("fieldTerminator", (Object)migrationPlugin.getDataMoveColumnDelimiter());
            stringArray = new String[mdColumnArray2.length];
            for (int i = 0; i < mdColumnArray2.length; ++i) {
                stringArray[i] = this.formatCol(mdColumnArray[i], mdColumnArray2[i], migrationPlugin);
            }
            stringTemplate.setAttribute("colList", (Object)stringArray);
            String string4 = offlineSQLLoaderPrintStream.getWriteDir();
            offlineSQLLoaderPrintStream.setWriteDir(string4 + File.separator + "control");
            offlineSQLLoaderPrintStream.setWriteDir(string4);
            offlineSQLLoaderPrintStream.startTable(string2);
            offlineSQLLoaderPrintStream.println(stringTemplate.toString());
            offlineSQLLoaderPrintStream.endTable();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private StringTemplateGroup getTemplateGroup() {
        if (this.templateGroup == null) {
            this.templateGroup = OfflineSQLLoaderGenerator.loadTemplates("oracle/dbtools/migration/datamove/offline/templates");
        }
        return this.templateGroup;
    }

    private static StringTemplateGroup loadTemplates(String string) {
        CommonGroupLoader commonGroupLoader = new CommonGroupLoader(string, null);
        StringTemplateGroup.registerGroupLoader((StringTemplateGroupLoader)commonGroupLoader);
        StringTemplateGroup.registerDefaultLexer(AngleBracketTemplateLexer.class);
        return StringTemplateGroup.loadGroup((String)"offlineCommands");
    }

    private String formatCol(MdColumn mdColumn, MdColumn mdColumn2, MigrationPlugin migrationPlugin) {
        String string = migrationPlugin.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2);
        String[] stringArray = MaskUtil.getMatchingRow(mdColumn.getColumnType());
        String string2 = null;
        string2 = stringArray != null ? "\"" + stringArray[0] + "(:" + mdColumn2.getColumnName() + ", '" + stringArray[1] + "')\"" : migrationPlugin.formatSQLLoaderColumn(mdColumn, mdColumn2);
        if (migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob() && mdColumn2.getColumnType().toUpperCase().equals("BLOB")) {
            string = "SQLDEVELOPER_CLOB_" + mdColumn2.getColumnOrder();
        }
        return string + " " + string2;
    }

    public boolean generateScriptCtl(ArrayList<String> arrayList, OfflineSQLLoaderPrintStream offlineSQLLoaderPrintStream, boolean bl) {
        try {
            this.setNLSHeader(offlineSQLLoaderPrintStream, bl);
            if (bl) {
                for (String string : arrayList) {
                    offlineSQLLoaderPrintStream.println("sqlldr %1/%2 control=control\\" + string + ".ctl " + "log=log\\" + string + ".log");
                }
            } else {
                for (String string : arrayList) {
                    offlineSQLLoaderPrintStream.println("sqlldr $1/$2 control=control/" + string + ".ctl " + "log=log/" + string + ".log");
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("chkCommandLineArg");
        stringTemplate.setAttribute("platformWindows", (Object)bl);
        offlineSQLLoaderPrintStream.println(stringTemplate.toString());
        return true;
    }

    private void setNLSHeader(OfflineSQLLoaderPrintStream offlineSQLLoaderPrintStream, boolean bl) {
        StringTemplate stringTemplate = this.getTemplateGroup().getInstanceOf("OracleHeader");
        stringTemplate.setAttribute("platformWindows", (Object)bl);
        offlineSQLLoaderPrintStream.println(stringTemplate.toString());
    }
}

