/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.util.MigrationUtils;
import oracle.dbtools.migration.datamove.DataMoveDescriptor;
import oracle.dbtools.migration.datamove.DataMoveException;
import oracle.dbtools.migration.datamove.DataMoveMarshal;
import oracle.dbtools.migration.datamove.DataMoveUtils;
import oracle.dbtools.migration.datamove.offline.ClobToBlobHandler;
import oracle.dbtools.migration.datamove.offline.Messages;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineConstraintHandler;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderGenerator;
import oracle.dbtools.migration.datamove.offline.OfflineSQLLoaderPrintStream;
import oracle.dbtools.migration.datamove.offline.OfflineTriggerHandler;
import oracle.dbtools.migration.datamove.online.ConstraintHandler;
import oracle.dbtools.migration.datamove.online.DataMoveAudience;
import oracle.dbtools.migration.datamove.online.DataMoveEvent;
import oracle.dbtools.migration.datamove.online.DataMoveListener;
import oracle.dbtools.migration.datamove.online.IdentityHandler;
import oracle.dbtools.migration.datamove.online.TriggerHandler;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.ide.Ide;
import oracle.ide.dialogs.MessageDialog;

public class OfflineDataMoveWorker
implements Cancelable,
DataMoveMarshal {
    private static Logger s_log = Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle");
    public static final String MY_ID = "OfflineDataMoveWorker";
    private CloseableIterator<MgvAllTablesRec> m_tables;
    private PersistenceManager m_persistenceManager;
    private PersistenceUtility m_persistenceUtility;
    private DBObjectId m_targetConnectionId;
    private DataMoveAudience m_audience;
    private MdConnection m_mdConnection;
    private Offline3rdPartyPrintStream thirdPartyPrintStream;
    private OfflineSQLLoaderPrintStream sqlloaderPrintStream;
    private boolean _truncate;

    public OfflineDataMoveWorker(PersistenceManager persistenceManager, MdConnection mdConnection, String string, Offline3rdPartyPrintStream offline3rdPartyPrintStream, OfflineSQLLoaderPrintStream offlineSQLLoaderPrintStream, boolean bl) throws DataMoveException {
        this.setPersistenceManager(persistenceManager);
        this.setPersistenceUtility(PersistenceUtility.getInstance(persistenceManager));
        this.setTargetConnectionId(mdConnection.getKey());
        this.setTargetConnection(mdConnection);
        this.sqlloaderPrintStream = offlineSQLLoaderPrintStream;
        this.thirdPartyPrintStream = offline3rdPartyPrintStream;
        this.m_audience = new DataMoveAudience();
        this._truncate = bl;
    }

    public OfflineDataMoveWorker(PersistenceManager persistenceManager, MdConnection mdConnection, String string, Offline3rdPartyPrintStream offline3rdPartyPrintStream, OfflineSQLLoaderPrintStream offlineSQLLoaderPrintStream) throws DataMoveException {
        this(persistenceManager, mdConnection, string, offline3rdPartyPrintStream, offlineSQLLoaderPrintStream, false);
    }

    private void setTargetConnection(MdConnection mdConnection) {
        this.m_mdConnection = mdConnection;
    }

    public void addListener(DataMoveListener dataMoveListener) {
        this.m_audience.addListener(dataMoveListener);
    }

    private void setTargetConnectionId(DBObjectId dBObjectId) {
        this.m_targetConnectionId = dBObjectId;
    }

    private void setPersistenceManager(PersistenceManager persistenceManager) {
        this.m_persistenceManager = persistenceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork() throws PersistenceException {
        MigrationPlugin migrationPlugin;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        MdSchema mdSchema = null;
        MdSchema mdSchema2 = null;
        MdCatalog mdCatalog = null;
        MdTable mdTable = null;
        boolean bl = false;
        PrintWriter printWriter = null;
        String string8 = null;
        MdColumn[] mdColumnArray = null;
        MdColumn[] mdColumnArray2 = null;
        String string9 = null;
        this.m_tables = this.getPersistenceUtility().getTablesForConnectionId(this.m_targetConnectionId);
        DataMoveDescriptor dataMoveDescriptor = null;
        DataMoveEvent dataMoveEvent = new DataMoveEvent(3, Messages.getString("OfflineDataMoveWorker.1"), Messages.getString("OfflineDataMoveWorker.2"));
        this.m_audience.fireListeners(dataMoveEvent);
        try {
            migrationPlugin = MigrationUtils.getPluginForConnection(this.m_mdConnection);
        }
        catch (MigrationPluginException migrationPluginException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)MigrationAddinArb.getString("MIGRATION_OFFLINE_DATA_NOPLUGIN_TEXT"), (String)MigrationAddinArb.getString("MIGRATION_OFFLINE_DATA_NOPLUGIN_TITLE"), (String)"f1_offlineDatamovePluginFound_html");
            return;
        }
        OfflineConstraintHandler offlineConstraintHandler = new OfflineConstraintHandler(this.m_mdConnection.getKey(), this.m_persistenceManager);
        OfflineTriggerHandler offlineTriggerHandler = new OfflineTriggerHandler(this.m_mdConnection.getKey(), this.m_persistenceManager);
        ClobToBlobHandler clobToBlobHandler = new ClobToBlobHandler(this.m_mdConnection.getKey(), this.m_persistenceManager);
        IdentityHandler identityHandler = new IdentityHandler(this.m_mdConnection.getKey(), this.m_persistenceManager);
        OfflineSQLLoaderGenerator offlineSQLLoaderGenerator = new OfflineSQLLoaderGenerator();
        do {
            try {
                String string10;
                String string11;
                if (dataMoveDescriptor == null) {
                    dataMoveDescriptor = this.getDescriptor();
                    string6 = this.sqlloaderPrintStream.getWriteDir();
                    string7 = this.thirdPartyPrintStream.getWriteDir();
                    string5 = string6;
                    string11 = string7;
                }
                if (dataMoveDescriptor == null) break;
                string8 = dataMoveDescriptor.getSourceTableName();
                mdColumnArray = dataMoveDescriptor.getSourceColumns();
                mdColumnArray2 = dataMoveDescriptor.getTargetColumns();
                Arrays.sort(mdColumnArray, new MdColumnComparator());
                Arrays.sort(mdColumnArray2, new MdColumnComparator());
                string9 = dataMoveDescriptor.getTargetTableName(true);
                mdTable = dataMoveDescriptor.getSourceTable();
                if (mdTable != null) {
                    mdSchema2 = MdSchema.retrieveExistingInstance(this.m_persistenceManager, mdTable.getSchemaId());
                    String string12 = string3 = mdSchema2 != null ? mdSchema2.getName() : null;
                }
                if (mdSchema2 != null) {
                    mdCatalog = MdCatalog.retrieveExistingInstance(this.m_persistenceManager, mdSchema2.getCatalogId());
                    string = mdCatalog != null ? mdCatalog.getCatalogName() : null;
                }
                string = this.processSourceName(string);
                string3 = this.processSourceName(string3);
                if (string == null || !string.equals(string2)) {
                    string5 = string6 + File.separator + (string != null ? string : "bad_catalog");
                    string11 = string7 + File.separator + (string != null ? string : "bad_catalog");
                    this.sqlloaderPrintStream.setWriteDir(string5);
                    this.thirdPartyPrintStream.setWriteDir(string11);
                    bl = true;
                } else {
                    bl = false;
                }
                if (string3 == null || !string3.equals(string4) || bl) {
                    if (string2 != null && string4 != null) {
                        identityHandler.setSchema(mdSchema);
                        this.postProcessingOnSchemaChange(migrationPlugin, clobToBlobHandler, offlineConstraintHandler, offlineTriggerHandler, identityHandler, offlineSQLLoaderGenerator, string2, string4, string6, string7);
                        if (bl) {
                            this.makeCallerScripts(string6, string7, string2, migrationPlugin.getPlatformName());
                        }
                    }
                    string5 = string6 + File.separator + (string != null ? string : "bad_catalog") + File.separator + (string3 != null ? string3 : "bad_schema");
                    string11 = string7 + File.separator + (string != null ? string : "bad_catalog") + File.separator + (string3 != null ? string3 : "bad_schema");
                    this.sqlloaderPrintStream.setWriteDir(string5);
                    this.thirdPartyPrintStream.setWriteDir(string11);
                    if (migrationPlugin.doIReturnUnloadScripts()) {
                        this.thirdPartyPrintStream.startDatabase(string, string3);
                        this.thirdPartyPrintStream.println("mkdir data");
                        this.thirdPartyPrintStream.println("mkdir log");
                    }
                    this.sqlloaderPrintStream.startDatabase(string, string3);
                    this.sqlloaderPrintStream.println("WHENEVER SQLERROR CONTINUE;");
                    offlineConstraintHandler.disableConstraints(this.sqlloaderPrintStream, string, dataMoveDescriptor.getTargetSchema().getName(), true);
                    offlineTriggerHandler.disableTriggers(this.sqlloaderPrintStream, string, dataMoveDescriptor.getTargetSchema().getName(), true);
                    if (migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob()) {
                        clobToBlobHandler.writeAddAndModify(this.sqlloaderPrintStream, string, dataMoveDescriptor.getTargetSchema().getName(), true);
                    }
                    if (this._truncate) {
                        if (printWriter != null) {
                            printWriter.flush();
                            printWriter.close();
                        }
                        string10 = this.sqlloaderPrintStream.getWriteDir() + File.separator + "trunc.sql";
                        printWriter = new PrintWriter(string10);
                        this.generateTruncStatements(printWriter, dataMoveDescriptor.getTargetTableName(true));
                        this.sqlloaderPrintStream.println("@@trunc.sql");
                    }
                    this.sqlloaderPrintStream.finished();
                }
                string10 = migrationPlugin.createDataFileName(string9, string8);
                boolean bl2 = true;
                if (migrationPlugin.doIReturnUnloadScripts()) {
                    bl2 = migrationPlugin.getDataExportCommmand(string8, mdColumnArray, string10, this.thirdPartyPrintStream);
                }
                dataMoveEvent = new DataMoveEvent(1, string8, bl2 ? Messages.getString("OfflineDataMoveWorker.5") : Messages.getString("OfflineDataMoveWorker.6"));
                this.m_audience.fireListeners(dataMoveEvent);
                if (this._truncate) {
                    this.generateTruncStatements(printWriter, dataMoveDescriptor.getTargetTableName(true));
                }
                boolean bl3 = offlineSQLLoaderGenerator.generateCtl(string8, string9, mdColumnArray, mdColumnArray2, string10, this.sqlloaderPrintStream, migrationPlugin);
                dataMoveEvent = new DataMoveEvent(2, string8, bl3);
                dataMoveDescriptor = this.getDescriptor();
            }
            catch (NoSuchObjectException noSuchObjectException) {
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                string2 = string;
                string4 = string3;
                mdSchema = mdSchema2;
            }
        } while (dataMoveDescriptor != null);
        if (printWriter != null) {
            printWriter.flush();
            printWriter.close();
        }
        if (mdCatalog != null) {
            identityHandler.setSchema(mdSchema);
            this.postProcessingOnSchemaChange(migrationPlugin, clobToBlobHandler, offlineConstraintHandler, offlineTriggerHandler, identityHandler, offlineSQLLoaderGenerator, string2, string4, string6, string7);
            this.makeCallerScripts(string6, string7, string2, migrationPlugin.getPlatformName());
        }
    }

    private String processSourceName(String string) {
        string = string.replaceAll(" ", "_");
        string = string.replaceAll(File.separator + File.separator, "_");
        return string;
    }

    private void generateTruncStatements(PrintWriter printWriter, String string) {
        String string2 = "TRUNCATE TABLE " + string + ";";
        printWriter.println(string2);
    }

    private void makeCallerScripts(String string, String string2, String string3, String string4) {
        String string5 = string + File.separator + string3;
        String string6 = string2 + File.separator + string3;
        this.sqlloaderPrintStream.setWriteDir(string5);
        this.sqlloaderPrintStream.buildCallerScript();
        this.sqlloaderPrintStream.setWriteDir(string);
        this.sqlloaderPrintStream.buildCallerScript();
        if (!"MSAccess".equals(string4)) {
            this.thirdPartyPrintStream.setWriteDir(string6);
            this.thirdPartyPrintStream.buildCallerScript();
            this.thirdPartyPrintStream.setWriteDir(string2);
            this.thirdPartyPrintStream.buildCallerScript();
        }
    }

    protected void postProcessingOnSchemaChange(MigrationPlugin migrationPlugin, ClobToBlobHandler clobToBlobHandler, ConstraintHandler constraintHandler, TriggerHandler triggerHandler, IdentityHandler identityHandler, OfflineSQLLoaderGenerator offlineSQLLoaderGenerator, String string, String string2, String string3, String string4) {
        String string5 = string3 + File.separator + (string != null ? string : "bad_catalog") + File.separator + (string2 != null ? string2 : "bad_schema");
        String string6 = string4 + File.separator + (string != null ? string : "bad_catalog") + File.separator + (string2 != null ? string2 : "bad_schema");
        this.sqlloaderPrintStream.setWriteDir(string5);
        this.thirdPartyPrintStream.setWriteDir(string6);
        DataMoveEvent dataMoveEvent = null;
        this.sqlloaderPrintStream.openEnableSQLFile();
        if (migrationPlugin.usesClobToBlob() && MigrationAddin.getMigrationConfig().getGenerateClobToBlob()) {
            clobToBlobHandler.writeProcedureCallAndNotNull(this.sqlloaderPrintStream, string, string2 + (string != null & string.trim().length() > 0 ? "_" + string : ""), true);
        }
        this.sqlloaderPrintStream.println("WHENEVER SQLERROR CONTINUE;");
        constraintHandler.reenableConstraints(this.sqlloaderPrintStream, true);
        triggerHandler.enableTriggers(this.sqlloaderPrintStream, true);
        identityHandler.enableIdentity(this.sqlloaderPrintStream, true);
        this.sqlloaderPrintStream.finished();
        if (migrationPlugin.doIReturnUnloadScripts()) {
            this.thirdPartyPrintStream.endDatabase();
        }
        migrationPlugin.setConnectStatement(this.thirdPartyPrintStream);
        this.sqlloaderPrintStream.endDatabase();
        boolean bl = offlineSQLLoaderGenerator.generateScriptCtl(this.sqlloaderPrintStream.m_createdFiles, this.sqlloaderPrintStream, false);
        this.sqlloaderPrintStream.winPrintstream();
        if (bl) {
            bl = offlineSQLLoaderGenerator.generateScriptCtl(this.sqlloaderPrintStream.m_createdFiles, this.sqlloaderPrintStream, true);
        }
        dataMoveEvent = new DataMoveEvent(3, Messages.getString("OfflineDataMoveWorker.8"), bl ? Messages.getString("OfflineDataMoveWorker.9") : Messages.getString("OfflineDataMoveWorker.10"));
        this.m_audience.fireListeners(dataMoveEvent);
        this.sqlloaderPrintStream.finished();
        this.thirdPartyPrintStream.finished();
        this.sqlloaderPrintStream.m_createdFiles.clear();
    }

    protected PersistenceUtility getPersistenceUtility() {
        return this.m_persistenceUtility;
    }

    protected void setPersistenceUtility(PersistenceUtility persistenceUtility) {
        this.m_persistenceUtility = persistenceUtility;
    }

    @Override
    public void signalCancel() {
    }

    @Override
    public DataMoveDescriptor getDescriptor() {
        if (!this.m_tables.hasNext()) {
            return null;
        }
        MgvAllTablesRec mgvAllTablesRec = (MgvAllTablesRec)this.m_tables.next();
        try {
            DataMoveDescriptor dataMoveDescriptor = DataMoveUtils.loadDescriptor(this.m_persistenceManager, mgvAllTablesRec.getTableId(), this.m_targetConnectionId);
            return dataMoveDescriptor;
        }
        catch (PersistenceException persistenceException) {
            MigrationLogUtil.logThrowable("OfflineDataMove.RETRIEVE_DESCRIPTOR_FAILED", Messages.getString("OfflineDataMoveWorker.12"), (Throwable)persistenceException);
            return null;
        }
    }

    class MdColumnComparator
    implements Comparator<MdColumn> {
        MdColumnComparator() {
        }

        @Override
        public int compare(MdColumn mdColumn, MdColumn mdColumn2) {
            return mdColumn.getColumnOrder() - mdColumn2.getColumnOrder();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof MdColumnComparator;
        }
    }
}

