/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.datamove.offline;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.migration.datamove.offline.Messages;
import oracle.dbtools.migration.datamove.offline.OfflineDatamovePrintStream;
import oracle.ide.Ide;

public class Offline3rdPartyPrintStream
extends OfflineDatamovePrintStream {
    private PrintWriter scriptFile;
    private String m_filePath;

    public Offline3rdPartyPrintStream(String string, String string2, String string3) {
        super(string, string2, string3);
        this.setUnloadDir(this.writeDir);
    }

    private void setUnloadDir(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        String string2 = string;
        File file = new File(string2);
        if (!file.exists()) {
            file.mkdir();
        }
        this.writeDir = string2;
    }

    @Override
    public void startTable(String string) {
    }

    @Override
    public void endTable() {
    }

    @Override
    public void println(String string) {
        this.scriptFile.println(string);
    }

    @Override
    public void endDatabase() {
        this.scriptFile.flush();
        this.scriptFile.close();
        this.stripCR(this.m_filePath, this.m_filePath.substring(0, this.m_filePath.lastIndexOf(".")) + ".sh");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripCR(String string, String string2) {
        boolean bl = false;
        try {
            String string3 = Ide.getEnvironOptions().getEncoding();
            File file = new File(string);
            File file2 = new File(string2);
            String string4 = "";
            BufferedReader bufferedReader = null;
            BufferedWriter bufferedWriter = null;
            try {
                if (!file.exists()) {
                    this.m_logger.log(Level.SEVERE, Messages.getString("Offline3rdPartyPrintStream.3"));
                    return;
                }
                if (file2.exists()) {
                    file2.delete();
                }
                if (string3 != null) {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string3));
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), string3));
                } else {
                    bufferedReader = new BufferedReader(new FileReader(file));
                    bufferedWriter = new BufferedWriter(new FileWriter(file2));
                }
                bufferedWriter.append("#!/bin/bash\n\n");
                while ((string4 = bufferedReader.readLine()) != null) {
                    int n;
                    string4 = string4.replaceAll("\\\\", "/");
                    if ((string4 = string4.replaceAll(" & ", " && ")).indexOf(37) > 0) {
                        char[] cArray = string4.toCharArray();
                        for (int i = 0; i < cArray.length; ++i) {
                            if (cArray[i] != '%') continue;
                            cArray[i] = 36;
                        }
                        string4 = new String(cArray);
                    }
                    if ((n = string4.trim().indexOf("mkdir ")) == 0) {
                        string4 = string4.replace("mkdir ", "mkdir -p ");
                    }
                    bufferedWriter.append(string4 + '\n');
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = true;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
            }
            catch (IOException iOException) {
                bl = true;
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            }
            finally {
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.flush();
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    bl = true;
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                }
            }
        }
        catch (Exception exception) {
            bl = true;
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
        if (bl) {
            this.m_logger.log(Level.SEVERE, Messages.getString("Offline3rdPartyPrintStream.4"));
        }
    }

    @Override
    public void startDatabase(String string, String string2) {
        try {
            String string3 = Ide.getEnvironOptions().getEncoding();
            PrintWriter printWriter = null;
            this.m_filePath = this.getWriteDir() + File.separator + "unload_script.bat";
            printWriter = string3 == null ? new PrintWriter(this.m_filePath) : new PrintWriter(this.m_filePath, string3);
            this.scriptFile = printWriter;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.m_logger.log(Level.SEVERE, Messages.getString("Offline3rdPartyPrintStream.6"), new Object[]{this.m_filePath, fileNotFoundException.getMessage()});
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.m_logger.log(Level.SEVERE, Messages.getString("Offline3rdPartyPrintStream.7"), new Object[]{this.m_filePath, unsupportedEncodingException.getMessage()});
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
        }
    }

    @Override
    public void finished() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildCallerScript() {
        String string = this.writeDir;
        PrintWriter printWriter = null;
        PrintWriter printWriter2 = null;
        File file = new File(string);
        File[] fileArray = null;
        try {
            if (file.isDirectory()) {
                fileArray = file.listFiles();
            }
            printWriter = new PrintWriter(string + File.separator + "unload_script.bat");
            printWriter2 = new PrintWriter(string + File.separator + "unload_script.sh");
            printWriter2.println("#!/bin/bash\n");
            this.checkScriptArgs(printWriter, true, 2);
            this.checkScriptArgs(printWriter2, false, 2);
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                if (!fileArray[i].isDirectory()) continue;
                printWriter.println("pushd " + fileArray[i].getName() + " & " + "call unload_script.bat %1 %2 %3" + " & popd");
                printWriter2.println("pushd " + fileArray[i].getName() + " && " + "sh unload_script.sh $@" + " && popd");
            }
            this.argErrorSection(printWriter, true);
            this.argErrorSection(printWriter2, false);
        }
        catch (Exception exception) {
        }
        finally {
            printWriter.flush();
            printWriter.close();
            printWriter2.flush();
            printWriter2.close();
        }
    }

    private void checkScriptArgs(PrintWriter printWriter, boolean bl, int n) {
        if (bl) {
            for (int i = 0; i < n; ++i) {
                printWriter.println("IF \"%" + (i + 1) + "\"==\"\" goto INPUT_ERROR");
            }
        } else {
            printWriter.println("if [[ $# -lt " + n + " ]]; then");
            printWriter.println("   echo \"Usage: sh unload_script.sh <server> <user> <password>\"");
            printWriter.println("   exit 1;");
            printWriter.println("fi");
        }
    }

    private void argErrorSection(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println("goto EXIT");
            printWriter.println(":INPUT_ERROR");
            printWriter.println("   echo Usage: unload_script.bat [server] [user] [password]");
            printWriter.println(":EXIT");
        }
    }

    public String getFilePathAndName() {
        return this.m_filePath;
    }

    public String getDirectoryPath() {
        return this.getWriteDir();
    }
}

