/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.core.util;

import java.awt.Font;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdConstraint;
import oracle.dbtools.metadata.persistence.MdConstraintDetail;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.convert.ConvertUtils;
import oracle.dbtools.migration.convert.DataTypeSpecification;
import oracle.dbtools.migration.core.util.Messages;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.navigator.MigrationConnectionNode;
import oracle.dbtools.migration.workbench.core.navigator.net.MigrationURLFormatHelper;
import oracle.dbtools.migration.workbench.core.navigator.nodes.CatalogFolderNode;
import oracle.dbtools.raptor.navigator.impl.DatabaseElement;
import oracle.dbtools.raptor.nls.NLSProvider;
import oracle.dbtools.raptor.nls.OracleNLSProvider;
import oracle.dbtools.raptor.report.navigatorV2.ReportXMLUtil;
import oracle.dbtools.raptor.report.navigatorV2.RootNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.ide.Context;
import oracle.ide.model.DefaultContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public abstract class MigrationUtils {
    private static Format s_oraDATEFormat = null;

    private MigrationUtils() {
    }

    public static String removeSingleQuotes(String string) {
        return MigrationUtils.removeQuotes(string, '\'');
    }

    private static String removeQuotes(String string, char c) {
        String string2 = "" + c;
        if (string.startsWith(string2) && string.endsWith(string2)) {
            return string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static String formatNLSDate(Date date) {
        Format format = MigrationUtils.getDateFormat();
        return format.format(date);
    }

    private static Format getDateFormat() {
        if (s_oraDATEFormat != null) {
            return s_oraDATEFormat;
        }
        PersistenceManager persistenceManager = MigrationAddin.getPersistenceManager();
        if (persistenceManager != null) {
            Connection connection = persistenceManager.getConn();
            s_oraDATEFormat = ((OracleNLSProvider)NLSProvider.getProvider((Connection)connection)).getOraDATEFormat();
        }
        return s_oraDATEFormat == null ? DateFormat.getInstance() : s_oraDATEFormat;
    }

    public static void resetDateFormatter() {
        s_oraDATEFormat = null;
    }

    public static void addReports(URL uRL) {
        ReportXMLUtil reportXMLUtil = new ReportXMLUtil();
        try {
            RootNode rootNode = RootNode.getInstance();
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            reportXMLUtil.parseXML((DefaultContainer)rootNode, inputStreamReader, true);
            UpdateMessage.fireStructureChanged((Subject)rootNode);
        }
        catch (IOException iOException) {
            Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
    }

    public static DataTypeSpecification getDataTypeSpecifcation(MdColumn mdColumn) {
        DataTypeSpecification dataTypeSpecification = new DataTypeSpecification(mdColumn.getColumnType(), mdColumn.getPrecision(), mdColumn.getScale());
        return dataTypeSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findCheckConstraintCondition(MdConstraint mdConstraint, PersistenceManager persistenceManager) throws PersistenceException {
        String string;
        ClobHelper clobHelper = mdConstraint.getConstraintText();
        CloseableIterator closeableIterator = null;
        try {
            string = ConvertUtils.getClobAsString(clobHelper);
            if (string != null && string.trim().length() > 0) {
                String string2 = string;
                return string2;
            }
            PersistenceUtility persistenceUtility = PersistenceUtility.getInstance(persistenceManager);
            closeableIterator = persistenceUtility.getConstraintDetails(mdConstraint.getKey());
            if (closeableIterator.hasNext()) {
                MdConstraintDetail mdConstraintDetail = (MdConstraintDetail)closeableIterator.next();
                clobHelper = mdConstraintDetail.getConstraintText();
                string = ConvertUtils.getClobAsString(clobHelper);
            }
        }
        catch (IOException iOException) {
            string = null;
        }
        finally {
            if (closeableIterator != null) {
                closeableIterator.close();
            }
        }
        return string;
    }

    private static STRUCT MigrationObjectFilterAsSTRUCT(MigrationObjectFilter migrationObjectFilter, Connection connection) throws SQLException {
        STRUCT sTRUCT;
        DBObjectId[] dBObjectIdArray;
        Object[] objectArray = new Object[]{migrationObjectFilter.getFilterType(), migrationObjectFilter.getObjectType(), null, null, null};
        if (migrationObjectFilter.getFilterType() == 1) {
            objectArray[3] = migrationObjectFilter.getObjectNames();
        } else if (migrationObjectFilter.getFilterType() == 2) {
            objectArray[4] = migrationObjectFilter.getWhereClause();
        } else if (migrationObjectFilter.getFilterType() == 3) {
            dBObjectIdArray = migrationObjectFilter.getObjectIds();
            sTRUCT = new Long[dBObjectIdArray.length];
            for (int i = 0; i < dBObjectIdArray.length; ++i) {
                sTRUCT[i] = Long.valueOf(dBObjectIdArray[i].getId());
            }
            objectArray[2] = sTRUCT;
        }
        dBObjectIdArray = StructDescriptor.createDescriptor((String)"MIGR_FILTER", (Connection)connection);
        sTRUCT = new STRUCT((StructDescriptor)dBObjectIdArray, connection, objectArray);
        return sTRUCT;
    }

    public static ARRAY migrationFilterListAsARRAY(MigrationObjectFilterList migrationObjectFilterList, Connection connection) throws SQLException {
        if (migrationObjectFilterList == null) {
            return null;
        }
        ArrayDescriptor arrayDescriptor = migrationObjectFilterList.getFilters();
        Object[] objectArray = new Object[((MigrationObjectFilter[])arrayDescriptor).length];
        for (int i = 0; i < ((MigrationObjectFilter[])arrayDescriptor).length; ++i) {
            objectArray[i] = MigrationUtils.MigrationObjectFilterAsSTRUCT((MigrationObjectFilter)arrayDescriptor[i], connection);
        }
        arrayDescriptor = ArrayDescriptor.createDescriptor((String)"MIGR_FILTER_SET", (Connection)connection);
        ARRAY aRRAY = new ARRAY(arrayDescriptor, connection, (Object)objectArray);
        return aRRAY;
    }

    public static String initCap(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        boolean bl = true;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == ' ' || Character.isWhitespace(cArray[i])) {
                bl = true;
                continue;
            }
            if (bl) {
                cArray[i] = Character.toUpperCase(cArray[i]);
                bl = false;
                continue;
            }
            cArray[i] = Character.toLowerCase(cArray[i]);
        }
        return new String(cArray);
    }

    public static MigrationPlugin getPluginForConnection(MdConnection mdConnection) throws MigrationPluginException {
        String string = MigrationUtils.getPluginIdForConnection(mdConnection);
        if (string == null) {
            throw new MigrationPluginException(new Throwable(MessageFormat.format(Messages.getString("MigrationUtils.3"), mdConnection.getKey().toString())));
        }
        MigrationPlugin migrationPlugin = MigrationAddin.findPlugin(string);
        if (migrationPlugin == null) {
            throw new MigrationPluginException(new Throwable(string + Messages.getString("MigrationUtils.4")));
        }
        return migrationPlugin;
    }

    public static String getPluginIdForConnection(MdConnection mdConnection) {
        return mdConnection.getProperty("PLUGIN_ID");
    }

    public static MdConnection getMdConnection(Context context) {
        ArrayList<MdConnection> arrayList = new ArrayList<MdConnection>();
        Element[] elementArray = context.getSelection();
        if (elementArray == null || elementArray.length == 0) {
            DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
            if (dBObject != null) {
                MdConnection mdConnection = MigrationUtils.getConnforDBObject(dBObject);
                arrayList.add(mdConnection);
            }
        } else {
            for (int i = 0; i < elementArray.length; ++i) {
                MdConnection mdConnection = MigrationUtils.getConnforElement(elementArray[i]);
                arrayList.add(mdConnection);
            }
        }
        if (arrayList.size() > 0) {
            return (MdConnection)arrayList.get(0);
        }
        return null;
    }

    public static MdConnection getConnforDBObject(DBObject dBObject) {
        MdConnection mdConnection = null;
        if (dBObject.getElement() instanceof MigrationConnectionNode) {
            MigrationConnectionNode migrationConnectionNode = (MigrationConnectionNode)dBObject.getElement();
            mdConnection = migrationConnectionNode.getMdConnection();
        } else if (dBObject.getElement() instanceof DatabaseElement) {
            Element element = dBObject.getElement();
            DBObjectId dBObjectId = MigrationURLFormatHelper.getSchemaId(((DatabaseElement)element).getURL());
            try {
                MdSchema mdSchema = MdSchema.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), dBObjectId);
                MdCatalog mdCatalog = MdCatalog.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), mdSchema.getCatalogId());
                mdConnection = MdConnection.retrieveExistingInstance(MigrationAddin.getPersistenceManager(), mdCatalog.getConnectionId());
            }
            catch (PersistenceException persistenceException) {
                Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, persistenceException.getStackTrace()[0].toString(), persistenceException);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                Logger.getLogger(MigrationUtils.class.getClass().getName()).log(Level.WARNING, noSuchObjectException.getStackTrace()[0].toString(), noSuchObjectException);
            }
        }
        return mdConnection;
    }

    public static MdConnection getConnforElement(Element element) {
        MdConnection mdConnection = null;
        if (element instanceof CatalogFolderNode) {
            mdConnection = ((CatalogFolderNode)element).getMdConnection();
        }
        return mdConnection;
    }

    public static boolean catalogIsDummy(MdCatalog mdCatalog) {
        if (mdCatalog == null) {
            return false;
        }
        String string = mdCatalog.getDummyFlag();
        if (string == null) {
            return false;
        }
        return string.equals("Y");
    }

    public static String mapSDToSDMWType(String string) {
        if (string.equalsIgnoreCase("MD_PROCEDURE") || string.equalsIgnoreCase("MD_FUNCTION")) {
            return "MD_STORED_PROGRAMS";
        }
        if (string.equalsIgnoreCase("MD_VIEW")) {
            return "MD_VIEWS";
        }
        if (string.equalsIgnoreCase("MD_TRIGGER")) {
            return "MD_TRIGGERS";
        }
        return null;
    }

    public static String fontToCSSString(Font font) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("font:");
        if (font.isBold()) {
            stringBuffer.append(" bold");
        }
        if (font.isItalic()) {
            stringBuffer.append(" italic");
        }
        stringBuffer.append(" " + font.getSize() + "pt");
        stringBuffer.append(" " + font.getFamily());
        return stringBuffer.toString();
    }
}

