/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.core;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.Messages;

public abstract class MigrationContext
implements Cancelable {
    private boolean m_shouldCancel = false;
    private static final String FIELD_REGEX = "\\$\\{.+?\\}";
    protected Map<String, Object> m_vars = Collections.synchronizedMap(new HashMap());

    public void setContextVariable(String string, Object object) {
        this.m_vars.put(string.toUpperCase(), object);
    }

    public void resetContextVariable(String string) {
        String string2 = string.toUpperCase();
        if (this.m_vars.containsKey(string2)) {
            this.m_vars.remove(string2);
        }
    }

    public Object getContextVariable(String string) {
        String string2 = string.toUpperCase();
        if (this.m_vars.containsKey(string2)) {
            return this.m_vars.get(string2);
        }
        return null;
    }

    public String applyToSQLString(String string) {
        Pattern pattern = Pattern.compile(FIELD_REGEX);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "";
        while (matcher.find()) {
            Object object;
            String string3 = matcher.group();
            if ((string3 = ((Object)string3.subSequence(2, string3.length() - 1)).toString().toUpperCase()).indexOf(46) != -1) {
                String string4 = string3.substring(0, string3.indexOf(46));
                String string5 = string3.substring(string3.indexOf(46) + 1);
                object = this.getContextVariable(string4);
                if (!(object instanceof PersistableObject)) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("MigrationContext.2"), string3));
                }
                PersistableObject persistableObject = (PersistableObject)object;
                string2 = persistableObject.getProperty(string5);
                if (string2 == null) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("MigrationContext.3"), string3));
                }
            } else {
                object = this.getContextVariable(string3);
                if (object == null) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("MigrationContext.4"), string3));
                }
                string2 = object.toString();
            }
            int n = 0;
            while ((n = string2.indexOf(36, n)) >= 0) {
                string2 = string2.substring(0, n) + "\\" + string2.substring(n);
                n += 2;
            }
            matcher.appendReplacement(stringBuffer, string2);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    @Override
    public void signalCancel() {
        this.m_shouldCancel = true;
    }

    public boolean shouldCancel() {
        return this.m_shouldCancel;
    }
}

