/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.command_line;

import oracle.dbtools.migration.command_line.MigrationDetails;

public class ConnectionDetails {
    MigrationDetails m_details = null;
    String m_urlFormat = null;
    private String connName = null;
    private String dbType = null;
    private String username = null;
    private String password = null;
    private String proxyclient = null;
    private String proxypassword = null;
    private String proxyname = null;
    private String tns = null;
    private String host = null;
    private String port = null;
    private String sid = null;
    private String service = null;
    private String superConnName = null;
    private boolean sysdba = false;

    ConnectionDetails(String string) {
        this.m_urlFormat = string;
        if (!this.readURLFormat()) {
            this.displayHelp();
        }
    }

    ConnectionDetails() {
    }

    public MigrationDetails getDetails() {
        return this.m_details;
    }

    public String getUrlFormat() {
        return this.writeURLFormat();
    }

    private String writeURLFormat() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isValid()) {
            stringBuffer.append(this.getConnName() + ":" + this.getDbType());
            if (this.isSysdba()) {
                stringBuffer.append(":SYSDBA");
            }
            if (!this.isOSAuthentication()) {
                stringBuffer.append(":" + this.getUsername());
            }
            if (!this.hasPassword()) {
                stringBuffer.append("/" + this.getPassword());
            }
            if (this.hasProxy()) {
                stringBuffer.append("=>" + this.getProxyclient());
                if (this.hasProxyPassword()) {
                    stringBuffer.append("/" + this.getProxypassword());
                } else {
                    stringBuffer.append(":" + this.getProxyname());
                }
            }
            if (this.hasTNS()) {
                stringBuffer.append("@" + this.getTns());
            } else {
                stringBuffer.append("@" + this.getHost() + ":" + this.getPort());
                if (this.hasSID()) {
                    stringBuffer.append(":" + this.getSid());
                } else {
                    stringBuffer.append("/" + this.getService());
                }
            }
        } else {
            return null;
        }
        return stringBuffer.toString();
    }

    private boolean hasSID() {
        return this.sid != null;
    }

    private boolean hasTNS() {
        return this.tns != null;
    }

    private boolean hasProxyPassword() {
        return this.proxypassword != null;
    }

    private boolean hasProxy() {
        return this.proxyclient != null;
    }

    private boolean hasPassword() {
        return this.password == null;
    }

    private boolean isValid() {
        return true;
    }

    public String getDbType() {
        return this.dbType;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        if (this.password.equals("''")) {
            return "";
        }
        return this.password;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getProxyclient() {
        return this.proxyclient;
    }

    public String getProxypassword() {
        return this.proxypassword;
    }

    public String getProxyname() {
        return this.proxyname;
    }

    public String getTns() {
        return this.tns;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getSid() {
        return this.sid;
    }

    public String getService() {
        return this.service;
    }

    public String getSuperConn() {
        return this.superConnName;
    }

    public void setSuperConn(String string) {
        this.superConnName = string;
    }

    public void setDbType(String string) {
        this.dbType = string;
    }

    public void setProxyclient(String string) {
        this.proxyclient = string;
    }

    public void setProxypassword(String string) {
        this.proxypassword = string;
    }

    public void setProxyname(String string) {
        this.proxyname = string;
    }

    public void setTns(String string) {
        this.tns = string;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public void setSid(String string) {
        this.sid = string;
    }

    public void setService(String string) {
        this.service = string;
    }

    public void setSysdba(boolean bl) {
        this.sysdba = bl;
    }

    public boolean isSysdba() {
        return this.sysdba;
    }

    public String getConnName() {
        return this.connName;
    }

    public void setConnName(String string) {
        this.connName = string;
    }

    private void displayHelp() {
    }

    private boolean readURLFormat() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        n2 = this.m_urlFormat.indexOf(":");
        if (n2 == -1) {
            return false;
        }
        this.connName = this.m_urlFormat.substring(n, n2);
        ++n2;
        n = n2;
        if ((n2 = this.m_urlFormat.indexOf(":", n)) == -1) {
            return false;
        }
        this.dbType = this.m_urlFormat.substring(n, n2);
        n = ++n2;
        if (this.m_urlFormat.toLowerCase().startsWith("sysdba", n2)) {
            this.sysdba = true;
            n = n2 += 7;
        }
        if (this.m_urlFormat.startsWith("@", n)) {
            n = ++n2;
        } else {
            int n3 = this.m_urlFormat.indexOf(47, n);
            int n4 = this.m_urlFormat.indexOf("=>", n);
            int n5 = this.m_urlFormat.indexOf("@", n);
            int n6 = this.m_urlFormat.indexOf(":", n);
            int n7 = 100000;
            if (n3 == -1 && n4 == -1 && n5 == -1) {
                return false;
            }
            n3 = this.numFlip(n3, -1, n7);
            n4 = this.numFlip(n4, -1, n7);
            n5 = this.numFlip(n5, -1, n7);
            n2 = n3 < n4 ? n3 : n4;
            n2 = n2 < n5 ? n2 : n5;
            n3 = this.numFlip(n3, n7, -1);
            n4 = this.numFlip(n4, n7, -1);
            n5 = this.numFlip(n5, n7, -1);
            this.username = this.m_urlFormat.substring(n, n2);
            n = ++n2;
            if (n2 - 1 == n3) {
                n4 = this.m_urlFormat.indexOf("=>", n);
                n5 = this.m_urlFormat.indexOf("@", n);
                n6 = this.m_urlFormat.indexOf(":", n);
                n4 = this.numFlip(n4, -1, n7);
                n5 = this.numFlip(n5, -1, n7);
                n6 = this.numFlip(n6, -1, n7);
                n2 = n5 < n4 ? n5 : n4;
                n2 = n2 < n6 ? n2 : n6;
                n4 = this.numFlip(n4, n7, -1);
                n5 = this.numFlip(n5, n7, -1);
                n6 = this.numFlip(n6, n7, -1);
                this.password = n2 == n ? null : this.m_urlFormat.substring(n, n2);
                if (n2 == n4) {
                    n = n2 += 2;
                    int n8 = this.m_urlFormat.indexOf("/", n);
                    int n9 = this.m_urlFormat.indexOf(":", n);
                    if (n8 == -1 && n9 == -1) {
                        return false;
                    }
                    n2 = (n8 = this.numFlip(n8, -1, n7)) < (n9 = this.numFlip(n9, -1, n7)) ? n8 : n9;
                    this.proxyclient = this.m_urlFormat.substring(n, n2);
                    n8 = this.numFlip(n8, n7, -1);
                    n9 = this.numFlip(n9, n7, -1);
                    n = ++n2;
                }
                if (this.m_urlFormat.startsWith(":", n2)) {
                    bl = true;
                }
                n = ++n2;
            }
        }
        n2 = this.m_urlFormat.indexOf(":", n);
        if (n2 == -1) {
            if (bl) {
                this.superConnName = this.m_urlFormat.substring(n);
            }
        } else {
            this.host = this.m_urlFormat.substring(n, n2);
            ++n2;
            n = n2;
            if ((n2 = this.m_urlFormat.indexOf(":", n)) == -1) {
                return false;
            }
            this.port = this.m_urlFormat.substring(n, n2);
            if (this.m_urlFormat.charAt(++n2 - 1) == ':') {
                this.sid = this.m_urlFormat.substring(n2);
            } else {
                this.service = this.m_urlFormat.substring(n2);
            }
        }
        return true;
    }

    private int numFlip(int n, int n2, int n3) {
        if (n == n2) {
            return n3;
        }
        return n;
    }

    public String getRole() {
        return this.sysdba ? "SYSDBA" : null;
    }

    public boolean isOSAuthentication() {
        return false;
    }

    public boolean isDefaultPasswordUsed() {
        return false;
    }
}

