/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.capture;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.metadata.persistence.CloseableIterator;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.MdCatalog;
import oracle.dbtools.metadata.persistence.MdConnection;
import oracle.dbtools.metadata.persistence.MdProject;
import oracle.dbtools.metadata.persistence.MdSchema;
import oracle.dbtools.metadata.persistence.MdTable;
import oracle.dbtools.metadata.persistence.MdView;
import oracle.dbtools.metadata.persistence.MgvAllCatalogsRec;
import oracle.dbtools.metadata.persistence.MgvAllSchemasRec;
import oracle.dbtools.metadata.persistence.MgvAllTablesRec;
import oracle.dbtools.metadata.persistence.MgvAllViewsRec;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceUtility;
import oracle.dbtools.migration.capture.CaptureAudience;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.capture.CaptureEvent;
import oracle.dbtools.migration.capture.CaptureEventListener;
import oracle.dbtools.migration.capture.CaptureException;
import oracle.dbtools.migration.capture.Capturer;
import oracle.dbtools.migration.core.Cancelable;
import oracle.dbtools.migration.core.Messages;
import oracle.dbtools.migration.workbench.core.BasicMigrationStorer;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilter;
import oracle.dbtools.migration.workbench.core.MigrationObjectFilterList;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.core.logging.MigrationLogUtil;
import oracle.ide.util.Assert;
import oracle.jdbc.OracleCallableStatement;

public abstract class CaptureWorker
implements Cancelable {
    public static final String[] CAPTURE_ORDER = new String[]{"MD_CATALOGS", "MD_SCHEMAS", "MD_USERS", "MD_TABLES", "MD_COLUMNS", "MD_INDEXES", "MD_INDEX_DETAILS", "MD_CONSTRAINTS", "MD_CONSTRAINT_DETAILS", "MD_VIEWS", "MD_STORED_PROGRAMS", "MD_TRIGGERS", "MD_GROUPS", "MD_SYNONYMS"};
    protected MdProject m_project;
    protected String m_projectName;
    protected CaptureContext m_context = new CaptureContext();
    protected String m_pluginIdentifier;
    protected MdConnection m_capturedConnection;
    protected MigrationObjectFilterList m_filters;

    public MdConnection getCapturedConnection() {
        return this.m_capturedConnection;
    }

    protected void setCapturedConnection(MdConnection mdConnection) {
        this.m_capturedConnection = mdConnection;
    }

    protected MdProject getProject() {
        return this.m_project;
    }

    protected void setProject(MdProject mdProject) {
        this.m_project = mdProject;
        this.setProjectName(mdProject.getProjectName());
    }

    protected String getProjectName() {
        return this.m_projectName;
    }

    protected void setProjectName(String string) {
        this.m_projectName = string;
    }

    protected abstract Capturer getCapturer();

    public CaptureWorker(String string, String string2) {
        this(string, string2, null);
    }

    public CaptureWorker(String string, String string2, MigrationObjectFilterList migrationObjectFilterList) {
        this.setProjectName(string);
        this.setPluginIdentifier(string2);
        this.setFilters(migrationObjectFilterList);
    }

    protected MigrationStorer getStorer() {
        return this.getCapturer().getStorer();
    }

    public void addActionListener(CaptureEventListener captureEventListener) {
        this.getCaptureAudience().addListener(captureEventListener);
    }

    protected void fireListeners(CaptureEvent captureEvent) {
        this.getCaptureAudience().fireListeners(captureEvent);
    }

    protected void fireStartStore(String string, String string2) {
        CaptureEvent captureEvent = new CaptureEvent(3, string, string2);
        this.fireListeners(captureEvent);
    }

    protected void fireEndStore(String string, String string2) {
        CaptureEvent captureEvent = new CaptureEvent(4, string, string2);
        this.fireListeners(captureEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runCapture() throws PersistenceException, CaptureException {
        CaptureEvent captureEvent = new CaptureEvent(6, "", MigrationAddinArb.getString("START_CAPTURE"));
        this.fireListeners(captureEvent);
        if (this.m_capturedConnection == null) {
            this.storeConnection();
        }
        for (String string : CAPTURE_ORDER) {
            try {
                if (this.shouldCancel()) {
                    CaptureEvent captureEvent2 = new CaptureEvent(-1, string, "");
                    this.fireListeners(captureEvent2);
                    try {
                        this.getStorer().rollback();
                    }
                    catch (SQLException sQLException) {
                        return false;
                    }
                    return false;
                }
                this.captureType(string);
            }
            catch (SQLException sQLException) {
                throw new CaptureException(sQLException);
            }
        }
        try {
            this.populateIdentifiers();
            this.getStorer().commit();
            this.updateStatistics();
            captureEvent.setEventId(7);
            this.fireListeners(captureEvent);
        }
        catch (SQLException sQLException) {
            MigrationLogUtil.logThrowable("MigrationLog.DB_COMMIT_ERROR", Messages.getString("CaptureWorker.3"), (Throwable)sQLException);
            Assert.printStackTrace((Throwable)sQLException);
            int n = 0;
            return n != 0;
        }
        finally {
            this.clearPersitenceCache();
        }
        return true;
    }

    private void updateStatistics() throws PersistenceException {
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        persistenceUtility.updateConnectionStatistics(this.getCapturedConnection());
    }

    protected void captureType(String string) throws PersistenceException, SQLException, CaptureException {
        if (this.m_filters != null && this.m_filters.getFilterForType(string) == null) {
            return;
        }
        if (string.equals("MD_CATALOGS")) {
            this.captureCatalog();
        } else if (string.equals("MD_SCHEMAS")) {
            this.captureSchema();
        } else if (string.equals("MD_VIEWS")) {
            this.capturePerSchema("MD_VIEWS");
        } else if (string.equals("MD_USERS")) {
            this.capturePerSchema("MD_USERS");
        } else if (string.equals("MD_TABLES")) {
            this.captureTables();
        } else if (string.equals("MD_COLUMNS")) {
            this.capturePerTable("MD_COLUMNS");
        } else if (string.equals("MD_INDEXES")) {
            this.capturePerTable("MD_INDEXES");
        } else if (string.equals("MD_INDEX_DETAILS")) {
            this.capturePerTable("MD_INDEX_DETAILS");
        } else if (string.equals("MD_CONSTRAINTS")) {
            this.capturePerTable("MD_CONSTRAINTS");
        } else if (string.equals("MD_CONSTRAINT_DETAILS")) {
            this.capturePerTable("MD_CONSTRAINT_DETAILS");
        } else if (string.equals("MD_STORED_PROGRAMS")) {
            this.capturePerSchema("MD_STORED_PROGRAMS");
        } else if (string.equals("MD_TRIGGERS")) {
            this.capturePerTable("MD_TRIGGERS");
            this.capturePerView("MD_TRIGGERS");
        } else if (string.equals("MD_GROUPS")) {
            this.capturePerCatalog("MD_GROUPS");
        } else if (string.equals("MD_SYNONYMS")) {
            this.captureSynonyms();
        } else {
            Assert.println((String)("DD>> TODO: Handle " + string));
        }
    }

    protected void captureCatalog() throws PersistenceException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_CATALOGS");
        }
        this.captureCatalogImpl(migrationObjectFilter);
    }

    protected abstract void captureCatalogImpl(MigrationObjectFilter var1) throws PersistenceException, CaptureException;

    protected void captureSchema() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        boolean bl = false;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_SCHEMAS");
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllCatalogsRec> closeableIterator = persistenceUtility.getCatalogsForConnectionId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            bl = true;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, "SCHEMA", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MgvAllCatalogsRec)closeableIterator.next();
            this.checkNewCatalog(((MgvAllCatalogsRec)object).getCatalogId());
            this.captureSchemaImpl(migrationObjectFilter);
        }
        if (!bl) {
            Logger.getLogger("oracle.dbtools.migration.workbench.core.MigrationLogResourceBundle").log(Level.INFO, "Capture.NO_VALID_CATALOGS");
        }
    }

    protected abstract void captureSchemaImpl(MigrationObjectFilter var1) throws PersistenceException, CaptureException;

    protected void capturePerCatalog(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllCatalogsRec> closeableIterator = persistenceUtility.getCatalogsForConnectionId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, string, "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MgvAllCatalogsRec)closeableIterator.next();
            this.checkNewCatalog(((MgvAllCatalogsRec)object).getCatalogId());
            this.capturePerCatalogImpl(string, migrationObjectFilter);
        }
    }

    protected abstract void capturePerCatalogImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void captureTables() throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_TABLES");
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllSchemasRec> closeableIterator = persistenceUtility.getSchemasForConnectionId(dBObjectId, this.m_filters);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MgvAllSchemasRec)closeableIterator.next();
            this.checkNewCatalog(((MgvAllCatalogsRec)object).getCatalogId());
            this.checkNewSchema(((MgvAllSchemasRec)object).getSchemaId());
            this.captureTableImpl(migrationObjectFilter);
        }
    }

    protected abstract void captureTableImpl(MigrationObjectFilter var1) throws PersistenceException, CaptureException;

    protected void capturePerSchema(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        this.m_context.setContextVariable("PER_CONTEXT", "MD_SCHEMAS");
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllSchemasRec> closeableIterator = persistenceUtility.getSchemasForConnectionId(dBObjectId, this.m_filters);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            object = (MgvAllSchemasRec)closeableIterator.next();
            this.checkNewCatalog(((MgvAllCatalogsRec)object).getCatalogId());
            this.checkNewSchema(((MgvAllSchemasRec)object).getSchemaId());
            this.capturePerSchemaImpl(string, migrationObjectFilter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected abstract void capturePerSchemaImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void capturePerTable(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        this.m_context.setContextVariable("PER_CONTEXT", "MD_TABLES");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllTablesRec> closeableIterator = persistenceUtility.getTablesForConnectionId(dBObjectId, this.m_filters);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            object = (MgvAllTablesRec)closeableIterator.next();
            this.checkNewCatalog(((MgvAllCatalogsRec)object).getCatalogId());
            this.checkNewSchema(((MgvAllSchemasRec)object).getSchemaId());
            this.checkNewTable(((MgvAllTablesRec)object).getTableId());
            this.capturePerTableImpl(string, migrationObjectFilter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected abstract void capturePerTableImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void capturePerView(String string) throws PersistenceException, SQLException, CaptureException {
        MigrationObjectFilter migrationObjectFilter = null;
        this.m_context.setContextVariable("PER_CONTEXT", "MD_VIEWS");
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType(string);
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllViewsRec> closeableIterator = persistenceUtility.getViewsForConnectionId(dBObjectId);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                this.m_context.resetContextVariable("PER_CONTEXT");
                return;
            }
            object = (MgvAllViewsRec)closeableIterator.next();
            this.checkNewCatalog(((MgvAllCatalogsRec)object).getCatalogId());
            this.checkNewSchema(((MgvAllSchemasRec)object).getSchemaId());
            this.checkNewView(((MgvAllViewsRec)object).getViewId());
            this.capturePerViewImpl(string, migrationObjectFilter);
        }
        this.m_context.resetContextVariable("PER_CONTEXT");
    }

    protected abstract void capturePerViewImpl(String var1, MigrationObjectFilter var2) throws PersistenceException, CaptureException;

    protected void storeConnection() throws PersistenceException, CaptureException {
        this.m_context.setContextVariable("PROJECT", this.getProjectName());
        this.fireStartStore("PROJECT", this.getProjectName());
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        MdProject mdProject = this.getProject();
        if (null == mdProject) {
            mdProject = persistenceUtility.findOrCreateNamedProject(this.getProjectName());
            this.setProject(mdProject);
        }
        mdProject = (MdProject)this.getStorer().storeObject(mdProject);
        this.m_context.setContextVariable("PROJECTID", mdProject.getKey());
        MdConnection mdConnection = new MdConnection(mdProject.getKey());
        mdConnection.setDburl(this.getCapturer().getSourceURL());
        this.m_context.setContextVariable("CONNECTION", mdConnection.getDburl());
        this.fireStartStore("CONNECTION", mdConnection.getDburl());
        mdConnection.setName(CaptureWorker.getModelConnectionName());
        mdConnection = (MdConnection)this.getStorer().storeObject(mdConnection);
        mdConnection.addProperty("PLUGIN_ID", this.getPluginIdentifier(), mdConnection.getKey());
        mdConnection = (MdConnection)this.getStorer().storeObject(mdConnection);
        MigrationLogUtil.startMigrationLogSession(mdConnection.getKey());
        this.setCapturedConnection(mdConnection);
        this.m_context.setContextVariable("CONNECTIONID", mdConnection.getKey());
        this.fireEndStore("CONNECTION", mdConnection.getDburl());
    }

    public static String getModelConnectionName() throws CaptureException {
        Object var0 = null;
        Date date = new Date();
        return new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss").format(date);
    }

    protected CaptureAudience getCaptureAudience() {
        if (this.m_context != null) {
            return this.m_context.getAudience();
        }
        return null;
    }

    @Override
    public void signalCancel() {
        this.m_context.signalCancel();
    }

    protected boolean shouldCancel() {
        return this.m_context.shouldCancel();
    }

    protected void checkNewCatalog(DBObjectId dBObjectId) throws PersistenceException {
        if (!dBObjectId.equals(this.m_context.getContextVariable("CATALOGID"))) {
            MdCatalog mdCatalog = MdCatalog.getExistingInstance(dBObjectId);
            try {
                PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                mdCatalog = (MdCatalog)persistenceUtility.loadPersistableObject(dBObjectId, "MD_CATALOGS");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new PersistenceException(noSuchObjectException);
            }
            this.m_context.setContextVariable("CATALOGID", mdCatalog.getKey());
            this.m_context.setContextVariable("CATALOG", mdCatalog);
        }
    }

    protected void checkNewSchema(DBObjectId dBObjectId) throws PersistenceException {
        if (!dBObjectId.equals(this.m_context.getContextVariable("SCHEMAID"))) {
            MdSchema mdSchema = MdSchema.getExistingInstance(dBObjectId);
            try {
                PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                mdSchema = (MdSchema)persistenceUtility.loadPersistableObject(dBObjectId, "MD_SCHEMAS");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new PersistenceException(noSuchObjectException);
            }
            this.m_context.setContextVariable("SCHEMA", mdSchema.getName());
            this.m_context.setContextVariable("SCHEMAID", mdSchema.getKey());
            this.m_context.setContextVariable("SCHEMAOBJ", mdSchema);
        }
    }

    protected void checkNewTable(DBObjectId dBObjectId) throws PersistenceException {
        if (!dBObjectId.equals(this.m_context.getContextVariable("TABLEID"))) {
            MdTable mdTable = MdTable.getExistingInstance(dBObjectId);
            try {
                PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                mdTable = (MdTable)persistenceUtility.loadPersistableObject(dBObjectId, "MD_TABLES");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new PersistenceException(noSuchObjectException);
            }
            this.m_context.setContextVariable("TABLE", mdTable.getTableName());
            this.m_context.setContextVariable("TABLEID", mdTable.getKey());
        }
    }

    protected void checkNewView(DBObjectId dBObjectId) throws PersistenceException {
        if (!dBObjectId.equals(this.m_context.getContextVariable("VIEWID"))) {
            MdView mdView = MdView.getExistingInstance(dBObjectId);
            try {
                PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
                mdView = (MdView)persistenceUtility.loadPersistableObject(dBObjectId, "MD_VIEWS");
            }
            catch (NoSuchObjectException noSuchObjectException) {
                throw new PersistenceException(noSuchObjectException);
            }
            this.m_context.setContextVariable("VIEWID", mdView.getKey());
            this.m_context.setContextVariable("VIEW", mdView.getViewName());
        }
    }

    protected String getPluginIdentifier() {
        return this.m_pluginIdentifier;
    }

    protected void setPluginIdentifier(String string) {
        this.m_pluginIdentifier = string;
    }

    public void setFilters(MigrationObjectFilterList migrationObjectFilterList) {
        this.m_filters = migrationObjectFilterList;
    }

    public void setTargetConnection(MdConnection mdConnection) {
        this.setCapturedConnection(mdConnection);
        this.m_context.setContextVariable("PROJECTID", mdConnection.getProjectId());
        this.m_context.setContextVariable("CONNECTION", mdConnection.getDburl());
        this.m_context.setContextVariable("CONNECTIONID", mdConnection.getKey());
    }

    protected void clearPersitenceCache() {
        ((BasicMigrationStorer)this.getCapturer().getStorer()).getPersistenceManager().releaseCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateIdentifiers() throws SQLException {
        OracleCallableStatement oracleCallableStatement = null;
        long l = this.m_capturedConnection.getKey().getId();
        Connection connection = ((BasicMigrationStorer)this.getCapturer().getStorer()).getPersistenceManager().getConn();
        if (connection != null) {
            try {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call MIGRATION.POPULATE_DERIVATIVES_TABLE(?)}");
                oracleCallableStatement.setLong(1, l);
                oracleCallableStatement.execute();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
            finally {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
        }
    }

    private final void dbg_plsql() throws SQLException {
        Connection connection = ((BasicMigrationStorer)this.getCapturer().getStorer()).getPersistenceManager().getConn();
        OracleCallableStatement oracleCallableStatement = null;
        if (connection != null) {
            try {
                oracleCallableStatement = (OracleCallableStatement)connection.prepareCall("{call DBMS_DEBUG_JDWP.CONNECT_TCP( ?, ? )}");
                oracleCallableStatement.setString(1, "localhost");
                oracleCallableStatement.setInt(2, 4001);
                oracleCallableStatement.execute();
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            finally {
                if (oracleCallableStatement != null) {
                    oracleCallableStatement.close();
                }
            }
        }
    }

    protected void captureSynonyms() throws PersistenceException, CaptureException, SQLException {
        MigrationObjectFilter migrationObjectFilter = null;
        if (this.m_filters != null) {
            migrationObjectFilter = this.m_filters.getFilterForType("MD_SYNONYMS");
        }
        PersistenceUtility persistenceUtility = this.getStorer().getPersistenceUtility();
        DBObjectId dBObjectId = (DBObjectId)this.m_context.getContextVariable("CONNECTIONID");
        CloseableIterator<MgvAllSchemasRec> closeableIterator = persistenceUtility.getSchemasForConnectionId(dBObjectId, this.m_filters);
        while (closeableIterator.hasNext()) {
            Object object;
            if (this.shouldCancel()) {
                closeableIterator.close();
                object = new CaptureEvent(-1, "CATALOG", "");
                this.fireListeners((CaptureEvent)object);
                return;
            }
            object = (MgvAllSchemasRec)closeableIterator.next();
            this.checkNewCatalog(((MgvAllCatalogsRec)object).getCatalogId());
            this.checkNewSchema(((MgvAllSchemasRec)object).getSchemaId());
            this.captureSynonymImpl(migrationObjectFilter);
        }
    }

    protected abstract void captureSynonymImpl(MigrationObjectFilter var1) throws PersistenceException, CaptureException;
}

