/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.ClobHelper;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdPrivilege
extends PersistableObject {
    public static final String TABLE_NAME = "MD_PRIVILEGES";
    public static final String COLNAME_SCHEMA_ID_FK = "SCHEMA_ID_FK";
    public static final String COLNAME_PRIVILEGE_NAME = "PRIVILEGE_NAME";
    public static final String COLNAME_PRIVELEGE_OBJECT_ID = "PRIVELEGE_OBJECT_ID";
    public static final String COLNAME_PRIVELEGEOBJECTTYPE = "PRIVELEGEOBJECTTYPE";
    public static final String COLNAME_PRIVELEGE_TYPE = "PRIVELEGE_TYPE";
    public static final String COLNAME_ADMIN_OPTION = "ADMIN_OPTION";
    public static final String COLNAME_NATIVE_SQL = "NATIVE_SQL";
    public static final String COLNAME_NATIVE_KEY = "NATIVE_KEY";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";
    public static final String COLNAME_COMMENTS = "COMMENTS";

    public MdPrivilege(DBObjectId dBObjectId, String string, String string2, String string3, ClobHelper clobHelper) {
        this.setSchemaId(dBObjectId);
        this.setPrivilegeName(string);
        this.setPrivelegeobjecttype(string2);
        this.setPrivelegeType(string3);
        this.setNativeSql(clobHelper);
    }

    public static MdPrivilege getExistingInstance(DBObjectId dBObjectId) {
        MdPrivilege mdPrivilege = new MdPrivilege();
        mdPrivilege.setKey(dBObjectId);
        return mdPrivilege;
    }

    private MdPrivilege() {
    }

    public static MdPrivilege retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdPrivilege mdPrivilege = MdPrivilege.getExistingInstance(dBObjectId);
        mdPrivilege.retrieve(persistenceManager);
        return mdPrivilege;
    }

    protected void setSchemaId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SCHEMA_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setPrivilegeName(String string) {
        Field field = new Field(COLNAME_PRIVILEGE_NAME, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setPrivelegeObjectId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_PRIVELEGE_OBJECT_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    protected void setPrivelegeobjecttype(String string) {
        Field field = new Field(COLNAME_PRIVELEGEOBJECTTYPE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    protected void setPrivelegeType(String string) {
        Field field = new Field(COLNAME_PRIVELEGE_TYPE, "STRING", false);
        field.setValue(string);
        this.setField(field);
    }

    public void setAdminOption(String string) {
        Field field = new Field(COLNAME_ADMIN_OPTION, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    protected void setNativeSql(String string) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        ClobHelper clobHelper = new ClobHelper(string);
        field.setValue(clobHelper);
        this.setField(field);
    }

    protected void setNativeSql(ClobHelper clobHelper) {
        Field field = new Field(COLNAME_NATIVE_SQL, "CLOBHELPER");
        field.setValue(clobHelper);
        this.setField(field);
    }

    public void setNativeKey(String string) {
        Field field = new Field(COLNAME_NATIVE_KEY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setComments(String string) {
        Field field = new Field(COLNAME_COMMENTS, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public DBObjectId getSchemaId() {
        Field field = this.getField(COLNAME_SCHEMA_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getPrivilegeName() {
        Field field = this.getField(COLNAME_PRIVILEGE_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getPrivelegeObjectId() {
        Field field = this.getField(COLNAME_PRIVELEGE_OBJECT_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public String getPrivelegeobjecttype() {
        Field field = this.getField(COLNAME_PRIVELEGEOBJECTTYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getPrivelegeType() {
        Field field = this.getField(COLNAME_PRIVELEGE_TYPE);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getAdminOption() {
        Field field = this.getField(COLNAME_ADMIN_OPTION);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public ClobHelper getNativeSql() {
        Field field = this.getField(COLNAME_NATIVE_SQL);
        if (field == null) {
            return null;
        }
        return field.getClobHelper();
    }

    public String getNativeKey() {
        Field field = this.getField(COLNAME_NATIVE_KEY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getComments() {
        Field field = this.getField(COLNAME_COMMENTS);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            this.setSchemaId(new DBObjectId(resultSet.getLong(COLNAME_SCHEMA_ID_FK)));
            this.setPrivilegeName(resultSet.getString(COLNAME_PRIVILEGE_NAME));
            Object object = new DBObjectId(resultSet.getLong(COLNAME_PRIVELEGE_OBJECT_ID));
            if (resultSet.wasNull()) {
                this.setPrivelegeObjectId(null);
            } else {
                this.setPrivelegeObjectId((DBObjectId)object);
            }
            this.setPrivelegeobjecttype(resultSet.getString(COLNAME_PRIVELEGEOBJECTTYPE));
            this.setPrivelegeType(resultSet.getString(COLNAME_PRIVELEGE_TYPE));
            object = resultSet.getString(COLNAME_ADMIN_OPTION);
            if (resultSet.wasNull()) {
                this.setAdminOption(null);
            } else {
                this.setAdminOption((String)object);
            }
            this.setNativeSql(new ClobHelper(resultSet.getClob(COLNAME_NATIVE_SQL)));
            object = resultSet.getString(COLNAME_NATIVE_KEY);
            if (resultSet.wasNull()) {
                this.setNativeKey(null);
            } else {
                this.setNativeKey((String)object);
            }
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
            object = resultSet.getString(COLNAME_COMMENTS);
            if (resultSet.wasNull()) {
                this.setComments(null);
            } else {
                this.setComments((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getPrivilegeName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_PRIVILEGE_NAME;
    }

    public void rename(String string) {
        this.setPrivilegeName(string);
    }

    @Override
    public String getContainerFieldName() {
        return COLNAME_SCHEMA_ID_FK;
    }

    @Override
    public DBObjectId getContainerId() {
        return this.getSchemaId();
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

