/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.persistence;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.metadata.persistence.CloseableResultSet;
import oracle.dbtools.metadata.persistence.DBObjectId;
import oracle.dbtools.metadata.persistence.Field;
import oracle.dbtools.metadata.persistence.NoSuchObjectException;
import oracle.dbtools.metadata.persistence.PersistableObject;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.metadata.persistence.PersistenceManager;

public class MdApplication
extends PersistableObject {
    public static final String TABLE_NAME = "MD_APPLICATIONS";
    public static final String COLNAME_NAME = "NAME";
    public static final String COLNAME_DESCRIPTION = "DESCRIPTION";
    public static final String COLNAME_BASE_DIR = "BASE_DIR";
    public static final String COLNAME_OUTPUT_DIR = "OUTPUT_DIR";
    public static final String COLNAME_BACKUP_DIR = "BACKUP_DIR";
    public static final String COLNAME_INPLACE = "INPLACE";
    public static final String COLNAME_CONNECTION_ID_FK = "CONNECTION_ID_FK";
    public static final String COLNAME_SECURITY_GROUP_ID = "SECURITY_GROUP_ID";
    public static final String COLNAME_CREATED_ON = "CREATED_ON";
    public static final String COLNAME_CREATED_BY = "CREATED_BY";
    public static final String COLNAME_LAST_UPDATED_ON = "LAST_UPDATED_ON";
    public static final String COLNAME_LAST_UPDATED_BY = "LAST_UPDATED_BY";

    public MdApplication(DBObjectId dBObjectId) {
        this.setConnectionId(dBObjectId);
    }

    public static MdApplication getExistingInstance(DBObjectId dBObjectId) {
        MdApplication mdApplication = new MdApplication();
        mdApplication.setKey(dBObjectId);
        return mdApplication;
    }

    private MdApplication() {
    }

    public static MdApplication retrieveExistingInstance(PersistenceManager persistenceManager, DBObjectId dBObjectId) throws PersistenceException, NoSuchObjectException {
        MdApplication mdApplication = MdApplication.getExistingInstance(dBObjectId);
        mdApplication.retrieve(persistenceManager);
        return mdApplication;
    }

    public void setName(String string) {
        Field field = new Field(COLNAME_NAME, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setDescription(String string) {
        Field field = new Field(COLNAME_DESCRIPTION, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setBaseDir(String string) {
        Field field = new Field(COLNAME_BASE_DIR, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setOutputDir(String string) {
        Field field = new Field(COLNAME_OUTPUT_DIR, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setBackupDir(String string) {
        Field field = new Field(COLNAME_BACKUP_DIR, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setInplace(Integer n) {
        Field field = new Field(COLNAME_INPLACE, "INTEGER");
        field.setValue(n);
        this.setField(field);
    }

    protected void setConnectionId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_CONNECTION_ID_FK, "DBOBJECTID", false);
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setSecurityGroupId(DBObjectId dBObjectId) {
        Field field = new Field(COLNAME_SECURITY_GROUP_ID, "DBOBJECTID");
        field.setValue(dBObjectId);
        this.setField(field);
    }

    public void setCreatedOn(Date date) {
        Field field = new Field(COLNAME_CREATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setCreatedBy(String string) {
        Field field = new Field(COLNAME_CREATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public void setLastUpdatedOn(Date date) {
        Field field = new Field(COLNAME_LAST_UPDATED_ON, "DATE");
        field.setValue(date);
        this.setField(field);
    }

    public void setLastUpdatedBy(String string) {
        Field field = new Field(COLNAME_LAST_UPDATED_BY, "STRING");
        field.setValue(string);
        this.setField(field);
    }

    public String getName() {
        Field field = this.getField(COLNAME_NAME);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getDescription() {
        Field field = this.getField(COLNAME_DESCRIPTION);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getBaseDir() {
        Field field = this.getField(COLNAME_BASE_DIR);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getOutputDir() {
        Field field = this.getField(COLNAME_OUTPUT_DIR);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public String getBackupDir() {
        Field field = this.getField(COLNAME_BACKUP_DIR);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Integer getInplace() {
        Field field = this.getField(COLNAME_INPLACE);
        if (field == null) {
            return null;
        }
        return field.getInteger();
    }

    public DBObjectId getConnectionId() {
        Field field = this.getField(COLNAME_CONNECTION_ID_FK);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public DBObjectId getSecurityGroupId() {
        Field field = this.getField(COLNAME_SECURITY_GROUP_ID);
        if (field == null) {
            return null;
        }
        return field.getDBObjectId();
    }

    public Date getCreatedOn() {
        Field field = this.getField(COLNAME_CREATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getCreatedBy() {
        Field field = this.getField(COLNAME_CREATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public Date getLastUpdatedOn() {
        Field field = this.getField(COLNAME_LAST_UPDATED_ON);
        if (field == null) {
            return null;
        }
        return field.getDate();
    }

    public String getLastUpdatedBy() {
        Field field = this.getField(COLNAME_LAST_UPDATED_BY);
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    public void retrieve(PersistenceManager persistenceManager) throws PersistenceException, NoSuchObjectException {
        CloseableResultSet closeableResultSet = this.issueRetrieveQuery(persistenceManager);
        ResultSet resultSet = closeableResultSet.getResultSet();
        try {
            Object object = resultSet.getString(COLNAME_NAME);
            if (resultSet.wasNull()) {
                this.setName(null);
            } else {
                this.setName((String)object);
            }
            object = resultSet.getString(COLNAME_DESCRIPTION);
            if (resultSet.wasNull()) {
                this.setDescription(null);
            } else {
                this.setDescription((String)object);
            }
            object = resultSet.getString(COLNAME_BASE_DIR);
            if (resultSet.wasNull()) {
                this.setBaseDir(null);
            } else {
                this.setBaseDir((String)object);
            }
            object = resultSet.getString(COLNAME_OUTPUT_DIR);
            if (resultSet.wasNull()) {
                this.setOutputDir(null);
            } else {
                this.setOutputDir((String)object);
            }
            object = resultSet.getString(COLNAME_BACKUP_DIR);
            if (resultSet.wasNull()) {
                this.setBackupDir(null);
            } else {
                this.setBackupDir((String)object);
            }
            object = resultSet.getInt(COLNAME_INPLACE);
            if (resultSet.wasNull()) {
                this.setInplace(null);
            } else {
                this.setInplace((Integer)object);
            }
            this.setConnectionId(new DBObjectId(resultSet.getLong(COLNAME_CONNECTION_ID_FK)));
            object = new DBObjectId(resultSet.getLong(COLNAME_SECURITY_GROUP_ID));
            if (resultSet.wasNull()) {
                this.setSecurityGroupId(null);
            } else {
                this.setSecurityGroupId((DBObjectId)object);
            }
            object = resultSet.getDate(COLNAME_CREATED_ON);
            if (resultSet.wasNull()) {
                this.setCreatedOn(null);
            } else {
                this.setCreatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_CREATED_BY);
            if (resultSet.wasNull()) {
                this.setCreatedBy(null);
            } else {
                this.setCreatedBy((String)object);
            }
            object = resultSet.getDate(COLNAME_LAST_UPDATED_ON);
            if (resultSet.wasNull()) {
                this.setLastUpdatedOn(null);
            } else {
                this.setLastUpdatedOn((Date)object);
            }
            object = resultSet.getString(COLNAME_LAST_UPDATED_BY);
            if (resultSet.wasNull()) {
                this.setLastUpdatedBy(null);
            } else {
                this.setLastUpdatedBy((String)object);
            }
        }
        catch (SQLException sQLException) {
            throw new PersistenceException(sQLException);
        }
        finally {
            closeableResultSet.close();
        }
        this.retrieveAdditionalProperties(persistenceManager);
        this.clearUpdatedFields();
    }

    @Override
    public String getObjectName() {
        return this.getName();
    }

    @Override
    public String getObjectNameFieldName() {
        return COLNAME_NAME;
    }

    public void rename(String string) {
        this.setName(string);
    }

    @Override
    protected String getStorageTableName() {
        return TABLE_NAME;
    }
}

