/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.metadata.createRepository;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import oracle.dbtools.metadata.createRepository.RepositoryRegistry;
import oracle.dbtools.migration.workbench.core.MigrationAddinArb;
import oracle.dbtools.migration.workbench.core.ui.AbstractMigrationProgressRunnable;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;

public class RunRepositoryScripts {
    public static final int CREATE_REPOSITORY = 1;
    public static final int DROP_REPOSITORY = 2;
    public static final int UPGRADE_REPOSITORY = 3;
    public static final int PURGE_REPOSITORY = 4;
    public static final int GENERIC = 5;
    private boolean m_first = true;
    private String m_firstVsn;
    private Connection m_conn = null;
    private Boolean m_success = null;
    private String m_script = "";
    private AbstractMigrationProgressRunnable m_progressBar = null;
    private IRaptorTaskProgressUpdater m_updater = null;
    private int m_mode = 5;
    private ScriptRunnerContext m_context;
    private ScriptExecutor runner;
    private boolean m_cancelled = false;

    public RunRepositoryScripts(Connection connection) {
        this.setConnection(connection);
    }

    public Connection getConnection() {
        return this.m_conn;
    }

    public void setConnection(Connection connection) {
        this.m_conn = connection;
    }

    public void close() throws SQLException {
        if (this.m_conn != null) {
            this.m_conn.close();
        }
    }

    public void run(Connection connection) throws SQLException {
        this.close();
        this.setConnection(connection);
        this.run();
    }

    public void run() {
        Object object;
        URL uRL = this.getClass().getResource(this.m_script);
        this.m_context = new ScriptRunnerContext();
        this.m_context.setTopLevel(true);
        this.m_context.setLastUrl(uRL);
        this.m_context.setSqlError(5);
        this.m_context.setOsError(5);
        BufferedOutputStream bufferedOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (this.m_mode == 1) {
            object = new MaskByteArrayOutputStream();
            bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
            if (this.m_progressBar != null) {
                this.m_progressBar.getProgBar().setExitOnDone(true);
                ((MaskByteArrayOutputStream)object).setCallRunScripts(this.m_progressBar);
            }
            if (this.m_updater != null) {
                ((MaskByteArrayOutputStream)object).setUpdater(this.m_updater);
            }
        } else {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        }
        this.runner = new ScriptExecutor(uRL, this.getConnection());
        this.runner.setScriptRunnerContext(this.m_context);
        this.runner.setOut(bufferedOutputStream);
        this.runner.setName("Migration Execution Thread");
        this.runner.run();
        if (this.m_context.getReturnExited()) {
            this.setSuccess(Boolean.FALSE);
            this.updateProgress(100, null, MigrationAddinArb.getString("REPOSITORY_FAILED_TO_BUILD"));
        } else {
            this.setSuccess(Boolean.TRUE);
            if (this.m_mode == 2) {
                this.updateProgress(100, null, MigrationAddinArb.getString("REPOSITORY_REMOVED"));
            } else if (this.m_mode == 1) {
                this.updateProgress(100, null, MigrationAddinArb.getString("REPOSITORY_BUILT"));
            } else if (this.m_mode == 3) {
                String string;
                object = new StringTokenizer(this.m_script, "_");
                ((StringTokenizer)object).nextToken();
                String string2 = ((StringTokenizer)object).nextToken();
                if (this.m_first) {
                    this.m_firstVsn = string2;
                    this.m_first = false;
                }
                if (Integer.parseInt(string = ((StringTokenizer)object).nextToken()) == 42) {
                    string2 = this.m_firstVsn;
                }
                String string3 = MigrationAddinArb.getString("MIGRATION_UPGRADED") + " " + string2 + " " + MigrationAddinArb.getString("MIGRATION_TO") + " " + string + " " + MigrationAddinArb.getString("MIGRATION_COMPLETE");
                this.updateProgress(100, null, string3);
            } else if (this.m_mode == 4) {
                object = MigrationAddinArb.getString("REPO_PURGED");
                this.updateProgress(100, null, object);
            } else {
                this.updateProgress(100, null, MigrationAddinArb.getString("REPOSITORY_BUILT_GENERIC"));
            }
        }
    }

    public void updateProgress(int n, Object object, Object object2) {
        if (this.m_progressBar != null) {
            this.m_progressBar.updateProgress(n, object, object2);
        }
        if (this.m_updater != null) {
            this.m_updater.getDescriptor().setMessage((String)object2);
            this.m_updater.getDescriptor().setProgress(n);
        }
    }

    public Boolean getSuccess() {
        return this.m_success;
    }

    public void setSuccess(Boolean bl) {
        this.m_success = bl;
    }

    public void setScript(String string) {
        this.m_script = string;
    }

    public AbstractMigrationProgressRunnable getProgressBar() {
        return this.m_progressBar;
    }

    public void setProgressBar(AbstractMigrationProgressRunnable abstractMigrationProgressRunnable) {
        this.m_progressBar = abstractMigrationProgressRunnable;
    }

    public IRaptorTaskProgressUpdater getUpdater() {
        return this.m_updater;
    }

    public void setUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
        this.m_updater = iRaptorTaskProgressUpdater;
    }

    public int getMode() {
        return this.m_mode;
    }

    public void setMode(int n) {
        this.m_mode = n;
    }

    public void signalCancel() {
        this.runner.interrupt();
        this.m_cancelled = true;
        if (this.m_mode == 1 || this.m_mode == 2) {
            this.cleanupCreated();
        }
    }

    private void cleanupCreated() {
        RepositoryRegistry.dropRepository(this.m_context.getBaseConnection(), this.m_progressBar);
    }

    public boolean wasCancelled() {
        return this.m_cancelled;
    }

    public class MaskByteArrayOutputStream
    extends ByteArrayOutputStream {
        int m_bytesSoFar = 0;
        int m_lastEpoch = -1;
        int m_maxBytes = 36000;
        int m_chunks = 100;
        int m_message = 0;
        AbstractMigrationProgressRunnable m_callRunScripts;
        IRaptorTaskProgressUpdater m_updater;

        public void updateBytesSoFar(int n) {
            this.m_bytesSoFar += n;
            int n2 = this.m_bytesSoFar * 100 / this.m_maxBytes;
            if (n2 / (100 / this.m_chunks) != this.m_lastEpoch) {
                this.m_lastEpoch = n2 / (100 / this.m_chunks);
                int n3 = this.m_lastEpoch * (100 / this.m_chunks);
                if (n3 >= 99) {
                    n3 = 100;
                } else if (n3 < 0) {
                    n3 = 0;
                }
                String string = this.getNextMessageText(n3);
                this.updateProgress(n3, null, string);
            }
        }

        String getNextMessageText(int n) {
            ++this.m_message;
            switch (this.m_message / (this.m_chunks / 5)) {
                case 0: {
                    return MigrationAddinArb.getString("REPOSITORY_STAGE0");
                }
                case 1: {
                    return MigrationAddinArb.getString("REPOSITORY_STAGE1");
                }
                case 2: {
                    return MigrationAddinArb.getString("REPOSITORY_STAGE2");
                }
                case 3: {
                    return MigrationAddinArb.getString("REPOSITORY_STAGE3");
                }
                case 4: {
                    return MigrationAddinArb.getString("REPOSITORY_STAGE4");
                }
            }
            return MigrationAddinArb.getString("REPOSITORY_STAGE4");
        }

        public void updateProgress(int n, Object object, Object object2) {
            if (this.m_callRunScripts != null) {
                this.m_callRunScripts.updateProgress(n, object, object2);
            }
            if (this.m_updater != null) {
                this.m_updater.getDescriptor().setMessage((String)object2);
                this.m_updater.getDescriptor().setProgress(n);
            }
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
            this.updateBytesSoFar(n2);
        }

        @Override
        public void write(int n) {
            this.updateBytesSoFar(1);
        }

        @Override
        public void write(byte[] byArray) {
            this.updateBytesSoFar(byArray.length);
        }

        public AbstractMigrationProgressRunnable getCallRunScripts() {
            return this.m_callRunScripts;
        }

        public void setCallRunScripts(AbstractMigrationProgressRunnable abstractMigrationProgressRunnable) {
            this.m_callRunScripts = abstractMigrationProgressRunnable;
        }

        public IRaptorTaskProgressUpdater getUpdater() {
            return this.m_updater;
        }

        public void setUpdater(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater) {
            this.m_updater = iRaptorTaskProgressUpdater;
        }
    }
}

