/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Wrapper;
import java.util.HashSet;
import java.util.Properties;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.metadata.persistence.MdColumn;
import oracle.dbtools.migration.capture.offline.OfflineCapturer;
import oracle.dbtools.migration.convert.Converter;
import oracle.dbtools.migration.datamove.offline.Offline3rdPartyPrintStream;
import oracle.dbtools.migration.workbench.core.AbstractMigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationAddin;
import oracle.dbtools.migration.workbench.core.MigrationPlugin;
import oracle.dbtools.migration.workbench.core.MigrationPluginException;
import oracle.dbtools.migration.workbench.core.Quoter;
import oracle.dbtools.migration.workbench.core.StatementProvider;
import oracle.dbtools.migration.workbench.core.ThirdPartyDbProvider;
import oracle.dbtools.migration.workbench.core.preferences.MigrationConfig;
import oracle.dbtools.migration.workbench.core.preferences.MigrationPluginPreferences;
import oracle.dbtools.migration.workbench.mysql3.MySQLConverter;
import oracle.dbtools.migration.workbench.mysql3.MySQLDbProvider;
import oracle.dbtools.migration.workbench.mysql3.MySQLOfflineCapturer;
import oracle.dbtools.migration.workbench.mysql3.MySQLQuoter;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Version;

public class MySQLPlugin
extends AbstractMigrationPlugin {
    public static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static boolean s_driverLoaded = false;
    protected Converter m_converter;
    public static final String[] CAPTURE_MENU = new String[]{"TABLE", "TABLE_FOLDER", "VIEW", "VIEW_FOLDER", "FUNCTIONS", "FUNCTIONS_FOLDER", "PROCEDURES", "PROCEDURES_FOLDER", "INDEX", "INDEX_FOLDER", "USER", "USER_FOLDER"};
    private static Version m_driverVersion;
    private static final Version MIN_VER;
    private static final Version MAX_VER;
    private HashSet<String> sqlldrReservedWords = null;

    public String getPlatformName() {
        return "MySQL";
    }

    public String getPluginName() {
        return this.getPlatformName();
    }

    public String getVersionNumber() {
        return "3.23";
    }

    public ThirdPartyDbProvider getProvider(String string) throws MigrationPluginException {
        try {
            MySQLPlugin.loadDriver();
            Connection connection = DriverManager.getConnection(string);
            return new MySQLDbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(String string, Properties properties) throws MigrationPluginException {
        MySQLPlugin.loadDriver();
        try {
            MySQLPlugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, properties);
            return new MySQLDbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    protected String getSupportedMapsXMLFileName() {
        return "/oracle/dbtools/migration/workbench/mysql3/SupportedDataTypesMap.xml";
    }

    public ThirdPartyDbProvider getProvider(String string, String string2, String string3) throws MigrationPluginException {
        try {
            MySQLPlugin.loadDriver();
            Connection connection = DriverManager.getConnection(string, string2, string3);
            return new MySQLDbProvider(connection);
        }
        catch (SQLException sQLException) {
            throw new MigrationPluginException((Throwable)sQLException);
        }
    }

    public ThirdPartyDbProvider getProvider(Connection connection) throws MigrationPluginException {
        return new MySQLDbProvider(connection);
    }

    public StatementProvider getStatementProviderForDataMove() {
        return new StatementProvider(){

            public Statement getStatementForDataMove(Connection connection) throws SQLException {
                Wrapper wrapper;
                if (m_driverVersion == null && connection != null) {
                    wrapper = connection.getMetaData();
                    m_driverVersion = new Version(new int[]{wrapper.getDriverMajorVersion(), wrapper.getDriverMinorVersion()});
                }
                if (DBUtil.checkVersion((Version)m_driverVersion, (Version)MAX_VER, (Version)MIN_VER)) {
                    wrapper = connection.createStatement(1003, 1007);
                    wrapper.setFetchSize(Integer.MIN_VALUE);
                    return wrapper;
                }
                return super.getStatementForDataMove(connection);
            }
        };
    }

    protected static void loadDriver() throws MigrationPluginException {
        if (!s_driverLoaded) {
            try {
                Object obj = Class.forName(DRIVER_CLASS).newInstance();
                if (obj instanceof Driver) {
                    Driver driver = (Driver)obj;
                    m_driverVersion = new Version(new int[]{driver.getMajorVersion(), driver.getMinorVersion()});
                }
                s_driverLoaded = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new MigrationPluginException((Throwable)classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new MigrationPluginException((Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new MigrationPluginException((Throwable)illegalAccessException);
            }
        }
    }

    public MigrationPluginPreferences getPreferencePanel() {
        return null;
    }

    public String getPublishedVersion() {
        return this.getVersionNumber();
    }

    public Converter getConverter() {
        if (this.m_converter == null) {
            this.m_converter = new MySQLConverter();
        }
        return this.m_converter;
    }

    public MigrationPlugin.PluginSupportLevel getPlatformSupportLevel(String string, int n, int n2, String string2) {
        if (!string.equals(this.getPlatformName())) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_NONE;
        }
        if (n == 3 && n2 >= 23) {
            return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_PREFERRED_VERSION;
        }
        return MigrationPlugin.PluginSupportLevel.SUPPORT_LEVEL_YES;
    }

    public String getIconFileName() {
        return "/oracle/dbtools/migration/workbench/plugin/mysql/images/mysql.png";
    }

    public void registerMenuItems() {
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.migration.workbench.plugin.mysql");
    }

    public Quoter getQuoter() {
        return new MySQLQuoter();
    }

    public boolean getDataExportCommmand(String string, MdColumn[] mdColumnArray, String string2, Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        MigrationConfig migrationConfig = MigrationAddin.getMigrationConfig();
        String string3 = migrationConfig.getEndColumnDelimiter();
        String string4 = migrationConfig.getEndRowDelimiter();
        Preferences preferences = Preferences.getPreferences();
        MigrationConfig migrationConfig2 = MigrationConfig.getInstance((PropertyStorage)preferences);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        int n = string.indexOf(".");
        if (n != -1 && n > 0 && n < string.length() - 1) {
            string5 = string.substring(0, n);
            string6 = string.substring(n + 1);
            string7 = "mysqldump -h <SERVER> -u <USERNAME> -p<PASSWORD>  -T \"<DESTINATION_PATH>\" --fields-terminated-by=\"" + string3 + "\" " + "--fields-escaped-by=\"\" --lines-terminated-by=\"" + string4 + "\" \"" + string5 + "\" \"" + string6 + "\" ";
        } else {
            string7 = "mysqldump -h <SERVER> -u <USERNAME> -p<PASSWORD>  -T \"<DESTINATION_PATH>\" --fields-terminated-by=\"" + string3 + "\" " + "--fields-escaped-by=\"\" --lines-terminated-by=\"" + string4 + "\" \"<DBNAME>\" \"" + string + "\"";
        }
        offline3rdPartyPrintStream.println(string7);
        return true;
    }

    public String createDataFileName(String string, String string2) {
        int n;
        if (string != null && (n = string.lastIndexOf(".")) < string.length() - 1) {
            return string.substring(n + 1) + ".txt";
        }
        return string2 + ".txt";
    }

    public String maybeQuoteSqlldrFieldReference(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = mdColumn2.getColumnName().toUpperCase();
        if (this.sqlldrReservedWords == null) {
            this.sqlldrReservedWords = new HashSet();
            this.sqlldrReservedWords.add("AND");
            this.sqlldrReservedWords.add("FLOAT");
            this.sqlldrReservedWords.add("RECOVERABLE");
            this.sqlldrReservedWords.add("APPEND");
            this.sqlldrReservedWords.add("FORMAT");
            this.sqlldrReservedWords.add("REENABLE");
            this.sqlldrReservedWords.add("BADFILE");
            this.sqlldrReservedWords.add("GENERATED");
            this.sqlldrReservedWords.add("REPLACE");
            this.sqlldrReservedWords.add("BADDN");
            this.sqlldrReservedWords.add("GRAPHIC");
            this.sqlldrReservedWords.add("RESUME");
            this.sqlldrReservedWords.add("BEGINDATA");
            this.sqlldrReservedWords.add("INDDN");
            this.sqlldrReservedWords.add("SEQUENCE");
            this.sqlldrReservedWords.add("BLANKS");
            this.sqlldrReservedWords.add("INDEXES");
            this.sqlldrReservedWords.add("SINGLEROW");
            this.sqlldrReservedWords.add("BLOCKSIZE");
            this.sqlldrReservedWords.add("INFILE");
            this.sqlldrReservedWords.add("SKIP");
            this.sqlldrReservedWords.add("BY");
            this.sqlldrReservedWords.add("INSERT");
            this.sqlldrReservedWords.add("SMALLINT");
            this.sqlldrReservedWords.add("BYTEINT");
            this.sqlldrReservedWords.add("INTEGER");
            this.sqlldrReservedWords.add("SORTDEVT");
            this.sqlldrReservedWords.add("CHAR");
            this.sqlldrReservedWords.add("INTO");
            this.sqlldrReservedWords.add("SORTED");
            this.sqlldrReservedWords.add("CHARACTERSET");
            this.sqlldrReservedWords.add("LAST");
            this.sqlldrReservedWords.add("SORTNUM");
            this.sqlldrReservedWords.add("CONCATENATE");
            this.sqlldrReservedWords.add("LOAD");
            this.sqlldrReservedWords.add("SQL/DS");
            this.sqlldrReservedWords.add("CONSTANT");
            this.sqlldrReservedWords.add("LOG");
            this.sqlldrReservedWords.add("STORAGE");
            this.sqlldrReservedWords.add("CONTINUE_LOAD");
            this.sqlldrReservedWords.add("MAX");
            this.sqlldrReservedWords.add("STREAM");
            this.sqlldrReservedWords.add("CONTINUEIF");
            this.sqlldrReservedWords.add("MLSLABEL");
            this.sqlldrReservedWords.add("SYSDATE");
            this.sqlldrReservedWords.add("COUNT");
            this.sqlldrReservedWords.add("NEXT");
            this.sqlldrReservedWords.add("TABLE");
            this.sqlldrReservedWords.add("DATA");
            this.sqlldrReservedWords.add("NO");
            this.sqlldrReservedWords.add("TERMINATED");
            this.sqlldrReservedWords.add("DATE");
            this.sqlldrReservedWords.add("NULLCOLS");
            this.sqlldrReservedWords.add("THIS");
            this.sqlldrReservedWords.add("DECIMAL");
            this.sqlldrReservedWords.add("NULLIF");
            this.sqlldrReservedWords.add("TRAILING");
            this.sqlldrReservedWords.add("DEFAULTIF");
            this.sqlldrReservedWords.add("OPTIONALLY");
            this.sqlldrReservedWords.add("TRUNCATE");
            this.sqlldrReservedWords.add("DELETE");
            this.sqlldrReservedWords.add("OPTIONS");
            this.sqlldrReservedWords.add("UNLOAD");
            this.sqlldrReservedWords.add("DISABLED_CONSTRAINTS");
            this.sqlldrReservedWords.add("PARALLEL");
            this.sqlldrReservedWords.add("UNRECOVERABLE");
            this.sqlldrReservedWords.add("DISCARDDN");
            this.sqlldrReservedWords.add("PART");
            this.sqlldrReservedWords.add("USING");
            this.sqlldrReservedWords.add("DISCARDFILE");
            this.sqlldrReservedWords.add("PARTITION");
            this.sqlldrReservedWords.add("VARCHAR");
            this.sqlldrReservedWords.add("DISCARDMAX");
            this.sqlldrReservedWords.add("PIECED");
            this.sqlldrReservedWords.add("VARGRAPHIC");
            this.sqlldrReservedWords.add("DISCARDS");
            this.sqlldrReservedWords.add("POSITION");
            this.sqlldrReservedWords.add("VARIABLE");
            this.sqlldrReservedWords.add("DOUBLE");
            this.sqlldrReservedWords.add("PRESERVE");
            this.sqlldrReservedWords.add("WHEN");
            this.sqlldrReservedWords.add("ENCLOSED");
            this.sqlldrReservedWords.add("RAW");
            this.sqlldrReservedWords.add("WHITESPACE");
            this.sqlldrReservedWords.add("EXCEPTIONS");
            this.sqlldrReservedWords.add("READBUFFERS");
            this.sqlldrReservedWords.add("WORKDDN");
            this.sqlldrReservedWords.add("EXTERNAL");
            this.sqlldrReservedWords.add("RECLEN");
            this.sqlldrReservedWords.add("YES");
            this.sqlldrReservedWords.add("FIELDS");
            this.sqlldrReservedWords.add("RECNUM");
            this.sqlldrReservedWords.add("ZONED");
            this.sqlldrReservedWords.add("FIXED");
            this.sqlldrReservedWords.add("RECORD");
        }
        String string2 = "";
        string2 = this.sqlldrReservedWords.contains(string) ? "\"" + string + "\"" : mdColumn2.getColumnName();
        return string2;
    }

    public String getDatafileExtension() {
        return "txt";
    }

    public String formatSQLLoaderColumn(MdColumn mdColumn, MdColumn mdColumn2) {
        String string = "";
        boolean bl = true;
        String string2 = mdColumn2.getColumnName();
        String string3 = mdColumn2.getColumnType();
        Integer n = mdColumn2.getPrecision();
        int n2 = 0;
        n2 = n == null ? 0 : n;
        if (string3.equalsIgnoreCase("CHAR") || string3.equalsIgnoreCase("NCHAR") || string3.equalsIgnoreCase("VARCHAR2") || string3.equalsIgnoreCase("NVARCHAR2") || string3.equalsIgnoreCase("CLOB") || string3.equalsIgnoreCase("NCLOB")) {
            if (n2 >= 255) {
                string = "CHAR(" + n2 + ")";
            }
            if (string3.equalsIgnoreCase("VARCHAR2") || string3.equalsIgnoreCase("NVARCHAR2") || string3.equalsIgnoreCase("CHAR") || string3.equalsIgnoreCase("NCHAR")) {
                string = MigrationAddin.getMigrationConfig().getEmptyStringIsSpace() ? string + " \"DECODE(:" + string2 + ", 'NULL', NULL, NULL, ' ', :" + string2 + ")\"" : string + " \"DECODE(:" + string2 + ", 'NULL', NULL, NULL, NULL, :" + string2 + ")\"";
                bl = false;
            }
            if (string3.equalsIgnoreCase("CLOB") || string3.equalsIgnoreCase("NCLOB")) {
                string = string + "CHAR(2000000)";
            }
        } else if (string3.equalsIgnoreCase("TIMESTAMP")) {
            string = "\"TO_TIMESTAMP(DECODE(:" + string2 + ", 'NULL', NULL, DECODE(translate(:" + string2 + ",'10 -,:.','1'), null, null,:" + string2 + ")), '" + MigrationAddin.getMigrationConfig().getTimeStampOfflineDateMask() + "')\"";
            bl = false;
        } else if (string3.equalsIgnoreCase("DATE")) {
            string = "\"TO_DATE(DECODE(:" + string2 + ", 'NULL', NULL,  DECODE(translate(:" + string2 + ",'10 -,:.','1'), null, null,:" + string2 + ")),  '" + MigrationAddin.getMigrationConfig().getDateOfflineDateMask() + "')\"";
            bl = false;
        } else if (string3.equalsIgnoreCase("INTERVAL DAY TO SECOND")) {
            string = "\"TO_DSINTERVAL(DECODE(:" + string2 + ", 'NULL', NULL, " + "TO_CHAR(FLOOR(REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 1)/24)) || ' ' ||" + "TO_CHAR(MOD(REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 1), 24)) || ':' ||" + "REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 2) || ':' ||" + "REGEXP_SUBSTR(:" + string2 + ", '[^:]+', 1, 3)))\"";
            bl = false;
        } else if (string3.equalsIgnoreCase("BLOB")) {
            string = " CHAR(2000000) ";
        }
        if (bl) {
            string = string + " NULLIF " + this.maybeQuoteSqlldrFieldReference(mdColumn, mdColumn2) + " = 'NULL'";
        }
        return string;
    }

    public int getPlatformMask() {
        return 1;
    }

    public OfflineCapturer getOfflineCapturer() {
        return new MySQLOfflineCapturer();
    }

    public String getPlatformNameforNavigator() {
        return "MySQL";
    }

    public void setConnectStatement(Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        this.setConnectStatementForShellScript(offline3rdPartyPrintStream);
        this.setConnectStatementForBatchFile(offline3rdPartyPrintStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectStatementForShellScript(Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        String string = offline3rdPartyPrintStream.getFilePathAndName();
        string = string.substring(0, string.lastIndexOf(".")) + ".sh";
        String string2 = "";
        String string3 = string.substring(0, string.lastIndexOf(".")) + ".tmp";
        File file = new File(string);
        File file2 = new File(string3);
        String string4 = "args=(\"$@\")\n";
        string4 = string4 + "server=${args[0]}\n";
        string4 = string4 + "username=${args[1]}\n";
        string4 = string4 + "password=${args[2]}\n";
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            if (!file.exists()) {
                return;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contains("mkdir -p log")) {
                    bufferedWriter.append(string2 + '\n');
                    bufferedWriter.append(string4 + '\n');
                    continue;
                }
                string2 = string2.replace("<SERVER>", "$server");
                string2 = string2.replace("<USERNAME>", "$username");
                string2 = string2.replace("<PASSWORD>", "$password");
                string2 = string2.replace("\"<DESTINATION_PATH>\"", "data");
                bufferedWriter.append(string2 + '\n');
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    file.delete();
                    file2.renameTo(new File(string));
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectStatementForBatchFile(Offline3rdPartyPrintStream offline3rdPartyPrintStream) {
        String string = offline3rdPartyPrintStream.getFilePathAndName();
        string = string.substring(0, string.lastIndexOf(".")) + ".bat";
        String string2 = "";
        String string3 = string.substring(0, string.lastIndexOf(".")) + ".tmp";
        File file = new File(string);
        File file2 = new File(string3);
        String string4 = "set server=%1\n";
        string4 = string4 + "set username=%2\n";
        string4 = string4 + "set password=%3\n";
        BufferedReader bufferedReader = null;
        BufferedWriter bufferedWriter = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            bufferedWriter = new BufferedWriter(new FileWriter(file2));
            if (!file.exists()) {
                return;
            }
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.contains("mkdir log")) {
                    bufferedWriter.append(string2 + '\n');
                    bufferedWriter.append(string4 + '\n');
                    continue;
                }
                string2 = string2.replace("<SERVER>", "%server%");
                string2 = string2.replace("<USERNAME>", "%username%");
                string2 = string2.replace("<PASSWORD>", "%password%");
                string2 = string2.replace("\"<DESTINATION_PATH>\"", "data");
                bufferedWriter.append(string2 + '\n');
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                    file.delete();
                    file2.renameTo(new File(string));
                }
            }
            catch (IOException iOException) {}
        }
    }

    static {
        MIN_VER = new Version("3.0");
        MAX_VER = new Version("5.1");
    }
}

