/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import oracle.ojc.storage.AbstractStorage;

public final class FileStorage
extends AbstractStorage {
    FileInputStream in;
    FileOutputStream out;
    private static boolean methodInit;
    private static Method methodValue;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileStorage(AbstractStorage storage, String name) {
        super(storage, name);
    }

    public FileStorage(File file) {
        super(file);
    }

    public void open() throws IOException {
        this.in = new FileInputStream(this.file);
    }

    public int size() throws IOException {
        if (!($assertionsDisabled || this.out == null && this.in != null)) {
            throw new AssertionError();
        }
        return this.in.available();
    }

    public byte[] read() throws IOException {
        if (!($assertionsDisabled || this.out == null && this.in != null)) {
            throw new AssertionError();
        }
        int avail = this.in.available();
        byte[] buf = new byte[avail];
        int nread = this.in.read(buf, 0, avail);
        if (nread != avail) {
            throw new IOException("incomplete read");
        }
        return buf;
    }

    public int read(byte[] buf) throws IOException {
        if (!($assertionsDisabled || this.out == null && this.in != null)) {
            throw new AssertionError();
        }
        int avail = this.in.available();
        int nbytes = avail < buf.length ? avail : buf.length;
        int nread = this.in.read(buf, 0, nbytes);
        if (nread != nbytes) {
            throw new IOException("incomplete read");
        }
        return nread;
    }

    public void write(byte[] buf, int start, int len) throws IOException {
        if (!$assertionsDisabled && this.in != null) {
            throw new AssertionError();
        }
        if (this.out == null) {
            this.out = new FileOutputStream(this.file);
        }
        this.out.write(buf, start, len);
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Method getMethod() {
        if (!methodInit) {
            try {
                Class<?> c = this.file.getClass();
                methodValue = c.getMethod("setLastModified", Long.TYPE);
            }
            catch (Exception e) {
                System.out.println("error: method java.io.File.setLastModified(), please use at least J2SE 1.5");
            }
            methodInit = true;
        }
        return methodValue;
    }

    public void setLastModified(long lastModified) {
        if (this.file != null && lastModified != -1L) {
            try {
                this.getMethod().invoke((Object)this.file, new Long(lastModified));
            }
            catch (Exception e) {
                System.out.println("error: unable to setTimeStamp on " + this.file.getPath());
            }
        }
    }

    static {
        $assertionsDisabled = !FileStorage.class.desiredAssertionStatus();
        methodInit = false;
        methodValue = null;
    }
}

