/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.storage;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import oracle.ojc.interfaces.Storage;

abstract class AbstractStorage
implements Storage {
    protected final File file;
    private String canonicalPath = null;
    private long lastModified = -1L;
    private HashMap properties = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    AbstractStorage(AbstractStorage storage, String name) {
        this.file = storage != null ? new File(storage.file, name) : null;
    }

    AbstractStorage(File file) {
        this.file = file;
    }

    public String getName() {
        return this.file != null ? this.file.getName() : null;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isInJar() {
        return false;
    }

    public String getPath() {
        return this.file != null ? this.file.getPath() : null;
    }

    public String getCanonicalPath() {
        if (this.canonicalPath == null && this.file != null) {
            try {
                this.canonicalPath = this.file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.canonicalPath;
    }

    public long modDate() {
        if (this.lastModified == -1L && this.file != null) {
            this.lastModified = this.file.lastModified();
        }
        return this.lastModified;
    }

    public Object getProperty(String property) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String property, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(property, value);
    }

    public void open() throws IOException {
    }

    public Storage open(String name) {
        return null;
    }

    public Storage create(String name) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public Storage createDir(String name) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public int size() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public byte[] read() throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public int read(byte[] buf) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    public String[] list() {
        ArrayList al = this.listStorage();
        if (al == null) {
            return null;
        }
        int size = al.size();
        String[] sa = new String[size];
        for (int i = 0; i < size; ++i) {
            Storage storage = (Storage)al.get(i);
            sa[i] = storage.getName();
        }
        return sa;
    }

    public ArrayList listStorage() {
        System.out.println("Error:  invalid internal call to 'AbstractStorage.listStorage()'.");
        System.out.println("Path: " + this.getPath());
        System.out.println("Class: " + this.getClass());
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    public void write(byte[] buf, int start, int len) throws IOException {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public void close() {
    }

    public String toString() {
        return this.getPath();
    }

    static {
        $assertionsDisabled = !AbstractStorage.class.desiredAssertionStatus();
    }
}

