/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.io.IOException;
import java.util.ArrayList;
import oracle.ojc.interfaces.Storage;

class WrappedStorage
implements Storage {
    private Storage storage;
    private boolean usedForIO;
    private WrappedStorage parent;
    static final /* synthetic */ boolean $assertionsDisabled;

    WrappedStorage(Storage storage) {
        this.storage = storage;
        if (!$assertionsDisabled && storage == null) {
            throw new AssertionError();
        }
        this.usedForIO = false;
        this.parent = null;
    }

    WrappedStorage(Storage storage, WrappedStorage parent) {
        this(storage);
        this.parent = parent;
    }

    public String getName() {
        return this.storage.getName();
    }

    public String getPath() {
        return this.storage.getPath();
    }

    public String getCanonicalPath() {
        return this.storage.getCanonicalPath();
    }

    public long modDate() {
        return this.storage.modDate();
    }

    public boolean isDirectory() {
        return this.storage.isDirectory();
    }

    public boolean isInJar() {
        return this.storage.isInJar();
    }

    public void setProperty(String property, Object value) {
        this.storage.setProperty(property, value);
    }

    public Object getProperty(String property) {
        return this.storage.getProperty(property);
    }

    public int size() throws IOException {
        return this.storage.size();
    }

    public byte[] read() throws IOException {
        this.setUsedForIO();
        return this.storage.read();
    }

    public int read(byte[] buf) throws IOException {
        this.setUsedForIO();
        return this.storage.read(buf);
    }

    public void write(byte[] buf, int start, int len) throws IOException {
        this.setUsedForIO();
        this.storage.write(buf, start, len);
    }

    public String[] list() {
        return this.storage.list();
    }

    public ArrayList listStorage() {
        return this.storage.listStorage();
    }

    public void open() throws IOException {
        this.setUsedForIO();
        this.storage.open();
    }

    public Storage open(String name) {
        Storage result = this.storage.open(name);
        if (result != null && !(result = new WrappedStorage(result, this)).isDirectory()) {
            this.setUsedForIO();
        }
        return result;
    }

    public Storage create(String name) throws IOException {
        this.setUsedForIO();
        return this.storage.create(name);
    }

    public Storage createDir(String name) throws IOException {
        this.setUsedForIO();
        return this.storage.createDir(name);
    }

    public void close() {
        this.storage.close();
    }

    private void setUsedForIO() {
        this.usedForIO = true;
        if (this.parent != null) {
            this.parent.setUsedForIO();
        }
    }

    boolean hasBeenUsedForIO() {
        return this.usedForIO;
    }

    void setParent(WrappedStorage parent) {
        this.parent = parent;
    }

    Storage getWrappedStorage() {
        return this.storage;
    }

    static {
        $assertionsDisabled = !WrappedStorage.class.desiredAssertionStatus();
    }
}

