/*
 * Decompiled with CFR 0.152.
 */
package oracle.ojc.compiler;

import java.util.BitSet;
import oracle.ojc.compiler.ByteCodeGenerator;
import oracle.ojc.compiler.Expression;
import oracle.ojc.compiler.Label;
import oracle.ojc.compiler.LoopStatement;
import oracle.ojc.compiler.Message;
import oracle.ojc.compiler.Parser;
import oracle.ojc.compiler.Scanner;
import oracle.ojc.compiler.StatementList;
import oracle.ojc.compiler.SwitchLoopList;

final class WhileStatement
extends LoopStatement {
    Expression condition;
    static final /* synthetic */ boolean $assertionsDisabled;

    WhileStatement(StatementList parent, int pos, int bodyPos, Expression condition, StatementList bodyStatements) {
        super(parent, pos, bodyPos, (byte)12, bodyStatements);
        this.condition = condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolveAndCheck(Parser parser) {
        SwitchLoopList outerSwitchLoop = parser.innerSwitchLoop;
        this.loopRec = new SwitchLoopList(outerSwitchLoop, null, this, parser.defSet, parser.posSet, parser.useSet);
        try {
            parser.innerSwitchLoop = this.loopRec;
            Expression expr = this.condition;
            expr = expr.resolveAndCheck(parser);
            expr = this.checkForBooleanExpression(parser, expr, this.condition.pos);
            BitSet defSetAfterCondition = (BitSet)parser.defSet.clone();
            StatementList bodyStatements = this.bodyStatements;
            boolean forEver = false;
            if (expr.isConstantBooleanExpression()) {
                if (!expr.getConstantBooleanExpressionValue()) {
                    if (this.condition.kind == 2) {
                        parser.error(Message.errorUnreachableStatement, bodyStatements.first == null ? this.pos : bodyStatements.first.pos, false);
                    }
                } else {
                    forEver = true;
                }
            }
            this.condition = expr;
            if (bodyStatements != null) {
                if (expr.isLogicalExpression()) {
                    parser.defSet = expr.getLogicalExpressionTrueDefSet();
                }
                bodyStatements.resolveAndCheck(parser);
                if (forEver && this.loopRec.breakSymbol == null && this.next != null && this.next.isCodeStatement()) {
                    parser.error(Message.errorUnreachableStatement, this.next.pos, false);
                }
            } else if (forEver && this.next != null && this.next.isCodeStatement()) {
                parser.error(Message.errorUnreachableStatement, this.next.pos, false);
            }
            this.loopRec.insertLabels();
            if (this.resultDefSet != null) {
                if (forEver) {
                    parser.defSet = this.resultDefSet;
                } else if (expr.isLogicalExpression()) {
                    parser.defSet = this.resultDefSet;
                    parser.defSet.and(expr.getLogicalExpressionFalseDefSet());
                } else {
                    parser.defSet = defSetAfterCondition;
                }
            } else {
                parser.defSet = expr.isLogicalExpression() ? expr.getLogicalExpressionFalseDefSet() : defSetAfterCondition;
            }
            if (this.resultPosSet != null) {
                parser.posSet.or(this.resultPosSet);
            }
            if (this.resultUseSet != null) {
                parser.useSet.or(this.resultUseSet);
            }
            this.checkPosibleReinitializations(parser);
            Object var8_7 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            parser.innerSwitchLoop = outerSwitchLoop;
            throw throwable;
        }
        if (!this.canReachNextStatement(true)) {
            this.setLastStatement();
        }
        ++parser.estimatedLineCount;
    }

    void generateByteCode(ByteCodeGenerator byteCodeGenerator) {
        StatementList bodyStatements;
        Expression expr = this.condition;
        if (expr.isConstantBooleanExpression() && !expr.getConstantBooleanExpressionValue()) {
            return;
        }
        Label testLabel = new Label();
        Label bodyLabel = new Label();
        if (!expr.isConstantBooleanExpression()) {
            byteCodeGenerator.generateBranch_goto(testLabel);
        }
        byteCodeGenerator.setLabel(bodyLabel);
        SwitchLoopList outerSwitchLoop = byteCodeGenerator.parser.innerSwitchLoop;
        byteCodeGenerator.parser.innerSwitchLoop = this.loopRec;
        if (this.loopRec.continueSymbol != null) {
            this.loopRec.continueSymbol.label = new Label();
        }
        if (this.loopRec.breakSymbol != null) {
            this.loopRec.breakSymbol.label = new Label();
        }
        if ((bodyStatements = this.bodyStatements) != null) {
            bodyStatements.generateByteCode(byteCodeGenerator);
        }
        if (this.pos != 0) {
            byteCodeGenerator.generateLineNumber(Scanner.positionToLine(this.pos));
        }
        byteCodeGenerator.parser.innerSwitchLoop = outerSwitchLoop;
        byteCodeGenerator.setLabel(testLabel);
        if (expr.isConstantBooleanExpression()) {
            if (expr.kind != 2) {
                expr.generateByteCode(byteCodeGenerator);
                byteCodeGenerator.generate_8((byte)87);
                byteCodeGenerator.decOpStackHeight(1);
            }
            byteCodeGenerator.generateBranch_goto(bodyLabel);
        } else {
            expr.generateByteCodeBranch(byteCodeGenerator, bodyLabel, false);
        }
    }

    boolean canReachNextStatement(boolean strict) {
        boolean forEver = false;
        Expression expr = this.condition;
        if (expr.isConstantBooleanExpression()) {
            forEver = expr.getConstantBooleanExpressionValue();
        }
        if (!$assertionsDisabled && this.loopRec == null) {
            throw new AssertionError();
        }
        if (this.loopRec.breakSymbol != null) {
            forEver = false;
        }
        return !forEver;
    }

    static {
        $assertionsDisabled = !WhileStatement.class.desiredAssertionStatus();
    }
}

